/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Stack;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.Stack.Action_ConstantVelocityStack;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.PickerGizmo;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Stack.VolumeStackManager;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Windows.Ensemble.Sequence.Sequence_MainWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleAxisEnum;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleDisplayOptionsWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_VertStackedEnsembleDisplayWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_AxisLocker;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_EnsembleCdpOverlay;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_KeyPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MultiLineSegments;
import com.PecosLibrary.Windows.Refraction.Picking.PickerGizmoWidget;
import com.PecosLibrary.Windows.Shared.BitmapCardWidget;
import com.PecosLibrary.Windows.Stack.VelocityVersionSelectionWidget;
import com.PecosLibrary.Windows.Volume.Stack.VolumeStackHorizonWidget;
import com.PecosLibrary.Windows.Volume.Stack.VolumeStack_InterpolatedWellTopWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StackVolumeWidget
extends JTabbedPane
implements Messenger.Listener,
ActionListener,
ItemListener,
GenericObjectListener.Listener {
    protected BitmapCardWidget m_bitmapCardWidget = new BitmapCardWidget();
    protected Sequence_MainWidget m_workerWidget;
    protected Java2D_EnsembleDisplayOptionsWidget m_wiggleOptionsWidget;
    protected VolumeStack_InterpolatedWellTopWidget m_overlayWidget;
    protected EnsembleWorker_Sequence m_sequence;
    protected Java2D_VertStackedEnsembleDisplayWidget m_widget;
    protected Java2D_AxisLocker m_axisLockerTime;
    protected VolumeStackHorizonWidget m_horizonWidget;
    protected PickerGizmoWidget m_pickerGizmoWidget;
    protected JComboBox<String> m_pickHorizonCombo = new JComboBox();
    protected JButton m_killHorizonPicksButton;
    protected Java2D_SimpleComposite m_basemap;
    protected JButton m_reloadMapButton;
    protected Java2D_Paintable_Table m_shotPaintable = null;
    protected Java2D_Paintable_Table m_receiverPaintable = null;
    protected JButton m_stackButton;
    protected JTextField m_newStackNameText = new JTextField("");
    protected JTextField m_muteText = new JTextField("25");
    protected JTextField m_minOffText = new JTextField("0");
    protected JTextField m_maxOffText = new JTextField("7000");
    protected JTextField m_minTimeText = new JTextField("400");
    protected JTextField m_maxTimeText = new JTextField("700");
    protected JTextField m_digiText = new JTextField("4");
    protected JTextField m_radiusText = new JTextField("1");
    protected JTextField m_velocityText = new JTextField("12000");
    protected ComboStringListWrapper m_versionCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_columnCombo = new ComboStringListWrapper();
    protected JButton m_reloadVersionColumnButton;
    protected VelocityVersionSelectionWidget m_velVersionWidget;
    protected boolean m_stacksOkay = false;
    protected JButton m_reloadStacksButton;
    protected ArrayList<Wrapper> m_wrapperList = new ArrayList();
    protected JComboBox<String> m_planeCombo = new JComboBox();
    protected JComboBox<String> m_visibleCombo = new JComboBox();

    public StackVolumeWidget() {
        try {
            this.addTab("Create and view stacks ", this.createMain());
            for (int n = 1; n <= 3; ++n) {
                this.addTab("Horizon viewer #" + Integer.toString(n), new VolumeStackHorizonWidget());
            }
            this.reloadVersions();
            this.reloadStacks();
            this.reloadPlots(true);
            this.reloadMap(true);
            for (Wrapper w : this.m_wrapperList) {
                w.loadUEC();
            }
            Messenger.singleton().addListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createMain() {
        try {
            JSplitPane splitter = new JSplitPane(1);
            splitter.setLeftComponent(this.createLeft());
            splitter.setRightComponent(this.createRight());
            return splitter;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRightRight() {
        try {
            for (int n = 1; n <= 4; ++n) {
                this.m_pickHorizonCombo.addItem(Pecos.getColNameHorizon(n));
            }
            this.m_pickHorizonCombo.setSelectedIndex(0);
            this.m_pickHorizonCombo.addItemListener(this);
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            LinearLayoutWidget sub = main.createVertical(0, "Select active horizon", 0);
            sub.addComponent(this.m_pickHorizonCombo, 0);
            this.m_killHorizonPicksButton = sub.createButton("Kill picks for active horizon", this, 0);
            sub.addComponent(new JLabel("(Applies to top plot only)"), 0);
            this.m_pickerGizmoWidget = new PickerGizmoWidget();
            main.addComponent(this.m_pickerGizmoWidget, 10);
            main.setPreferredSize(new Dimension(200, 500));
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void reloadStacks() {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            String parentPath = Tools_FileSystem.confirmSubDirectoryExists(project.projectPath(), "VolumeStacks");
            ArrayList<String> list = Tools_FileSystem.subdirectories(parentPath, false);
            this.m_stacksOkay = list.size() >= 1;
            for (Wrapper w : this.m_wrapperList) {
                w.StackCombo.setStringArray(list);
                w.resetSpinner();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            for (int n = 0; n < this.m_wrapperList.size(); ++n) {
                if (sender != this.m_wrapperList.get(n)) continue;
                this.m_wrapperList.get(n).loadStack();
                this.reloadPlots(false);
            }
            if (sender == this.m_axisLockerTime) {
                this.m_widget.setAxisLocked_Time(this.m_axisLockerTime.locked(), this.m_axisLockerTime.min(), this.m_axisLockerTime.max());
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createRightPlot() {
        try {
            this.m_widget = new Java2D_VertStackedEnsembleDisplayWidget(4);
            this.m_widget.setVisibleCount(2);
            this.m_widget.HeaderTextRowCount = 0;
            this.m_widget.setHeaderPlotVisibleCount(0, 1);
            this.m_widget.setHeaderPlotHeader(0, 0, "Interpolated", "Elevation");
            this.m_widget.DrawColor = true;
            this.m_widget.DrawWiggles = false;
            this.m_widget.setPlotBorder(true, Color.BLACK, 2);
            this.m_widget.setEnsembleDisplayOptionsWidget(this.m_wiggleOptionsWidget);
            return this.m_widget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRight() {
        try {
            JSplitPane splitter = new JSplitPane(1);
            splitter.setLeftComponent(this.createRightPlot());
            splitter.setRightComponent(this.createRightRight());
            splitter.setOneTouchExpandable(true);
            splitter.setResizeWeight(1.0);
            return splitter;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createNewStackWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            this.m_velVersionWidget = new VelocityVersionSelectionWidget(this);
            main.addComponent(this.m_velVersionWidget, 0);
            String s = "<HTML>The new stack will be created using the processing sequence   defined in this window and the velocity function defined in the \"Velocity picker\" window</HTML>";
            main.addComponent(new JLabel(s), 0);
            main.createGapLabel(12);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, 0);
            this.m_reloadVersionColumnButton = new JButton("Reload versions/columns");
            this.m_reloadVersionColumnButton.addActionListener(this);
            this.m_versionCombo.listener().addListener(this);
            int row = 0;
            grid.addSimple(row++, new JLabel("Stack name"), this.m_newStackNameText);
            grid.addSimple(row++, new JLabel("Version name"), this.m_versionCombo);
            grid.addSimple(row++, new JLabel("Statics column"), this.m_columnCombo);
            grid.addSimple(row++, new JLabel(" "), this.m_reloadVersionColumnButton);
            grid.addSimple(row++, new JLabel("Stretch mute %"), this.m_muteText);
            grid.addSimple(row++, new JLabel("Constant velocity"), this.m_velocityText);
            grid.addSimple(row++, new JLabel("Minimum offset"), this.m_minOffText);
            grid.addSimple(row++, new JLabel("Maximum offset"), this.m_maxOffText);
            grid.addSimple(row++, new JLabel("Sample interval"), this.m_digiText);
            grid.addSimple(row++, new JLabel("Minimum time"), this.m_minTimeText);
            grid.addSimple(row++, new JLabel("Maximum time"), this.m_maxTimeText);
            grid.addSimple(row++, new JLabel("Bin spray radius"), this.m_radiusText);
            this.m_stackButton = main.createButton("Create new stack", this, 0);
            main.addStretch(10);
            main.setPreferredSize(new Dimension(300, 1200));
            main.setMaximumSize(new Dimension(300, 1200));
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createStackSelectorWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            int maxVis = 4;
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Number of visible stacks", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("# plots visible"), this.m_visibleCombo);
            this.m_axisLockerTime = new Java2D_AxisLocker("Time lock", "Lock axis ");
            this.m_axisLockerTime.listener().addListener(this);
            this.m_axisLockerTime.setRange(250.0, 600.0);
            main.addComponent(this.m_axisLockerTime, 0);
            this.m_reloadStacksButton = main.createButton("Reload list of stacks", this, 0);
            grid = main.createGridLayoutWidget(0, "Select stacks and bins", 0);
            row = 0;
            this.m_planeCombo.addItem("View inlines");
            this.m_planeCombo.addItem("View crosslines");
            this.m_planeCombo.setSelectedIndex(0);
            this.m_planeCombo.setEnabled(false);
            grid.addSimple(row++, new JLabel(" "), new JLabel(" "), this.m_planeCombo);
            int n = 0;
            while (n < maxVis) {
                String lbl = String.format("%d ", n + 1);
                Wrapper wrapper = new Wrapper();
                wrapper.Spinner = new JSpinner(wrapper.SpinnerModel);
                grid.addSimple(row++, new JLabel(lbl), wrapper.StackCombo, wrapper.Spinner);
                wrapper.Spinner.addChangeListener(wrapper);
                this.m_visibleCombo.addItem(lbl);
                wrapper.StackCombo.listener().addListener(wrapper);
                this.m_wrapperList.add(wrapper);
                wrapper.Listener.addListener(this);
                wrapper.Overlay.Size = 3;
                wrapper.PlotIndex = n++;
                wrapper.m_lineSegmentUEC.addListener(wrapper);
                wrapper.m_leftClickUEC.addListener(wrapper);
                wrapper.m_middleClickUEC.addListener(wrapper);
                wrapper.m_keyUEC.addListener(wrapper);
                wrapper.loadUEC();
            }
            this.m_wrapperList.get((int)0).StackCombo.setForeground(Color.red);
            this.m_wrapperList.get((int)0).Overlay.DotColor = Color.RED;
            this.m_wrapperList.get((int)1).StackCombo.setForeground(Color.blue);
            this.m_wrapperList.get((int)1).Overlay.DotColor = Color.blue;
            this.m_wrapperList.get((int)1).Overlay.DumpMessages = true;
            this.m_wrapperList.get((int)2).StackCombo.setForeground(Color.MAGENTA);
            this.m_wrapperList.get((int)2).Overlay.DotColor = Color.MAGENTA;
            this.m_wrapperList.get((int)3).StackCombo.setForeground(Color.GREEN);
            this.m_wrapperList.get((int)3).Overlay.DotColor = Color.GREEN;
            this.m_visibleCombo.setSelectedIndex(1);
            this.m_visibleCombo.addItemListener(this);
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            this.m_basemap = new Java2D_SimpleComposite(false);
            this.m_basemap.setAxesVisible(false, false);
            this.m_basemap.setColorScaleVisible(false);
            main.addComponent(this.m_basemap, 10);
            this.m_reloadMapButton = main.createButton("Reload basemap", this, 0);
            main.setPreferredSize(new Dimension(300, 1200));
            main.setMaximumSize(new Dimension(300, 1200));
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (e.getSource() == this.m_visibleCombo) {
                this.m_widget.setVisibleCount(1 + this.m_visibleCombo.getSelectedIndex());
                this.reloadPlots(true);
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadStaticsColumns() {
        try {
            String versionName = this.m_versionCombo.getSelectedString();
            IDatabaseConnection database = RefractionStaticsProject.singleton().getVersionDatabase(versionName);
            ArrayList<String> recColList = database.listOfColumnNames("Receiver");
            ArrayList<String> shotColList = database.listOfColumnNames("Shot");
            database = null;
            System.gc();
            ArrayList<String> intersection = new ArrayList<String>();
            for (String rec : recColList) {
                boolean ok = false;
                for (String shot : shotColList) {
                    if (!rec.equalsIgnoreCase(shot)) continue;
                    ok = true;
                }
                if (!ok || !rec.startsWith("STATICS_")) continue;
                intersection.add(rec);
            }
            Collections.sort(intersection);
            intersection.add(0, "Do not apply statics");
            this.m_columnCombo.setStringArray(intersection);
            this.m_columnCombo.setSelectedIndex(0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadVersions() {
        try {
            ArrayList<String> versionList = RefractionStaticsProject.singleton().versionList();
            this.m_versionCombo.setStringArray(versionList);
            this.reloadStaticsColumns();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createSequenceWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            String s = "<HTML>The processing sequence is only used when creating new stacks.  You should not apply statics here - apply them using the options on the stack tab.</HTML>";
            JLabel lbl = new JLabel(s);
            lbl.setBorder(BorderFactory.createRaisedBevelBorder());
            main.addComponent(lbl, 0);
            main.createGapLabel(12);
            main.addComponent(this.m_workerWidget, 10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createLeft() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            String sequenceFileName = p.guiOptionsPath() + "/Stack_Comp.SequenceXML";
            this.m_workerWidget = new Sequence_MainWidget("Stack_Comp", EnsembleWorker_Sequence.SequenceType.Interactive);
            this.m_workerWidget.setFileName(sequenceFileName);
            this.m_sequence = this.m_workerWidget.sequence();
            this.m_overlayWidget = new VolumeStack_InterpolatedWellTopWidget();
            this.m_overlayWidget.listener().addListener(this);
            this.m_wiggleOptionsWidget = new Java2D_EnsembleDisplayOptionsWidget("Trace display options");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Basemap, this.createStackSelectorWidget(), "Basemap");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Stack, this.createNewStackWidget(), "Create new stacks");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Sequence, this.createSequenceWidget(), "Ensemble processing sequence");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Diagram, this.m_overlayWidget, "Interpolated overlay");
            this.m_bitmapCardWidget.setPreferredSize(new Dimension(300, 500));
            return this.m_bitmapCardWidget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void reloadPlots(boolean reloadStacks) {
        try {
            int n;
            if (reloadStacks) {
                for (n = 0; n < this.m_wrapperList.size(); ++n) {
                    this.m_wrapperList.get(n).loadStack();
                }
            }
            for (n = 0; n <= this.m_visibleCombo.getSelectedIndex(); ++n) {
                Ensemble e = this.m_wrapperList.get((int)n).StackEnsemble;
                this.m_widget.setEnsemble(n, e);
            }
            this.m_widget.setAxisType(Java2D_EnsembleAxisEnum.UniformSpacing);
            this.m_widget.setTimeLineColorAndSpacing(Color.DARK_GRAY, 50.0);
            this.m_widget.clearAndLoadWigglePaintables();
            this.m_widget.unzoom();
            this.reloadMap(false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void createNewStack() {
        try {
            Action_ConstantVelocityStack action = new Action_ConstantVelocityStack();
            action.Sequence = this.m_sequence;
            action.StackName = this.m_newStackNameText.getText();
            action.ApplyStatics = this.m_columnCombo.getSelectedIndex() >= 1;
            action.VersionName = this.m_versionCombo.getSelectedString();
            action.StaticsName = this.m_columnCombo.getSelectedString();
            action.Radius = 1;
            action.MinTime = Tools_Widget.extractInteger(this.m_minTimeText, 0, 0, 5000);
            action.MaxTime = Tools_Widget.extractInteger(this.m_maxTimeText, 1000, 300, 5000);
            action.Digi = Tools_Widget.extractInteger(this.m_digiText, 4, 1, 8);
            action.MinOffset = Tools_Widget.extractInteger(this.m_minOffText, 0, 0, 5000);
            action.MaxOffset = Tools_Widget.extractInteger(this.m_maxOffText, 7000, 1000, 50000);
            action.Mute = Tools_Widget.extractInteger(this.m_muteText, 25, 10, 80);
            action.Radius = Tools_Widget.extractInteger(this.m_radiusText, 1, 0, 5);
            action.Velocity = Tools_Widget.extractDouble(this.m_velocityText, 10000.0, 500.0, 50000.0);
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            project.executeSingleAction(action);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadMap(boolean reloadGeom) {
        try {
            Java2D_Widget w = this.m_basemap.mainWidget();
            w.clearPaintableList();
            w.clearEventConsumerList();
            if (reloadGeom) {
                this.m_shotPaintable = Tools_RefractionStaticsProject.loadGeomPO("Shot");
                this.m_receiverPaintable = Tools_RefractionStaticsProject.loadGeomPO("Receiver");
            }
            if (this.m_shotPaintable != null) {
                w.addPaintable(this.m_shotPaintable, -9999);
            }
            if (this.m_receiverPaintable != null) {
                w.addPaintable(this.m_receiverPaintable, -9999);
            }
            for (int n = 0; n <= this.m_visibleCombo.getSelectedIndex(); ++n) {
                if (this.m_wrapperList.get((int)n).Overlay.m_ensemble == null) continue;
                w.addPaintable(this.m_wrapperList.get((int)n).Overlay, -9999);
            }
            w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            w.forceImageRepaint();
            w.mooz();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void killSelectedPicks() {
        try {
            int index = this.m_pickHorizonCombo.getSelectedIndex();
            this.m_wrapperList.get((int)0).StackManager.killPicks(index);
            this.m_wrapperList.get((int)0).StackEnsemble = null;
            this.reloadPlots(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_killHorizonPicksButton) {
                this.killSelectedPicks();
                return;
            }
            if (e.getSource() == this.m_reloadMapButton) {
                this.reloadMap(true);
                return;
            }
            if (e.getSource() == this.m_reloadStacksButton) {
                this.reloadStacks();
                this.reloadPlots(true);
                return;
            }
            if (e.getSource() == this.m_reloadVersionColumnButton) {
                this.reloadVersions();
                return;
            }
            if (e.getSource() == this.m_stackButton) {
                this.createNewStack();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
    }

    public class Wrapper
    implements ChangeListener,
    GenericObjectListener.Listener {
        public int PlotIndex = 0;
        public ComboStringListWrapper StackCombo = new ComboStringListWrapper();
        public VolumeStackManager StackManager = new VolumeStackManager();
        public SpinnerNumberModel SpinnerModel = new SpinnerNumberModel();
        public JSpinner Spinner;
        public boolean IgnoreStateChange = true;
        public GenericObjectListener Listener = new GenericObjectListener();
        public Ensemble StackEnsemble = null;
        public int CurrentIndex = 0;
        public Java2D_Paintable_EnsembleCdpOverlay Overlay = new Java2D_Paintable_EnsembleCdpOverlay();
        protected Java2D_UserEventConsumer_MultiLineSegments m_lineSegmentUEC = new Java2D_UserEventConsumer_MultiLineSegments();
        protected Java2D_UserEventConsumer_KeyPressed m_keyUEC = new Java2D_UserEventConsumer_KeyPressed();
        protected Java2D_UserEventConsumer_ButtonPressed m_leftClickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
        protected Java2D_UserEventConsumer_ButtonPressed m_middleClickUEC = new Java2D_UserEventConsumer_ButtonPressed(2);

        protected void loadUEC() {
            try {
                boolean needControlPoint;
                if (StackVolumeWidget.this.m_widget == null) {
                    return;
                }
                StackVolumeWidget.this.m_widget.clearUserEventConsumerList(this.PlotIndex);
                PickerGizmo pg = PickerGizmo.singleton();
                boolean bl = needControlPoint = pg.LeftClickAction == PickerGizmo.LeftClickActionEnum.ControlPointAdd || pg.LeftClickAction == PickerGizmo.LeftClickActionEnum.ControlPointKill;
                if (needControlPoint) {
                    StackVolumeWidget.this.m_widget.addEventConsumer(this.PlotIndex, this.m_lineSegmentUEC);
                } else {
                    StackVolumeWidget.this.m_widget.addEventConsumer(this.PlotIndex, this.m_leftClickUEC);
                }
                StackVolumeWidget.this.m_widget.addEventConsumer(this.PlotIndex, this.m_middleClickUEC);
                StackVolumeWidget.this.m_widget.addEventConsumer(this.PlotIndex, this.m_keyUEC);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            try {
                if (this.IgnoreStateChange) {
                    return;
                }
                this.Listener.broadcast(this, null);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void saveCurrentHeaders() {
            try {
                if (this.StackEnsemble == null) {
                    return;
                }
                if (StackVolumeWidget.this.m_planeCombo.getSelectedIndex() == 0) {
                    if (this.CurrentIndex < this.StackManager.inlineMin()) {
                        return;
                    }
                    if (this.CurrentIndex > this.StackManager.inlineMax()) {
                        return;
                    }
                    this.StackManager.saveInlineEnsembleHeaders(this.StackEnsemble, this.CurrentIndex);
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        protected boolean copyHeader(Ensemble oldEnsemble, Ensemble newEnsemble, String colName) {
            try {
                PickerGizmo pg = PickerGizmo.singleton();
                boolean modified = false;
                int indexOld = oldEnsemble.dictionary().getEntryIndex("Trace", colName);
                int indexNew = newEnsemble.dictionary().getEntryIndex("Trace", colName);
                int nt = newEnsemble.traceCount();
                for (int n = 0; n < newEnsemble.traceCount(); ++n) {
                    float newval = newEnsemble.trace(n).header().getFloat(indexNew);
                    if (!(newval < 1.0f)) continue;
                    double count = 1.0E-20;
                    double sum = 0.0;
                    int low = Math.max(0, n - 1);
                    int high = Math.min(nt - 1, n + 1);
                    for (int k = low; k <= high; ++k) {
                        float oldval = oldEnsemble.trace(k).header().getFloat(indexOld);
                        if (!(oldval > 0.0f)) continue;
                        count += 1.0;
                        sum += (double)oldval;
                    }
                    float temp = (float)(sum / count);
                    if (!(temp > 0.1f)) continue;
                    pg.pickTrace_External(newEnsemble.trace(n), indexNew, temp);
                    modified = true;
                }
                return modified;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                return false;
            }
        }

        public void loadStack() {
            try {
                boolean changeByOne;
                this.saveCurrentHeaders();
                Ensemble oldEnsemble = this.StackEnsemble;
                int oldIndex = this.CurrentIndex;
                this.StackEnsemble = null;
                this.CurrentIndex = -999999;
                if (!this.StackManager.valid()) {
                    return;
                }
                int index = this.SpinnerModel.getNumber().intValue();
                if (StackVolumeWidget.this.m_planeCombo.getSelectedIndex() == 0) {
                    this.StackEnsemble = this.StackManager.getInlineEnsemble(index);
                    this.CurrentIndex = index;
                }
                boolean bl = changeByOne = this.CurrentIndex == oldIndex - 1 || this.CurrentIndex == oldIndex + 1;
                if (oldEnsemble != null && this.StackEnsemble != null && changeByOne && oldEnsemble.traceCount() == this.StackEnsemble.traceCount()) {
                    for (int h = 1; h <= 4; ++h) {
                        this.copyHeader(oldEnsemble, this.StackEnsemble, Pecos.getColNameHorizon(h));
                    }
                }
                this.Overlay.m_ensemble = this.StackEnsemble;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void handleGenericObjectListener(Object sender, Object data) {
            try {
                if (sender == this.StackCombo) {
                    this.StackEnsemble = null;
                    this.CurrentIndex = -9999;
                    this.resetSpinner();
                    this.Listener.broadcast(this, null);
                }
                PickerGizmo pg = PickerGizmo.singleton();
                pg.PickName = (String)StackVolumeWidget.this.m_pickHorizonCombo.getSelectedItem();
                if (sender == PickerGizmo.singleton()) {
                    this.loadUEC();
                    return;
                }
                if (this.StackEnsemble != null && sender == this.m_keyUEC) {
                    if (pg.handleKey(this.m_keyUEC, this.StackEnsemble, this.StackEnsemble, StackVolumeWidget.this.m_widget.transform(0), true)) {
                        this.saveCurrentHeaders();
                        StackVolumeWidget.this.m_widget.repaintAll();
                    }
                    return;
                }
                if (this.StackEnsemble != null && sender == this.m_lineSegmentUEC) {
                    if (this.m_lineSegmentUEC.Dragging) {
                        return;
                    }
                    if (!this.m_lineSegmentUEC.Finished) {
                        return;
                    }
                    if (pg.handleControlPoint(this.m_lineSegmentUEC, this.StackEnsemble, this.StackEnsemble)) {
                        this.saveCurrentHeaders();
                        StackVolumeWidget.this.m_widget.repaintAll();
                    }
                    return;
                }
                if (this.StackEnsemble != null && sender == this.m_middleClickUEC) {
                    return;
                }
                if (this.StackEnsemble != null && sender == this.m_leftClickUEC) {
                    if (pg.handleButtonPressed(this.m_leftClickUEC, this.StackEnsemble, this.StackEnsemble, true)) {
                        this.saveCurrentHeaders();
                        StackVolumeWidget.this.m_widget.repaintAll();
                    }
                    return;
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void resetSpinner() {
            try {
                this.IgnoreStateChange = true;
                this.Spinner.setEnabled(false);
                this.StackCombo.setEnabled(false);
                if (!StackVolumeWidget.this.m_stacksOkay) {
                    return;
                }
                String name = this.StackCombo.getSelectedString();
                RefractionStaticsProject project = RefractionStaticsProject.singleton();
                String parentPath = Tools_FileSystem.confirmSubDirectoryExists(project.projectPath(), "VolumeStacks");
                String path = parentPath + "/" + name;
                if (!Tools_FileSystem.exists_path(path)) {
                    return;
                }
                this.StackManager.setPath(path);
                if (StackVolumeWidget.this.m_planeCombo.getSelectedIndex() == 0) {
                    int min = this.StackManager.inlineMin();
                    int max = this.StackManager.inlineMax();
                    int mid = (min + max) / 2;
                    this.SpinnerModel.setMinimum(new Integer(min));
                    this.SpinnerModel.setMaximum(new Integer(max));
                    this.SpinnerModel.setValue(new Integer(mid));
                }
                this.Spinner.setModel(this.SpinnerModel);
                this.Spinner.setEnabled(true);
                this.StackCombo.setEnabled(true);
                this.IgnoreStateChange = false;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }
    }
}

