/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Stack;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Stack.SlidingStackComparisonWidget;
import com.PecosLibrary.Windows.Stack.StackComparisonWidget;
import com.PecosLibrary.Windows.Stack.StackProfileManagerWidget;
import javax.swing.JTabbedPane;

public class StackProfileCompositeWidget
extends JTabbedPane
implements GenericObjectListener.Listener,
ISaveableFrame {
    protected StackProfileManagerWidget m_profileWidget;
    protected StackComparisonWidget m_stackCompareWidget;
    protected SlidingStackComparisonWidget m_slideCompareWidget;

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.Stack.StackProfileCompositeWidget";
    }

    @Override
    public String TAB_LABEL() {
        return "Profile stacks";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "Profile stacks";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return true;
    }

    public StackProfileCompositeWidget() {
        try {
            this.m_profileWidget = new StackProfileManagerWidget();
            this.m_stackCompareWidget = new StackComparisonWidget();
            this.m_slideCompareWidget = new SlidingStackComparisonWidget();
            this.addTab("Profile creation / selection", this.m_profileWidget);
            this.addTab("Create and view stacks along profile", this.m_stackCompareWidget);
            this.addTab("Additional stack comparison options", this.m_slideCompareWidget);
            this.m_profileWidget.listener().addListener(this);
            this.m_slideCompareWidget.reloadProfile();
            this.m_stackCompareWidget.reloadProfile();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_profileWidget) {
                this.m_stackCompareWidget.setSeismicProfile(this.m_profileWidget.selectedProfile());
                this.m_slideCompareWidget.setSeismicProfile(this.m_profileWidget.selectedProfile());
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

