/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Stack;

import com.PecosCore.Data.ArrayRenormalization;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleFirstBreakPickPlotData;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Ensemble.Worker.Amplitude.EnsembleWorker_AGC;
import com.PecosLibrary.Ensemble.Worker.Amplitude.EnsembleWorker_AmplitudeSquasher;
import com.PecosLibrary.Ensemble.Worker.Amplitude.EnsembleWorker_CrudeDespike;
import com.PecosLibrary.Ensemble.Worker.Amplitude.EnsembleWorker_RMS;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.PickerGizmo;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Seismic.SeismicProfile;
import com.PecosLibrary.Stack.StackGizmo;
import com.PecosLibrary.Stack.VelocityLocationCollection;
import com.PecosLibrary.Stack.VelocityManager;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Windows.Ensemble.Sequence.Sequence_MainWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleAxisEnum;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleDisplayOptionsWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_VertStackedEnsembleDisplayWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_AxisLocker;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_KeyPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MultiLineSegments;
import com.PecosLibrary.Windows.Refraction.Picking.PickerGizmoWidget;
import com.PecosLibrary.Windows.Shared.BitmapCardWidget;
import com.PecosLibrary.Windows.Stack.VelocityVersionSelectionWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JSplitPane;
import javax.swing.JTextField;

public class StackComparisonWidget
extends JSplitPane
implements Messenger.Listener,
ActionListener,
ItemListener,
GenericObjectListener.Listener {
    protected BitmapCardWidget m_bitmapCardWidget = new BitmapCardWidget();
    protected Sequence_MainWidget m_workerWidget;
    protected JLabel m_gravityLabel = new JLabel("Gravity/stack QC options not applied");
    protected Java2D_EnsembleDisplayOptionsWidget m_wiggleOptionsWidget;
    protected EnsembleWorker_Sequence m_sequence;
    protected PickerGizmoWidget m_pickerGizmoWidget;
    protected Java2D_VertStackedEnsembleDisplayWidget m_widget;
    protected Java2D_AxisLocker m_axisLockerTime;
    protected JCheckBox m_chkDisplayWiggles;
    protected JCheckBox m_chkApplyAGC;
    protected JTextField m_txtAgcLen;
    protected JCheckBox m_chkApplyDespike;
    protected JCheckBox m_chkApplyCompression;
    protected JCheckBox m_chkInterpolateHeaders;
    protected JLabel m_profileLabel = new JLabel("NOT SELECTED", 0);
    protected JButton m_stackButton;
    protected JButton m_btnStackEverything;
    protected JTextField m_txtPrefix = new JTextField("Name");
    protected JLabel m_lblStackLine = new JLabel(" ");
    protected JLabel m_lblStackStatic = new JLabel(" ");
    protected JTextField m_newStackNameText = new JTextField("");
    protected JTextField m_muteText = new JTextField("25");
    protected JTextField m_minOffText = new JTextField("0");
    protected JTextField m_maxOffText = new JTextField("7000");
    protected ComboStringListWrapper m_versionCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_columnCombo = new ComboStringListWrapper();
    protected JButton m_reloadVersionColumnButton;
    protected JProgressBar m_progress = new JProgressBar();
    protected int m_numStackHeaderBytes = 100;
    protected ArrayRenormalization m_agc = new ArrayRenormalization();
    protected float[] m_tempArray = new float[10];
    protected VelocityVersionSelectionWidget m_velVersionWidget;
    protected SeismicProfile m_selectedProfile = null;
    protected ArrayList<Wrapper> m_wrapperList = new ArrayList();
    protected JComboBox<String> m_visibleCombo = new JComboBox();
    public String EventPickTime = "EventPickTime";
    protected String m_velocityName;
    protected VelocityManager m_velManager;
    protected EnsembleWorker_AGC m_agcWorker = new EnsembleWorker_AGC();
    protected EnsembleWorker_AmplitudeSquasher m_squasher = new EnsembleWorker_AmplitudeSquasher();
    protected EnsembleWorker_CrudeDespike m_despike = new EnsembleWorker_CrudeDespike();

    public SeismicProfile selectedProfile() {
        return this.m_selectedProfile;
    }

    public void setSeismicProfile(SeismicProfile sp) {
        try {
            this.m_selectedProfile = sp;
            this.reloadProfile();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public StackComparisonWidget() {
        super(1);
        try {
            this.m_velManager = RefractionStaticsProject.singleton().getVelocityManager();
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.createRight());
            this.reloadProfile();
            this.reloadVersions();
            Messenger.singleton().addListener(this);
            PickerGizmo.singleton().listener().addListener(this);
            this.loadUEC();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_versionCombo) {
                this.reloadStaticsColumns();
                return;
            }
            if (sender == PickerGizmo.singleton()) {
                this.loadUEC();
                return;
            }
            for (int n = 0; n < this.m_wrapperList.size(); ++n) {
                if (sender != this.m_wrapperList.get((int)n).StackCombo) continue;
                this.loadPlot(this.m_wrapperList.get((int)n).StackCombo.getSelectedString(), n);
                this.reloadPlots(false);
                return;
            }
            if (sender == this.m_axisLockerTime) {
                this.m_widget.setAxisLocked_Time(this.m_axisLockerTime.locked(), this.m_axisLockerTime.min(), this.m_axisLockerTime.max());
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createRight() {
        try {
            this.m_widget = new Java2D_VertStackedEnsembleDisplayWidget(4);
            this.m_widget.setVisibleCount(2);
            this.m_widget.HeaderTextRowCount = 0;
            this.m_widget.setHeaderPlotVisibleCount(0, 1);
            this.m_widget.setHeaderPlotHeader(0, 0, "Interpolated", "Elevation");
            this.m_widget.DrawColor = true;
            this.m_widget.DrawWiggles = false;
            this.m_widget.setPlotBorder(true, Color.BLACK, 2);
            this.m_widget.setEnsembleDisplayOptionsWidget(this.m_wiggleOptionsWidget);
            this.m_widget.setHeaderPlotVisibleCount(0, 1);
            for (int n = 1; n < 4; ++n) {
                this.m_widget.setHeaderPlotVisibleCount(n, 0);
            }
            return this.m_widget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createNewStackWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            this.m_velVersionWidget = new VelocityVersionSelectionWidget(this);
            main.addComponent(this.m_velVersionWidget, 0);
            String s = "<HTML>The new stack will be created using the processing sequence   defined in this window and the velocity function defined in the \"Velocity picker\" window</HTML>";
            main.addComponent(new JLabel(s), 0);
            main.createGapLabel(12);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, 0);
            this.m_reloadVersionColumnButton = new JButton("Reload versions/columns");
            this.m_reloadVersionColumnButton.addActionListener(this);
            this.m_versionCombo.listener().addListener(this);
            int row = 0;
            grid.addSimple(row++, new JLabel("Stack name"), this.m_newStackNameText);
            grid.addSimple(row++, new JLabel("Version name"), this.m_versionCombo);
            grid.addSimple(row++, new JLabel("Statics column"), this.m_columnCombo);
            grid.addSimple(row++, new JLabel(" "), this.m_reloadVersionColumnButton);
            grid.addSimple(row++, new JLabel("Stretch mute %"), this.m_muteText);
            grid.addSimple(row++, new JLabel("Minimum offset"), this.m_minOffText);
            grid.addSimple(row++, new JLabel("Maximum offset"), this.m_maxOffText);
            this.m_stackButton = main.createButton("Create new stack", this, 0);
            main.addComponent(this.m_progress, 0);
            main.addStretch(10);
            LinearLayoutWidget stack = main.createVertical(0, "Batch stack options", 0);
            stack.addComponent(new JLabel("This process uses the above offset limits"), 0);
            stack.addHorzPair(new JLabel("Stack prefix:"), 0, this.m_txtPrefix, 4);
            this.m_btnStackEverything = stack.createButton("Create stacks for all profiles and statics fields", this, 0);
            stack.addHorzPair(this.m_lblStackLine, 4, this.m_lblStackStatic, 4);
            main.setPreferredSize(new Dimension(300, 1200));
            main.setMaximumSize(new Dimension(300, 1200));
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createStackSelectorWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            String s = "<HTML>Select the active profile in the \"Profile manager\" window</HTML>";
            LinearLayoutWidget sub = main.createVertical(0, "Selected profile", 0);
            this.m_profileLabel.setBorder(BorderFactory.createRaisedBevelBorder());
            sub.addComponent(this.m_profileLabel, 0);
            sub.createGapLabel(6);
            sub.addComponent(new JLabel(s), 0);
            this.m_chkDisplayWiggles = new JCheckBox("Display trace wiggles");
            this.m_chkDisplayWiggles.addActionListener(this);
            main.addComponent(this.m_chkDisplayWiggles, 0);
            this.m_chkApplyDespike = new JCheckBox("Apply simple despike");
            this.m_chkApplyDespike.addActionListener(this);
            this.m_chkApplyCompression = new JCheckBox("Data range compression");
            this.m_chkApplyCompression.addActionListener(this);
            sub = main.createHorizontal(3, "Stack amplitude modifications", 0);
            sub.addComponent(this.m_chkApplyDespike, 0);
            sub.addComponent(this.m_chkApplyCompression, 10);
            this.m_chkApplyAGC = new JCheckBox("Apply AGC");
            this.m_chkApplyAGC.addActionListener(this);
            this.m_txtAgcLen = new JTextField("400");
            this.m_txtAgcLen.addActionListener(this);
            sub = main.createHorizontal(3, "Apply AGC to stack", 0);
            sub.addComponent(this.m_chkApplyAGC, 0);
            sub.addComponent(new JLabel("Window (ms)"), 0);
            sub.addComponent(this.m_txtAgcLen, 10);
            this.m_chkInterpolateHeaders = new JCheckBox("Interpolate headers");
            this.m_chkInterpolateHeaders.addActionListener(this);
            sub = main.createHorizontal(3, "Interpolate shot/receiver database values", 0);
            sub.addComponent(this.m_chkInterpolateHeaders, 10);
            int maxVis = 4;
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Select stacks", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("# plots visible"), this.m_visibleCombo);
            for (int n = 0; n < maxVis; ++n) {
                Wrapper wrapper = new Wrapper();
                grid.addSimple(row++, new JLabel(String.format("Plot %d", n + 1)), wrapper.StackCombo);
                this.m_visibleCombo.addItem(String.format("%d", n + 1));
                wrapper.StackCombo.listener().addListener(this);
                this.m_wrapperList.add(wrapper);
                wrapper.LeftClickUEC.addListener(this);
                wrapper.KeyUEC.addListener(this);
                wrapper.LineSegmentUEC.addListener(this);
                wrapper.MiddleClickUEC.addListener(this);
            }
            this.m_visibleCombo.setSelectedIndex(1);
            this.m_visibleCombo.addItemListener(this);
            this.m_axisLockerTime = new Java2D_AxisLocker("Time lock", "Lock axis ");
            this.m_axisLockerTime.listener().addListener(this);
            this.m_axisLockerTime.setRange(250.0, 600.0);
            main.addComponent(this.m_axisLockerTime, 0);
            main.addStretch(10);
            main.setPreferredSize(new Dimension(300, 1200));
            main.setMaximumSize(new Dimension(300, 1200));
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (e.getSource() == this.m_visibleCombo) {
                this.m_widget.setVisibleCount(1 + this.m_visibleCombo.getSelectedIndex());
                this.reloadPlots(true);
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void loadUEC() {
        try {
            this.m_widget.clearUserEventConsumerList();
            PickerGizmo pg = PickerGizmo.singleton();
            boolean needControlPoint = pg.LeftClickAction == PickerGizmo.LeftClickActionEnum.ControlPointAdd || pg.LeftClickAction == PickerGizmo.LeftClickActionEnum.ControlPointKill;
            for (int n = 0; n < this.m_wrapperList.size(); ++n) {
                Wrapper w = this.m_wrapperList.get(n);
                if (needControlPoint) {
                    this.m_widget.addEventConsumer(n, w.LineSegmentUEC);
                } else {
                    this.m_widget.addEventConsumer(n, w.LeftClickUEC);
                }
                this.m_widget.addEventConsumer(n, w.MiddleClickUEC);
                this.m_widget.addEventConsumer(n, w.KeyUEC);
            }
            this.m_widget.addZoomer();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected ArrayList<String> getStaticsColumns(IDatabaseConnection database) {
        try {
            ArrayList<String> recColList = database.listOfColumnNames("Receiver");
            ArrayList<String> shotColList = database.listOfColumnNames("Shot");
            database = null;
            System.gc();
            ArrayList<String> intersection = new ArrayList<String>();
            for (String rec : recColList) {
                boolean ok = false;
                for (String shot : shotColList) {
                    if (!rec.equalsIgnoreCase(shot)) continue;
                    ok = true;
                }
                if (!ok || !rec.startsWith("STATICS_")) continue;
                intersection.add(rec);
            }
            Collections.sort(intersection);
            return intersection;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void reloadStaticsColumns() {
        try {
            String versionName = this.m_versionCombo.getSelectedString();
            IDatabaseConnection database = RefractionStaticsProject.singleton().getVersionDatabase(versionName);
            ArrayList<String> intersection = this.getStaticsColumns(database);
            intersection.add(0, "Do not apply statics");
            this.m_columnCombo.setStringArray(intersection);
            this.m_columnCombo.setSelectedIndex(0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadVersions() {
        try {
            ArrayList<String> versionList = RefractionStaticsProject.singleton().versionList();
            this.m_versionCombo.setStringArray(versionList);
            this.reloadStaticsColumns();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createSequenceWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            String s = "<HTML>The processing sequence is only used when creating new stacks.  You should not apply statics here - apply them using the options on the stack tab.</HTML>";
            JLabel lbl = new JLabel(s);
            lbl.setBorder(BorderFactory.createRaisedBevelBorder());
            main.addComponent(lbl, 0);
            main.createGapLabel(12);
            main.addComponent(this.m_workerWidget, 10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createLeft() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            String sequenceFileName = p.guiOptionsPath() + "/Stack_Comp.SequenceXML";
            this.m_pickerGizmoWidget = new PickerGizmoWidget();
            this.m_workerWidget = new Sequence_MainWidget("Stack_Comp", EnsembleWorker_Sequence.SequenceType.Interactive);
            this.m_workerWidget.setFileName(sequenceFileName);
            this.m_sequence = this.m_workerWidget.sequence();
            if (this.m_sequence.size() < 1) {
                this.m_sequence.add(new EnsembleWorker_AGC());
                this.m_sequence.add(new EnsembleWorker_RMS());
            }
            this.m_wiggleOptionsWidget = new Java2D_EnsembleDisplayOptionsWidget("Trace display options");
            LinearLayoutWidget w = LinearLayoutWidget.vert(0, null);
            w.addComponent(this.m_wiggleOptionsWidget, 0);
            w.addStretch(10);
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Basemap, this.createStackSelectorWidget(), "Basemap");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Stack, this.createNewStackWidget(), "Create new stacks");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Sequence, this.createSequenceWidget(), "Ensemble processing sequence");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Wiggle, w, "Display options");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.PickControl, this.m_pickerGizmoWidget, "Pick controls");
            this.m_bitmapCardWidget.setPreferredSize(new Dimension(300, 500));
            return this.m_bitmapCardWidget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void reloadPlots(boolean reloadStacks) {
        try {
            int n;
            this.m_widget.DrawWiggles = this.m_chkDisplayWiggles.isSelected();
            this.m_widget.DrawColor = !this.m_widget.DrawWiggles;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            SeismicProfile sp = this.m_selectedProfile;
            if (sp == null) {
                for (int n2 = 0; n2 < this.m_wrapperList.size(); ++n2) {
                    this.m_wrapperList.get((int)n2).StackCombo.setStringArray(new ArrayList<String>());
                    this.m_wrapperList.get((int)n2).StackEnsemble = null;
                }
                return;
            }
            if (reloadStacks) {
                for (n = 0; n < this.m_wrapperList.size(); ++n) {
                    this.loadPlot(this.m_wrapperList.get((int)n).StackCombo.getSelectedString(), n);
                }
            }
            for (n = 0; n < this.m_wrapperList.size(); ++n) {
                Ensemble ensemble = this.m_wrapperList.get((int)n).StackEnsemble;
            }
            for (n = 0; n <= this.m_visibleCombo.getSelectedIndex(); ++n) {
                Ensemble e = this.m_wrapperList.get((int)n).StackEnsemble;
                this.m_widget.setEnsemble(n, e);
            }
            this.m_widget.setAxisType(Java2D_EnsembleAxisEnum.UniformSpacing);
            this.m_widget.setTimeLineColorAndSpacing(Color.DARK_GRAY, 50.0);
            this.m_widget.clearAndLoadWigglePaintables();
            this.m_widget.unzoom();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadPlot(String stack, int index) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            SeismicProfile sp = this.m_selectedProfile;
            if (stack == null) {
                this.m_widget.setEnsemble(index, null);
                return;
            }
            Wrapper plotWrapper = this.m_wrapperList.get(index);
            Ensemble ensemble = sp.getStack(stack);
            if (ensemble != null) {
                Tools_Ensemble.copyHeaderValue(ensemble, "Trace", "Easting", "Trace", "CdpX");
                Tools_Ensemble.copyHeaderValue(ensemble, "Trace", "Northing", "Trace", "CdpY");
                ensemble.dictionary().addEntry("Trace", this.EventPickTime, DataType.Float);
                Tools_Ensemble.setHeaderValue(ensemble, "Trace", this.EventPickTime, 0, -9999, 0);
                EnsembleFirstBreakPickPlotData pickPlotData = ensemble.pickPlotData();
                pickPlotData.add(this.EventPickTime, Color.black, 5, Java2D_PointSymbol.FilledOval);
                if (this.m_chkApplyDespike.isSelected()) {
                    this.m_despike.performWork(ensemble);
                    ensemble = this.m_despike.output(0);
                }
                if (this.m_chkApplyCompression.isSelected()) {
                    this.m_squasher.performWork(ensemble);
                    ensemble = this.m_squasher.output(0);
                }
                if (this.m_chkApplyAGC.isSelected()) {
                    double window = Tools_Widget.extractDouble(this.m_txtAgcLen, 40.0, 20.0, 1000.0);
                    this.m_agcWorker.setWindow(window);
                    this.m_agcWorker.performWork(ensemble);
                    ensemble = this.m_agcWorker.output(0);
                    this.m_agcWorker.performWork(ensemble);
                    ensemble = this.m_agcWorker.output(0);
                }
            }
            plotWrapper.StackEnsemble = ensemble;
            if (ensemble != null && this.m_chkInterpolateHeaders.isSelected()) {
                if (index == 0) {
                    Tools_RefractionStaticsProject.computeInterpolatedHeaders(ensemble, "Interpolated", "Trace", "Easting", "Trace", "Northing");
                }
                Tools_Ensemble.copyHeaderValue(ensemble, "Trace", "Easting", "Trace", "CdpX");
                Tools_Ensemble.copyHeaderValue(ensemble, "Trace", "Northing", "Trace", "CdpY");
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadStacks() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            SeismicProfile sp = this.m_selectedProfile;
            if (sp == null) {
                for (int n = 0; n < this.m_wrapperList.size(); ++n) {
                    this.m_wrapperList.get((int)n).StackCombo.setStringArray(new ArrayList<String>());
                    this.m_wrapperList.get((int)n).StackEnsemble = null;
                }
                return;
            }
            ArrayList<String> stacks = sp.stackNames();
            for (int n = 0; n < this.m_wrapperList.size(); ++n) {
                this.m_wrapperList.get((int)n).StackCombo.setStringArray(stacks);
                this.m_wrapperList.get((int)n).StackEnsemble = null;
            }
            this.reloadPlots(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void createAllNewStacks() {
        try {
            String velName;
            VelocityLocationCollection velField;
            this.m_lblStackLine.setText(" ");
            this.m_lblStackStatic.setText(" ");
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            ArrayList<String> versionList = RefractionStaticsProject.singleton().versionList();
            Object prefix = this.m_txtPrefix.getText();
            prefix = Tools_Strings.removeCrap((String)prefix, false);
            if (((String)prefix).length() > 0) {
                prefix = (String)prefix + "_";
            }
            if ((velField = this.m_velManager.getVelocityLocationCollection(velName = this.m_velVersionWidget.getSelectedVersion())).size() < 1) {
                JOptionPane.showMessageDialog(null, "Stacking velocity field not picked", "Stacking velocity field not picked", 0);
                return;
            }
            double mute = Tools_Widget.extractDouble(this.m_muteText, 25.0, 1.0, 100.0);
            double minOff = Tools_Widget.extractDouble(this.m_minOffText, 0.0, 0.0, 30000.0);
            double maxOff = Tools_Widget.extractDouble(this.m_maxOffText, 0.0, 0.0, 40000.0);
            int num = p.getProfileManager().profileCount();
            Table_Abstract shotTable = null;
            HashMap_Integer shotHash = null;
            int colIndexShot = 0;
            Table_Abstract recTable = null;
            HashMap_Integer recHash = null;
            int colIndexRec = 0;
            for (int v = 0; v < versionList.size(); ++v) {
                String versionName = versionList.get(v);
                IDatabaseConnection database = RefractionStaticsProject.singleton().getVersionDatabase(versionName);
                ArrayList<String> intersection = this.getStaticsColumns(database);
                for (int sv = -1; sv < intersection.size(); ++sv) {
                    boolean applyStatics = false;
                    String staticsName = "NoStatics";
                    if (sv >= 0) {
                        applyStatics = true;
                        staticsName = intersection.get(sv);
                        String sql = String.format("SELECT ShotID, %s FROM Shot", staticsName);
                        shotTable = database.extractTableDataUsingQuery("Shot", sql, Pecos.MaxQueryRowCount);
                        shotHash = shotTable.createMapID();
                        colIndexShot = shotTable.column_indexOfColumn(staticsName);
                        sql = String.format("SELECT ReceiverID, %s FROM Receiver", staticsName);
                        recTable = database.extractTableDataUsingQuery("Receiver", sql, Pecos.MaxQueryRowCount);
                        recHash = recTable.createMapID();
                        colIndexRec = recTable.column_indexOfColumn(staticsName);
                    }
                    this.m_lblStackStatic.setText(String.format("%s, %s", versionName, staticsName));
                    this.m_lblStackStatic.paintImmediately(0, 0, 333, 33);
                    staticsName = Tools_Strings.removePrefix(staticsName, "STATICS_");
                    String stackName = (String)prefix + versionName + "_" + staticsName;
                    for (int k = 0; k < num; ++k) {
                        this.m_lblStackLine.setText(String.format("Profile %d of %d", k + 1, num));
                        this.m_lblStackLine.paintImmediately(0, 0, 444, 33);
                        SeismicProfile sp = p.getProfileManager().getSeismicProfile(k);
                        int numBins = sp.binCount();
                        int samplesPerTrace = sp.samplesPerTrace();
                        float t0 = 0.0f;
                        float digi = sp.sampleInterval();
                        velField.setRequestedInterp(t0, digi, samplesPerTrace);
                        StackGizmo giz = new StackGizmo();
                        Ensemble stackEnsemble = new Ensemble();
                        this.m_progress.setMaximum(numBins);
                        try {
                            this.m_sequence.getParametersFromWidgets();
                        }
                        catch (Exception errrr) {
                            errrr.printStackTrace();
                        }
                        boolean requiresTraceTable = this.m_sequence.requiresTraceTableColumns();
                        for (int b = 0; b < numBins; ++b) {
                            this.m_progress.setValue(b);
                            this.m_progress.paintImmediately(0, 0, 600, 30);
                            Ensemble ensemble = new Ensemble();
                            sp.populateSeismicProfileEnsemble(b, ensemble);
                            float[] stack = null;
                            if (ensemble.traceCount() >= 1) {
                                p.prepGeometryHeaders(ensemble, false, false);
                                p.inputDataProcessor_Run(ensemble);
                                if (!ensemble.dictionary().containsEntry("Trace", "Offset")) {
                                    JOptionPane.showMessageDialog(null, "Unable to compute offset - are coords okay?", "Cannot create stack", 0);
                                    return;
                                }
                                try {
                                    if (requiresTraceTable) {
                                        p.traceTableWrapper().traceTable().populateEnsembleUsingTraceIndex(ensemble);
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                Ensemble ensembleProc = this.m_sequence.work(ensemble.clone());
                                if (applyStatics) {
                                    int indexShotID = ensembleProc.dictionary().getEntryIndex("Trace", "ShotID");
                                    int indexRecID = ensembleProc.dictionary().getEntryIndex("Trace", "ReceiverID");
                                    for (int n = 0; n < ensembleProc.traceCount(); ++n) {
                                        float statics = 0.0f;
                                        EnsembleTrace trace = ensembleProc.trace(n);
                                        int shotID = trace.header().getInt(indexShotID);
                                        int shotRow = shotHash.get(shotID);
                                        statics += shotTable.getFloat(shotRow, colIndexShot);
                                        int recID = trace.header().getInt(indexRecID);
                                        int recRow = recHash.get(recID);
                                        trace.data().addShiftToFirstSampleCoord(statics += recTable.getFloat(recRow, colIndexRec));
                                    }
                                }
                                double x = sp.binX(b);
                                double y = sp.binY(b);
                                float[] velocity = velField.getVelocity(x, y);
                                stack = giz.stack(ensembleProc, velocity, t0, digi, mute, minOff, maxOff);
                            } else {
                                stack = new float[samplesPerTrace];
                            }
                            EnsembleTrace stackTrace = stackEnsemble.addTrace();
                            stackTrace.data().insertArray(stack, samplesPerTrace);
                        }
                        sp.saveStack(stackName, stackEnsemble, t0, digi, samplesPerTrace);
                    }
                }
            }
            this.m_lblStackLine.setText(" ");
            this.m_lblStackStatic.setText(" ");
            this.m_progress.setValue(0);
            this.reloadStacks();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void createNewStack() {
        try {
            this.m_progress.setValue(0);
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            SeismicProfile sp = this.m_selectedProfile;
            String stackName = this.m_newStackNameText.getText();
            if (!sp.isNewStackNameOkay(stackName)) {
                return;
            }
            double mute = Tools_Widget.extractDouble(this.m_muteText, 25.0, 1.0, 100.0);
            double minOff = Tools_Widget.extractDouble(this.m_minOffText, 0.0, 0.0, 30000.0);
            double maxOff = Tools_Widget.extractDouble(this.m_maxOffText, 0.0, 0.0, 40000.0);
            int numBins = sp.binCount();
            int samplesPerTrace = sp.samplesPerTrace();
            float t0 = 0.0f;
            float digi = sp.sampleInterval();
            String velName = this.m_velVersionWidget.getSelectedVersion();
            VelocityLocationCollection velField = this.m_velManager.getVelocityLocationCollection(velName);
            if (velField.size() < 1) {
                JOptionPane.showMessageDialog(null, "Stacking velocity field not picked", "Stacking velocity field not picked", 0);
                return;
            }
            velField.setRequestedInterp(t0, digi, samplesPerTrace);
            StackGizmo giz = new StackGizmo();
            boolean applyStatics = this.m_columnCombo.getSelectedIndex() >= 1;
            Table_Abstract shotTable = null;
            HashMap_Integer shotHash = null;
            int colIndexShot = 0;
            Table_Abstract recTable = null;
            HashMap_Integer recHash = null;
            int colIndexRec = 0;
            if (applyStatics) {
                String versionName = this.m_versionCombo.getSelectedString();
                String staticsName = this.m_columnCombo.getSelectedString();
                IDatabaseConnection database = RefractionStaticsProject.singleton().getVersionDatabase(versionName);
                String sql = String.format("SELECT ShotID, %s FROM Shot", staticsName);
                shotTable = database.extractTableDataUsingQuery("Shot", sql, Pecos.MaxQueryRowCount);
                shotHash = shotTable.createMapID();
                colIndexShot = shotTable.column_indexOfColumn(staticsName);
                sql = String.format("SELECT ReceiverID, %s FROM Receiver", staticsName);
                recTable = database.extractTableDataUsingQuery("Receiver", sql, Pecos.MaxQueryRowCount);
                recHash = recTable.createMapID();
                colIndexRec = recTable.column_indexOfColumn(staticsName);
            }
            Ensemble stackEnsemble = new Ensemble();
            this.m_progress.setMaximum(numBins);
            try {
                this.m_sequence.getParametersFromWidgets();
            }
            catch (Exception errrr) {
                errrr.printStackTrace();
            }
            boolean requiresTraceTable = this.m_sequence.requiresTraceTableColumns();
            for (int b = 0; b < numBins; ++b) {
                this.m_progress.setValue(b);
                this.m_progress.paintImmediately(0, 0, 600, 30);
                Ensemble ensemble = new Ensemble();
                sp.populateSeismicProfileEnsemble(b, ensemble);
                float[] stack = null;
                if (ensemble.traceCount() >= 1) {
                    p.prepGeometryHeaders(ensemble, false, false);
                    p.inputDataProcessor_Run(ensemble);
                    if (!ensemble.dictionary().containsEntry("Trace", "Offset")) {
                        JOptionPane.showMessageDialog(null, "Unable to compute offset - are coords okay?", "Cannot create stack", 0);
                        return;
                    }
                    try {
                        if (requiresTraceTable) {
                            p.traceTableWrapper().traceTable().populateEnsembleUsingTraceIndex(ensemble);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Ensemble ensembleProc = this.m_sequence.work(ensemble.clone());
                    if (applyStatics) {
                        int indexShotID = ensembleProc.dictionary().getEntryIndex("Trace", "ShotID");
                        int indexRecID = ensembleProc.dictionary().getEntryIndex("Trace", "ReceiverID");
                        for (int n = 0; n < ensembleProc.traceCount(); ++n) {
                            float statics = 0.0f;
                            EnsembleTrace trace = ensembleProc.trace(n);
                            int shotID = trace.header().getInt(indexShotID);
                            int shotRow = shotHash.get(shotID);
                            statics += shotTable.getFloat(shotRow, colIndexShot);
                            int recID = trace.header().getInt(indexRecID);
                            int recRow = recHash.get(recID);
                            trace.data().addShiftToFirstSampleCoord(statics += recTable.getFloat(recRow, colIndexRec));
                        }
                    }
                    double x = sp.binX(b);
                    double y = sp.binY(b);
                    float[] velocity = velField.getVelocity(x, y);
                    stack = giz.stack(ensembleProc, velocity, t0, digi, mute, minOff, maxOff);
                } else {
                    stack = new float[samplesPerTrace];
                }
                EnsembleTrace stackTrace = stackEnsemble.addTrace();
                stackTrace.data().insertArray(stack, samplesPerTrace);
            }
            sp.saveStack(stackName, stackEnsemble, t0, digi, samplesPerTrace);
            this.m_progress.setValue(0);
            this.reloadStacks();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnStackEverything) {
                this.createAllNewStacks();
                return;
            }
            if (e.getSource() == this.m_chkDisplayWiggles) {
                this.reloadStacks();
                return;
            }
            if (e.getSource() == this.m_chkInterpolateHeaders) {
                this.reloadPlots(true);
                return;
            }
            if (e.getSource() == this.m_chkApplyAGC || e.getSource() == this.m_chkApplyCompression || e.getSource() == this.m_chkApplyDespike) {
                this.reloadPlots(true);
                return;
            }
            if (e.getSource() == this.m_txtAgcLen) {
                this.reloadPlots(true);
                return;
            }
            if (e.getSource() == this.m_reloadVersionColumnButton) {
                this.reloadVersions();
                return;
            }
            if (e.getSource() == this.m_stackButton) {
                this.createNewStack();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void reloadProfile() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            SeismicProfile sp = this.m_selectedProfile;
            if (sp == null) {
                this.m_stackButton.setEnabled(false);
                this.m_profileLabel.setForeground(Color.red);
                this.m_profileLabel.setText("No profile selected");
                return;
            }
            this.m_stackButton.setEnabled(true);
            this.m_profileLabel.setForeground(Color.blue);
            this.m_profileLabel.setText(sp.name());
            this.reloadStacks();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
    }

    protected class Wrapper {
        public ComboStringListWrapper StackCombo = new ComboStringListWrapper();
        public Ensemble StackEnsemble = null;
        public Java2D_UserEventConsumer_MultiLineSegments LineSegmentUEC = new Java2D_UserEventConsumer_MultiLineSegments();
        public Java2D_UserEventConsumer_KeyPressed KeyUEC = new Java2D_UserEventConsumer_KeyPressed();
        public Java2D_UserEventConsumer_ButtonPressed LeftClickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
        public Java2D_UserEventConsumer_ButtonPressed MiddleClickUEC = new Java2D_UserEventConsumer_ButtonPressed(2);

        protected Wrapper() {
        }
    }
}

