/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Stack;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Seismic.SeismicProfile;
import com.PecosLibrary.Stack.ProfileManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

public class ProfileCreationDialog
extends JDialog
implements ActionListener {
    protected JTextField m_spacingText = new JTextField("50");
    protected JTextField m_radiusText = new JTextField("50");
    protected JProgressBar m_progress = new JProgressBar();
    protected JButton m_createButton = new JButton("Create new seismic profile");
    protected JButton m_cancelButton;
    protected JTextField m_minOffText = new JTextField("0");
    protected JTextField m_maxOffText = new JTextField("50000");
    protected JCheckBox m_snapToLine = new JCheckBox("Snap all traces to the profile line");
    protected double m_x1;
    protected double m_y1;
    protected double m_x2;
    protected double m_y2;
    protected boolean m_multipleLines;
    protected double m_lineSpacing = 0.0;
    protected int m_lineCount;
    public SeismicProfile NewProfile = null;

    public ProfileCreationDialog(double x1, double y1, double x2, double y2, boolean multipleLines, double lineSpacing, int lineCount) {
        try {
            this.m_multipleLines = multipleLines;
            this.m_lineSpacing = lineSpacing;
            this.m_lineCount = lineCount;
            this.m_x1 = x1;
            this.m_y1 = y1;
            this.m_x2 = x2;
            this.m_y2 = y2;
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget middle = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            GridLayoutWidget grid = middle.createGridLayoutWidget(3, 0);
            ParameterTree tree = RefractionStaticsProject.singleton().information();
            this.m_spacingText.setText(tree.string_get("PL_BinSpacing", "50"));
            this.m_radiusText.setText(tree.string_get("PL_BinSize", "50"));
            this.m_minOffText.setText(tree.string_get("PL_MinOff", "0"));
            this.m_maxOffText.setText(tree.string_get("PL_MaxOff", "50000"));
            grid.addSimple(0, new JLabel("Bin center spacing (ft/m)"), this.m_spacingText);
            grid.addSimple(1, new JLabel("Bin size (ft/m)"), this.m_radiusText);
            grid.addSimple(2, new JLabel("Minimum offset"), this.m_minOffText);
            grid.addSimple(3, new JLabel("Maximum offset"), this.m_maxOffText);
            if (!this.m_multipleLines && RefractionStaticsProject.singleton().dim3D()) {
                middle.addComponent(this.m_snapToLine, 0);
            }
            this.m_createButton.addActionListener(this);
            middle.addComponent(this.m_createButton, 0);
            middle.addComponent(this.m_progress, 0);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addStretch(10);
            this.m_cancelButton = bottom.createButton("Cancel", this, 0);
            bottom.addStretch(10);
            this.getContentPane().add((Component)middle, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setTitle("Create a new profile");
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void createProfile() {
        boolean inputSequenceOn = false;
        try {
            ProfileManager pm = RefractionStaticsProject.singleton().getProfileManager();
            inputSequenceOn = RefractionStaticsProject.singleton().inputDataSequenceOn();
            RefractionStaticsProject.singleton().inputDataSequenceOn_Set(false);
            String name = pm.getNextName();
            if (!pm.isNewProfileNameOkay(name)) {
                return;
            }
            double dx = this.m_x2 - this.m_x1;
            double dy = this.m_y2 - this.m_y1;
            double lineLength = Math.sqrt(dx * dx + dy * dy + 1.0);
            double minSpacing = lineLength / 400.0;
            double maxSpacing = lineLength / 40.0;
            double spacing = Tools_Widget.extractDouble(this.m_spacingText, 100.0, minSpacing, maxSpacing);
            double radius = Tools_Widget.extractDouble(this.m_radiusText, 100.0, 10.0, 1000.0);
            double minOff = Tools_Widget.extractDouble(this.m_minOffText, 0.0, 0.0, 1000000.0);
            double maxOff = Tools_Widget.extractDouble(this.m_maxOffText, 50000.0, minOff + 1.0, minOff + 1000000.0);
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            ParameterTree tree = project.information();
            tree.string_put("PL_BinSpacing", this.m_spacingText.getText());
            tree.string_put("PL_BinSize", this.m_radiusText.getText());
            tree.string_put("PL_MinOff", this.m_minOffText.getText());
            tree.string_put("PL_MaxOff", this.m_maxOffText.getText());
            project.saveInformation();
            ITraceTable traceTable = project.traceTableWrapper().traceTable();
            long totalTraces = traceTable.rowCount();
            this.m_progress.setMaximum((int)(totalTraces / 10L));
            Ensemble ensemble = new Ensemble();
            String path = Tools_FileSystem.confirmSubDirectoryExists(pm.path(), name);
            SeismicProfile profile = new SeismicProfile(path, this.m_x1, this.m_y1, this.m_x2, this.m_y2, spacing, radius);
            profile.MinimumOffset = minOff;
            profile.MaximumOffset = maxOff;
            profile.Dim2D = RefractionStaticsProject.singleton().dim2D();
            profile.ProfileSnapOn = this.m_snapToLine.isSelected();
            int h = this.m_progress.getSize().height;
            int w = this.m_progress.getSize().width;
            long currentIndex = 0L;
            RefractionStaticsProject.singleton().prepSeismicFilesForScanning();
            while (currentIndex < totalTraces) {
                this.m_progress.setValue((int)(currentIndex / 10L));
                this.m_progress.paintImmediately(0, 0, w, h);
                project.ensemble_Sequence(ensemble, currentIndex, 5000, true);
                profile.appendEnsemble_SecondPass(ensemble);
                int chunk = (int)((currentIndex += 5000L) / 5000L);
                if (chunk % 20 != 0) continue;
                double percent = 100.0 * (double)currentIndex / (double)totalTraces;
                System.out.println("Percent = " + Double.toString(percent));
            }
            profile.finishedSecondPass();
            pm.reloadProfileList();
            RefractionStaticsProject.singleton().finishedSeismicFileScanning();
            this.NewProfile = profile;
            this.dispose();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        try {
            RefractionStaticsProject.singleton().inputDataSequenceOn_Set(inputSequenceOn);
            this.dispose();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        try {
            RefractionStaticsProject.singleton().finishedSeismicFileScanning();
            this.dispose();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void createMultipleProfiles() {
        boolean inputSequenceOn = false;
        try {
            ProfileManager pm = RefractionStaticsProject.singleton().getProfileManager();
            inputSequenceOn = RefractionStaticsProject.singleton().inputDataSequenceOn();
            RefractionStaticsProject.singleton().inputDataSequenceOn_Set(false);
            int startID = pm.getNextMultipleLineID();
            this.m_lineCount = Math.max(this.m_lineCount, 3);
            if (this.m_lineCount % 2 == 0) {
                ++this.m_lineCount;
            }
            int half = this.m_lineCount / 2;
            double dx = this.m_x2 - this.m_x1;
            double dy = this.m_y2 - this.m_y1;
            double lineLength = Math.sqrt(dx * dx + dy * dy + 1.0);
            double minSpacing = lineLength / 400.0;
            double maxSpacing = lineLength / 40.0;
            double spacing = Tools_Widget.extractDouble(this.m_spacingText, 100.0, minSpacing, maxSpacing);
            double radius = Tools_Widget.extractDouble(this.m_radiusText, 100.0, 10.0, 1000.0);
            double minOff = Tools_Widget.extractDouble(this.m_minOffText, 0.0, 0.0, 1000000.0);
            double maxOff = Tools_Widget.extractDouble(this.m_maxOffText, 50000.0, minOff + 1.0, minOff + 1000000.0);
            double angle = Math.atan2(dy, dx);
            double perp = angle + 1.5707963267948966;
            double sx = this.m_lineSpacing * Math.cos(perp);
            double sy = this.m_lineSpacing * Math.sin(perp);
            ArrayList<SeismicProfile> profiles = new ArrayList<SeismicProfile>();
            for (int n = -half; n <= half; ++n) {
                int id = startID + n + half;
                String name = "Profile" + Integer.toString(id);
                String path = pm.path() + "/" + name;
                if (!pm.isNewProfileNameOkay(name)) {
                    return;
                }
                double x1 = this.m_x1 + (double)n * sx;
                double y1 = this.m_y1 + (double)n * sy;
                double x2 = this.m_x2 + (double)n * sx;
                double y2 = this.m_y2 + (double)n * sy;
                SeismicProfile profile = new SeismicProfile(path, x1, y1, x2, y2, spacing, radius);
                profile.MinimumOffset = minOff;
                profile.MaximumOffset = maxOff;
                profile.Dim2D = RefractionStaticsProject.singleton().dim2D();
                profile.ProfileSnapOn = false;
                profiles.add(profile);
            }
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            ITraceTable traceTable = project.traceTableWrapper().traceTable();
            long totalTraces = traceTable.rowCount();
            this.m_progress.setMaximum((int)(totalTraces / 100L));
            Ensemble ensemble = new Ensemble();
            int h = this.m_progress.getSize().height;
            int w = this.m_progress.getSize().width;
            long currentIndex = 0L;
            while (currentIndex < totalTraces) {
                this.m_progress.setValue((int)(currentIndex / 100L));
                this.m_progress.paintImmediately(0, 0, w, h);
                project.ensemble_Sequence(ensemble, currentIndex, 5000, true);
                for (SeismicProfile profile : profiles) {
                    profile.appendEnsemble_SecondPass(ensemble);
                }
                int chunk = (int)((currentIndex += 5000L) / 5000L);
                if (chunk % 20 != 0) continue;
                double percent = 100.0 * (double)currentIndex / (double)totalTraces;
                System.out.println("Percent = " + Double.toString(percent));
            }
            for (SeismicProfile profile : profiles) {
                profile.finishedSecondPass();
            }
            pm.reloadProfileList();
            this.NewProfile = (SeismicProfile)profiles.get(half);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        try {
            RefractionStaticsProject.singleton().inputDataSequenceOn_Set(inputSequenceOn);
            this.dispose();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_createButton) {
                if (!this.m_multipleLines) {
                    this.createProfile();
                } else {
                    this.createMultipleProfiles();
                }
                return;
            }
            if (e.getSource() == this.m_cancelButton) {
                this.dispose();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

