/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Shear;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Seismic.Segy.Segy_Dictionary;
import com.PecosCore.Tools.Tools_ByteArray;
import com.PecosLibrary.Ensemble.Worker.Geometry.EnsembleWorker_ComputeAzimuthAndOffset;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_VertStackedEnsembleDisplayWidget;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import javax.swing.JProgressBar;

public class ShearRotationData {
    public Ensemble EnsembleMaxH = new Ensemble();
    public Ensembles EnsemblesP = new Ensembles();
    public Ensembles EnsemblesH1 = new Ensembles();
    public Ensembles EnsemblesH2 = new Ensembles();
    public Segy SegyP = new Segy();
    public Segy SegyH1 = new Segy();
    public Segy SegyH2 = new Segy();
    public Segy_Dictionary Dict = new Segy_Dictionary();
    public EnsembleWorker_Sequence Sequence;
    public EnsembleWorker_ComputeAzimuthAndOffset m_computeOffset = new EnsembleWorker_ComputeAzimuthAndOffset();
    public boolean Valid = false;
    public double Angle1 = 1.57;
    public double Angle2 = 0.0;
    protected float[] m_temp1 = new float[2];
    protected float[] m_temp2 = new float[2];
    protected float[] m_temp3 = new float[2];
    public String OutFilename = "";

    public void export(JProgressBar bar) {
        try {
            this.SegyH1.setSegyDictionary(this.Dict);
            this.SegyH2.setSegyDictionary(this.Dict);
            bar.setValue(0);
            int numTraces = (int)this.SegyH1.traceCount();
            int numPerChunk = 20000;
            int startTrace = 0;
            RandomAccessFile raf = new RandomAccessFile(this.OutFilename, "rw");
            raf.write(this.SegyH1.ebcdicBytes(), 0, 3200);
            raf.write(this.SegyH1.headerBytes(), 0, 400);
            ByteBuffer blob = ByteBuffer.allocate(100000 + numPerChunk * this.SegyH1.bytesPerTrace());
            this.SegyH1.setBufferForSequentialRead(blob);
            int sampPerTrace = this.SegyH1.samplesPerTrace();
            float[] temp = new float[sampPerTrace];
            byte[] out = new byte[4 * sampPerTrace];
            while (startTrace < numTraces) {
                int lastTrace = startTrace + numPerChunk - 1;
                if (lastTrace >= numTraces) {
                    lastTrace = numTraces - 1;
                }
                int numInThisChunk = lastTrace - startTrace + 1;
                long start = System.currentTimeMillis();
                this.EnsemblesH1.ProcessedEnsemble.clearTraces(false);
                this.SegyH1.populateEnsemble(this.EnsemblesH1.ProcessedEnsemble, startTrace, numInThisChunk, true, true);
                this.EnsemblesH2.ProcessedEnsemble.clearTraces(false);
                this.SegyH2.populateEnsemble(this.EnsemblesH2.ProcessedEnsemble, startTrace, numInThisChunk, true, true);
                Tools_Ensemble.computeAzimuthAndOffset(this.EnsemblesH1.ProcessedEnsemble);
                Tools_Ensemble.computeAzimuthAndOffset(this.EnsemblesH2.ProcessedEnsemble);
                long read = System.currentTimeMillis() - start;
                start = System.currentTimeMillis();
                this.computeMaxH(null, 0);
                long compute = System.currentTimeMillis() - start;
                start = System.currentTimeMillis();
                for (int n = 0; n < numInThisChunk; ++n) {
                    int offset = n * this.SegyH1.bytesPerTrace() + 240;
                    this.EnsembleMaxH.trace(n).data().copyToArray(temp);
                    Tools_ByteArray.convertFloatToIBM(out, temp, sampPerTrace);
                    byte[] blobbytes = blob.array();
                    for (int b = 0; b < 4 * sampPerTrace; ++b) {
                        blobbytes[b + offset] = out[b];
                    }
                }
                long convert = System.currentTimeMillis() - start;
                start = System.currentTimeMillis();
                raf.write(blob.array(), 0, numInThisChunk * this.SegyH1.bytesPerTrace());
                String s = String.format("%d,   read=%d  compute=%d  convert=%d", startTrace += numPerChunk, (int)read, (int)compute, (int)convert);
                System.out.println(s);
            }
            raf.close();
            bar.setValue(0);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void computeMaxH(Java2D_VertStackedEnsembleDisplayWidget widget, int index) {
        try {
            Ensemble eh1 = this.EnsemblesH1.ProcessedEnsemble;
            Ensemble eh2 = this.EnsemblesH2.ProcessedEnsemble;
            this.EnsembleMaxH = eh1.clone();
            int indexAz1 = eh1.dictionary().getEntryIndex("Trace", "Azimuth");
            int indexAz2 = eh2.dictionary().getEntryIndex("Trace", "Azimuth");
            int indexAzMax = this.EnsembleMaxH.dictionary().getEntryIndex("Trace", "Azimuth");
            float cos1 = (float)Math.cos(this.Angle1);
            float sin1 = (float)Math.sin(this.Angle1);
            float cos2 = (float)Math.cos(this.Angle2);
            float sin2 = (float)Math.sin(this.Angle2);
            for (int n = 0; n < eh1.traceCount(); ++n) {
                EnsembleTrace t1 = eh1.trace(n);
                EnsembleTrace t2 = eh2.trace(n);
                EnsembleTrace tm = this.EnsembleMaxH.trace(n);
                double azimuth1 = t1.header().getDouble(indexAz1);
                double azimuth2 = t2.header().getDouble(indexAz2);
                double azimuthm = tm.header().getDouble(indexAzMax);
                double azimuthFlipped = azimuth1 + Math.PI;
                float cosaf = (float)Math.cos(azimuthFlipped);
                float sinaf = (float)Math.sin(azimuthFlipped);
                if (this.m_temp1.length != t1.data().length()) {
                    this.m_temp1 = new float[t1.data().length()];
                    this.m_temp2 = new float[t1.data().length()];
                    this.m_temp3 = new float[t1.data().length()];
                }
                t1.data().copyToArray(this.m_temp1);
                t2.data().copyToArray(this.m_temp2);
                for (int s = 0; s < this.m_temp1.length; ++s) {
                    float sample1 = 1000.0f * this.m_temp1[s];
                    float sample2 = 1000.0f * this.m_temp2[s];
                    float x1 = sample1 * cos1;
                    float y1 = sample1 * sin1;
                    float x2 = sample2 * cos2;
                    float y2 = sample2 * sin2;
                    float x = x1 + x2;
                    float y = y1 + y2;
                    this.m_temp3[s] = x * cosaf + y * sinaf;
                }
                tm.data().insertArray(this.m_temp3, this.m_temp3.length);
            }
            if (widget != null) {
                widget.setEnsemble(index, this.EnsembleMaxH);
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void loadEnsembles(Java2D_VertStackedEnsembleDisplayWidget widget, int first, int count) {
        try {
            this.loadEnsembles(widget, first, count, 0, this.EnsemblesP, this.SegyP);
            this.loadEnsembles(widget, first, count, 1, this.EnsemblesH1, this.SegyH1);
            this.loadEnsembles(widget, first, count, 2, this.EnsemblesH2, this.SegyH2);
            this.computeMaxH(widget, 3);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void loadEnsembles(Java2D_VertStackedEnsembleDisplayWidget widget, int first, int count, int index, Ensembles ensembles, Segy segy) {
        try {
            segy.setSegyDictionary(this.Dict);
            ensembles.InputEnsemble.clearTraces(false);
            segy.populateEnsemble(ensembles.InputEnsemble, first, count, true, true);
            ensembles.ProcessedEnsemble.clearTraces(true);
            Tools_Ensemble.computeAverageAmplitude(ensembles.InputEnsemble, "AVGAMP");
            Tools_Ensemble.computeMaximumAmplitude(ensembles.InputEnsemble, "MAXAMP");
            ensembles.InputEnsemble.copyToOtherEnsemble(ensembles.ProcessedEnsemble);
            this.m_computeOffset.performWork(ensembles.ProcessedEnsemble);
            ensembles.ProcessedEnsemble = this.Sequence.work(ensembles.ProcessedEnsemble);
            widget.setEnsemble(index, ensembles.ProcessedEnsemble);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public class Ensembles {
        public Ensemble InputEnsemble = new Ensemble();
        public Ensemble InputEnsemble_Copy = new Ensemble();
        public Ensemble ProcessedEnsemble = new Ensemble();
    }
}

