/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Shared;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.util.ArrayList;
import javax.swing.JLabel;

public class TableColumnSelectorWidget
extends GridLayoutWidget
implements GenericObjectListener.Listener,
Messenger.Listener {
    protected GenericObjectListener m_listener = new GenericObjectListener();
    protected ParameterTree m_parameterTree = null;
    protected ComboStringListWrapper m_cmbTable = new ComboStringListWrapper();
    protected ComboStringListWrapper m_cmbColumn = new ComboStringListWrapper();
    protected String m_keyColumn;
    protected String m_keyTable;
    public int Row = 0;

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public TableColumnSelectorWidget(String borderLabel, int insets, ParameterTree tree, GenericObjectListener.Listener listener, String keyTable, String keyColumn, String defTable, String defColumn) {
        super(insets, borderLabel);
        try {
            if (listener != null) {
                this.m_listener.addListener(listener);
            }
            this.m_parameterTree = tree;
            this.m_cmbTable.setPreferredSelected(defTable);
            this.m_cmbColumn.setPreferredSelected(defColumn);
            this.addSimple(this.Row++, new JLabel("Table:"), this.m_cmbTable);
            this.addSimple(this.Row++, new JLabel("Column:"), this.m_cmbColumn);
            Messenger.singleton().addListener(this);
            this.m_cmbTable.listener().addListener(this);
            this.m_cmbColumn.listener().addListener(this);
            this.m_keyTable = keyTable;
            this.m_keyColumn = keyColumn;
            if (this.m_parameterTree != null) {
                defTable = this.m_parameterTree.string_get(this.m_keyTable, defTable);
                defColumn = this.m_parameterTree.string_get(this.m_keyColumn, defColumn);
                this.m_cmbTable.setPreferredSelected(defTable);
                this.m_cmbColumn.setPreferredSelected(defColumn);
                this.reloadCombo();
            }
            this.reloadCombo();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (sender == this.m_cmbTable) {
                String table = this.m_cmbTable.getSelectedString();
                ArrayList<String> columns = null;
                if (table.equalsIgnoreCase("Shot")) {
                    columns = p.shotTable().column_listOfNames();
                }
                if (table.equalsIgnoreCase("Receiver")) {
                    columns = p.receiverTable().column_listOfNames();
                }
                if (table.equalsIgnoreCase("Trace")) {
                    columns = p.traceTableWrapper().traceTable().columns();
                }
                this.m_cmbColumn.setStringArray(columns);
                String column = this.m_cmbColumn.getSelectedString();
                if (this.m_parameterTree != null) {
                    this.m_parameterTree.string_put(this.m_keyTable, table);
                    this.m_parameterTree.string_put(this.m_keyColumn, column);
                }
            }
            if (sender == this.m_cmbColumn) {
                String column = this.m_cmbColumn.getSelectedString();
                if (this.m_parameterTree != null) {
                    this.m_parameterTree.string_put(this.m_keyColumn, column);
                }
            }
            this.m_listener.broadcast(this, data);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            if (message == Messenger.Message.ColumnsModified || message == Messenger.Message.ProjectVersionChanged) {
                this.reloadCombo();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadCombo() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            ArrayList<String> tables = new ArrayList<String>();
            tables.add("Shot");
            tables.add("Receiver");
            tables.add("Trace");
            this.m_cmbTable.setStringArray(tables);
            String table = this.m_cmbTable.getSelectedString();
            ArrayList<String> columns = null;
            if (table.equalsIgnoreCase("Shot")) {
                columns = p.shotTable().column_listOfNames();
            }
            if (table.equalsIgnoreCase("Receiver")) {
                columns = p.receiverTable().column_listOfNames();
            }
            if (table.equalsIgnoreCase("Trace")) {
                columns = p.traceTableWrapper().traceTable().columns();
            }
            this.m_cmbColumn.setStringArray(columns);
            if (this.m_parameterTree != null) {
                this.m_parameterTree.string_put(this.m_keyTable, table);
                this.m_parameterTree.string_put(this.m_keyColumn, this.m_cmbColumn.getSelectedString());
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

