/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Shared;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Tools.Tools_Bitmap;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PopupMenuButton
extends JButton
implements ActionListener,
MouseListener {
    protected ArrayList<String> m_rootOptions = new ArrayList();
    protected HashMap<String, ArrayList<String>> m_map = new HashMap();
    protected WeakReference<Listener> m_listener;

    public PopupMenuButton(String imageName, String buttonText, Listener listener) {
        try {
            if (imageName != null) {
                ImageIcon icon = Tools_Bitmap.makeIcon(imageName);
                if (icon != null) {
                    this.setIcon(icon);
                    if (buttonText != null) {
                        this.setToolTipText(buttonText);
                    }
                } else {
                    this.setText(buttonText);
                }
            } else {
                this.setText(buttonText);
            }
            this.addMouseListener(this);
            this.m_listener = new WeakReference<Listener>(listener);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addOption(String root, String txt) {
        try {
            if (txt == null || root == null) {
                return;
            }
            if (txt.length() < 1 || root.length() < 1) {
                return;
            }
            if (!this.m_map.containsKey(root)) {
                this.m_map.put(root, new ArrayList());
            }
            this.m_map.get(root).add(txt);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addOption(String txt) {
        try {
            if (txt == null) {
                return;
            }
            if (txt.length() < 1) {
                return;
            }
            this.m_rootOptions.add(txt);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() instanceof JMenuItem) {
                JMenuItem mi = (JMenuItem)e.getSource();
                Listener listener = (Listener)this.m_listener.get();
                if (listener != null) {
                    listener.handlePopupMenuButton(this, mi.getText());
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    protected void showPopupMenu(MouseEvent event) {
        try {
            if (this.m_rootOptions.size() < 1 && this.m_map.size() < 1) {
                return;
            }
            JPopupMenu popupMenu = new JPopupMenu();
            for (String root : this.m_rootOptions) {
                JMenuItem item = new JMenuItem(root);
                item.addActionListener(this);
                popupMenu.add(item);
            }
            for (String root : this.m_map.keySet()) {
                JMenu menu = new JMenu(root);
                popupMenu.add(menu);
                ArrayList<String> list = this.m_map.get(root);
                for (String txt : list) {
                    JMenuItem item = new JMenuItem(txt);
                    item.addActionListener(this);
                    menu.add(item);
                }
            }
            popupMenu.show(event.getComponent(), event.getX(), event.getY());
            popupMenu.setVisible(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        try {
            this.showPopupMenu(event);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    public static interface Listener {
        public void handlePopupMenuButton(PopupMenuButton var1, String var2);
    }
}

