/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Shared;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class MultiTextDialog
extends JDialog
implements ActionListener {
    protected LinearLayoutWidget m_buttonPanel = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
    protected GridLayoutWidget m_grid = new GridLayoutWidget(3, null);
    protected int m_row = 0;
    protected JButton m_btnOK = new JButton("Create new model");
    protected JButton m_btnCancel = new JButton("Cancel");
    protected ArrayList<JLabel> m_listLabel = new ArrayList();
    protected ArrayList<JTextField> m_listText = new ArrayList();
    public boolean OK = false;

    public MultiTextDialog(Frame parent, String title, String ... labels) {
        super(parent, title, true);
        try {
            this.getContentPane().setLayout(new BorderLayout());
            this.m_row = 0;
            for (String lbl : labels) {
                JLabel label = new JLabel(lbl);
                this.m_listLabel.add(label);
                JTextField txt = new JTextField("");
                this.m_listText.add(txt);
                this.m_grid.addSimple(this.m_row++, label, txt);
            }
            this.getContentPane().add((Component)this.m_grid, "Center");
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.m_buttonPanel.addComponent(this.m_btnOK, 0);
            this.m_buttonPanel.addComponent(this.m_btnCancel, 0);
            this.m_buttonPanel.addStretch(10);
            this.getContentPane().add((Component)this.m_buttonPanel, "South");
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setSize(this.getSize().width + 250, this.getSize().height);
            this.setLocationRelativeTo(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public int grid_row() {
        return this.m_row;
    }

    public GridLayoutWidget grid_widget() {
        return this.m_grid;
    }

    public void showDialog(String okText) {
        try {
            this.m_btnOK.setText(okText);
            this.OK = false;
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void showDialog() {
        try {
            this.OK = false;
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setText(int index, String s) throws Exception {
        try {
            this.m_listText.get(index).setText(s);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public String getText(int index) throws Exception {
        try {
            return this.m_listText.get(index).getText();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public double getDouble(int index, double failureValue, double minimum, double maximum) throws Exception {
        try {
            return Tools_Widget.extractDouble(this.m_listText.get(index), failureValue, minimum, maximum);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public int getInt(int index, int failureValue, int minimum, int maximum) throws Exception {
        try {
            return Tools_Widget.extractInteger(this.m_listText.get(index), failureValue, minimum, maximum);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnOK) {
                this.OK = true;
                this.dispose();
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

