/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Shared;

import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Ensemble.Sequence.Sequence_SplitterWidget;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.Timer;

public class InputDataProcessingDialog
extends JDialog
implements ActionListener {
    protected Sequence_SplitterWidget m_splitter;
    protected JCheckBox m_chkOff = new JCheckBox("Apply offset limits");
    protected JTextField m_txtMinOff = new JTextField("0");
    protected JTextField m_txtMaxOff = new JTextField("100000");
    protected JCheckBox m_chkAz = new JCheckBox("Apply azimuth limits");
    protected JTextField m_txtAzDir = new JTextField("90");
    protected JTextField m_txtAzAngle = new JTextField("45");
    protected JCheckBox m_chkOn = new JCheckBox("Apply input processing options");
    protected JButton m_btnCancel;
    protected Timer m_timer = new Timer(1000, this);

    public InputDataProcessingDialog() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            LinearLayoutWidget main = LinearLayoutWidget.vert(5, null);
            this.getContentPane().setLayout(new BorderLayout());
            EnsembleWorker_Sequence sequence = RefractionStaticsProject.singleton().inputDataSequence();
            sequence.removeAllListeners();
            this.m_splitter = new Sequence_SplitterWidget(sequence);
            sequence.setSelectedIndex(0);
            this.m_chkOn.setSelected(p.inputDataSequenceOn());
            main.addComponent(this.m_chkOn, 0);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Offset limits", 0);
            grid.addSimple(0, new JLabel(""), this.m_chkOff);
            grid.addSimple(1, new JLabel("Minimum offset"), this.m_txtMinOff);
            grid.addSimple(2, new JLabel("Maximum offset"), this.m_txtMaxOff);
            this.m_chkOff.setSelected(p.inputDataSequence_ApplyOffsetLimits());
            this.m_txtMinOff.setText(Double.toString(p.inputDataSequence_MinOffset()));
            this.m_txtMaxOff.setText(Double.toString(p.inputDataSequence_MaxOffset()));
            grid = main.createGridLayoutWidget(0, "Azimuth limits", 0);
            grid.addSimple(0, new JLabel(""), this.m_chkAz);
            grid.addSimple(1, new JLabel("Direction"), this.m_txtAzDir);
            grid.addSimple(2, new JLabel("Acceptance angle"), this.m_txtAzAngle);
            this.m_chkAz.setSelected(p.inputDataSequence_ApplyAzimuthLimits());
            this.m_txtAzDir.setText(Double.toString(180.0 * p.inputDataSequence_AzDir() / Math.PI));
            this.m_txtAzAngle.setText(Double.toString(180.0 * p.inputDataSequence_AzAngle() / Math.PI));
            main.addComponent(this.m_splitter, 10);
            this.m_splitter.setBorder(BorderFactory.createLineBorder(Color.black));
            this.getContentPane().add((Component)main, "Center");
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addStretch(10);
            this.m_btnCancel = bottom.createButton("Close", this, 0);
            bottom.addStretch(10);
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setSize(this.getSize().width + 190, this.getSize().height + 500);
            this.setTitle("Define input processing sequence");
            this.setLocationRelativeTo(null);
            this.m_timer.start();
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (e.getSource() == this.m_btnCancel) {
                p.inputDataSequenceOn_Set(this.m_chkOn.isSelected());
                p.inputDataProcessor_Save();
                p.setInputDataSequence_ApplyOffsetLimits(this.m_chkOff.isSelected());
                double min = Tools_Widget.extractDouble(this.m_txtMinOff, 0.0, 0.0, 30000.0);
                double max = Tools_Widget.extractDouble(this.m_txtMaxOff, min + 100.0, min + 100.0, 30000.0);
                p.setInputDataSequence_MinOffset(min);
                p.setInputDataSequence_MaxOffset(max);
                double dir = Math.PI * Tools_Widget.extractDouble(this.m_txtAzDir, 0.0, -360.0, 360.0) / 180.0;
                double angle = Math.PI * Tools_Widget.extractDouble(this.m_txtAzAngle, 45.0, 2.0, 90.0) / 180.0;
                p.setInputDataSequence_ApplyAzimuthLimits(this.m_chkAz.isSelected());
                p.setInputDataSequence_AzDir(dir);
                p.setInputDataSequence_AzAngle(angle);
                this.dispose();
            }
            if (e.getSource() == this.m_timer) {
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

