/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Shared;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.ExceptionMonitorEntry;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Shared.ScrollTable;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class ExceptionMonitorPanel
extends LinearLayoutWidget
implements ActionListener,
ListSelectionListener,
GenericObjectListener.Listener {
    protected JButton m_btnSave;
    protected JLabel m_lblSave;
    protected ScrollTable m_mainTable = new ScrollTable();
    protected ScrollTable m_detailTable = new ScrollTable();

    public ExceptionMonitorPanel() {
        super(LinearLayoutWidget.Direction.Vertical, 0, null);
        try {
            LinearLayoutWidget top = this.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null, 0);
            this.m_btnSave = top.createButton("Save", this, 0);
            this.m_lblSave = top.createLabel("", 0, 10);
            this.addComponent(this.m_mainTable, 10);
            this.addComponent(new JLabel("Details of selected exception:"), 0);
            this.addComponent(this.m_detailTable, 10);
            this.m_mainTable.table().setModel(ExceptionMonitor.instance());
            this.m_mainTable.table().getSelectionModel().addListSelectionListener(this);
            this.m_mainTable.setMininimumColumnWidth(0, 410);
            this.m_mainTable.setMininimumColumnWidth(1, 310);
            ExceptionMonitor.instance().getListenerController().addListener(this);
            this.reload();
            this.m_lblSave.setText("");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void reload() {
        try {
            this.m_detailTable.table().setModel(new DefaultTableModel());
            ExceptionMonitor.instance().fireTableDataChanged();
            this.m_lblSave.setText("Current exception list not saved");
            this.m_lblSave.setForeground(Color.red);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == ExceptionMonitor.instance() && data != null) {
                if (!(data instanceof ExceptionMonitor.Message)) {
                    return;
                }
                ExceptionMonitor.Message message = (ExceptionMonitor.Message)((Object)data);
                if (message == ExceptionMonitor.Message.ExceptionAdded) {
                    this.reload();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            this.m_detailTable.table().setModel(new DefaultTableModel());
            int[] sel = this.m_mainTable.table().getSelectedRows();
            if (sel == null) {
                return;
            }
            if (sel.length < 1) {
                return;
            }
            ExceptionMonitorEntry entry = ExceptionMonitor.instance().getEntry(sel[0]);
            if (entry == null) {
                return;
            }
            this.m_detailTable.table().setModel(entry);
            this.m_detailTable.setMininimumColumnWidth(0, 410);
            this.m_detailTable.setMininimumColumnWidth(1, 310);
            this.m_detailTable.setMininimumColumnWidth(3, 310);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnSave) {
                String message = ExceptionMonitor.instance().saveCurrentState();
                this.m_lblSave.setText(message);
                this.m_lblSave.setForeground(Color.blue);
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }
}

