/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Shared;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Windows.Shared.ScrollTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

public class EnvironmentVariablesWidget
extends ScrollTable {
    public EnvironmentVariablesWidget() {
        try {
            this.m_table.setModel(new PropsModel());
            this.setMininimumColumnWidth(0, 400);
            this.setMininimumColumnWidth(1, 800);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected class PropsModel
    extends AbstractTableModel {
        protected ArrayList<String> m_keys = new ArrayList();
        protected ArrayList<String> m_vals = new ArrayList();

        public PropsModel() {
            try {
                Map<String, String> env = System.getenv();
                for (String envName : env.keySet()) {
                    this.m_keys.add(envName);
                }
                Collections.sort(this.m_keys);
                for (String envName : this.m_keys) {
                    this.m_vals.add(env.get(envName));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public int getRowCount() {
            return this.m_keys.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int column) {
            try {
                if (row < 0 || row >= this.m_keys.size()) {
                    return "";
                }
                if (column == 0) {
                    return this.m_keys.get(row);
                }
                if (column == 1) {
                    return this.m_vals.get(row);
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
            return " ";
        }

        @Override
        public String getColumnName(int column) {
            try {
                if (column == 0) {
                    return "Property name";
                }
                if (column == 1) {
                    return "Property value";
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
            return "Error";
        }
    }
}

