/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Shared;

import com.PecosCore.Shared.ExceptionMonitor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.ref.WeakReference;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicButtonUI;

public class ButtonTabComponent
extends JPanel {
    protected WeakReference<JTabbedPane> m_pane;
    private static final MouseListener buttonMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            try {
                Component component = e.getComponent();
                if (component instanceof AbstractButton) {
                    AbstractButton button = (AbstractButton)component;
                    button.setBorderPainted(true);
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            try {
                Component component = e.getComponent();
                if (component instanceof AbstractButton) {
                    AbstractButton button = (AbstractButton)component;
                    button.setBorderPainted(false);
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    };

    public ButtonTabComponent(final JTabbedPane pane) {
        super(new FlowLayout(0, 0, 0));
        try {
            if (pane == null) {
                throw new NullPointerException("TabbedPane is null");
            }
            this.m_pane = new WeakReference<JTabbedPane>(pane);
            this.setOpaque(false);
            JLabel label = new JLabel(){

                @Override
                public String getText() {
                    int i = pane.indexOfTabComponent(ButtonTabComponent.this);
                    if (i != -1) {
                        return pane.getTitleAt(i);
                    }
                    return null;
                }
            };
            this.add(label);
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            TabButton button = new TabButton();
            this.add(button);
            this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    private class TabButton
    extends JButton
    implements ActionListener {
        private BasicStroke m_stroke = new BasicStroke(2.0f);

        public TabButton() {
            try {
                int size = 17;
                this.setPreferredSize(new Dimension(size, size));
                this.setUI(new BasicButtonUI());
                this.setContentAreaFilled(false);
                this.setFocusable(false);
                this.setBorder(BorderFactory.createEtchedBorder());
                this.setBorderPainted(false);
                this.addMouseListener(buttonMouseListener);
                this.setRolloverEnabled(true);
                this.addActionListener(this);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JTabbedPane pane = (JTabbedPane)ButtonTabComponent.this.m_pane.get();
                if (pane == null) {
                    return;
                }
                int i = pane.indexOfTabComponent(ButtonTabComponent.this);
                if (i != -1) {
                    pane.remove(i);
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void updateUI() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            try {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g.create();
                if (this.getModel().isPressed()) {
                    g2.translate(1, 1);
                }
                g2.setStroke(this.m_stroke);
                g2.setColor(Color.BLACK);
                if (this.getModel().isRollover()) {
                    g2.setColor(Color.MAGENTA);
                }
                int delta = 6;
                g2.drawLine(delta, delta, this.getWidth() - delta - 1, this.getHeight() - delta - 1);
                g2.drawLine(this.getWidth() - delta - 1, delta, delta, this.getHeight() - delta - 1);
                g2.dispose();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }
}

