/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Shared;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Tools.Tools_Bitmap;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class BitmapCardWidget
extends LinearLayoutWidget
implements MouseMotionListener,
MouseListener {
    public ArrayList<Entry> m_list = new ArrayList();
    protected int m_iconSize = 24;
    protected int m_selectedIndex = -1;
    protected int m_mouseIndex = -1;
    protected JPanel m_mainPanel = new JPanel();
    protected CardLayout m_cardLayout = new CardLayout();
    protected BitmapPainter m_painter = new BitmapPainter();

    public BitmapCardWidget() {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_mainPanel.setLayout(this.m_cardLayout);
            this.m_painter.setMinimumSize(new Dimension(24, 26));
            this.m_painter.setPreferredSize(new Dimension(24, 26));
            this.addComponent(this.m_painter, 0);
            this.addComponent(this.m_mainPanel, 10);
            this.m_painter.addMouseListener(this);
            this.m_painter.addMouseMotionListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void removeComponent(JComponent comp) {
        try {
            for (int n = this.m_list.size() - 1; n >= 0; --n) {
                Entry e = this.m_list.get(n);
                if (e.Comp != comp) continue;
                this.m_list.remove(n);
                this.m_mainPanel.remove(comp);
                this.m_selectedIndex = 0;
                this.m_mouseIndex = -1;
                this.m_painter.repaint();
                this.setLabel();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addComponent(BitmapEnum bm, JComponent comp, String label) {
        try {
            Entry entry = new Entry();
            entry.Comp = comp;
            entry.Icon = Tools_Bitmap.makeIcon(bm.Bitmap);
            entry.Label = label;
            entry.Enum = bm;
            this.m_list.add(entry);
            this.m_mainPanel.add((Component)comp, label);
            if (this.m_list.size() <= 1) {
                this.m_cardLayout.show(this.m_mainPanel, label);
                this.m_selectedIndex = 0;
                this.m_mouseIndex = -1;
                this.setLabel();
            }
            this.m_painter.repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void showComponent(JComponent comp) {
        try {
            for (int n = this.m_list.size() - 1; n >= 0; --n) {
                Entry e = this.m_list.get(n);
                if (e.Comp != comp) continue;
                this.m_selectedIndex = n;
                this.m_mouseIndex = -1;
                this.m_painter.repaint();
                this.m_cardLayout.show(this.m_mainPanel, e.Label);
                this.setLabel();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void setLabel() {
        try {
            if (this.m_list.size() < 1) {
                return;
            }
            Entry selEntry = this.m_list.get(this.m_selectedIndex);
            if (this.m_mouseIndex < 0 || this.m_mouseIndex == this.m_selectedIndex) {
                this.m_painter.setToolTipText(selEntry.Label);
                return;
            }
            Entry entry = this.m_list.get(this.m_mouseIndex);
            this.m_painter.setToolTipText(entry.Label);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        try {
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        try {
            this.m_mouseIndex = -1;
            this.setLabel();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        try {
            if (this.m_mouseIndex < 0) {
                return;
            }
            this.m_selectedIndex = this.m_mouseIndex;
            this.setLabel();
            this.m_painter.repaint();
            this.m_cardLayout.show(this.m_mainPanel, this.m_list.get((int)this.m_selectedIndex).Label);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseDragged(MouseEvent event) {
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        try {
            int x = event.getX();
            this.m_mouseIndex = -1;
            for (int n = 0; n < this.m_list.size(); ++n) {
                Entry entry = this.m_list.get(n);
                if (x < entry.LeftPixel || x > entry.RightPixel) continue;
                this.m_mouseIndex = n;
            }
            this.setLabel();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected class BitmapPainter
    extends JPanel {
        @Override
        public void paintComponent(Graphics g) {
            try {
                Dimension size = this.getSize();
                Graphics2D g2d = (Graphics2D)g;
                g2d.setColor(this.getBackground());
                g2d.fillRect(0, 0, size.width, size.height);
                int left = 0;
                int gap = 5;
                for (int n = 0; n < BitmapCardWidget.this.m_list.size(); ++n) {
                    Entry entry = BitmapCardWidget.this.m_list.get(n);
                    entry.LeftPixel = left - gap / 2;
                    entry.RightPixel = left + BitmapCardWidget.this.m_iconSize + gap / 2 + 1;
                    if (n == BitmapCardWidget.this.m_selectedIndex) {
                        g2d.setColor(Color.PINK);
                        g2d.fillRect(left, 0, BitmapCardWidget.this.m_iconSize, size.height);
                    }
                    g2d.drawImage(entry.Icon.getImage(), left, 0, null);
                    left = left + BitmapCardWidget.this.m_iconSize + gap;
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }

    public class Entry {
        public BitmapEnum Enum;
        public ImageIcon Icon;
        public String Label;
        public JComponent Comp;
        public int LeftPixel;
        public int RightPixel;
    }
}

