/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Segy;

import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class Segy_EbcdicWidget
extends LinearLayoutWidget
implements ItemListener,
GenericObjectListener.Listener {
    protected Segy m_segy;
    protected JComboBox<String> m_combo = new JComboBox();
    protected JList<String> m_list = new JList();

    public Segy_EbcdicWidget(Segy segy) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_segy = segy;
            this.m_segy.getListenerController().addListener(this);
            LinearLayoutWidget top = this.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null, 0);
            top.addComponent(new JLabel("Select encoding"), 0);
            top.addComponent(this.m_combo, 10);
            this.m_combo.addItem("ASCII (no encoding)");
            this.m_combo.addItem("EBCDIC - Microsoft version");
            this.m_combo.addItem("EBCDIC - IBM PC version");
            this.m_combo.addItem("EBCDIC - IBM System 390");
            this.m_combo.setSelectedIndex(3);
            this.m_combo.addItemListener(this);
            this.m_list.setFont(new Font("Monospaced", 0, 12));
            this.addComponent(new JScrollPane(this.m_list), 10);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reload() {
        try {
            DefaultListModel<String> model = new DefaultListModel<String>();
            if (!this.m_segy.isFileOK()) {
                this.m_list.setModel(model);
                return;
            }
            byte[] ebcdic = this.m_segy.ebcdicBytes();
            if (this.m_combo.getSelectedIndex() == 0) {
                for (int n = 0; n < 40; ++n) {
                    model.addElement(new String(ebcdic, n * 80, 80));
                }
            } else {
                String characters = "";
                if (this.m_combo.getSelectedIndex() == 1) {
                    characters = "Cp037";
                } else if (this.m_combo.getSelectedIndex() == 2) {
                    characters = "Cp437";
                } else if (this.m_combo.getSelectedIndex() == 3) {
                    characters = "Cp1047";
                }
                for (int n = 0; n < 40; ++n) {
                    model.addElement(new String(ebcdic, n * 80, 80, characters));
                }
            }
            this.m_list.setModel(model);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_segy) {
                this.reload();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.reload();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

