/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Segy;

import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Seismic.Segy.Segy_Dictionary;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Menus.Menu_Test;
import com.PecosLibrary.Windows.Segy.Segy_DataDisplayWidget;
import com.PecosLibrary.Windows.Segy.Segy_MainWidget;
import com.PecosLibrary.Windows.Shared.EnvironmentVariablesWidget;
import com.PecosLibrary.Windows.Shared.ExceptionMonitorPanel;
import com.PecosLibrary.Windows.Shared.JavaSystemPropertiesWidget;
import com.PecosLibrary.Windows.Synthetic.Menu_Synthetic;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;

public class AppFrame_Segy
extends JDialog
implements ActionListener,
ClipboardOwner {
    protected JMenuBar m_menuBar = new JMenuBar();
    protected JMenu m_windowMenu = new JMenu("Window");
    protected Menu_Test m_testMenu;
    protected Menu_Synthetic m_synMenu;
    protected JTabbedPane m_tabs = new JTabbedPane();
    protected Segy m_segy = new Segy();
    protected Segy_Dictionary m_dict = new Segy_Dictionary();
    protected Segy_MainWidget m_mainWidget;
    protected Segy_DataDisplayWidget m_dataDisplayWidget;
    protected JMenuItem m_captureScreenMI;
    protected JMenuItem m_captureWindowMI;
    protected JMenuItem m_closeWindowMI;
    protected JMenu m_captureMenu = new JMenu("ScreenCapture");

    public AppFrame_Segy(boolean isModal) {
        try {
            if (isModal) {
                this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            } else {
                this.setModalityType(Dialog.ModalityType.MODELESS);
            }
            this.setJMenuBar(this.m_menuBar);
            this.m_menuBar.add(this.m_windowMenu);
            this.m_closeWindowMI = new JMenuItem("Close this window");
            this.m_windowMenu.add(this.m_closeWindowMI);
            this.m_closeWindowMI.addActionListener(this);
            this.m_synMenu = new Menu_Synthetic(this.m_menuBar);
            this.m_menuBar.add(this.m_captureMenu);
            this.m_captureScreenMI = new JMenuItem("Entire screen");
            this.m_captureMenu.add(this.m_captureScreenMI);
            this.m_captureScreenMI.addActionListener(this);
            this.m_captureWindowMI = new JMenuItem("Active window");
            this.m_captureMenu.add(this.m_captureWindowMI);
            this.m_captureWindowMI.addActionListener(this);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.m_tabs, "Center");
            this.m_mainWidget = new Segy_MainWidget(this.m_segy, this.m_dict);
            this.m_dataDisplayWidget = new Segy_DataDisplayWidget(this.m_segy, this.m_dict);
            this.m_tabs.addTab("File selection / dictionary editor", this.m_mainWidget);
            this.m_tabs.addTab("View seismic data", this.m_dataDisplayWidget);
            this.createSystemTab();
            this.setSize(1100, 950);
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
            this.setTitle("SEG-Y Viewer and Dictionary Editor");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    protected void screenCapture(boolean entireScreen) {
        try {
            Point p = this.getLocationOnScreen();
            Dimension d = this.getSize();
            Rectangle rect = new Rectangle(p, d);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (entireScreen) {
                Dimension screenSize = toolkit.getScreenSize();
                rect = new Rectangle(screenSize);
            }
            Robot robot = new Robot();
            BufferedImage image = robot.createScreenCapture(rect);
            TransferableImage trans = new TransferableImage(image);
            Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
            c.setContents(trans, this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_captureWindowMI) {
                this.screenCapture(false);
            }
            if (e.getSource() == this.m_captureScreenMI) {
                this.screenCapture(true);
            }
            if (e.getSource() == this.m_closeWindowMI) {
                this.dispose();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void createSystemTab() {
        try {
            JTabbedPane tabs = new JTabbedPane();
            tabs.addTab("Application exceptions", new ExceptionMonitorPanel());
            tabs.addTab("Java system properties", new JavaSystemPropertiesWidget());
            tabs.addTab("Environment variables", new EnvironmentVariablesWidget());
            tabs.addTab("qc", new Java2D_SimpleComposite(false));
            this.m_tabs.add("System", tabs);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private class TransferableImage
    implements Transferable {
        Image i;

        public TransferableImage(Image i) {
            this.i = i;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(DataFlavor.imageFlavor) && this.i != null) {
                return this.i;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor};
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            DataFlavor[] flavors = this.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavor.equals(flavors[i])) continue;
                return true;
            }
            return false;
        }
    }
}

