/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Uphole;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.DatabaseEnum;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Uphole.UpholeImportData;
import com.PecosLibrary.Refraction.Uphole.UpholeModel;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.JDBC.TableWrapperWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_VerticalStackWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_LineSegment;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_Line;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MouseoverInfo;
import com.PecosLibrary.Windows.Refraction.Uphole.Page_ImportUphole_Coords;
import com.PecosLibrary.Windows.Refraction.Uphole.Page_ImportUphole_Name;
import com.PecosLibrary.Windows.Refraction.Uphole.UpholeMappingDialog;
import com.PecosLibrary.Windows.Shared.PopupMenuButton;
import com.PecosLibrary.Windows.Wizard.SimpleWizardDialog;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UpholeWidget
extends JTabbedPane
implements ActionListener,
GenericObjectListener.Listener,
ItemListener,
Messenger.Listener,
PopupMenuButton.Listener,
ISaveableFrame,
ChangeListener {
    protected static IDatabaseConnection DB;
    protected TableWrapperWidget m_tableWidget;
    protected MapWidget m_mapWidget;
    JSplitPane m_tableTab;
    JSplitPane m_profileTab;
    protected Grid3D m_elevationGrid;
    protected Java2D_VerticalStackWidget m_profileWidget;
    protected ComboStringListWrapper m_modelCombo = new ComboStringListWrapper();
    protected JButton m_btnReloadModelList;
    protected JButton m_btnCreateNewModel;
    protected JLabel m_lblRowCount = new JLabel(" ");
    protected JLabel m_lblMaxLayers = new JLabel(" ");
    protected SelectedProfileInfo m_selectedProfileInfo;
    protected UpholeProfile m_profile;
    protected Java2D_UserEventConsumer_Line m_profileLineUEC = new Java2D_UserEventConsumer_Line();

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.Refraction.Uphole.UpholeWidget";
    }

    @Override
    public String TAB_LABEL() {
        return "Uphole";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "Uphole surveys";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return true;
    }

    public UpholeWidget() {
        try {
            this.m_profileLineUEC.addListener(this);
            Messenger.singleton().addListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JSplitPane createTableTab() {
        try {
            JSplitPane tab = new JSplitPane(1);
            this.m_tableWidget = RefractionStaticsProject.singleton().getUphole() == null ? TableWrapperWidget.createEmptyWidget(DatabaseEnum.Uphole) : new TableWrapperWidget(RefractionStaticsProject.singleton().getUphole().getDBConnection(), RefractionStaticsProject.singleton().getUphole().name(), DatabaseEnum.Uphole);
            LinearLayoutWidget left = LinearLayoutWidget.vert(0, null);
            LinearLayoutWidget sub = left.createHorizontal(0, "Select model", 0);
            sub.addComponent(this.m_modelCombo, 10);
            this.m_modelCombo.listener().addListener(this);
            this.m_btnReloadModelList = sub.createButton("Reload list", this, 0);
            this.m_btnCreateNewModel = sub.createButton("New model", this, 0);
            GridLayoutWidget grid = left.createGridLayoutWidget(0, "Model description", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Number of locations: "), this.m_lblRowCount);
            grid.addSimple(row++, new JLabel("Maximum number of layers: "), this.m_lblMaxLayers);
            tab.setLeftComponent(left);
            tab.setRightComponent(this.m_tableWidget);
            if (RefractionStaticsProject.singleton().getUphole() != null && RefractionStaticsProject.singleton().getUphole().getDBConnection() != null) {
                RefractionStaticsProject.singleton().getUphole().getDBConnection().closeConnection();
            }
            return tab;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JSplitPane createProfileTab() {
        try {
            JSplitPane tab = new JSplitPane(1);
            this.m_mapWidget = new MapWidget(true);
            tab.setLeftComponent(this.m_mapWidget);
            this.m_mapWidget.addStretch(10);
            this.m_mapWidget.setMinimumSize(new Dimension(300, 300));
            this.m_profileWidget = new Java2D_VerticalStackWidget(2);
            tab.setRightComponent(this.m_profileWidget);
            this.reloadSmallMapUIH();
            return tab;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void reloadTable() {
        try {
            this.m_tableWidget = RefractionStaticsProject.singleton().getUphole() == null ? TableWrapperWidget.createEmptyWidget(DatabaseEnum.Uphole) : new TableWrapperWidget(RefractionStaticsProject.singleton().getUphole().getDBConnection(), RefractionStaticsProject.singleton().getUphole().name(), DatabaseEnum.Uphole);
            this.m_tableTab.setRightComponent(this.m_tableWidget);
            if (RefractionStaticsProject.singleton().getUphole() != null && RefractionStaticsProject.singleton().getUphole().getDBConnection() != null) {
                RefractionStaticsProject.singleton().getUphole().getDBConnection().closeConnection();
            }
            this.initElevation();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadModelCombo() {
        try {
            String projectPath = RefractionStaticsProject.singleton().projectPath();
            String upholePath = Tools_FileSystem.confirmSubDirectoryExists(projectPath, "Uphole");
            ArrayList<String> models = DB.getTableNames();
            this.m_modelCombo.setStringArray(models);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadSmallMapUIH() {
        try {
            this.m_mapWidget.CompositeWidget.mainWidget().clearEventConsumerList();
            this.m_mapWidget.CompositeWidget.mainWidget().addZoomer();
            this.m_mapWidget.CompositeWidget.mainWidget().addEventConsumer(this.m_profileLineUEC);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected void loadMapProfile() {
        try {
            this.m_profileWidget.clear();
            if (RefractionStaticsProject.singleton().getUphole() == null) {
                return;
            }
            double x1 = this.m_profileLineUEC.StartWorldX;
            double y1 = this.m_profileLineUEC.StartWorldY;
            double x2 = this.m_profileLineUEC.EndWorldX;
            double y2 = this.m_profileLineUEC.EndWorldY;
            if (this.m_profile == null) {
                System.out.println("Recreate profile object");
                this.m_profile = new UpholeProfile(0.5f);
            }
            if (this.m_profileLineUEC.StartWorldX != 0.0 && this.m_profileLineUEC.StartWorldY != 0.0 && this.m_profileLineUEC.EndWorldX != 0.0 && this.m_profileLineUEC.EndWorldY != 0.0) {
                this.m_mapWidget.LineSegment.Valid = true;
                this.m_mapWidget.LineSegment.DrawSymbols = false;
                this.m_mapWidget.LineSegment.X1 = x1;
                this.m_mapWidget.LineSegment.Y1 = y1;
                this.m_mapWidget.LineSegment.X2 = x2;
                this.m_mapWidget.LineSegment.Y2 = y2;
                this.m_mapWidget.LineSegment.LineColor = Color.BLACK;
                this.m_profile.Valid = true;
            }
            this.m_profile.populateProfile();
            this.m_profileWidget.mainWidget(0).addPaintable(this.m_profile, 0);
            this.m_profileWidget.mainWidget(1).addPaintable(null, 1);
            this.m_profileWidget.setColorLabel(0, "Velocity");
            this.m_profileWidget.setTransform(Java2D_Transform.Technique.Normal);
            this.m_profileWidget.unzoom();
            this.m_profileWidget.initializeMouseoverPanel(this.m_profile, Java2D_UserEventConsumer_MouseoverInfo.ModelType.Uphole);
            this.m_mapWidget.CompositeWidget.mainWidget().repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadModel() {
        try {
            if (this.m_selectedProfileInfo == null) {
                this.m_selectedProfileInfo = new SelectedProfileInfo();
            }
            this.m_selectedProfileInfo.StartPixelX = this.m_profileLineUEC.StartPixelX;
            this.m_selectedProfileInfo.StartPixelY = this.m_profileLineUEC.StartPixelY;
            this.m_selectedProfileInfo.EndPixelX = this.m_profileLineUEC.EndPixelX;
            this.m_selectedProfileInfo.EndPixelY = this.m_profileLineUEC.EndPixelY;
            this.m_selectedProfileInfo.StartWorldX = this.m_profileLineUEC.StartWorldX;
            this.m_selectedProfileInfo.StartWorldY = this.m_profileLineUEC.StartWorldY;
            this.m_selectedProfileInfo.EndWorldX = this.m_profileLineUEC.EndWorldX;
            this.m_selectedProfileInfo.EndWorldY = this.m_profileLineUEC.EndWorldY;
            this.m_profile = null;
            String modelName = this.m_modelCombo.getSelectedString();
            RefractionStaticsProject.singleton().setUphole(new UpholeModel());
            RefractionStaticsProject.singleton().getUphole().load(modelName);
            this.handleNewModel();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void handleNewModel() {
        try {
            if (RefractionStaticsProject.singleton().getUphole() == null) {
                return;
            }
            UpholeModel model = RefractionStaticsProject.singleton().getUphole();
            if (model.name() == null) {
                return;
            }
            if (!model.mapped()) {
                // empty if block
            }
            this.reloadTable();
            this.reloadSmallMapUIH();
            this.m_profile = null;
            this.m_mapWidget.handleNewModel();
            if (this.m_selectedProfileInfo == null) {
                // empty if block
            }
            this.m_mapWidget.reloadPlot();
            if (this.m_selectedProfileInfo != null) {
                if (this.m_selectedProfileInfo.StartWorldX != 0.0 && this.m_selectedProfileInfo.StartWorldY != 0.0 && this.m_selectedProfileInfo.EndWorldX != 0.0 && this.m_selectedProfileInfo.EndWorldY != 0.0) {
                    this.m_profileLineUEC.StartPixelX = this.m_selectedProfileInfo.StartPixelX;
                    this.m_profileLineUEC.StartPixelY = this.m_selectedProfileInfo.StartPixelY;
                    this.m_profileLineUEC.EndPixelX = this.m_selectedProfileInfo.EndPixelX;
                    this.m_profileLineUEC.EndPixelY = this.m_selectedProfileInfo.EndPixelY;
                    this.m_profileLineUEC.StartWorldX = this.m_selectedProfileInfo.StartWorldX;
                    this.m_profileLineUEC.StartWorldY = this.m_selectedProfileInfo.StartWorldY;
                    this.m_profileLineUEC.EndWorldX = this.m_selectedProfileInfo.EndWorldX;
                    this.m_profileLineUEC.EndWorldY = this.m_selectedProfileInfo.EndWorldY;
                }
                this.loadMapProfile();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void initElevation() {
        try {
            this.m_elevationGrid = RefractionStaticsProject.singleton().getEmptyGrid3D();
            this.m_elevationGrid.interp_Prep();
            Table_Abstract shotTable = RefractionStaticsProject.singleton().getShotTable();
            Table_Abstract receiverTable = RefractionStaticsProject.singleton().getRecTable();
            int indexShotX = shotTable.column_indexOfColumn("Easting");
            int indexShotY = shotTable.column_indexOfColumn("Northing");
            int indexShotZ = shotTable.column_indexOfColumn("Elevation");
            int indexReceiverX = receiverTable.column_indexOfColumn("Easting");
            int indexReceiverY = receiverTable.column_indexOfColumn("Northing");
            int indexReceiverZ = receiverTable.column_indexOfColumn("Elevation");
            for (int s = 0; s < shotTable.row_count(); ++s) {
                double shotX = shotTable.getDouble(s, indexShotX);
                double shotY = shotTable.getDouble(s, indexShotY);
                double shotZ = shotTable.getDouble(s, indexShotZ);
                this.m_elevationGrid.interp_Add(shotX, shotY, (float)shotZ, 1.0f);
            }
            for (int r = 0; r < receiverTable.row_count(); ++r) {
                double receiverX = receiverTable.getDouble(r, indexReceiverX);
                double receiverY = receiverTable.getDouble(r, indexReceiverY);
                double receiverZ = receiverTable.getDouble(r, indexReceiverZ);
                this.m_elevationGrid.interp_Add(receiverX, receiverY, (float)receiverZ, 1.0f);
            }
            this.m_elevationGrid.interp_Finish(1);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            if (e.getSource() == this.m_profileTab) {
                this.reloadSmallMapUIH();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handlePopupMenuButton(PopupMenuButton button, String text) {
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            if (message == Messenger.Message.UpholeModelChanged) {
                this.reloadModelCombo();
                RefractionStaticsProject refractionStaticsProject = RefractionStaticsProject.singleton();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_profileLineUEC) {
                if (this.m_profileLineUEC.Dragging) {
                    this.loadMapProfile();
                } else {
                    System.out.println("handleGenericObjectListener m_profileLineUEC.Dragging == false");
                    this.m_mapWidget.CompositeWidget.mainWidget().mooz();
                }
            }
            if (sender == this.m_modelCombo) {
                this.loadModel();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnCreateNewModel) {
                this.importSurvey();
                this.reloadTable();
            }
            if (e.getSource() == this.m_btnReloadModelList) {
                this.reloadModelCombo();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void importSurvey() {
        try {
            UpholeImportData data = new UpholeImportData();
            ArrayList<SimpleWizardDialog.Page> pageList = new ArrayList<SimpleWizardDialog.Page>();
            Page_ImportUphole_Name pageName = new Page_ImportUphole_Name(data);
            Page_ImportUphole_Coords pageCoords = new Page_ImportUphole_Coords(data);
            pageList.add(new SimpleWizardDialog.Page(pageName, "Survey name", "name"));
            pageList.add(new SimpleWizardDialog.Page(pageCoords, "Coordinates", "coords"));
            SimpleWizardDialog dialog = new SimpleWizardDialog(pageList, "Import uphole", 600, 900);
            dialog.showDialog();
            if (dialog.Finish) {
                pageCoords.updateXYZColumns();
                UpholeModel model = UpholeModel.importSurvey(data);
                RefractionStaticsProject.singleton().setUphole(model);
            }
            this.reloadTable();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void mapColumns() {
        try {
            UpholeMappingDialog dialog = new UpholeMappingDialog();
            dialog.showDialog();
            if (!dialog.Finish) {
                return;
            }
            RefractionStaticsProject.singleton().getUphole().mapColumns(dialog.RowList, dialog.ImportVelocity);
            this.loadModel();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected class MapWidget
    extends LinearLayoutWidget
    implements ActionListener,
    ItemListener {
        public Java2D_SimpleComposite CompositeWidget;
        public JButton m_btnReload;
        public Java2D_Paintable_LineSegment LineSegment;
        public Java2D_Polygon Polygon;
        protected Java2D_Paintable_Table m_gridPaintable;
        public LinearLayoutWidget Bottom;

        public MapWidget(boolean tinyWidth) {
            super(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.LineSegment = new Java2D_Paintable_LineSegment();
            this.m_gridPaintable = null;
            try {
                this.Bottom = this.createHorizontal(0, null, 0);
                this.m_btnReload = this.Bottom.createButton("Reload plot", this, 0);
                this.Bottom.addStretch(10);
                Tools_FontChanger.changeSizeOfFont(this.Bottom, -2, null, true);
                this.CompositeWidget = new Java2D_SimpleComposite(true);
                this.CompositeWidget.setAxesVisible(true, true);
                this.CompositeWidget.setScrollVisible(true, true);
                this.CompositeWidget.mainWidget().addZoomer();
                this.addComponent(this.CompositeWidget, 10);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void handleNewModel() {
            try {
                this.LineSegment.Valid = false;
                if (RefractionStaticsProject.singleton().getUphole() == null) {
                    return;
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void reloadPlot() {
            try {
                this.m_gridPaintable = null;
                Java2D_Widget w = this.CompositeWidget.mainWidget();
                w.clearPaintableList();
                if (RefractionStaticsProject.singleton().getUphole() == null) {
                    w.mooz();
                    return;
                }
                Java2D_PaintableInterface grid = null;
                if (grid != null) {
                    ((Grid3D)grid).ArrayDirty = true;
                    w.addPaintable(grid, 0);
                }
                try {
                    this.m_gridPaintable = this.getPaintableTable();
                    w.addPaintable(this.m_gridPaintable, 0);
                }
                catch (Exception error) {
                    error.printStackTrace();
                }
                w.addPaintable(this.LineSegment, 0);
                w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
                w.mooz();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.reloadPlot();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public Java2D_Paintable_Table getPaintableTable() {
            try {
                if (RefractionStaticsProject.singleton().getUphole() == null) {
                    return null;
                }
                Java2D_Paintable_Table painter = new Java2D_Paintable_Table();
                painter.setTable(RefractionStaticsProject.singleton().getUphole().getTable());
                painter.setAxisX("Easting");
                painter.setAxisY("Northing");
                painter.UseColorScale = false;
                painter.FixedColor = Color.BLACK;
                painter.Size_Pixel = 3;
                return painter;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                return null;
            }
        }
    }

    public class UpholeProfile
    implements Java2D_PaintableInterface {
        int MaxValidX = 0;
        double Offset = 0.0;
        double SizeX = 25.0;
        int TotalNumX = 0;
        int DepthNodeCount = 0;
        double Digi = 0.0;
        double[] WorldX = new double[50];
        double[] WorldY = new double[50];
        double[] Elevation = new double[50];
        float[][] Velocity = new float[50][50];
        float[] Depth = new float[50];
        boolean Valid = false;
        protected int[] m_pixelDepthTop = new int[100];
        protected int[] m_pixelDepthBottom = new int[100];

        public UpholeProfile(float digi) {
            try {
                if (RefractionStaticsProject.singleton().getUphole() == null) {
                    throw new Exception("No uphole model selected");
                }
                this.Digi = digi;
                this.DepthNodeCount = (int)(RefractionStaticsProject.singleton().getUphole().getMaxDepth() / this.Digi) + 1;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void setEndpoints(double x1, double y1, double x2, double y2) {
            try {
                this.MaxValidX = 0;
                double dx = x2 - x1;
                double dy = y2 - y1;
                this.Offset = Math.sqrt(1.0E-8 + dx * dx + dy * dy);
                if (this.Offset < 5.0) {
                    return;
                }
                int num = 2 + (int)(this.Offset / this.SizeX);
                this.MaxValidX = num + 1;
                if (this.MaxValidX >= this.TotalNumX) {
                    this.TotalNumX = this.MaxValidX + 50;
                    this.reallocateArrays();
                }
                if (this.Depth.length < this.DepthNodeCount) {
                    this.reallocateArrays();
                }
                double cos = dx / this.Offset;
                double sin = dy / this.Offset;
                for (int n = 0; n < this.TotalNumX; ++n) {
                    this.WorldX[n] = x1 + cos * this.SizeX * (double)n;
                    this.WorldY[n] = y1 + sin * this.SizeX * (double)n;
                    this.Elevation[n] = UpholeWidget.this.m_elevationGrid.getNearestValue(this.WorldX[n], this.WorldY[n]);
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void populateProfile() {
            try {
                if (RefractionStaticsProject.singleton().getUphole() == null) {
                    return;
                }
                if (!this.Valid) {
                    return;
                }
                this.setEndpoints(UpholeWidget.this.m_profileLineUEC.StartWorldX, UpholeWidget.this.m_profileLineUEC.StartWorldY, UpholeWidget.this.m_profileLineUEC.EndWorldX, UpholeWidget.this.m_profileLineUEC.EndWorldY);
                if (RefractionStaticsProject.singleton().getUphole().getInterpolationMaxDepth() <= 0.0) {
                    RefractionStaticsProject.singleton().getUphole().interpolateVelocities(0.5, RefractionStaticsProject.singleton().getUphole().getMaxDepth());
                }
                float depth = 0.0f;
                for (int z = 0; z < this.DepthNodeCount; ++z) {
                    this.Depth[z] = depth;
                    depth = (float)((double)depth + this.Digi);
                }
                for (int n = 0; n <= this.MaxValidX; ++n) {
                    RefractionStaticsProject.singleton().getUphole().getInterpolatedVelocity(this.WorldX[n], this.WorldY[n], this.Elevation[n], this.Depth, this.Velocity[n]);
                    boolean bl = false;
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        protected void reallocateArrays() {
            try {
                this.WorldX = new double[this.TotalNumX];
                this.WorldY = new double[this.TotalNumX];
                this.Elevation = new double[this.TotalNumX];
                this.Velocity = new float[this.TotalNumX][this.DepthNodeCount];
                this.Depth = new float[this.DepthNodeCount];
                float depth = 0.0f;
                for (int z = 0; z < this.DepthNodeCount; ++z) {
                    this.Depth[z] = depth;
                    depth = (float)((double)depth + this.Digi);
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void Java2D_RangeColor(Range_Double range, int supplementalData) {
            for (int x = 0; x < this.TotalNumX; ++x) {
                for (int z = 0; z < this.DepthNodeCount; ++z) {
                    range.expandRange(this.Velocity[x][z]);
                }
            }
        }

        @Override
        public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
            try {
                rangeX.expandRange(-this.SizeX);
                rangeX.expandRange(this.SizeX + this.SizeX * (double)this.MaxValidX);
                for (int n = 0; n < this.TotalNumX; ++n) {
                    rangeY.expandRange(this.Elevation[n] + this.SizeX);
                    rangeY.expandRange(this.Elevation[n] - RefractionStaticsProject.singleton().getUphole().getMaxDepth());
                }
                boolean bl = rangeY.rangeValid();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
            try {
                if (paintParameter.PaintLevel != 0) {
                    return;
                }
                Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
                Java2D_Transform transform = paintParameter.Transform;
                Graphics2D g2d = paintParameter.G2D;
                g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_0);
                double scaleX = transform.scaleX();
                double shiftX = transform.shiftX();
                double scaleY = transform.scaleY();
                double shiftY = transform.shiftY();
                int pixelX = (int)(scaleX * this.SizeX) + 1;
                if (this.m_pixelDepthTop.length < this.DepthNodeCount + 1) {
                    this.m_pixelDepthTop = new int[this.DepthNodeCount + 10];
                    this.m_pixelDepthBottom = new int[this.DepthNodeCount + 10];
                }
                this.m_pixelDepthTop[0] = 0;
                this.m_pixelDepthBottom[0] = -((int)(scaleY * (double)this.Depth[0]));
                this.m_pixelDepthTop[this.DepthNodeCount - 1] = -((int)(scaleY * (double)(this.Depth[this.DepthNodeCount - 1] + this.Depth[this.DepthNodeCount - 2])));
                this.m_pixelDepthBottom[this.DepthNodeCount - 1] = -((int)(scaleY * (double)this.Depth[this.DepthNodeCount - 1]));
                for (int z = 1; z < this.DepthNodeCount - 1; ++z) {
                    this.m_pixelDepthTop[z] = -((int)(scaleY * (double)(this.Depth[z] + this.Depth[z - 1])));
                    this.m_pixelDepthBottom[z] = -((int)(scaleY * (double)(this.Depth[z] + this.Depth[z + 1])));
                }
                Color color = Color.black;
                double z1 = 0.0;
                double z2 = 0.0;
                for (int ix = 0; ix <= this.MaxValidX; ++ix) {
                    double x = this.SizeX * (double)ix - 0.5 * this.SizeX;
                    int x1 = (int)(x * scaleX + shiftX);
                    double z = this.Elevation[ix];
                    for (int iz = 0; iz < this.DepthNodeCount; ++iz) {
                        z1 = iz == 0 ? z : z - 0.5 * (double)(this.Depth[iz - 1] + this.Depth[iz]);
                        z2 = iz == this.DepthNodeCount - 1 ? z - (double)this.Depth[this.DepthNodeCount - 1] : z - 0.5 * (double)(this.Depth[iz + 1] + this.Depth[iz]);
                        int y1 = (int)(z1 * scaleY + shiftY);
                        int y2 = (int)(z2 * scaleY + shiftY);
                        int h = Math.abs(y2 - y1) + 1;
                        int yt = Math.min(y1, y2);
                        color = Color.white;
                        if (this.Velocity[ix][iz] > 0.0f) {
                            color = colorWrapper.colorUsingValue(this.Velocity[ix][iz]);
                        }
                        g2d.setColor(color);
                        g2d.fillRect(x1, yt, pixelX, h);
                    }
                }
                g2d.setColor(Color.black);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public int Java2D_MaximumPaintLevel(int supplementalData) {
            try {
                return 0;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                return 0;
            }
        }

        @Override
        public boolean Java2D_ImageContentsDirty(int supplementalData) {
            try {
                return false;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                return false;
            }
        }

        @Override
        public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
        }
    }

    public class SelectedProfileInfo {
        protected int StartPixelX;
        protected int StartPixelY;
        protected int EndPixelX;
        protected int EndPixelY;
        protected double StartWorldX;
        protected double StartWorldY;
        protected double EndWorldX;
        protected double EndWorldY;
    }
}

