/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Uphole;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class UpholeMappingDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener {
    protected GridLayoutWidget m_grid;
    protected ComboStringListWrapper m_tableCombo;
    protected JCheckBox m_chkImportVel = new JCheckBox("Import velocity from file");
    protected JButton m_btnAdd = new JButton("Add layer");
    protected JButton m_btnDelete = new JButton("X");
    protected JLabel m_lblBlank = new JLabel(" ");
    protected JButton m_btnFinish = new JButton("Finish");
    protected JButton m_btnCancel = new JButton("Cancel");
    protected JLabel m_lblStatus = new JLabel(" ");
    public boolean Finish = false;
    public boolean ImportVelocity = false;
    public ArrayList<UpholeMappingRow> RowList = new ArrayList();

    public UpholeMappingDialog() {
        try {
            this.setTitle("Uphole column mapping");
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget main = LinearLayoutWidget.vert(3, null);
            this.getContentPane().add((Component)main, "Center");
            LinearLayoutWidget top = main.createHorizontal(3, "Import options", 0);
            GridLayoutWidget table = main.createGridLayoutWidget(3, 0);
            table.addSimple(0, new JLabel("Select the ASCII table to import: "), this.m_tableCombo);
            GridLayoutWidget header = main.createGridLayoutWidget(3, 0);
            this.m_chkImportVel.setSelected(false);
            this.m_chkImportVel.addActionListener(this);
            this.m_btnAdd.addActionListener(this);
            header.addSimple(0, this.m_lblStatus, new JLabel(" "), new JLabel(" "), new JLabel(" "), this.m_btnAdd);
            ArrayList<String> columnList = new ArrayList<String>();
            String idColumn = RefractionStaticsProject.singleton().getUphole().getTable().name() + "ID";
            for (String column : RefractionStaticsProject.singleton().getUphole().getTable().column_listOfNames()) {
                if (column.equalsIgnoreCase(idColumn) || column.equalsIgnoreCase("Easting") || column.equalsIgnoreCase("Northing") || column.equalsIgnoreCase("Elevation")) continue;
                columnList.add(column);
            }
            Collections.sort(columnList);
            columnList.add(0, " ");
            this.m_grid = main.createGridLayoutWidget(0, 10);
            JLabel indexLabel = new JLabel("Layer           ");
            JLabel indexTime = new JLabel("Time");
            JLabel indexDepth = new JLabel("Depth");
            JLabel indexVelocity = new JLabel("Velocity");
            this.m_grid.addComponent(indexLabel, 0, 0, 1.0, 10.0);
            this.m_grid.addComponent(indexTime, 0, 1, 1.0, 6.0);
            this.m_grid.addComponent(indexDepth, 0, 2, 1.0, 6.0);
            this.m_grid.addComponent(indexVelocity, 0, 3, 1.0, 6.0);
            UpholeMappingRow row = new UpholeMappingRow();
            row.IndexLabel.setText("1");
            row.TimeColumns.setStringArray(columnList);
            row.DepthColumns.setStringArray(columnList);
            row.VelocityColumns.setStringArray(columnList);
            this.m_grid.addComponent(row.IndexLabel, 1, 0, 0.0, 10.0);
            this.m_grid.addComponent(row.TimeColumns, 1, 1, 0.0, 6.0);
            this.m_grid.addComponent(row.DepthColumns, 1, 2, 0.0, 6.0);
            this.m_grid.addComponent(row.VelocityColumns, 1, 3, 0.0, 6.0);
            this.RowList.add(row);
            row.TimeColumns.listener().addListener(this);
            row.DepthColumns.listener().addListener(this);
            row.VelocityColumns.listener().addListener(this);
            row.VelocityColumns.setEnabled(this.m_chkImportVel.isSelected());
            this.m_lblBlank = new JLabel(" ");
            this.m_btnFinish = new JButton("Finish");
            this.m_btnCancel = new JButton("Cancel");
            this.m_btnFinish.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.m_grid.addComponent(new JLabel(" "), 2, 1, 0.0, 6.0);
            this.m_grid.addComponent(this.m_btnFinish, 3, 1, 0.0, 6.0);
            this.m_grid.addComponent(this.m_btnCancel, 3, 3, 0.0, 6.0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void showDialog() {
        try {
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadColumns() {
        try {
            ArrayList<String> columnList = new ArrayList<String>();
            columnList.add(" ");
            String idColumn = RefractionStaticsProject.singleton().getUphole().getTable().name() + "ID";
            for (String column : RefractionStaticsProject.singleton().getUphole().getTable().column_listOfNames()) {
                if (column.equalsIgnoreCase(idColumn) || column.equalsIgnoreCase("Easting") || column.equalsIgnoreCase("Northing") || column.equalsIgnoreCase("Elevation")) continue;
                columnList.add(column);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addRow(int index) {
        try {
            ArrayList<String> columnList = new ArrayList<String>();
            String idColumn = RefractionStaticsProject.singleton().getUphole().getTable().name() + "ID";
            for (String column : RefractionStaticsProject.singleton().getUphole().getTable().column_listOfNames()) {
                if (column.equalsIgnoreCase(idColumn) || column.equalsIgnoreCase("Easting") || column.equalsIgnoreCase("Northing") || column.equalsIgnoreCase("Elevation")) continue;
                columnList.add(column);
            }
            Collections.sort(columnList);
            columnList.add(0, " ");
            UpholeMappingRow row = new UpholeMappingRow();
            row.IndexLabel.setText(Integer.toString(index));
            row.TimeColumns.setStringArray(columnList);
            row.DepthColumns.setStringArray(columnList);
            row.VelocityColumns.setStringArray(columnList);
            this.m_grid.remove(this.m_btnFinish);
            this.m_grid.remove(this.m_btnCancel);
            this.m_grid.remove(this.m_lblBlank);
            this.m_grid.remove(this.m_btnDelete);
            this.m_btnDelete = new JButton("X");
            this.m_btnDelete.addActionListener(this);
            this.m_grid.addComponent(row.IndexLabel, index, 0, 0.0, 10.0);
            this.m_grid.addComponent(row.TimeColumns, index, 1, 0.0, 6.0);
            this.m_grid.addComponent(row.DepthColumns, index, 2, 0.0, 6.0);
            this.m_grid.addComponent(row.VelocityColumns, index, 3, 0.0, 6.0);
            this.m_grid.addComponent(this.m_btnDelete, index, 4, 0.0, 6.0);
            this.RowList.add(row);
            row.TimeColumns.listener().addListener(this);
            row.DepthColumns.listener().addListener(this);
            row.VelocityColumns.listener().addListener(this);
            row.VelocityColumns.setEnabled(this.m_chkImportVel.isSelected());
            this.m_lblBlank = new JLabel(" ");
            this.m_btnFinish = new JButton("Finish");
            this.m_btnCancel = new JButton("Cancel");
            this.m_btnFinish.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.m_grid.addComponent(this.m_lblBlank, index + 1, 1, 0.0, 6.0);
            this.m_grid.addComponent(this.m_btnFinish, index + 2, 1, 0.0, 6.0);
            this.m_grid.addComponent(this.m_btnCancel, index + 2, 3, 0.0, 6.0);
            this.pack();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void deleteLastRow() {
        try {
            this.m_grid.remove(this.m_btnFinish);
            this.m_grid.remove(this.m_btnCancel);
            this.m_grid.remove(this.m_lblBlank);
            this.m_grid.remove(this.m_btnDelete);
            this.m_btnDelete = new JButton("X");
            this.m_btnDelete.addActionListener(this);
            int lastIndex = this.RowList.size();
            UpholeMappingRow row = this.RowList.get(lastIndex - 1);
            this.m_grid.remove(row.IndexLabel);
            this.m_grid.remove(row.TimeColumns);
            this.m_grid.remove(row.DepthColumns);
            this.m_grid.remove(row.VelocityColumns);
            this.RowList.remove(lastIndex - 1);
            if (this.RowList.size() > 1) {
                this.m_grid.addComponent(this.m_btnDelete, lastIndex - 1, 4, 0.0, 6.0);
            }
            this.m_lblBlank = new JLabel(" ");
            this.m_btnFinish = new JButton("Finish");
            this.m_btnCancel = new JButton("Cancel");
            this.m_btnFinish.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.m_grid.addComponent(this.m_lblBlank, lastIndex, 1, 0.0, 6.0);
            this.m_grid.addComponent(this.m_btnFinish, lastIndex + 1, 1, 0.0, 6.0);
            this.m_grid.addComponent(this.m_btnCancel, lastIndex + 1, 3, 0.0, 6.0);
            this.pack();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_chkImportVel) {
                for (UpholeMappingRow row : this.RowList) {
                    row.VelocityColumns.setEnabled(this.m_chkImportVel.isSelected());
                }
                return;
            }
            if (e.getSource() == this.m_btnAdd) {
                if (this.RowList.size() >= 20) {
                    return;
                }
                int nextRow = this.RowList.size() + 1;
                this.addRow(nextRow);
                return;
            }
            if (e.getSource() == this.m_btnDelete) {
                this.deleteLastRow();
                return;
            }
            if (e.getSource() == this.m_btnFinish) {
                for (UpholeMappingRow row : this.RowList) {
                    if (row.TimeColumns.getSelectedIndex() == 0) {
                        this.mappingError();
                        return;
                    }
                    if (row.DepthColumns.getSelectedIndex() == 0) {
                        this.mappingError();
                        return;
                    }
                    if (!this.m_chkImportVel.isSelected() || row.VelocityColumns.getSelectedIndex() != 0) continue;
                    this.mappingError();
                    return;
                }
                this.ImportVelocity = this.m_chkImportVel.isSelected();
                this.Finish = true;
                this.dispose();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.Finish = false;
                this.dispose();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void mappingError() {
        JOptionPane.showMessageDialog(null, "One or more columns are not mapped. \nPlease select valid columns or \ndelete any unused rows.", "Not mapped", 0);
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    public class UpholeMappingRow {
        public JLabel IndexLabel = new JLabel();
        public ComboStringListWrapper TimeColumns = new ComboStringListWrapper();
        public ComboStringListWrapper DepthColumns = new ComboStringListWrapper();
        public ComboStringListWrapper VelocityColumns = new ComboStringListWrapper();
        public boolean Valid = false;
    }
}

