/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction;

import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Data.TraceTable.ITraceTable_Wrapper;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Action.Export.Action_ExportTraceTableToCSV;
import com.PecosLibrary.Action.Import.Action_ImportTraceTableFromCSV;
import com.PecosLibrary.Action.JDBC.Action_TraceTableSQL;
import com.PecosLibrary.Data.TraceTable.TraceTable_SimpleModel;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.JDBC.ColumnMathDialog;
import com.PecosLibrary.Windows.Refraction.ExportTotalDialog;
import com.PecosLibrary.Windows.Refraction.TraceTable_SetConstDialog;
import com.PecosLibrary.Windows.Shared.PopupMenuButton;
import com.PecosLibrary.Windows.Shared.ScrollTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;

public class TraceTableWidget
extends LinearLayoutWidget
implements ActionListener,
PopupMenuButton.Listener,
Messenger.Listener,
ISaveableFrame {
    protected ScrollTable m_table;
    protected JButton m_constButton;
    protected JButton m_refreshButton;
    protected JButton m_testMathButton;
    protected JButton m_totalButton;
    protected JTextField m_txtRow = new JTextField("0");
    protected JProgressBar m_progress = new JProgressBar();
    protected JCheckBox m_chk_auto_backup = new JCheckBox("Backup every hour");
    protected PopupMenuButton m_backupButton;
    protected String m_backup_CSV_Create = "CSV - create backup";
    protected String m_backup_CSV_Load = "CSV - restore backup";
    protected String m_backup_Binary_Create = "Binary - create backup";
    protected String m_backup_Binary_Load = "Binary - restore backup";
    protected Timer m_timer = new Timer(3600000, this);
    protected ExportTotalDialog m_ExportTotalDialog;
    protected TraceTable_SetConstDialog m_constDialog;

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.Refraction.TraceTableWidget";
    }

    @Override
    public String TAB_LABEL() {
        return "Trace";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "Trace table";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return true;
    }

    public TraceTableWidget() {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            LinearLayoutWidget top = this.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null, 0);
            this.m_refreshButton = top.createButton("Refresh", this, 0);
            this.m_testMathButton = top.createButton("SQL math", this, 0);
            this.m_testMathButton.setToolTipText("This is very flexible, but slow");
            this.m_totalButton = top.createButton("Export geometry", this, 0);
            this.m_constButton = top.createButton("Set column to constant", this, 0);
            top.createLabel("Row:", 4, 0);
            top.addComponent(this.m_txtRow, 2);
            this.m_txtRow.addActionListener(this);
            top.addStretch(10);
            this.m_backupButton = new PopupMenuButton(null, "Backup options...", this);
            this.m_backupButton.addOption(this.m_backup_Binary_Create);
            this.m_backupButton.addOption(this.m_backup_Binary_Load);
            this.m_backupButton.addOption(this.m_backup_CSV_Create);
            this.m_backupButton.addOption(this.m_backup_CSV_Load);
            top.addComponent(this.m_backupButton, 0);
            this.m_chk_auto_backup.setSelected(false);
            top.addComponent(this.m_chk_auto_backup, 0);
            this.m_table = new ScrollTable();
            this.addComponent(this.m_table, 10);
            this.reloadTable();
            Messenger.singleton().addListener(this);
            this.m_timer.start();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            if (message == Messenger.Message.PickColumnAdded || message == Messenger.Message.TraceTableReloaded) {
                this.reloadTable();
                return;
            }
            if (message == Messenger.Message.PicksChanged) {
                if (this.m_table.table().getModel() == null) {
                    this.reloadTable();
                    return;
                }
                if (this.m_table.table().getModel() instanceof TraceTable_SimpleModel) {
                    TraceTable_SimpleModel model = (TraceTable_SimpleModel)this.m_table.table().getModel();
                    model.fireTableDataChanged();
                }
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handlePopupMenuButton(PopupMenuButton button, String text) {
        try {
            Action_Base action;
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (text.equalsIgnoreCase(this.m_backup_Binary_Create)) {
                RefractionStaticsProject.singleton().trace_table_create_backup();
                JOptionPane.showMessageDialog(this, "Trace table backup created");
            }
            if (text.equalsIgnoreCase(this.m_backup_Binary_Load)) {
                if (RefractionStaticsProject.singleton().trace_table_restore_backup()) {
                    JOptionPane.showMessageDialog(this, "Trace table backup restored");
                } else {
                    JOptionPane.showMessageDialog(this, "Backup could not be restored.", "Restore error", 0);
                }
                this.reloadTable();
            }
            if (text.equalsIgnoreCase(this.m_backup_CSV_Create)) {
                action = new Action_ExportTraceTableToCSV();
                action.Hasher.string_put("Name", "Backup");
                RefractionStaticsProject.singleton().executeSingleAction(action);
            }
            if (text.equalsIgnoreCase(this.m_backup_CSV_Load)) {
                action = new Action_ImportTraceTableFromCSV();
                ((Action_ImportTraceTableFromCSV)action).Hasher.string_put("Name", "Backup");
                RefractionStaticsProject.singleton().executeSingleAction(action);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void scrollToRow() {
        try {
            RefractionStaticsProject rsp = RefractionStaticsProject.singleton();
            int row = Tools_Widget.extractInteger(this.m_txtRow, 0, 0, 1000000000);
            JTable table = this.m_table.table();
            table.scrollRectToVisible(table.getCellRect(row, 0, true));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void reloadTable() {
        try {
            this.m_table.table().setModel(new DefaultTableModel());
            RefractionStaticsProject rsp = RefractionStaticsProject.singleton();
            ITraceTable_Wrapper ttw = rsp.traceTableWrapper();
            ITraceTable tt = ttw.traceTable();
            TraceTable_SimpleModel model = new TraceTable_SimpleModel(tt);
            this.m_table.table().setModel(model);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void exportTotal() {
        try {
            if (this.m_ExportTotalDialog == null) {
                this.m_ExportTotalDialog = new ExportTotalDialog();
            }
            this.m_ExportTotalDialog.showDialog();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_timer && this.m_chk_auto_backup.isSelected()) {
                RefractionStaticsProject.singleton().trace_table_create_backup();
            }
            if (e.getSource() == this.m_txtRow) {
                this.scrollToRow();
                return;
            }
            if (e.getSource() == this.m_totalButton) {
                this.exportTotal();
                return;
            }
            if (e.getSource() == this.m_constButton) {
                if (this.m_constDialog == null) {
                    this.m_constDialog = new TraceTable_SetConstDialog();
                }
                this.m_constDialog.showDialog();
                this.reloadTable();
                return;
            }
            if (e.getSource() == this.m_testMathButton) {
                ColumnMathDialog dlg = new ColumnMathDialog("Trace", null, "Trace table column math", null);
                if (!dlg.RunTraceOkay) {
                    return;
                }
                String sql = dlg.TraceSQL;
                Action_TraceTableSQL action = new Action_TraceTableSQL();
                action.Hasher.string_put("SQL", sql);
                RefractionStaticsProject.singleton().executeSingleAction(action);
                return;
            }
            if (e.getSource() == this.m_refreshButton) {
                this.reloadTable();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

