/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Data.TraceTable.ITraceTableScannerMonitor;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionProjectSuggestions;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

public class PickSimpleMathDialog
extends JDialog
implements ActionListener,
ITraceTableScannerMonitor {
    protected JButton m_btnOK = new JButton("Copy column");
    protected JButton m_btnCancel = new JButton("Close");
    protected JTextField m_txt_scalar2 = new JTextField("-1");
    protected JTextField m_txt_default = new JTextField("0");
    protected ComboStringListWrapper m_combo1 = new ComboStringListWrapper();
    protected ComboStringListWrapper m_combo2 = new ComboStringListWrapper();
    protected ComboStringListWrapper m_combo3 = new ComboStringListWrapper();
    protected JProgressBar m_progress = new JProgressBar();
    protected JCheckBox m_mustBeValidCheck = new JCheckBox("Require valid input picks ( >= 0)");
    public boolean OK = false;
    protected static PickSimpleMathDialog m_singleton = null;
    protected boolean m_bUserPicksModified = false;

    public static PickSimpleMathDialog singleton() {
        try {
            if (m_singleton == null) {
                m_singleton = new PickSimpleMathDialog();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected PickSimpleMathDialog() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget middle = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            GridLayoutWidget grid = middle.createGridLayoutWidget(3, "Select columns", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Column #1:"), this.m_combo1);
            grid.addSimple(row++, new JLabel("Column #2:"), this.m_combo2);
            grid.addSimple(row++, new JLabel("Scalar"), this.m_txt_scalar2);
            grid.addSimple(row++, new JLabel("Output Column:"), this.m_combo3);
            grid.addSimple(row++, new JLabel("Default output value, if inputs are invalid"), this.m_txt_default);
            middle.createLabel("Output = Column1 + Scalar * Column2", 2, 0);
            middle.addComponent(this.m_mustBeValidCheck, 0);
            this.m_mustBeValidCheck.setSelected(true);
            this.m_progress.setMaximum(1000);
            middle.addComponent(this.m_progress, 0);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            bottom.addStretch(10);
            this.getContentPane().add((Component)middle, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.pack();
            this.setSize(this.getSize().width + 100, this.getSize().height);
            this.setTitle("Copy pick columns");
            this.setLocationRelativeTo(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnCancel) {
                if (this.m_bUserPicksModified) {
                    RefractionProjectSuggestions.singleton().userPicksModified();
                }
                this.m_bUserPicksModified = false;
                this.dispose();
                return;
            }
            float scalar = (float)Tools_Widget.extractDouble(this.m_txt_scalar2, 0.0, -2.0E7, 2.0E7);
            float def = (float)Tools_Widget.extractDouble(this.m_txt_default, 0.0, -2.0E7, 2.0E7);
            if (e.getSource() == this.m_btnOK) {
                boolean mbv = this.m_mustBeValidCheck.isSelected();
                ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
                String c1 = this.m_combo1.getSelectedString();
                String c2 = this.m_combo2.getSelectedString();
                String c3 = this.m_combo3.getSelectedString();
                int res = JOptionPane.showConfirmDialog(this, "Okay to overwrite contents of " + c3 + "?", "Confirm copy", 2, 2, null);
                if (res != 0) {
                    return;
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                int col1 = table.column_indexOfColumn(c1);
                int col2 = table.column_indexOfColumn(c2);
                int col3 = table.column_indexOfColumn(c3);
                for (long r = 0L; r < table.rowCount(); ++r) {
                    float p1 = table.getFloat(r, col1);
                    float p2 = table.getFloat(r, col2);
                    float p3 = def;
                    if (!mbv || p1 > 0.0f && p2 > 0.0f) {
                        p3 = p1 + scalar * p2;
                    }
                    table.putFloat(r, col3, p3);
                    if (r % 100000L != 0L) continue;
                    double percent = 100.0 * (double)r / (double)table.rowCount();
                    this.setPercentDone(percent);
                }
                this.m_bUserPicksModified = true;
                this.setCursor(Cursor.getDefaultCursor());
                this.m_progress.setValue(0);
                JOptionPane.showMessageDialog(null, "Succesfully modified " + c3, "Pick math complete", 0);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void setPercentDone(double percent) {
        try {
            percent = Math.max(percent, 0.0);
            percent = Math.min(percent, 99.99);
            this.m_progress.setValue((int)(10.0 * percent));
            this.m_progress.paintImmediately(0, 0, 500, 30);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void setMessage(String message) {
    }

    protected void loadColumns() {
        try {
            ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            ArrayList<String> cols = table.columns("FBP_");
            this.m_combo1.setStringArray(cols);
            this.m_combo2.setStringArray(cols);
            this.m_combo3.setStringArray(cols);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void showDialog(String preferredFrom) {
        try {
            this.m_bUserPicksModified = false;
            this.OK = false;
            this.loadColumns();
            this.m_progress.setValue(0);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

