/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Refraction.Picking.PickPlaneEnum;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;

public class PickPlaneCombo
extends JComboBox<String>
implements ItemListener {
    protected GenericObjectListener m_listenerManager = new GenericObjectListener();
    protected boolean m_ignoreEvent = false;

    public PickPlaneCombo(GenericObjectListener.Listener listener, boolean includeSparse) {
        try {
            if (includeSparse) {
                this.build(listener, 4);
            } else {
                this.build(listener, 3);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public PickPlaneCombo(GenericObjectListener.Listener listener) {
        try {
            this.build(listener, 3);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void build(GenericObjectListener.Listener listener, int max) {
        try {
            if (listener != null) {
                this.m_listenerManager.addListener(listener);
            }
            PickPlaneEnum[] vals = PickPlaneEnum.values();
            for (int n = 0; n < max; ++n) {
                this.addItem(vals[n].Description);
            }
            this.setSelectedIndex(0);
            this.setEditable(false);
            this.addItemListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setPickPlane(PickPlaneEnum pickPlane, boolean broadcastChange) {
        try {
            this.m_ignoreEvent = true;
            this.setSelectedIndex(pickPlane.ordinal());
            this.m_ignoreEvent = false;
            if (broadcastChange) {
                this.m_listenerManager.broadcast(this, null);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        this.m_ignoreEvent = false;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (this.m_ignoreEvent) {
                return;
            }
            this.m_listenerManager.broadcast(this, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public GenericObjectListener getListenerController() {
        return this.m_listenerManager;
    }

    public PickPlaneEnum getPickPlane() {
        return PickPlaneEnum.values()[this.getSelectedIndex()];
    }
}

