/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Data.Column_Long;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Data.TraceTable.ITraceTableScannerMonitor;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.TraceTable.TraceTable_ScannerBase;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Refraction.Picking.AzimuthSelectorWidget;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class OffsetBinInlineCrosslineNavigationWidget
extends LinearLayoutWidget
implements ActionListener,
ItemListener,
ListSelectionListener,
GenericObjectListener.Listener,
ITraceTableScannerMonitor {
    protected GenericObjectListener m_listener = new GenericObjectListener();
    protected JComboBox<String> m_plane = new JComboBox();
    protected JLabel m_selected = new JLabel("Nothing selected", 0);
    protected JButton m_btnPrev = new JButton("Prev");
    protected JButton m_btnNext = new JButton("Next");
    protected JTable m_table = new JTable();
    protected JTextField m_txtBinSize = new JTextField("100");
    protected JTextField m_txtOverlap = new JTextField("25");
    protected JButton m_btnBin = new JButton("Perform binning");
    protected JProgressBar m_progress = new JProgressBar();
    protected JCheckBox m_chkAutoBin = new JCheckBox("Automatic offset binning");
    protected AzimuthSelectorWidget m_azimuthSelectorWidget;
    protected int m_inline = -9999;
    protected int m_crossline = -9999;
    protected int m_selectedRow = 0;
    protected BinData InlineData = new BinData();
    protected BinData CrosslineData = new BinData();
    protected long[] m_indices = new long[200];
    protected boolean m_ignoreTableSelection = false;

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public AzimuthSelectorWidget azimuthSelectorWidget() {
        return this.m_azimuthSelectorWidget;
    }

    @Override
    public void setPercentDone(double percent) {
    }

    @Override
    public void setMessage(String message) {
    }

    protected void bin() {
        try {
            try {
                if (SharedApplicationData.singleton().appFrame() != null) {
                    SharedApplicationData.singleton().appFrame().setCursor(Cursor.getPredefinedCursor(3));
                }
            }
            catch (Exception error) {
                error.printStackTrace();
            }
            double offsetBinSize = Tools_Widget.extractDouble(this.m_txtBinSize, 100.0, 1.0, 5000.0);
            double overlap = Tools_Widget.extractDouble(this.m_txtOverlap, 25.0, 0.0, 80.0);
            Scanner scanner = new Scanner(offsetBinSize, overlap);
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            ITraceTable traceTable = project.traceTableWrapper().traceTable();
            scanner.scan(traceTable, this);
            if (this.m_plane.getSelectedIndex() == 0) {
                this.m_table.setModel(this.InlineData);
            } else {
                this.m_table.setModel(this.CrosslineData);
            }
            this.InlineData.fireTableDataChanged();
            this.CrosslineData.fireTableDataChanged();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        try {
            if (SharedApplicationData.singleton().appFrame() != null) {
                SharedApplicationData.singleton().appFrame().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public OffsetBinInlineCrosslineNavigationWidget() {
        super(LinearLayoutWidget.Direction.Vertical, 0, null);
        try {
            LinearLayoutWidget topWidget = this.createHorizontal(0, "Navigation", 0);
            this.m_plane.addItem("Inline");
            this.m_plane.addItem("Crossline");
            this.m_plane.setSelectedIndex(0);
            this.m_plane.addItemListener(this);
            topWidget.addComponent(this.m_plane, 0);
            topWidget.addComponent(this.m_selected, 0);
            this.m_selected.setPreferredSize(new Dimension(120, 12));
            this.m_btnPrev = topWidget.createButton("Previous", this, 0);
            this.m_btnNext = topWidget.createButton("Next", this, 0);
            topWidget.addStretch(10);
            GridLayoutWidget grid = this.createGridLayoutWidget(0, "Binning options", 0);
            grid.addSimple(0, new JLabel("Offset bin size (ft/m)"), this.m_txtBinSize);
            grid.addSimple(1, new JLabel("Percent offset bin overlap"), this.m_txtOverlap);
            grid.addSimple(2, this.m_btnBin, this.m_progress);
            grid.addSimple(3, new JLabel(""), this.m_chkAutoBin);
            this.m_btnBin.addActionListener(this);
            this.m_chkAutoBin.setSelected(true);
            this.m_chkAutoBin.setToolTipText("Automatically perform offset binning when new inline/crossline selected");
            this.addComponent(new JScrollPane(this.m_table), 10);
            this.m_table.setSelectionMode(0);
            this.m_table.getSelectionModel().addListSelectionListener(this);
            this.m_azimuthSelectorWidget = new AzimuthSelectorWidget();
            this.addComponent(this.m_azimuthSelectorWidget, 0);
            Tools_FontChanger.changeSizeOfFont(this, -2, null, true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void populate(Ensemble ensemble, OffsetBin bin) {
        try {
            if (bin.Count < 1) {
                return;
            }
            if (this.m_indices.length < bin.Count) {
                this.m_indices = new long[bin.Count + 100];
            }
            for (int n = 0; n < bin.Count; ++n) {
                this.m_indices[n] = bin.Indices.getInt(n);
            }
            try {
                if (SharedApplicationData.singleton().appFrame() != null) {
                    SharedApplicationData.singleton().appFrame().setCursor(Cursor.getPredefinedCursor(3));
                }
            }
            catch (Exception error) {
                error.printStackTrace();
            }
            RefractionStaticsProject.singleton().ensemble_Indices(ensemble, this.m_indices, bin.Count, true);
            try {
                if (SharedApplicationData.singleton().appFrame() != null) {
                    SharedApplicationData.singleton().appFrame().setCursor(Cursor.getDefaultCursor());
                }
            }
            catch (Exception error) {
                error.printStackTrace();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void populateEnsemble_Crossline(Ensemble ensemble, boolean emitSignal) {
        try {
            this.m_selectedRow = Math.max(this.m_selectedRow, 0);
            this.m_selectedRow = Math.min(this.m_selectedRow, this.CrosslineData.Bins.size() - 1);
            if (this.m_selectedRow < 0) {
                return;
            }
            this.populate(ensemble, this.CrosslineData.Bins.get(this.m_selectedRow));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void populateEnsemble_Inline(Ensemble ensemble, boolean emitSignal) {
        try {
            this.m_selectedRow = Math.max(this.m_selectedRow, 0);
            this.m_selectedRow = Math.min(this.m_selectedRow, this.InlineData.Bins.size() - 1);
            if (this.m_selectedRow < 0) {
                return;
            }
            this.populate(ensemble, this.InlineData.Bins.get(this.m_selectedRow));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void populateEnsemble(Ensemble ensemble, boolean emitSignal) {
        try {
            ensemble.clearTraces(false);
            if (this.m_plane.getSelectedIndex() == 0) {
                this.populateEnsemble_Inline(ensemble, emitSignal);
            } else {
                this.populateEnsemble_Crossline(ensemble, emitSignal);
            }
            if (emitSignal) {
                this.m_listener.broadcast(this, null);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        try {
            this.m_ignoreTableSelection = true;
            if (this.m_selectedRow >= 0) {
                this.m_table.getSelectionModel().setSelectionInterval(this.m_selectedRow, this.m_selectedRow);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        this.m_ignoreTableSelection = false;
    }

    public void setInlineCrossline(int inlineBin, int crossBin, boolean auto) {
        try {
            this.m_inline = inlineBin;
            this.m_crossline = crossBin;
            this.m_ignoreTableSelection = true;
            this.InlineData.Bins.clear();
            this.CrosslineData.Bins.clear();
            if (this.m_chkAutoBin.isSelected() || auto) {
                this.bin();
            }
            if (this.m_plane.getSelectedIndex() == 0) {
                this.m_selected.setText(Integer.toString(this.m_inline));
                this.m_table.setModel(this.InlineData);
            } else {
                this.m_selected.setText(Integer.toString(this.m_crossline));
                this.m_table.setModel(this.CrosslineData);
            }
            this.m_ignoreTableSelection = false;
            this.m_listener.broadcast(this, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        this.m_ignoreTableSelection = false;
    }

    public void goToPriorOffsets() {
        try {
            if (this.m_plane.getSelectedIndex() == 0) {
                if (this.InlineData.Bins.size() < 1) {
                    return;
                }
                if (this.m_selectedRow < 1) {
                    return;
                }
                --this.m_selectedRow;
                this.m_table.getSelectionModel().setSelectionInterval(this.m_selectedRow, this.m_selectedRow);
                this.listener().broadcast(this, null);
            } else {
                if (this.CrosslineData.Bins.size() < 1) {
                    return;
                }
                if (this.m_selectedRow < 1) {
                    return;
                }
                --this.m_selectedRow;
                this.m_table.getSelectionModel().setSelectionInterval(this.m_selectedRow, this.m_selectedRow);
                this.listener().broadcast(this, null);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void goToNextOffsets() {
        try {
            if (this.m_plane.getSelectedIndex() == 0) {
                if (this.InlineData.Bins.size() < 1) {
                    return;
                }
                if (this.m_selectedRow >= this.InlineData.Bins.size() - 1) {
                    return;
                }
                ++this.m_selectedRow;
                this.m_table.getSelectionModel().setSelectionInterval(this.m_selectedRow, this.m_selectedRow);
                this.listener().broadcast(this, null);
            } else {
                if (this.CrosslineData.Bins.size() < 1) {
                    return;
                }
                if (this.m_selectedRow >= this.CrosslineData.Bins.size() - 1) {
                    return;
                }
                ++this.m_selectedRow;
                this.m_table.getSelectionModel().setSelectionInterval(this.m_selectedRow, this.m_selectedRow);
                this.listener().broadcast(this, null);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (e.getSource() == this.m_plane) {
                if (this.m_plane.getSelectedIndex() == 0) {
                    this.m_selected.setText(Integer.toString(this.m_inline));
                    this.m_table.setModel(this.InlineData);
                } else {
                    this.m_selected.setText(Integer.toString(this.m_crossline));
                    this.m_table.setModel(this.CrosslineData);
                }
                this.m_listener.broadcast(this, null);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnBin) {
                this.bin();
            }
            if (e.getSource() == this.m_btnPrev) {
                if (this.m_plane.getSelectedIndex() == 0) {
                    this.setInlineCrossline(this.m_inline - 1, this.m_crossline, true);
                } else {
                    this.setInlineCrossline(this.m_inline, this.m_crossline - 1, true);
                }
                return;
            }
            if (e.getSource() == this.m_btnNext) {
                if (this.m_plane.getSelectedIndex() == 0) {
                    this.setInlineCrossline(this.m_inline + 1, this.m_crossline, true);
                } else {
                    this.setInlineCrossline(this.m_inline, this.m_crossline + 1, true);
                }
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == null) {
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            if (e.getSource() == this.m_table.getSelectionModel()) {
                if (this.m_ignoreTableSelection) {
                    return;
                }
                this.m_selectedRow = this.m_table.getSelectedRow();
                this.m_listener.broadcast(this, null);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected class Scanner
    extends TraceTable_ScannerBase {
        protected double m_offsetBinSize;
        protected double m_overlap;

        public Scanner(double offsetBinSize, double overlap) {
            try {
                OffsetBinInlineCrosslineNavigationWidget.this.InlineData.OffsetBinSize = offsetBinSize;
                OffsetBinInlineCrosslineNavigationWidget.this.InlineData.Overlap = overlap;
                OffsetBinInlineCrosslineNavigationWidget.this.InlineData.MaxOffset = 0.0;
                OffsetBinInlineCrosslineNavigationWidget.this.InlineData.Bins.clear();
                OffsetBinInlineCrosslineNavigationWidget.this.CrosslineData.OffsetBinSize = offsetBinSize;
                OffsetBinInlineCrosslineNavigationWidget.this.CrosslineData.Overlap = overlap;
                OffsetBinInlineCrosslineNavigationWidget.this.CrosslineData.MaxOffset = 0.0;
                OffsetBinInlineCrosslineNavigationWidget.this.CrosslineData.Bins.clear();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void work() throws Exception {
            try {
                this.m_offset = Math.abs(this.m_offset);
                if (OffsetBinInlineCrosslineNavigationWidget.this.m_inline == this.m_inlineBin) {
                    OffsetBinInlineCrosslineNavigationWidget.this.InlineData.add(this.m_offset, this.m_traceRow);
                }
                if (OffsetBinInlineCrosslineNavigationWidget.this.m_crossline == this.m_crosslineBin) {
                    OffsetBinInlineCrosslineNavigationWidget.this.CrosslineData.add(this.m_offset, this.m_traceRow);
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                throw ex;
            }
        }

        @Override
        public void finishScan() throws Exception {
        }
    }

    protected class BinData
    extends AbstractTableModel {
        public ArrayList<OffsetBin> Bins = new ArrayList();
        public double MaxOffset = 0.0;
        public double OffsetBinSize = 100.0;
        public double Overlap = 25.0;

        protected BinData() {
        }

        public void add(double offset, long row) {
            try {
                double chunk = this.OffsetBinSize * (1.0 - 0.01 * this.Overlap);
                while (offset >= this.MaxOffset + this.OffsetBinSize) {
                    this.Bins.add(new OffsetBin(this.MaxOffset, this.MaxOffset + this.OffsetBinSize));
                    this.MaxOffset += chunk;
                }
                int index = (int)(offset / chunk);
                this.add(index - 1, offset, row);
                this.add(index, offset, row);
                this.add(index + 1, offset, row);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        protected void add(int index, double offset, long row) {
            try {
                if (index < 0 || index >= this.Bins.size()) {
                    return;
                }
                OffsetBin bin = this.Bins.get(index);
                if (offset >= bin.MinOffset && offset <= bin.MaxOffset) {
                    bin.add(row);
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public String getColumnName(int column) {
            try {
                if (column == 0) {
                    return "Min offset";
                }
                if (column == 1) {
                    return "Max offset";
                }
                if (column == 2) {
                    return "Count";
                }
                return "ERROR";
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return "Error";
            }
        }

        @Override
        public int getRowCount() {
            return this.Bins.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int row, int column) {
            try {
                if (row >= this.Bins.size()) {
                    return "";
                }
                if (column == 0) {
                    return Integer.toString((int)this.Bins.get((int)row).MinOffset);
                }
                if (column == 1) {
                    return Integer.toString((int)this.Bins.get((int)row).MaxOffset);
                }
                if (column == 2) {
                    return Integer.toString(this.Bins.get((int)row).Count);
                }
                return "Error";
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return "Error";
            }
        }
    }

    protected class OffsetBin {
        public double MinOffset;
        public double MaxOffset;
        public int Count = 0;
        public Column_Long Indices = new Column_Long();

        public OffsetBin(double min, double max) {
            this.MinOffset = min;
            this.MaxOffset = max;
        }

        public void add(long index) {
            try {
                this.Indices.putLong(this.Count, index);
                ++this.Count;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }
    }
}

