/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.QC.Action_NoiseComputation;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class NoiseComputationDialog
extends JDialog
implements ActionListener {
    protected JButton m_btnOK = new JButton("Create pick column");
    protected JButton m_btnCancel = new JButton("Cancel");
    protected JTextField m_windowText = new JTextField("100");
    protected JTextField m_killText = new JTextField("5");
    protected JCheckBox m_killCheck = new JCheckBox("Kill noisy traces");
    protected JCheckBox m_killTracesWithDC = new JCheckBox("Kill traces with DC bias");
    protected JTextField m_killDcText = new JTextField("150");
    public boolean OK = false;

    public NoiseComputationDialog() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget middle = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            JLabel lbl = middle.createLabel("This will add a column named NoiseLevel \nto the shot/receiver tables", 0, 0);
            GridLayoutWidget grid = middle.createGridLayoutWidget(3, "NoiseLevel computation options", 0);
            grid.addSimple(0, new JLabel("Window (milliseconds)"), this.m_windowText);
            grid.addSimple(1, new JLabel(""), this.m_killCheck);
            grid.addSimple(2, new JLabel("Kill threshold (percent)"), this.m_killText);
            this.m_killCheck.setSelected(false);
            this.m_killCheck.addActionListener(this);
            this.m_killText.setEnabled(this.m_killCheck.isSelected());
            grid = middle.createGridLayoutWidget(3, "DC bias options", 0);
            grid.addSimple(0, new JLabel(""), this.m_killTracesWithDC);
            grid.addSimple(1, new JLabel("Maximum DC length (ms)"), this.m_killDcText);
            this.m_killTracesWithDC.addActionListener(this);
            this.m_killDcText.setEnabled(this.m_killTracesWithDC.isSelected());
            middle.addStretch(10);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            this.m_btnCancel = bottom.createButton("Cancel", this, 0);
            this.m_btnOK = bottom.createButton("Compute noise levels", this, 0);
            bottom.addStretch(10);
            this.getContentPane().add((Component)middle, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.pack();
            this.setSize(this.getSize().width + 100, this.getSize().height);
            this.setTitle("Noise level computation");
            this.setLocationRelativeTo(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void showDialog() {
        try {
            this.OK = false;
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean dataOK() {
        try {
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public void launchJob() {
        try {
            double w = Tools_Widget.extractDouble(this.m_windowText, 100.0, 20.0, 1000.0);
            double thresh = Tools_Widget.extractDouble(this.m_killText, 5.0, 1.0, 50.0);
            Action_NoiseComputation action = new Action_NoiseComputation();
            action.KillDC = this.m_killTracesWithDC.isSelected();
            action.MaxDC = Tools_Widget.extractDouble(this.m_killText, 150.0, 50.0, 2000.0);
            action.Hasher.double_put("Window", w);
            action.Hasher.double_put("Threshold", thresh);
            action.Hasher.bool_put("Kill", this.m_killCheck.isSelected());
            RefractionStaticsProject.singleton().executeSingleAction(action);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.m_killText.setEnabled(this.m_killCheck.isSelected());
            this.m_killDcText.setEnabled(this.m_killTracesWithDC.isSelected());
            if (e.getSource() == this.m_killCheck) {
                if (this.m_killCheck.isSelected()) {
                    this.m_btnOK.setText("Compute noise levels and kill noisy traces");
                } else {
                    this.m_btnOK.setText("Compute noise levels");
                }
            }
            if (e.getSource() == this.m_btnOK) {
                this.OK = true;
                this.dispose();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

