/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Math.AzimuthSelector;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Arc2D;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AzimuthSelectorWidget
extends LinearLayoutWidget
implements ComponentListener,
ActionListener,
ChangeListener,
GenericObjectListener.Listener {
    protected GenericObjectListener m_listener = new GenericObjectListener();
    protected JCheckBox m_chkOn = new JCheckBox("Apply azimuth limitations");
    protected JCheckBox m_chkSymmetric = new JCheckBox("Apply shot/receiver symmetry");
    protected JSlider m_slideDirection = new JSlider();
    protected JSlider m_slideAngle = new JSlider();
    protected JTextField m_txtDirection = new JTextField("0");
    protected JTextField m_txtAngle = new JTextField("45");
    protected AzDispWidget m_widget = new AzDispWidget();
    protected LinearLayoutWidget m_dirWidget;
    protected LinearLayoutWidget m_angleWidget;
    protected AzimuthSelector m_azimuthSelector = new AzimuthSelector();
    protected boolean m_ignoreSliderChangeEvent = false;

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public AzimuthSelectorWidget() {
        super(LinearLayoutWidget.Direction.Vertical, 3, "Trace azimuth selection (degrees, X axis is zero)");
        try {
            LinearLayoutWidget top = this.createHorizontal(3, null, 0);
            top.addComponent(this.m_chkOn, 1);
            top.addComponent(this.m_chkSymmetric, 1);
            LinearLayoutWidget bottom = this.createHorizontal(3, null, 10);
            this.m_dirWidget = bottom.createVertical(0, "", 5);
            this.m_dirWidget.addComponent(new JLabel("Direction"), 0);
            this.m_dirWidget.addComponent(this.m_txtDirection, 0);
            this.m_dirWidget.addComponent(this.m_slideDirection, 0);
            this.m_dirWidget.addStretch(10);
            this.m_angleWidget = bottom.createVertical(0, "", 5);
            this.m_angleWidget.addComponent(new JLabel("Acceptance"), 0);
            this.m_angleWidget.addComponent(this.m_txtAngle, 0);
            this.m_angleWidget.addComponent(this.m_slideAngle, 0);
            this.m_angleWidget.addStretch(10);
            JLabel lbl = new JLabel("");
            this.m_widget.BackColor = lbl.getBackground();
            bottom.addComponent(this.m_widget, 5);
            int w = 70;
            int h = 70;
            this.m_widget.setMinimumSize(new Dimension(w, h));
            this.m_widget.setPreferredSize(new Dimension(w, h));
            this.m_slideDirection.setMinimum(0);
            this.m_slideDirection.setMaximum(359);
            this.m_slideDirection.setValue(0);
            this.m_slideAngle.setMinimum(0);
            this.m_slideAngle.setMaximum(180);
            this.m_slideAngle.setValue(45);
            this.m_slideDirection.addChangeListener(this);
            this.m_slideAngle.addChangeListener(this);
            this.m_chkOn.addActionListener(this);
            this.m_chkSymmetric.addActionListener(this);
            this.m_txtDirection.addActionListener(this);
            this.m_txtAngle.addActionListener(this);
            this.m_chkOn.setSelected(false);
            this.m_txtDirection.setEnabled(this.m_chkOn.isSelected());
            this.m_slideDirection.setEnabled(this.m_chkOn.isSelected());
            this.m_txtAngle.setEnabled(this.m_chkOn.isSelected());
            this.m_slideAngle.setEnabled(this.m_chkOn.isSelected());
            this.addComponentListener(this);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void prepEnsemble(Ensemble ensemble, boolean setShowTrace) {
        try {
            if (ensemble == null) {
                return;
            }
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                trace.AzimuthAccepted = true;
            }
            if (!this.m_chkOn.isSelected()) {
                return;
            }
            if (!ensemble.dictionary().containsEntry("Trace", "Azimuth")) {
                return;
            }
            double dir = Math.PI * Tools_Widget.extractDouble(this.m_txtDirection, 0.0, -720.0, 720.0) / 180.0;
            double angle = Math.PI * Tools_Widget.extractDouble(this.m_txtAngle, 45.0, 0.0, 180.0) / 180.0;
            this.m_azimuthSelector.setLimits(dir, angle, this.m_chkSymmetric.isSelected());
            this.m_widget.Angle = 180.0 * angle / Math.PI;
            this.m_widget.Direction = 180.0 * dir / Math.PI;
            this.m_widget.Symmetric = this.m_chkSymmetric.isSelected();
            this.m_widget.repaint();
            int azIndex = ensemble.dictionary().getEntryIndex("Trace", "Azimuth");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                double az = trace.header().getDouble(azIndex);
                trace.AzimuthAccepted = this.m_azimuthSelector.accept(az);
                if (!setShowTrace) continue;
                trace.PlotData.ShowTrace = trace.PlotData.ShowTrace && trace.AzimuthAccepted;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            if (this.m_ignoreSliderChangeEvent) {
                return;
            }
            if (e.getSource() == this.m_slideDirection) {
                this.m_txtDirection.setText(Integer.toString(this.m_slideDirection.getValue()));
            }
            if (e.getSource() == this.m_slideAngle) {
                this.m_txtAngle.setText(Integer.toString(this.m_slideAngle.getValue()));
            }
            this.m_listener.broadcast(this, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setOn(boolean on) {
        this.m_chkOn.setSelected(on);
    }

    public boolean isOn() {
        return this.m_chkOn.isSelected();
    }

    public double dir() {
        return Math.PI * (double)Tools_Widget.extractInteger(this.m_txtDirection, 0, -360, 360) / 180.0;
    }

    public void setDir(double dir) {
        try {
            int v = (int)(dir * 180.0 / Math.PI);
            this.m_txtDirection.setText(Integer.toString(v));
            this.m_ignoreSliderChangeEvent = true;
            this.m_slideDirection.setValue(v);
            this.m_ignoreSliderChangeEvent = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public double angle() {
        return Math.PI * (double)Tools_Widget.extractInteger(this.m_txtAngle, 45, 0, 90) / 180.0;
    }

    public void setAngle(double angle) {
        try {
            int v = (int)(angle * 180.0 / Math.PI);
            this.m_txtAngle.setText(Integer.toString(v));
            this.m_ignoreSliderChangeEvent = true;
            this.m_slideAngle.setValue(v);
            this.m_ignoreSliderChangeEvent = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (this.m_txtAngle == e.getSource()) {
                int angle = (int)Tools_Widget.extractDouble(this.m_txtAngle, 45.0, 0.0, 180.0);
                angle = Math.max(angle, 0);
                angle = Math.min(angle, 180);
                this.m_ignoreSliderChangeEvent = true;
                this.m_slideAngle.setValue(angle);
                this.m_ignoreSliderChangeEvent = false;
            }
            if (this.m_txtDirection == e.getSource()) {
                int dir;
                for (dir = (int)Tools_Widget.extractDouble(this.m_txtDirection, 0.0, -720.0, 720.0); dir < 0; dir += 360) {
                }
                while (dir >= 360) {
                    dir -= 360;
                }
                this.m_txtDirection.setText(Integer.toString(dir));
                this.m_ignoreSliderChangeEvent = true;
                this.m_slideDirection.setValue(dir);
                this.m_ignoreSliderChangeEvent = false;
            }
            this.m_txtDirection.setEnabled(this.m_chkOn.isSelected());
            this.m_slideDirection.setEnabled(this.m_chkOn.isSelected());
            this.m_txtAngle.setEnabled(this.m_chkOn.isSelected());
            this.m_slideAngle.setEnabled(this.m_chkOn.isSelected());
            this.m_listener.broadcast(this, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.m_listener.broadcast(this, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    protected class AzDispWidget
    extends JPanel {
        public double Direction = 0.0;
        public double Angle = 45.0;
        public Color BackColor = Color.LIGHT_GRAY;
        public Color DeadColor = Color.RED;
        public Color OkColor = Color.GREEN;
        public boolean Symmetric = false;

        protected AzDispWidget() {
        }

        @Override
        public void paintComponent(Graphics g) {
            try {
                Dimension size = this.getSize();
                Graphics2D g2d = (Graphics2D)g;
                g2d.setColor(this.BackColor);
                g2d.fillRect(0, 0, size.width, size.height);
                int midx = size.width / 2;
                int midy = size.height / 2;
                int radius = Math.min(midx, midy) - 5;
                g2d.setColor(this.DeadColor);
                g2d.fillOval(midx - radius, midy - radius, 2 * radius, 2 * radius);
                g2d.setColor(this.OkColor);
                Arc2D.Double pie = new Arc2D.Double(midx - radius, midy - radius, 2 * radius, 2 * radius, this.Direction - this.Angle / 2.0, this.Angle, 2);
                g2d.fill(pie);
                if (this.Symmetric) {
                    pie = new Arc2D.Double(midx - radius, midy - radius, 2 * radius, 2 * radius, 180.0 + this.Direction - this.Angle / 2.0, this.Angle, 2);
                    g2d.fill(pie);
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }
}

