/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Refraction.LinearMoveoutTrendWidget_Picks;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class LinearMoveoutTrendDialog_Picks
extends JDialog
implements ActionListener,
GenericObjectListener.Listener,
ClipboardOwner {
    protected RefractionStaticsProject m_project;
    protected LinearMoveoutTrendWidget_Picks m_lmoWidget;
    protected JLabel m_statusLabel = new JLabel("", 0);
    protected JButton m_btnOK = new JButton("Apply changes");
    protected JButton m_btnCancel = new JButton("Cancel");
    protected JButton m_btnScreen = new JButton("Screencapture");
    protected JButton m_btnAcceptInterp = new JButton("Select interpolated curve");
    protected JButton m_btnExportCSV = new JButton("Export to CSV file");
    protected JButton m_btnExportSLB = new JButton("Export to SLB file");

    public LinearMoveoutTrendDialog_Picks() {
        try {
            this.m_project = RefractionStaticsProject.singleton();
            this.getContentPane().setLayout(new BorderLayout());
            this.m_lmoWidget = new LinearMoveoutTrendWidget_Picks();
            Tools_FontChanger.changeSizeOfFont(this.m_statusLabel, 2);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            bottom.addComponent(this.m_statusLabel, 10);
            bottom.addComponent(this.m_btnExportSLB, 0);
            bottom.addComponent(this.m_btnExportCSV, 0);
            bottom.addComponent(this.m_btnAcceptInterp, 0);
            bottom.addComponent(this.m_btnScreen, 0);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.m_btnScreen.addActionListener(this);
            this.m_btnAcceptInterp.addActionListener(this);
            this.m_btnExportCSV.addActionListener(this);
            this.m_btnExportSLB.addActionListener(this);
            this.getContentPane().add((Component)this.m_lmoWidget, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.branchOK();
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.setSize(1050, 850);
            this.setTitle("Linear moveout trend");
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean branchOK() {
        try {
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnOK) {
                this.m_lmoWidget.copyCurrentToProject();
                Messenger.broadcast(Messenger.Message.MoveoutTrendModified, this, null);
                this.dispose();
            }
            if (e.getSource() == this.m_btnExportCSV) {
                String file = Tools_Chooser.getSaveFileName("csv");
                if (file.length() < 3) {
                    return;
                }
                this.m_lmoWidget.save_csv(file);
                return;
            }
            if (e.getSource() == this.m_btnExportSLB) {
                String file = Tools_Chooser.getSaveFileName("txt");
                if (file.length() < 3) {
                    return;
                }
                this.m_lmoWidget.save_slb(file);
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
            if (e.getSource() == this.m_btnScreen) {
                this.screen();
                return;
            }
            if (e.getSource() == this.m_btnAcceptInterp) {
                this.acceptInterp();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void screen() {
        try {
            Rectangle rec = this.getBounds();
            BufferedImage capture = new Robot().createScreenCapture(rec);
            TransferableImage trans = new TransferableImage(capture);
            Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
            c.setContents(trans, this);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void acceptInterp() {
        try {
            this.m_lmoWidget.acceptInterp();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private class TransferableImage
    implements Transferable {
        Image i;

        public TransferableImage(Image i) {
            this.i = i;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(DataFlavor.imageFlavor) && this.i != null) {
                return this.i;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor};
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            DataFlavor[] flavors = this.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavor.equals(flavors[i])) continue;
                return true;
            }
            return false;
        }
    }
}

