/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Import.WizardSegy;

import com.PecosCore.Data.DataType;
import com.PecosCore.Seismic.Segy.Segy_Dictionary;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Refraction.Import.WizardSegy.SegyWizardSharedData;
import com.PecosLibrary.Windows.Wizard.ISimpleWizardPage;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class Page_SegyWiz_Optional
extends LinearLayoutWidget
implements ISimpleWizardPage,
GenericObjectListener.Listener,
ActionListener {
    protected SegyWizardSharedData m_data;
    protected String m_table;
    protected ArrayList<String> m_restrictedList = new ArrayList();
    protected JButton m_addButton;
    protected ArrayList<Entry> m_list = new ArrayList();
    protected ArrayList<String> m_semiList = new ArrayList();

    public Page_SegyWiz_Optional(String table, SegyWizardSharedData data) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_data = data;
            this.m_table = table;
            LinearLayoutWidget sub = this.createHorizontal(0, null, 0);
            this.m_addButton = sub.createButton("Add new entry", this, 0);
            sub.addStretch(10);
            this.createGapLabel(20);
            this.m_restrictedList.add("Easting");
            this.m_restrictedList.add("Northing");
            this.m_restrictedList.add("Elevation");
            this.m_restrictedList.add("LineNumber");
            this.m_restrictedList.add("PointIndex");
            this.m_restrictedList.add("PointNumber");
            GridLayoutWidget w = this.createGridLayoutWidget(0, 0);
            int row = 0;
            w.addComponent(new JLabel(" "), row, 0, 1.0, 8.0);
            w.addComponent(new JLabel("Column name"), row, 1, 1.0, 8.0);
            w.addComponent(new JLabel("Byte offset"), row, 2, 1.0, 8.0);
            w.addComponent(new JLabel("Data type"), row, 3, 1.0, 8.0);
            w.addComponent(new JLabel("Modification method"), row, 4, 1.0, 8.0);
            w.addComponent(new JLabel("Factor (if used)"), row, 5, 1.0, 8.0);
            w.addComponent(new JLabel("Valid"), row, 6, 1.0, 8.0);
            w.addComponent(new JLabel("Default value"), row, 7, 1.0, 8.0);
            for (int n = 0; n < 15; ++n) {
                Entry e = new Entry();
                this.m_list.add(e);
                e.KillButton.addActionListener(this);
                w.addComponent(e.KillButton, ++row, 0, 1.0, 8.0);
                w.addComponent(e.NameText, row, 1, 1.0, 8.0);
                w.addComponent(e.OffsetText, row, 2, 1.0, 8.0);
                w.addComponent(e.TypeCombo, row, 3, 1.0, 8.0);
                w.addComponent(e.ModCombo, row, 4, 1.0, 8.0);
                w.addComponent(e.FactorText, row, 5, 1.0, 8.0);
                w.addComponent(e.ValidCheck, row, 6, 1.0, 8.0);
                w.addComponent(e.DefaultText, row, 7, 1.0, 8.0);
            }
            this.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(this, -2, null, true);
            if (this.m_table.equalsIgnoreCase("Shot")) {
                this.addSemi("UpholeTime");
                this.addSemi("PointDepth");
            }
            if (this.m_table.equalsIgnoreCase("Trace")) {
                this.addSemi("TraceCode");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void dialogJustOpened() {
    }

    protected void addSemi(String colName) {
        try {
            int semiCount = this.m_semiList.size();
            Entry e = this.m_list.get(semiCount);
            e.KillButton.setEnabled(false);
            e.NameText.setText(colName);
            this.m_semiList.add(colName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        try {
            Segy_Dictionary dict = this.m_data.Dictionary;
            if (evt.getSource() == this.m_addButton) {
                for (Entry e : this.m_list) {
                    e.getData();
                }
                String colName = JOptionPane.showInputDialog(null, "Name of the new column", "Column name", -1);
                if (colName == null) {
                    return;
                }
                if (colName.length() < 1) {
                    return;
                }
                if (dict.hasEntry(this.m_table, colName)) {
                    return;
                }
                boolean bad = false;
                for (String s : this.m_restrictedList) {
                    bad = bad || s.equalsIgnoreCase(colName);
                }
                for (String s : this.m_semiList) {
                    bad = bad || s.equalsIgnoreCase(colName);
                }
                if (bad) {
                    return;
                }
                dict.addEntry(this.m_table, colName, DataType.Short, DataType.Double, 0, Segy_Dictionary.Modification.None, 1);
                this.activatePage();
                return;
            }
            boolean killed = false;
            for (Entry e : this.m_list) {
                if (e.KillButton != evt.getSource()) continue;
                dict.removeEntry(this.m_table, e.Header.Column);
                killed = true;
            }
            if (killed) {
                for (Entry e : this.m_list) {
                    e.getData();
                }
                this.activatePage();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.okayToGoToNextPage();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public GenericObjectListener listener() {
        return null;
    }

    @Override
    public boolean okayToGoToNextPage() {
        try {
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void leavingPage() {
        try {
            for (Entry e : this.m_list) {
                e.getData();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void activatePage() {
        try {
            void var3_7;
            Segy_Dictionary dict = this.m_data.Dictionary;
            for (Entry entry : this.m_list) {
                entry.Header = null;
            }
            ArrayList<String> allCols = dict.columns(this.m_table);
            for (Entry e : this.m_list) {
                e.setVis(false);
            }
            boolean bl = false;
            while (var3_7 < this.m_semiList.size()) {
                String semi = this.m_semiList.get((int)var3_7);
                Entry e = this.m_list.get((int)var3_7);
                e.setVis(true);
                e.KillButton.setEnabled(false);
                Segy_Dictionary.Entry hdr = dict.getEntry_Create(this.m_table, semi);
                e.setHeader(hdr);
                ++var3_7;
            }
            int n = this.m_semiList.size();
            for (String col : allCols) {
                void var3_9;
                boolean bad = false;
                for (String s : this.m_restrictedList) {
                    bad = bad || s.equalsIgnoreCase(col);
                }
                for (String s : this.m_semiList) {
                    bad = bad || s.equalsIgnoreCase(col);
                }
                if (bad || var3_9 >= this.m_list.size()) continue;
                Segy_Dictionary.Entry hdr = dict.getEntry(this.m_table, col);
                Entry e = this.m_list.get((int)var3_9);
                e.setVis(true);
                e.setHeader(hdr);
                ++var3_9;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected class Entry
    implements ActionListener {
        public Segy_Dictionary.Entry Header;
        public JButton KillButton = new JButton("Delete");
        public JTextField NameText = new JTextField("");
        public JTextField OffsetText = new JTextField("");
        public JComboBox<String> TypeCombo = new JComboBox();
        public JComboBox<String> ModCombo = new JComboBox();
        public JTextField FactorText = new JTextField("");
        public JCheckBox ValidCheck = new JCheckBox("Valid");
        public JTextField DefaultText = new JTextField("0");

        public Entry() {
            try {
                Segy_Dictionary.Modification[] mods;
                this.NameText.setEditable(false);
                this.TypeCombo.addItem(DataType.Short.Description);
                this.TypeCombo.addItem(DataType.Int.Description);
                this.TypeCombo.addItem(DataType.Float.Description);
                for (Segy_Dictionary.Modification mod : mods = Segy_Dictionary.Modification.values()) {
                    this.ModCombo.addItem(mod.Description);
                }
                this.ValidCheck.addActionListener(this);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public void setVis(boolean vis) {
            this.KillButton.setVisible(vis);
            this.NameText.setVisible(vis);
            this.OffsetText.setVisible(vis);
            this.TypeCombo.setVisible(vis);
            this.ModCombo.setVisible(vis);
            this.FactorText.setVisible(vis);
            this.ValidCheck.setVisible(vis);
            this.DefaultText.setVisible(vis);
        }

        public void setHeader(Segy_Dictionary.Entry hdr) {
            this.Header = hdr;
            this.NameText.setText(hdr.Column);
            this.OffsetText.setText(Integer.toString(1 + hdr.FirstByte));
            this.FactorText.setText(Integer.toString(hdr.Factor));
            this.TypeCombo.setSelectedIndex(hdr.HeaderType.ordinal());
            this.ModCombo.setSelectedIndex(hdr.ModMethod.ordinal());
            this.ValidCheck.setSelected(hdr.Valid);
            this.DefaultText.setVisible(!this.ValidCheck.isSelected());
            this.DefaultText.setText(Double.toString(hdr.DefaultValue));
        }

        public void getData() {
            if (this.Header == null) {
                return;
            }
            this.Header.Column = this.NameText.getText();
            this.Header.FirstByte = Tools_Widget.extractInteger(this.OffsetText, 1, 1, 237) - 1;
            this.Header.Factor = Tools_Widget.extractInteger(this.FactorText, 0, -1000000, 1000000);
            this.Header.HeaderType = DataType.values()[this.TypeCombo.getSelectedIndex()];
            this.Header.ModMethod = Segy_Dictionary.Modification.values()[this.ModCombo.getSelectedIndex()];
            this.Header.HeaderType = DataType.values()[this.TypeCombo.getSelectedIndex()];
            this.Header.Valid = this.ValidCheck.isSelected();
            this.Header.DefaultValue = Tools_Widget.extractDouble(this.DefaultText, 0.0, -1.0E20, 1.0E20);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (e.getSource() == this.ValidCheck) {
                    this.DefaultText.setVisible(!this.ValidCheck.isSelected());
                    return;
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }
}

