/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Import.WizardSegy;

import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Refraction.Import.WizardSegy.SegyWizardSharedData;
import com.PecosLibrary.Windows.Shared.MultipleFileSelectionWidget;
import com.PecosLibrary.Windows.Wizard.ISimpleWizardPage;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class Page_SegyWiz_Files
extends LinearLayoutWidget
implements ISimpleWizardPage,
GenericObjectListener.Listener {
    protected SegyWizardSharedData m_data;
    protected MultipleFileSelectionWidget m_filesWidget = new MultipleFileSelectionWidget("Select SEG-Y file(s)");
    protected JLabel m_label = new JLabel(" ");
    protected double m_totalBytes = 0.0;

    public Page_SegyWiz_Files(SegyWizardSharedData data) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_data = data;
            this.addComponent(this.m_filesWidget, 10);
            this.addComponent(this.m_label, 0);
            this.m_filesWidget.getListenerController().addListener(this);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void dialogJustOpened() {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.okayToGoToNextPage();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public GenericObjectListener listener() {
        return null;
    }

    protected void prepSegy() {
        try {
            this.m_totalBytes = 0.0;
            ArrayList<String> valid = new ArrayList<String>();
            for (String s : this.m_filesWidget.fileList()) {
                Segy segy = new Segy();
                segy.setFileName(s);
                if (segy.isFileOK()) {
                    valid.add(s);
                    this.m_totalBytes += (double)segy.fileByteCount();
                    continue;
                }
                JOptionPane.showMessageDialog(null, s + " is not a valid SEG-Y file", " ", 0);
            }
            this.m_filesWidget.setFileList(valid, false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean okayToGoToNextPage() {
        try {
            this.prepSegy();
            if (this.m_filesWidget.fileList().size() < 1) {
                this.m_label.setForeground(Color.red);
                this.m_label.setText("Please select at least one SEG-Y file");
                return false;
            }
            this.m_label.setForeground(Color.blue);
            this.m_label.setText("  ");
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void leavingPage() {
        try {
            this.m_data.Files = this.m_filesWidget.fileList();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void activatePage() {
        try {
            this.okayToGoToNextPage();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

