/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Import;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Geometry.TableParser;
import com.PecosCore.Plugins.PluginManager;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.Table_CustomModel;
import com.PecosLibrary.Data.Table_SimpleModel;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Plugins.Plugin_DataDisplayWidget;
import com.PecosLibrary.Windows.Refraction.Import.WizardSegy.SegyWizardSharedData;
import com.PecosLibrary.Windows.Shared.ScrollTable;
import com.PecosLibrary.Windows.Wizard.ISimpleWizardPage;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class Page_PluginWiz_LineNumber
extends LinearLayoutWidget
implements ISimpleWizardPage,
ActionListener,
GenericObjectListener.Listener,
ItemListener,
FocusListener {
    protected JRadioButton m_btn3 = new JRadioButton("3");
    protected JRadioButton m_btn4 = new JRadioButton("4");
    protected ButtonGroup m_btnGroup = new ButtonGroup();
    protected SegyWizardSharedData m_data;
    protected LinearLayoutWidget m_tableWidget;
    protected Plugin_DataDisplayWidget m_dataWidget;
    protected JButton m_scanButton;
    protected JProgressBar m_progress = new JProgressBar();
    protected JLabel m_scanLabel = new JLabel("", 0);
    protected JTextField m_txtScanCount = new JTextField("100000");
    protected JTable m_shotTable = new JTable();
    protected JTable m_recTable = new JTable();
    protected JTable m_shotConflictTable = new JTable();
    protected JTable m_recConflictTable = new JTable();
    protected ScrollTable m_headerTable = new ScrollTable();
    protected Java2D_SimpleComposite m_widget;
    protected Table_Abstract m_shotDataTable;
    protected TableParser m_shotParser;
    protected Table_Abstract m_recDataTable;
    protected TableParser m_recParser;
    protected long m_numRead = 0L;
    protected long m_totalTraces = 0L;

    public Page_PluginWiz_LineNumber(SegyWizardSharedData data) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_data = data;
            JLabel label1 = new JLabel("Select the length (in digits) of the Line Number.");
            JLabel label2 = new JLabel("Flatirons will take that many digits from the beginning of the Point Number to form the Line Number.");
            JLabel label3 = new JLabel("Please note: this is only used if there is no Line Number header in the input file.");
            label1.setForeground(Color.BLUE);
            label2.setForeground(Color.BLUE);
            label3.setForeground(Color.BLUE);
            this.addComponent(label1, 0);
            this.addComponent(label2, 0);
            this.addComponent(label3, 0);
            this.addComponent(this.m_btn3, 0);
            this.addComponent(this.m_btn4, 0);
            this.m_btnGroup.add(this.m_btn3);
            this.m_btnGroup.add(this.m_btn4);
            this.m_btn3.setSelected(true);
            this.m_btn3.addItemListener(this);
            this.m_btn4.addItemListener(this);
            this.addComponent(this.createScanWidget(), 0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource() == this.m_scanButton) {
                this.scan();
                return;
            }
            this.handleGenericObjectListener(null, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void leavingPage() {
        try {
            if (this.m_btn3.isSelected()) {
                SharedApplicationData.singleton().setLineNumberLength(3);
            } else {
                SharedApplicationData.singleton().setLineNumberLength(4);
            }
            if (this.m_headerTable.table().isEditing()) {
                this.m_headerTable.table().getCellEditor().stopCellEditing();
            }
            this.addExtraDictionaryHeaders();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void activatePage() {
        try {
            this.okayToGoToNextPage();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public boolean okayToGoToNextPage() {
        return true;
    }

    @Override
    public void dialogJustOpened() {
    }

    @Override
    public GenericObjectListener listener() {
        return null;
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        try {
            if (this.m_btn3.isSelected()) {
                SharedApplicationData.singleton().setLineNumberLength(3);
            } else {
                SharedApplicationData.singleton().setLineNumberLength(4);
            }
            if (this.m_shotDataTable != null && this.m_recDataTable != null) {
                this.reloadLineNumbers();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createScanWidget() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            LinearLayoutWidget top = main.createHorizontal(3, null, 0);
            this.m_scanButton = top.createButton("Begin scan (cannot interrupt!)", this, 0);
            top.addComponent(this.m_progress, 4);
            top.addComponent(this.m_scanLabel, 12);
            this.m_progress.setMaximum(1000);
            this.m_progress.setMinimum(0);
            JTabbedPane tabs = new JTabbedPane();
            tabs.addTab("Shot table", new JScrollPane(this.m_shotTable));
            this.m_shotTable.setGridColor(Color.black);
            this.m_shotTable.setShowGrid(true);
            tabs.addTab("Receiver table", new JScrollPane(this.m_recTable));
            this.m_recTable.setGridColor(Color.black);
            this.m_recTable.setShowGrid(true);
            tabs.addTab("Shot conflicts table", new JScrollPane(this.m_shotConflictTable));
            this.m_shotConflictTable.setGridColor(Color.black);
            this.m_shotConflictTable.setShowGrid(true);
            tabs.addTab("Receiver conflicts table", new JScrollPane(this.m_recConflictTable));
            this.m_recConflictTable.setGridColor(Color.black);
            this.m_recConflictTable.setShowGrid(true);
            this.m_widget = new Java2D_SimpleComposite(false);
            this.m_widget.setScrollVisible(true, true);
            tabs.addTab("Basemap", this.m_widget);
            tabs.addTab("Header mapping", new JScrollPane(this.m_headerTable));
            this.m_headerTable.table().setGridColor(Color.black);
            this.m_headerTable.table().setShowGrid(true);
            main.addComponent(tabs, 10);
            return main;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected void scan() {
        try {
            this.m_shotTable.setModel(new DefaultTableModel());
            this.m_recTable.setModel(new DefaultTableModel());
            this.m_shotConflictTable.setModel(new DefaultTableModel());
            this.m_recConflictTable.setModel(new DefaultTableModel());
            this.m_headerTable.table().setModel(new DefaultTableModel());
            this.m_progress.setValue(0);
            this.m_shotDataTable = new Table_Memory();
            this.m_shotDataTable.setName("Shot");
            this.m_shotParser = new TableParser(this.m_shotDataTable);
            this.m_recDataTable = new Table_Memory();
            this.m_recDataTable.setName("Receiver");
            this.m_recParser = new TableParser(this.m_recDataTable);
            ArrayList<String> fileList = new ArrayList<String>();
            this.m_totalTraces = 0L;
            this.m_numRead = 0L;
            this.m_scanLabel.setForeground(Color.red);
            for (String name : this.m_data.Files) {
                if (!PluginManager.singleton().currentPlugin().quickCheckFile(name)) continue;
                fileList.add(name);
            }
            long totalConflicts = 0L;
            for (String name : fileList) {
                totalConflicts = this.m_recParser.totalConflicts() + this.m_shotParser.totalConflicts();
                if (totalConflicts >= 100000L) continue;
                this.importFile(name);
            }
            this.m_progress.setValue(0);
            totalConflicts = this.m_shotParser.totalConflicts() + this.m_recParser.totalConflicts();
            if (totalConflicts < 1L) {
                this.m_scanLabel.setForeground(Color.blue);
                this.m_scanLabel.setText(String.format("%d shots, %d receivers, %d traces", this.m_shotDataTable.row_count(), this.m_recDataTable.row_count(), (int)this.m_numRead));
            } else {
                this.m_scanLabel.setForeground(Color.red);
                this.m_scanLabel.setText("Import conflicts found");
            }
            Table_Memory headerTable = PluginManager.singleton().currentPlugin().getHeaderTable();
            this.m_shotTable.setModel(new Table_SimpleModel(this.m_shotDataTable));
            this.m_recTable.setModel(new Table_SimpleModel(this.m_recDataTable));
            this.m_shotConflictTable.setModel(new Table_SimpleModel(this.m_shotParser.createSimpleTable()));
            this.m_recConflictTable.setModel(new Table_SimpleModel(this.m_recParser.createSimpleTable()));
            JComboBox<String> tableBox = new JComboBox<String>();
            tableBox.addItem("Shot");
            tableBox.addItem("Receiver");
            tableBox.addItem("Trace");
            Table_CustomModel model = new Table_CustomModel(headerTable);
            this.m_headerTable.table().setModel(model);
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("Shot");
            tableList.add("Receiver");
            tableList.add("Trace");
            Table_CustomModel.ComboCellEditor editor = model.getComboCellEditor(tableList);
            Table_CustomModel.ComboCellRenderer renderer = model.getComboCellRenderer();
            this.m_headerTable.table().getColumnModel().getColumn(1).setCellEditor(editor);
            this.m_headerTable.table().getColumnModel().getColumn(1).setCellRenderer(renderer);
            model.setColumnEditable(1, true);
            model.setColumnEditable(2, true);
            for (int r = 0; r < model.getRowCount(); ++r) {
                String field = (String)model.getValueAt(r, 2);
                if (field.length() <= 1) continue;
                model.setRowEditable(r, false);
            }
            model.setColumnEditable(0, false);
            this.m_headerTable.setMininimumColumnWidth(0, 300);
            this.m_headerTable.setMininimumColumnWidth(1, 300);
            this.m_headerTable.setMininimumColumnWidth(2, 300);
            PluginManager.singleton().currentPlugin().resetTrackers();
            this.loadPlot();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void importFile(String name) {
        try {
            PluginManager.singleton().currentPlugin().openDataset(name);
            if (!PluginManager.singleton().currentPlugin().populateDictionary(this.m_data.IsMarine)) {
                PluginManager.singleton().currentPlugin().closeDataset(name);
                return;
            }
            Ensemble ensemble = new Ensemble(PluginManager.singleton().currentPlugin().getDictionary().createExactCopy());
            long totalConflicts = this.m_recParser.totalConflicts() + this.m_shotParser.totalConflicts();
            while (this.m_numRead < 10000L && totalConflicts < 100000L) {
                long tracesRead = PluginManager.singleton().currentPlugin().readEnsemble(ensemble);
                Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FileID", 0, 1, 0);
                Tools_Ensemble.setHeaderLong(ensemble, "Trace", "IndexInFile", 0, 1L, 1L);
                this.m_shotParser.handleEnsemble(ensemble);
                this.m_recParser.handleEnsemble(ensemble);
                totalConflicts = this.m_recParser.totalConflicts() + this.m_shotParser.totalConflicts();
                this.m_numRead += tracesRead;
                double progress = 1000.0 * (double)this.m_numRead / (double)this.m_totalTraces;
                this.m_progress.setValue((int)progress);
                this.m_progress.paintImmediately(0, 0, 1000, 40);
            }
            PluginManager.singleton().currentPlugin().closeDataset(name);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadPlot() {
        try {
            this.m_widget.mainWidget().clearPaintableList();
            this.m_widget.setColorTitle("Elevation");
            Java2D_Paintable_Table recPainter = new Java2D_Paintable_Table();
            recPainter.setTable(this.m_recDataTable);
            recPainter.setAxisC("Elevation");
            recPainter.UseColorScale = true;
            recPainter.Size_Pixel = 3;
            recPainter.Symbol = Java2D_PointSymbol.Plus;
            recPainter.setAxisX("Easting");
            recPainter.setAxisY("Northing");
            this.m_widget.mainWidget().addPaintable(recPainter, -9999);
            Java2D_Paintable_Table shotPainter = new Java2D_Paintable_Table();
            shotPainter.setTable(this.m_shotDataTable);
            shotPainter.setAxisC("Elevation");
            shotPainter.UseColorScale = true;
            shotPainter.Size_Pixel = 3;
            shotPainter.Symbol = Java2D_PointSymbol.X;
            shotPainter.setAxisX("Easting");
            shotPainter.setAxisY("Northing");
            this.m_widget.mainWidget().addPaintable(shotPainter, -9999);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        try {
            this.m_widget.mainWidget().transform().setTechnique(Java2D_Transform.Technique.Basemap);
            this.m_widget.mainWidget().mooz();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void reloadLineNumbers() {
        try {
            int lineNumberLength = SharedApplicationData.singleton().lineNumberLength();
            if (PluginManager.singleton().currentPlugin().getIndexShotLine() >= 0) {
                int indexShotPoint = this.m_shotDataTable.column_indexOfColumn("PointNumber");
                int indexShotLine = this.m_shotDataTable.column_indexOfColumn("LineNumber");
                for (int shot = 0; shot < this.m_shotDataTable.row_count(); ++shot) {
                    int shotPoint = this.m_shotDataTable.getInt(shot, indexShotPoint);
                    String shotPointString = Integer.toString(shotPoint);
                    String shotLineString = shotPointString.substring(0, lineNumberLength);
                    int shotLine = Integer.parseInt(shotLineString);
                    this.m_shotDataTable.putInt(shot, indexShotLine, shotLine);
                }
            }
            if (PluginManager.singleton().currentPlugin().getIndexReceiverLine() >= 0) {
                int indexReceiverPoint = this.m_recDataTable.column_indexOfColumn("PointNumber");
                int indexReceiverLine = this.m_recDataTable.column_indexOfColumn("LineNumber");
                for (int rec = 0; rec < this.m_recDataTable.row_count(); ++rec) {
                    int receiverPoint = this.m_recDataTable.getInt(rec, indexReceiverPoint);
                    String receiverPointString = Integer.toString(receiverPoint);
                    String receiverLineString = receiverPointString.substring(0, lineNumberLength);
                    int receiverLine = Integer.parseInt(receiverLineString);
                    this.m_recDataTable.putInt(rec, indexReceiverLine, receiverLine);
                }
            }
            this.m_shotTable.setModel(new Table_SimpleModel(this.m_shotDataTable));
            this.m_recTable.setModel(new Table_SimpleModel(this.m_recDataTable));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addExtraDictionaryHeaders() {
        try {
            TableModel tm = this.m_headerTable.table().getModel();
            if (tm instanceof Table_CustomModel) {
                Table_CustomModel model = (Table_CustomModel)tm;
                Table_Abstract table = model.getTable();
                for (int r = 0; r < table.row_count(); ++r) {
                    String tableName = table.getString(r, 1);
                    if (!tableName.equalsIgnoreCase("Shot") && !tableName.equalsIgnoreCase("Receiver") && !tableName.equalsIgnoreCase("Trace")) continue;
                    String columnName = table.getString(r, 2);
                    String externalName = table.getString(r, 0);
                    if (columnName.length() <= 1 || PluginManager.singleton().currentPlugin().getDictionary().containsEntry(tableName, columnName)) continue;
                    PluginManager.singleton().currentPlugin().addAdditionalHeader(tableName, externalName, columnName);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void focusLost(FocusEvent e) {
        try {
            if (e.getSource() != this.m_headerTable) return;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void focusGained(FocusEvent fe) {
    }
}

