/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Import;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.Action_Sequence;
import com.PecosLibrary.Data.Table_SimpleModel;
import com.PecosLibrary.Windows.Shared.DimensionSelectionWidget;
import com.PecosLibrary.Windows.Shared.FileWidget;
import com.PecosLibrary.Windows.Shared.UnitsSelectionWidget;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MultipleProjectImportDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener,
ListSelectionListener {
    public boolean OK = false;
    protected JLabel m_lbl = new JLabel("", 0);
    protected JButton m_btnOK = new JButton("Launch import");
    protected JButton m_btnCancel = new JButton("Cancel");
    protected JCheckBox m_chkRemoveSpecial = new JCheckBox("Remove special characters from project names");
    protected FileWidget m_dictFileWidget;
    protected JButton m_btnAddSegyFiles;
    protected JButton m_btnClearAllSegyFiles;
    protected JButton m_btnClearSelectedSegyFiles;
    protected Table_Abstract m_table = new Table_Memory();
    protected Table_SimpleModel m_model;
    protected int m_colIndexFile;
    protected int m_colIndexName;
    protected int m_colIndexOkay;
    protected int m_colIndexCount;
    protected JTable m_tbl = new JTable();
    protected JCheckBox m_chkCreateCompressedData = new JCheckBox("Create compressed seismic file");
    protected JTextField m_txtMaxTime = new JTextField("2000");
    protected DimensionSelectionWidget m_dimWidget = new DimensionSelectionWidget(3, "Project dimension");
    protected UnitsSelectionWidget m_unitsWidget = new UnitsSelectionWidget(3);
    protected Action_Sequence m_sequence = null;
    protected ArrayList<String> m_fileList = new ArrayList();

    public boolean compressed() {
        return this.m_chkCreateCompressedData.isSelected();
    }

    public int compressionLength() {
        return Tools_Widget.extractInteger(this.m_txtMaxTime, 1000, 100, 10000);
    }

    public DimensionSelectionWidget dimWidget() {
        return this.m_dimWidget;
    }

    public UnitsSelectionWidget unitsWidget() {
        return this.m_unitsWidget;
    }

    public String dictFileName() {
        return this.m_dictFileWidget.getText();
    }

    public Table_Abstract table() {
        return this.m_table;
    }

    public MultipleProjectImportDialog() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget middle = LinearLayoutWidget.vert(3, null);
            LinearLayoutWidget buttWidget = middle.createHorizontal(3, null, 0);
            this.m_btnAddSegyFiles = buttWidget.createButton("Add SEGY files", this, 0);
            this.m_btnClearAllSegyFiles = buttWidget.createButton("Remove all files", this, 0);
            this.m_btnClearSelectedSegyFiles = buttWidget.createButton("Remove selected", this, 0);
            buttWidget.addStretch(10);
            buttWidget.addComponent(this.m_chkRemoveSpecial, 0);
            this.m_chkRemoveSpecial.addActionListener(this);
            this.m_colIndexFile = this.m_table.column_append("File name", DataType.Text);
            this.m_colIndexName = this.m_table.column_append("Project name", DataType.Text);
            this.m_colIndexCount = this.m_table.column_append("Trace count", DataType.Int);
            this.m_colIndexOkay = this.m_table.column_append("Status", DataType.Text);
            this.m_model = new Table_SimpleModel(this.m_table);
            this.m_tbl.setModel(this.m_model);
            middle.addComponent(new JScrollPane(this.m_tbl), 10);
            this.m_dictFileWidget = new FileWidget(false, false, 3, "SEGY dictionary", this);
            middle.addComponent(this.m_dictFileWidget, 0);
            LinearLayoutWidget opt = middle.createHorizontal(3, null, 0);
            opt.addComponent(this.m_dimWidget, 10);
            opt.addComponent(this.m_unitsWidget, 10);
            middle.addComponent(this.createCompressed(), 0);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            bottom.addComponent(this.m_lbl, 100);
            this.getContentPane().add((Component)middle, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.setSize(850, 600);
            this.setTitle("Create multiple refraction projects");
            this.dataOK();
            this.setLocationRelativeTo(null);
            this.reloadProjects();
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected JComponent createCompressed() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(3, "Compressed option");
            main.addComponent(new JLabel("Note - compression ratio is approximately a factor of 3"), 0);
            main.addComponent(this.m_chkCreateCompressedData, 0);
            main.addHorzPair(new JLabel("Maximum output time"), 0, this.m_txtMaxTime, 10);
            this.m_txtMaxTime.setEnabled(true);
            this.m_chkCreateCompressedData.addActionListener(this);
            return main;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected void reloadProjects() {
        try {
            for (int n = 0; n < this.m_table.row_count(); ++n) {
                String fileName = this.m_table.getString(n, this.m_colIndexFile);
                File f = new File(fileName);
                String name = f.getName();
                ArrayList<String> tokens = Tools_Strings.tokenizer(name, ".", false);
                this.m_table.putString(n, this.m_colIndexName, tokens.get(0));
            }
            this.dataOK();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            this.dataOK();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void dataOK() {
        try {
            this.m_btnOK.setEnabled(false);
            this.m_lbl.setText(" ");
            this.m_lbl.setForeground(Color.red);
            if (this.m_table.row_count() < 1) {
                this.m_lbl.setText("Must select at least one SEGY file");
                return;
            }
            String projectPath = SharedApplicationData.staticsProjectPath();
            boolean exists = false;
            for (int n = 0; n < this.m_table.row_count(); ++n) {
                String name = this.m_table.getString(n, this.m_colIndexName);
                String path = projectPath + "/" + name;
                if (Tools_FileSystem.exists_path(path)) {
                    exists = true;
                    this.m_lbl.setText("Project already exists");
                    this.m_table.putString(n, this.m_colIndexOkay, "Project already exists");
                    continue;
                }
                this.m_table.putString(n, this.m_colIndexOkay, " ");
            }
            this.m_model.fireTableStructureChanged();
            if (exists) {
                return;
            }
            String dict = this.m_dictFileWidget.getText();
            if (dict.isEmpty()) {
                this.m_lbl.setText("Must select a SEGY dictionay file");
                return;
            }
            this.m_btnOK.setEnabled(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.dataOK();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Action_Sequence sequence() {
        return this.m_sequence;
    }

    public String projectName() {
        try {
            return "";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "ERROR";
        }
    }

    protected void addFiles() {
        try {
            ArrayList<String> newFiles = Tools_Chooser.getFileNames(null);
            for (String fileName : newFiles) {
                boolean exists = false;
                for (int n = 0; n < this.m_table.row_count(); ++n) {
                    String currFileName = this.m_table.getString(n, this.m_colIndexFile);
                    exists = exists || currFileName.equals(fileName);
                }
                if (exists) continue;
                this.m_fileList.add(fileName);
            }
            this.reloadSegyFileTable();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadSegyFileTable() {
        try {
            this.m_table.row_clear(true);
            for (String fileName : this.m_fileList) {
                Segy segy = new Segy();
                segy.setFileName(fileName);
                if (!segy.isFileOK()) continue;
                int row = this.m_table.row_increment();
                File f = new File(fileName);
                String name = f.getName();
                name = Tools_Strings.removeFileSuffix(name);
                if (this.m_chkRemoveSpecial.isSelected()) {
                    name = Tools_Strings.removeCrap(name, false);
                }
                this.m_table.putString(row, this.m_colIndexName, name);
                this.m_table.putString(row, this.m_colIndexFile, fileName);
                this.m_table.putInt(row, this.m_colIndexCount, (int)segy.traceCount());
            }
            this.m_model.fireTableStructureChanged();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_chkRemoveSpecial) {
                this.reloadSegyFileTable();
                this.dataOK();
                return;
            }
            if (e.getSource() == this.m_btnAddSegyFiles) {
                this.addFiles();
                this.dataOK();
                return;
            }
            if (e.getSource() == this.m_btnClearAllSegyFiles) {
                this.m_fileList.clear();
                this.m_table.row_clear(true);
                this.reloadSegyFileTable();
                this.m_model.fireTableStructureChanged();
                this.dataOK();
                return;
            }
            if (e.getSource() == this.m_btnClearSelectedSegyFiles) {
                int[] sel = this.m_tbl.getSelectedRows();
                if (sel == null) {
                    return;
                }
                for (int n = sel.length - 1; n >= 0; --n) {
                    this.m_fileList.remove(sel[n]);
                }
                this.reloadSegyFileTable();
                this.dataOK();
                return;
            }
            if (e.getSource() == this.m_btnOK) {
                this.OK = true;
                this.dispose();
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

