/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Import;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.Import.Action_ImportBinaryPickFiles;
import com.PecosLibrary.Windows.Refraction.ProjectNameSelectionWidget;
import com.PecosLibrary.Windows.Shared.DimensionSelectionWidget;
import com.PecosLibrary.Windows.Shared.FileWidget;
import com.PecosLibrary.Windows.Shared.UnitsSelectionWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ImportBinaryPickFilesDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener {
    protected JButton m_btnOK = new JButton("Launch import");
    protected JButton m_btnCancel = new JButton("Cancel");
    protected ProjectNameSelectionWidget m_nameWidget = new ProjectNameSelectionWidget(3, ProjectNameSelectionWidget.ProjectType.Statics);
    protected FileWidget m_pathWidget = new FileWidget(true, false, 2, "Binary pick file path", this);
    protected JTextField m_txtDec = new JTextField("1");
    protected DimensionSelectionWidget m_dimWidget = new DimensionSelectionWidget(3, "Project dimension");
    protected UnitsSelectionWidget m_unitsWidget = new UnitsSelectionWidget(3);
    public Action_ImportBinaryPickFiles ActionImport = null;

    public ImportBinaryPickFilesDialog() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget middle = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            middle.addComponent(this.m_nameWidget, 0);
            LinearLayoutWidget stuff = middle.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null, 0);
            stuff.addComponent(this.m_dimWidget, 10);
            stuff.addComponent(this.m_unitsWidget, 10);
            middle.addComponent(this.m_pathWidget, 0);
            middle.addHorzPair(new JLabel("Input trace decimation"), 0, this.m_txtDec, 10);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            bottom.addStretch(10);
            this.getContentPane().add((Component)middle, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.setSize(650, 400);
            this.setTitle("Create a refraction project using GLI files");
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
            this.dataOK();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void showDialog() {
        try {
            this.setVisible(true);
            this.requestFocus();
            this.dataOK();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean dataOK() {
        try {
            if (!this.m_nameWidget.checkName()) {
                return false;
            }
            String path = this.m_pathWidget.getText();
            return Tools_FileSystem.exists_path(path);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    public String projectName() {
        return this.m_nameWidget.name();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnOK) {
                if (!this.dataOK()) {
                    return;
                }
                this.ActionImport = new Action_ImportBinaryPickFiles();
                String parentPath = SharedApplicationData.staticsProjectPath();
                this.ActionImport.Hasher.string_put("Decimation", this.m_txtDec.getText());
                this.ActionImport.Hasher.string_put("ParentPath", parentPath);
                this.ActionImport.Hasher.string_put("ProjectName", this.m_nameWidget.name());
                this.ActionImport.Hasher.string_put("Dimension", this.m_dimWidget.dimension());
                this.ActionImport.Hasher.string_put("Units", this.m_unitsWidget.units());
                this.ActionImport.Hasher.string_put("Directory", this.m_pathWidget.getText());
                this.dispose();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.ActionImport = null;
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

