/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.FWI;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.FWI.FwiModel;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3D;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3DProfile;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_VerticalStackWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_Line;
import com.PecosLibrary.Windows.Refraction.Tomography.TomoLayerNewModelDialog;
import com.PecosLibrary.Windows.Shared.PopupMenuButton;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class Fwi3DWidget
extends JSplitPane
implements ActionListener,
GenericObjectListener.Listener,
ItemListener,
Messenger.Listener,
PopupMenuButton.Listener,
ISaveableFrame {
    protected MapWidget m_smallMapWidget = new MapWidget(true);
    protected MapWidget m_bigMapWidget = new MapWidget(false);
    protected Java2D_VerticalStackWidget m_profileDisplayWidget;
    protected Java2D_UserEventConsumer_Line m_profileLineUEC = new Java2D_UserEventConsumer_Line();
    protected JButton m_btnCreateNew;
    protected ComboStringListWrapper m_modelCombo = new ComboStringListWrapper();
    protected boolean m_ignoreModelCombo = true;
    protected JLabel m_lblSizeX = new JLabel("", 4);
    protected JLabel m_lblSizeZ = new JLabel("", 4);
    protected JLabel m_lblNumInline = new JLabel("", 4);
    protected JLabel m_lblNumCrossline = new JLabel("", 4);
    protected JLabel m_lblNumZ = new JLabel("", 4);
    protected JLabel m_lblMemory = new JLabel("", 4);
    protected JTextField m_txtMinOffset = new JTextField("200");
    protected JTextField m_txtMaxOffset = new JTextField("6000");
    protected JTextField m_txtNumIter = new JTextField("10");
    protected JTextField m_txtOffsetCorner = new JTextField("75");
    protected JButton m_btnUpdate;
    protected JTextField m_txtNumThreads = new JTextField("2");
    protected JButton m_btnUpdateThreads;
    protected ComboStringListWrapper m_pickVersionCombo;
    protected JTextField m_txtAzimuthCenter = new JTextField("45");
    protected JTextField m_txtAzimuthRadius = new JTextField("45");
    protected JCheckBox m_chkApplyAzimuth = new JCheckBox("Apply azimuth restrictions");
    protected DefaultListModel<String> m_historyListModel = new DefaultListModel();
    protected JList<String> m_historyList = new JList();
    protected JButton m_btnReloadHistory;
    protected JTextField m_txtWeatheringVelocityDepth = new JTextField("100");
    protected JButton m_btnSetWeatheringVelocity;
    protected JCheckBox m_chkComputeRefractorElevation = new JCheckBox("Use the new weathering velocity to update the first refractor elevation");
    protected JButton m_btnStatics;
    protected ButtonGroup m_intGroup = new ButtonGroup();
    protected JRadioButton m_radIntElev = new JRadioButton("Fixed elevation");
    protected JRadioButton m_radIntDepth = new JRadioButton("Fixed depth");
    protected JLabel m_lblStaticsResult = new JLabel(" ");
    protected JTextField m_txtStaticsName = new JTextField("Tomo3D");
    protected JTextField m_txtIntDatumDepth = new JTextField("400");
    protected JTextField m_txtIntDatumElev = new JTextField("-200");
    protected JTextField m_txtFinalDatumElev = new JTextField("2000");
    protected JTextField m_txtRepVel = new JTextField("10000");
    protected JCheckBox m_chkZeroMean = new JCheckBox("Force statics to be zero mean");
    protected JCheckBox m_chkApplyResidual = new JCheckBox("Apply residual correction");
    protected JTextField m_txtResidCorrMult = new JTextField("1");
    protected JCheckBox m_chkStackPick = new JCheckBox("Apply stack pick correction");
    protected JTextField m_txtStackPickMult = new JTextField("0.5");
    protected TomoLayerNewModelDialog m_newDlg;
    protected String m_staticsColName;

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.Refraction.FWI.Fwi3DWidget";
    }

    @Override
    public String TAB_LABEL() {
        return "FWI3D";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "FWI3D";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return true;
    }

    public Fwi3DWidget() {
        super(1);
        try {
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.createRight());
            Messenger.singleton().addListener(this);
            this.reloadModelCombo();
            this.loadModel();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected ComboStringListWrapper createPickCombo() {
        try {
            ComboStringListWrapper combo = new ComboStringListWrapper("FBP_User");
            ITraceTable traceTable = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            ArrayList<String> pickCols = traceTable.columns("FBP_");
            combo.setStringArray(pickCols);
            combo.listener().addListener(this);
            return combo;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRight() {
        try {
            JTabbedPane topTabs = new JTabbedPane();
            topTabs.addTab("Map view", this.m_bigMapWidget);
            this.m_profileDisplayWidget = new Java2D_VerticalStackWidget(2);
            topTabs.addTab("Profile", this.m_profileDisplayWidget);
            return topTabs;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createLeft() {
        try {
            JTabbedPane topTabs = new JTabbedPane();
            topTabs.addTab("Model", this.createModelTab());
            topTabs.addTab("Update", this.createUpdateTab());
            topTabs.addTab("Statics", this.createStaticsTab());
            topTabs.addTab("Extra", this.createExtraTab());
            topTabs.addTab("History", this.createHistoryTab());
            return topTabs;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createHistoryTab() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            this.m_btnReloadHistory = main.createButton("Reload history", this, 0);
            main.addComponent(new JScrollPane(this.m_historyList), 10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void reloadHistory() {
        try {
            this.m_historyListModel.clear();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createStaticsTab() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            this.m_intGroup.add(this.m_radIntElev);
            this.m_intGroup.add(this.m_radIntDepth);
            this.m_radIntElev.setSelected(true);
            this.m_radIntElev.addActionListener(this);
            this.m_radIntDepth.addActionListener(this);
            GridLayoutWidget grid = main.createGridLayoutWidget(3, "Intermediate datum options", 0);
            int row = 0;
            grid.addSimple(row++, this.m_radIntElev, this.m_txtIntDatumElev);
            grid.addSimple(row++, this.m_radIntDepth, this.m_txtIntDatumDepth);
            this.m_txtIntDatumElev.setEnabled(this.m_radIntElev.isSelected());
            this.m_txtIntDatumDepth.setEnabled(this.m_radIntDepth.isSelected());
            grid = main.createGridLayoutWidget(0, "Final datum options", 0);
            row = 0;
            grid.addSimple(row++, new JLabel("Final datum"), this.m_txtFinalDatumElev);
            grid.addSimple(row++, new JLabel("Replacement velocity"), this.m_txtRepVel);
            String s = "<HTML><font color=\"blue\">Residual terms are computed during batch update </font></HTML>";
            LinearLayoutWidget res = main.createVertical(0, "Residual correction options", 0);
            res.addComponent(new JLabel(s, 0), 0);
            res.addComponent(this.m_chkApplyResidual, 0);
            this.m_chkApplyResidual.setSelected(true);
            res.addHorzPair(new JLabel("Residual multiplier"), 0, this.m_txtResidCorrMult, 10);
            s = "<HTML><font color=\"blue\">Stack picks are made in the tomo stacks display</font></HTML>";
            LinearLayoutWidget stackPickWidget = main.createVertical(0, "Residual correction options", 0);
            stackPickWidget.addComponent(new JLabel(s, 0), 0);
            stackPickWidget.addComponent(this.m_chkStackPick, 0);
            this.m_chkStackPick.setSelected(false);
            stackPickWidget.addHorzPair(new JLabel("Stack pick multiplier"), 0, this.m_txtStackPickMult, 10);
            main.addHorzPair(new JLabel("Statics name"), 0, this.m_txtStaticsName, 10);
            main.addComponent(this.m_chkZeroMean, 0);
            this.m_btnStatics = main.createButton("Compute statics", this, 0);
            main.addComponent(this.m_lblStaticsResult, 0);
            main.addStretch(10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createUpdateTab() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            this.m_btnUpdate = new JButton("Start batch update - single thread");
            this.m_btnUpdate.addActionListener(this);
            this.m_btnUpdateThreads = new JButton("Start batch update - multiple threads");
            this.m_btnUpdateThreads.addActionListener(this);
            this.m_pickVersionCombo = this.createPickCombo();
            GridLayoutWidget grid = main.createGridLayoutWidget(3, "Batch update options", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel(" "), this.m_chkApplyAzimuth);
            grid.addSimple(row++, new JLabel("Center azimuth"), this.m_txtAzimuthCenter);
            grid.addSimple(row++, new JLabel("Azimuth radius"), this.m_txtAzimuthRadius);
            grid = main.createGridLayoutWidget(3, "Batch update options", 0);
            row = 0;
            grid.addSimple(row++, new JLabel("Minimum offset"), this.m_txtMinOffset);
            grid.addSimple(row++, new JLabel("Maximum offset"), this.m_txtMaxOffset);
            grid.addSimple(row++, new JLabel("Number of iterations"), this.m_txtNumIter);
            grid.addSimple(row++, new JLabel("Offset weight corner"), this.m_txtOffsetCorner);
            grid.addSimple(row++, new JLabel("Pick version"), this.m_pickVersionCombo);
            grid.addSimple(row++, new JLabel(" "), this.m_btnUpdate);
            grid.addSimple(row++, new JLabel("Number of threads"), this.m_txtNumThreads);
            grid.addSimple(row++, new JLabel(" "), this.m_btnUpdateThreads);
            int np = Runtime.getRuntime().availableProcessors();
            if (np <= 2) {
                this.m_btnUpdateThreads.setEnabled(false);
                this.m_txtNumThreads.setEnabled(false);
                JLabel lbl = new JLabel("Must have more than two cores to run multithreaded");
                lbl.setForeground(Color.red);
                grid.addComponent(lbl, row++, 0, 1.0, 1.0, 1, 2);
            }
            main.addStretch(10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createExtraTab() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(3, null);
            LinearLayoutWidget sub = main.createVertical(0, "Weathering velocity for delay time model", 0);
            JLabel lbl = new JLabel("You must assign branches first!", 0);
            lbl.setForeground(Color.red);
            sub.addComponent(lbl, 0);
            sub.addHorzPair(new JLabel("Depth at which to compute weathering velocity"), 0, this.m_txtWeatheringVelocityDepth, 10);
            sub.addComponent(this.m_chkComputeRefractorElevation, 0);
            this.m_chkComputeRefractorElevation.setSelected(true);
            this.m_btnSetWeatheringVelocity = sub.createButton("Set weathering velocity", this, 0);
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            main.addStretch(10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createModelTab() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            LinearLayoutWidget sub = main.createHorizontal(0, "Select model", 0);
            sub.addComponent(this.m_modelCombo, 10);
            this.m_modelCombo.listener().addListener(this);
            this.m_btnCreateNew = sub.createButton("New model", this, 0);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Model description", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Horizontal node spacing"), this.m_lblSizeX);
            grid.addSimple(row++, new JLabel("Vertical node spacing"), this.m_lblSizeZ);
            grid.addSimple(row++, new JLabel("Inline node count"), this.m_lblNumInline);
            grid.addSimple(row++, new JLabel("Crossline node count"), this.m_lblNumCrossline);
            grid.addSimple(row++, new JLabel("Vertical node count"), this.m_lblNumZ);
            grid.addSimple(row++, new JLabel("Total model memory (MB)"), this.m_lblMemory);
            JLabel lbl = new JLabel("Left-click and drag to display profiles", 0);
            lbl.setForeground(Color.blue);
            lbl.setBorder(BorderFactory.createRaisedBevelBorder());
            main.addComponent(lbl, 0);
            main.addComponent(this.m_smallMapWidget, 11);
            this.m_smallMapWidget.CompositeWidget.mainWidget().addZoomer();
            this.m_smallMapWidget.CompositeWidget.mainWidget().addEventConsumer(this.m_profileLineUEC);
            this.m_profileLineUEC.addListener(this);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void reloadModelCombo() {
        try {
            this.m_ignoreModelCombo = true;
            String fwiPath = RefractionStaticsProject.singleton().fwi3DProjectsPath();
            ArrayList<String> subdirs = Tools_FileSystem.subdirectories(fwiPath, false);
            ArrayList<String> models = new ArrayList<String>();
            for (String s : subdirs) {
                if (s.equalsIgnoreCase("ShotRecStacks")) continue;
                models.add(s);
            }
            this.m_modelCombo.setStringArray(models);
            this.m_ignoreModelCombo = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void handleNewModel() {
        try {
            FwiModel model = RefractionStaticsProject.singleton().getFwi3D();
            this.m_smallMapWidget.handleNewModel();
            this.m_bigMapWidget.handleNewModel();
            this.reloadHistory();
            if (model == null) {
                this.m_lblSizeX.setText("");
                this.m_lblSizeZ.setText("");
                this.m_lblNumInline.setText("");
                this.m_lblNumCrossline.setText("");
                this.m_lblNumZ.setText("");
                this.m_lblMemory.setText("");
                return;
            }
            this.m_lblSizeX.setText(Double.toString(model.binSizeHorz()));
            this.m_lblSizeZ.setText(Double.toString(model.binSizeVert()));
            this.m_lblNumInline.setText(Integer.toString(model.numX()));
            this.m_lblNumCrossline.setText(Integer.toString(model.numY()));
            this.m_lblNumZ.setText(Integer.toString(model.numZ()));
            double numNodes = (double)model.numX() * (double)model.numY() * (double)model.numZ();
            double mem = 8.0 * numNodes;
            int mb = 1 + (int)(mem *= 1.0E-6);
            this.m_lblMemory.setText(Integer.toString(mb));
            this.m_smallMapWidget.reloadPlot();
            this.m_bigMapWidget.reloadPlot();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadModel() {
        try {
            String name = this.m_modelCombo.getSelectedString();
            if (name == null) {
                return;
            }
            if (name.length() < 1) {
                return;
            }
            FwiModel model = new FwiModel(name);
            RefractionStaticsProject.singleton().setFwi3D(model);
            this.handleNewModel();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void createNewModel() {
        try {
            if (this.m_newDlg == null) {
                this.m_newDlg = new TomoLayerNewModelDialog(TomoLayerNewModelDialog.ModelType.FWI3D, TomoLayerNewModelDialog.InitialVelocitySource.Linear);
            }
            this.m_newDlg.showDialog();
            if (this.m_newDlg.OK) {
                this.reloadModelCombo();
                FwiModel model = RefractionStaticsProject.singleton().getFwi3D();
                if (model != null) {
                    this.m_ignoreModelCombo = true;
                    this.m_modelCombo.setPreferredSelected(model.name());
                    this.m_ignoreModelCombo = false;
                }
                this.handleNewModel();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void computeV0() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            FwiModel model = p.getFwi3D();
            if (model == null) {
                JOptionPane.showMessageDialog(null, "FWI model not valid", "Cannot compute V0", 0);
                return;
            }
            int maxBranch = RefractionStaticsProject.delayTimeData().branchAssignment().maxBranch();
            if (maxBranch < 1) {
                JOptionPane.showMessageDialog(null, "Must assign branches first", "Cannot compute V0", 0);
                return;
            }
            double depth = Tools_Widget.extractDouble(this.m_txtWeatheringVelocityDepth, 100.0, 1.0, 1000.0);
            boolean updateZ = this.m_chkComputeRefractorElevation.isSelected();
            model.computeWeatheringVelocity((float)depth, updateZ);
            this.reloadHistory();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void computeStatics() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            FwiModel model = p.getFwi3D();
            if (model == null) {
                return;
            }
            this.computeStatics(model.SourceHash, p.shotTable(), "ShotID", false);
            this.computeStatics(model.ReceiverHash, p.receiverTable(), "ReceiverID", true);
            if (this.m_chkZeroMean.isSelected()) {
                Tools_RefractionStaticsProject.convertToZeroMean(this.m_staticsColName);
            }
            this.reloadHistory();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void computeStatics(HashMap_Integers<FwiModel.Element> hash, Table_Abstract table, String idname, boolean updateHistory) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            FwiModel model = p.getFwi3D();
            if (model == null) {
                return;
            }
            this.m_staticsColName = this.m_txtStaticsName.getText();
            this.m_staticsColName = Tools_Strings.removeCrap(this.m_staticsColName, true);
            if (this.m_staticsColName.length() < 2) {
                return;
            }
            this.m_staticsColName = "STATICS_" + this.m_staticsColName;
            boolean includeStackPick = this.m_chkStackPick.isSelected();
            double stackPickScalar = Tools_Widget.extractDouble(this.m_txtStackPickMult, 1.0, -10.0, 10.0);
            double residualScalar = Tools_Widget.extractDouble(this.m_txtResidCorrMult, 1.0, -10.0, 10.0);
            boolean includeResidual = this.m_chkApplyResidual.isSelected();
            boolean flatInt = this.m_radIntElev.isSelected();
            double fixedElev = Tools_Widget.extractDouble(this.m_txtIntDatumElev, 0.0, -30000.0, 30000.0);
            double depth = 100.0;
            if (!flatInt) {
                depth = Tools_Widget.extractDouble(this.m_txtIntDatumDepth, 100.0, 1.0, 30000.0);
            }
            double finalDatum = Tools_Widget.extractDouble(this.m_txtFinalDatumElev, 0.0, -30000.0, 30000.0);
            double repVel = Tools_Widget.extractDouble(this.m_txtRepVel, 1000.0, 100.0, 30000.0);
            int indexStatics = table.column_append(this.m_staticsColName, DataType.Double);
            int indexID = table.column_indexOfColumn(idname);
            int indexStackPick = table.column_indexOfColumn("Tomo3D_StackPickTime");
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexZ = table.column_indexOfColumn("Elevation");
            int indexD = -9999;
            if (table.column_exists("PointDepth")) {
                indexD = table.column_indexOfColumn("PointDepth");
            }
            for (int n = 0; n < table.row_count(); ++n) {
                double x = table.getDouble(n, indexX);
                double y = table.getDouble(n, indexY);
                double z = table.getDouble(n, indexZ);
                double d = 0.0;
                if (indexD >= 0) {
                    d = table.getDouble(n, indexD);
                }
                int id = table.getInt(n, indexID);
                double intDatum = fixedElev;
                if (!flatInt) {
                    intDatum = z - depth;
                }
                model.computeStatics(x, y, z - d, intDatum, finalDatum, repVel);
                double statics = model.Statics;
                if (includeStackPick) {
                    double shift = stackPickScalar * table.getDouble(n, indexStackPick);
                    statics += shift;
                }
                if (includeResidual && hash.containsKey(id)) {
                    FwiModel.Element e = hash.get(id);
                    statics += residualScalar * e.Residual;
                }
                table.putDouble(n, indexStatics, statics);
            }
            p.geometryDatabase().writeColumnContentsToDatabase(table, this.m_staticsColName);
            if (updateHistory) {
                try {
                    model.getHistory().addWithTime("Compute statics:");
                    model.getHistory().add("Column name = " + this.m_staticsColName);
                    if (includeResidual) {
                        model.getHistory().add("Residual term included, scalar = " + Double.toString(residualScalar));
                    }
                    if (this.m_chkZeroMean.isSelected()) {
                        model.getHistory().add("Converted to zero mean");
                    }
                    if (flatInt) {
                        model.getHistory().add("Flat intermediate datum, elevation = " + Double.toString(fixedElev));
                    } else {
                        model.getHistory().add("Intermediate datum at depth = " + Double.toString(depth));
                    }
                    model.getHistory().add("Final datum = " + Double.toString(finalDatum));
                    model.getHistory().add("Replacment velocity = " + Double.toString(repVel));
                    model.getHistory().save();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (e.getSource() == this.m_btnReloadHistory) {
                this.reloadHistory();
                return;
            }
            if (e.getSource() == this.m_btnSetWeatheringVelocity) {
                this.computeV0();
                return;
            }
            if (e.getSource() == this.m_btnStatics) {
                this.computeStatics();
                return;
            }
            if (e.getSource() == this.m_radIntDepth) {
                this.m_txtIntDatumElev.setEnabled(this.m_radIntElev.isSelected());
                this.m_txtIntDatumDepth.setEnabled(this.m_radIntDepth.isSelected());
                return;
            }
            if (e.getSource() == this.m_radIntElev) {
                this.m_txtIntDatumElev.setEnabled(this.m_radIntElev.isSelected());
                this.m_txtIntDatumDepth.setEnabled(this.m_radIntDepth.isSelected());
                return;
            }
            if (e.getSource() == this.m_btnCreateNew) {
                this.createNewModel();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handlePopupMenuButton(PopupMenuButton button, String text) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
    }

    protected void loadMapProfile() {
        try {
            this.m_profileDisplayWidget.clear();
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            TomoEikonal3D model = p.getEikonal3D();
            if (model == null) {
                return;
            }
            double x1 = this.m_profileLineUEC.StartWorldX;
            double y1 = this.m_profileLineUEC.StartWorldY;
            double x2 = this.m_profileLineUEC.EndWorldX;
            double y2 = this.m_profileLineUEC.EndWorldY;
            model.setWorldLocation(x1, y1, true, true);
            double z1 = model.InterpolatedElevation;
            model.setWorldLocation(x2, y2, true, true);
            double z2 = model.InterpolatedElevation;
            TomoEikonal3DProfile profile = model.createNewProfile();
            model.populateProfile(profile, x1, y1, x2, y2);
            profile.fireShot((float)z1);
            profile.accuratePath_SetReceiver((float)z2, 1000.0f);
            this.m_profileDisplayWidget.mainWidget(0).addPaintable(profile, 1000);
            this.m_profileDisplayWidget.mainWidget(1).addPaintable(profile, 1002);
            this.m_profileDisplayWidget.setColorLabel(0, "Velocity");
            this.m_profileDisplayWidget.setColorLabel(1, "Node sampling");
            this.m_profileDisplayWidget.setTransform(Java2D_Transform.Technique.Normal);
            this.m_profileDisplayWidget.unzoom();
            this.m_smallMapWidget.CompositeWidget.mainWidget().repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_profileLineUEC) {
                this.loadMapProfile();
            }
            if (sender == this.m_modelCombo) {
                if (this.m_ignoreModelCombo) {
                    return;
                }
                this.loadModel();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected class MapWidget
    extends LinearLayoutWidget
    implements ActionListener,
    ItemListener {
        public Java2D_SimpleComposite CompositeWidget;
        public JComboBox<String> ComboAttribute;
        public JComboBox<String> ComboElevation;
        public JTextField m_txtDepth;
        public JCheckBox m_chkShowShots;
        public JCheckBox m_chkShowReceivers;
        public JButton m_btnReload;
        public boolean m_ignoreCombo;

        public MapWidget(boolean tinyWidth) {
            super(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.ComboAttribute = new JComboBox();
            this.ComboElevation = new JComboBox();
            this.m_txtDepth = new JTextField("0");
            this.m_chkShowShots = new JCheckBox("Show shots");
            this.m_chkShowReceivers = new JCheckBox("Show receivers");
            this.m_ignoreCombo = false;
            try {
                LinearLayoutWidget top = this.createHorizontal(0, null, 0);
                top.addComponent(this.ComboAttribute, 0);
                top.addComponent(new JLabel("Elevation:"), 0);
                top.addComponent(this.ComboElevation, 2);
                top.addComponent(new JLabel("Depth:"), 0);
                top.addComponent(this.m_txtDepth, 2);
                this.ComboAttribute.addItem("Surface elevation");
                this.ComboAttribute.addItem("Velocity at fixed elevation");
                this.ComboAttribute.addItem("Statistical weight at elevation");
                this.ComboAttribute.addItem("Velocity at fixed depth");
                this.ComboAttribute.setSelectedIndex(0);
                this.ComboAttribute.addItemListener(this);
                this.ComboElevation.addItemListener(this);
                this.m_txtDepth.addActionListener(this);
                this.m_txtDepth.setEnabled(this.ComboAttribute.getSelectedIndex() == 3);
                this.ComboElevation.setEnabled(this.ComboAttribute.getSelectedIndex() == 1 || this.ComboAttribute.getSelectedIndex() == 2);
                LinearLayoutWidget bottom = this.createHorizontal(0, null, 0);
                bottom.addComponent(this.m_chkShowReceivers, 0);
                this.m_chkShowReceivers.addActionListener(this);
                bottom.addComponent(this.m_chkShowShots, 0);
                this.m_chkShowShots.addActionListener(this);
                this.m_btnReload = bottom.createButton("Reload plot", this, 0);
                bottom.addStretch(10);
                Tools_FontChanger.changeSizeOfFont(top, -2, null, true);
                Tools_FontChanger.changeSizeOfFont(bottom, -2, null, true);
                this.CompositeWidget = new Java2D_SimpleComposite(true);
                this.CompositeWidget.setAxesVisible(true, true);
                this.CompositeWidget.setScrollVisible(true, true);
                this.addComponent(this.CompositeWidget, 10);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void handleNewModel() {
            try {
                FwiModel model = RefractionStaticsProject.singleton().getFwi3D();
                this.ComboElevation.removeAllItems();
                if (model == null) {
                    return;
                }
                for (int z = 0; z < model.numZ(); ++z) {
                    double elev = model.originZ() + (double)z * model.binSizeVert();
                    this.ComboElevation.addItem(Double.toString(elev));
                }
                this.ComboElevation.setSelectedIndex(0);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void reloadPlot() {
            try {
                int index;
                FwiModel model = RefractionStaticsProject.singleton().getFwi3D();
                Java2D_Widget w = this.CompositeWidget.mainWidget();
                w.clearPaintableList();
                if (model == null) {
                    w.mooz();
                    return;
                }
                Grid3D grid = null;
                if (this.ComboAttribute.getSelectedIndex() == 0) {
                    grid = model.getSurfaceGrid3D();
                }
                if (this.ComboAttribute.getSelectedIndex() == 1) {
                    index = this.ComboElevation.getSelectedIndex();
                    grid = model.getVelocityAtElevationGrid3D(index);
                }
                if (this.ComboAttribute.getSelectedIndex() == 2) {
                    index = this.ComboElevation.getSelectedIndex();
                    grid = model.getWeightAtElevationGrid3D(index);
                }
                if (this.ComboAttribute.getSelectedIndex() == 3) {
                    float depth = (float)Tools_Widget.extractDouble(this.m_txtDepth, 0.0, 0.0, 100000.0);
                    grid = model.getVelocityAtDepthGrid3D(depth);
                }
                if (grid != null) {
                    grid.ArrayDirty = true;
                    w.addPaintable(grid, 0);
                }
                if (this.m_chkShowShots.isSelected()) {
                    try {
                        w.addPaintable(Tools_RefractionStaticsProject.loadGeomPO("Shot"), 0);
                    }
                    catch (Exception error) {
                        error.printStackTrace();
                    }
                }
                if (this.m_chkShowReceivers.isSelected()) {
                    try {
                        w.addPaintable(Tools_RefractionStaticsProject.loadGeomPO("Receiver"), 0);
                    }
                    catch (Exception error) {
                        error.printStackTrace();
                    }
                }
                w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
                w.mooz();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            try {
                if (this.m_ignoreCombo) {
                    return;
                }
                this.m_txtDepth.setEnabled(this.ComboAttribute.getSelectedIndex() == 3);
                this.ComboElevation.setEnabled(this.ComboAttribute.getSelectedIndex() == 1 || this.ComboAttribute.getSelectedIndex() == 2);
                if (e.getSource() == this.ComboAttribute) {
                    this.reloadPlot();
                }
                if (e.getSource() == this.ComboElevation) {
                    this.reloadPlot();
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.reloadPlot();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }
    }
}

