/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Data.TraceTable.ITraceTableScannerMonitor;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Shared.FileWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;

public class ExportTotalDialog
extends JDialog
implements ActionListener,
ItemListener,
ITraceTableScannerMonitor,
GenericObjectListener.Listener {
    protected JButton m_btnOK = new JButton("Export");
    protected JButton m_btnCancel = new JButton("Cancel");
    protected FileWidget m_fileWidget;
    protected JList m_shotColumnsList = new JList();
    protected JList m_recColumnsList = new JList();
    protected JList m_traceColumnsList = new JList();
    protected JProgressBar m_progress = new JProgressBar();
    public boolean OK = false;
    protected ArrayList<String> m_shotList;
    protected ArrayList<String> m_recList;
    protected ArrayList<String> m_traceList;

    public ExportTotalDialog() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget middle = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            this.m_fileWidget = new FileWidget(false, false, 0, "Output ASCII file (CSV format)", null);
            this.m_fileWidget.OpenFile = false;
            middle.addComponent(this.m_fileWidget, 0);
            GridLayoutWidget listgrid = middle.createGridLayoutWidget(3, null, 10);
            boolean col = false;
            listgrid.addComponent(new JLabel("Select shot columns"), 0, 0, 0.0, 5.0);
            listgrid.addComponent(new JScrollPane(this.m_shotColumnsList), 1, 0, 10.0, 5.0);
            listgrid.addComponent(new JLabel("Select receiver columns"), 0, 1, 0.0, 5.0);
            listgrid.addComponent(new JScrollPane(this.m_recColumnsList), 1, 1, 10.0, 5.0);
            listgrid.addComponent(new JLabel("Select trace columns"), 0, 2, 0.0, 5.0);
            listgrid.addComponent(new JScrollPane(this.m_traceColumnsList), 1, 2, 10.0, 5.0);
            this.m_progress.setMaximum(1000);
            middle.addComponent(this.m_progress, 0);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            bottom.addStretch(10);
            this.getContentPane().add((Component)middle, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.pack();
            this.setSize(this.getSize().width + 50, this.getSize().height + 400);
            this.setTitle("Export trace table contents to CSV file");
            this.setLocationRelativeTo(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void setPercentDone(double percent) {
        try {
            percent = Math.max(percent, 0.0);
            percent = Math.min(percent, 99.99);
            this.m_progress.setValue((int)(10.0 * percent));
            this.m_progress.paintImmediately(0, 0, 500, 30);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void setMessage(String message) {
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    protected void loadColumns() {
        try {
            ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            this.m_traceList = table.columns();
            this.m_traceColumnsList.setListData(this.m_traceList.toArray());
            this.m_shotList = this.database().listOfColumnNames("Shot");
            this.m_shotColumnsList.setListData(this.m_shotList.toArray());
            this.m_recList = this.database().listOfColumnNames("Receiver");
            this.m_recColumnsList.setListData(this.m_recList.toArray());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void showDialog() {
        try {
            this.OK = false;
            this.loadColumns();
            this.m_progress.setValue(0);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    public ArrayList<Entry> prepTraceEntries(ArrayList<String> columnNames, JList<String> colList, ITraceTable table) {
        try {
            ArrayList<Entry> list = new ArrayList<Entry>();
            int[] sel = colList.getSelectedIndices();
            if (sel == null) {
                return list;
            }
            for (int n = 0; n < sel.length; ++n) {
                Entry e = new Entry();
                e.ColumnName = columnNames.get(sel[n]);
                e.ColumnIndex = table.column_indexOfColumn(e.ColumnName);
                e.DT = table.column_type(e.ColumnIndex);
                list.add(e);
            }
            return list;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public ArrayList<Entry> prepEntries(ArrayList<String> columnNames, JList<String> colList, Table_Abstract table) {
        try {
            ArrayList<Entry> list = new ArrayList<Entry>();
            int[] sel = colList.getSelectedIndices();
            if (sel == null) {
                return list;
            }
            for (int n = 0; n < sel.length; ++n) {
                Entry e = new Entry();
                e.ColumnName = columnNames.get(sel[n]);
                e.ColumnIndex = table.column_indexOfColumn(e.ColumnName);
                e.DT = table.column_type(e.ColumnIndex);
                list.add(e);
            }
            return list;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected void work() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            ITraceTable table = p.traceTableWrapper().traceTable();
            int indexShotID = table.column_indexOfColumn("ShotID");
            int indexRecID = table.column_indexOfColumn("ReceiverID");
            Table_Abstract shotTable = p.shotTable();
            Table_Abstract recTable = p.receiverTable();
            HashMap_Integer shotHash = p.shotMap();
            HashMap_Integer recHash = p.receiverMap();
            ArrayList<Entry> shotOutput = this.prepEntries(this.m_shotList, this.m_shotColumnsList, shotTable);
            ArrayList<Entry> recOutput = this.prepEntries(this.m_recList, this.m_recColumnsList, recTable);
            ArrayList<Entry> traceOutput = this.prepTraceEntries(this.m_traceList, this.m_traceColumnsList, table);
            String fileName = this.m_fileWidget.getText();
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            boolean started = false;
            for (Entry e : shotOutput) {
                if (started) {
                    writer.write(", ");
                }
                writer.write("Shot_" + e.ColumnName);
                started = true;
            }
            for (Entry e : recOutput) {
                if (started) {
                    writer.write(", ");
                }
                writer.write("Rec_" + e.ColumnName);
                started = true;
            }
            for (Entry e : traceOutput) {
                if (started) {
                    writer.write(", ");
                }
                writer.write("Trace_" + e.ColumnName);
                started = true;
            }
            writer.newLine();
            int row = 0;
            while ((long)row < table.rowCount()) {
                int shotID = table.getInt(row, indexShotID);
                int shotRow = shotHash.get(shotID);
                int recID = table.getInt(row, indexRecID);
                int recRow = recHash.get(recID);
                started = false;
                for (Entry e : shotOutput) {
                    if (started) {
                        writer.write(", ");
                    }
                    writer.write(shotTable.getString(shotRow, e.ColumnIndex));
                    started = true;
                }
                for (Entry e : recOutput) {
                    if (started) {
                        writer.write(", ");
                    }
                    writer.write(recTable.getString(recRow, e.ColumnIndex));
                    started = true;
                }
                for (Entry e : traceOutput) {
                    if (started) {
                        writer.write(", ");
                    }
                    writer.write(table.getString(row, e.ColumnIndex));
                    started = true;
                }
                if (row % 10000 == 0) {
                    this.setPercentDone(100.0 * (double)row / (double)table.rowCount());
                }
                writer.newLine();
                ++row;
            }
            writer.close();
            this.OK = true;
            this.dispose();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnOK) {
                this.work();
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            this.setCursor(Cursor.getDefaultCursor());
            ExceptionMonitor.add(error);
        }
    }

    protected class Entry {
        public String ColumnName;
        public int ColumnIndex;
        public DataType DT;

        protected Entry() {
        }
    }
}

