/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime.Wizard;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.Table_SimpleModel;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeModel_StaticsInfo;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Windows.Wizard.ISimpleWizardPage;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

public class Page_Static_Final
extends LinearLayoutWidget
implements ItemListener,
ActionListener,
ISimpleWizardPage {
    protected DelayTimeModel_StaticsInfo m_staticsInfo;
    protected JComboBox<String> m_combo;
    protected JPanel m_mainPanel = new JPanel();
    protected CardLayout m_cardLayout = new CardLayout();
    protected JTextField m_repVelText;
    protected GridLayoutWidget m_databaseGrid;
    protected JComboBox<String> m_databaseCombo = new JComboBox();
    protected JButton m_databaseReloadButton = new JButton("Reload");
    protected LinearLayoutWidget m_fixedDepthWidget;
    protected JTextField m_fixedDepthText = new JTextField("200");
    protected JTextField m_fixedDepthSmoothRadiusText = new JTextField("0");
    protected LinearLayoutWidget m_fixedElevWidget;
    protected JTextField m_fixedElevText = new JTextField("1000");
    protected JTable m_tableElev = new JTable();
    protected JTable m_tableVel = new JTable();

    public Page_Static_Final(DelayTimeModel_StaticsInfo staticsInfo) {
        super(LinearLayoutWidget.Direction.Vertical, 0, null);
        try {
            this.m_staticsInfo = staticsInfo;
            this.addComponent(new JLabel("Surface and refractor elevations"), 0);
            this.m_tableElev.setShowGrid(true);
            this.m_tableElev.setGridColor(Color.LIGHT_GRAY);
            this.m_tableElev.setModel(new Table_SimpleModel(this.m_staticsInfo.ElevationTable));
            this.addComponent(new JScrollPane(this.m_tableElev), 11);
            this.addComponent(new JLabel("Layer velocities"), 0);
            this.m_tableVel.setShowGrid(true);
            this.m_tableVel.setGridColor(Color.LIGHT_GRAY);
            this.m_tableVel.setModel(new Table_SimpleModel(this.m_staticsInfo.VelocityTable));
            this.addComponent(new JScrollPane(this.m_tableVel), 11);
            this.m_mainPanel.setLayout(this.m_cardLayout);
            this.m_databaseGrid = new GridLayoutWidget(0, null);
            int row = 0;
            this.m_databaseGrid.addSimple(row++, new JLabel("Select column"), this.m_databaseCombo);
            this.m_databaseReloadButton.addActionListener(this);
            this.m_databaseGrid.addComponent(this.m_databaseReloadButton, row++, 1);
            this.m_databaseGrid.addComponent(new JLabel(""), row, 0, 5.0, 5.0);
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            ArrayList<String> cols = p.getVersionColumnNames(p.versionName(), true);
            for (String c : cols) {
                this.m_databaseCombo.addItem(c);
            }
            this.m_fixedDepthWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_fixedElevWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_fixedDepthText = this.m_fixedDepthWidget.createSubTextField("Fixed depth (ft/m)", "200", null);
            this.m_fixedDepthSmoothRadiusText = this.m_fixedDepthWidget.createSubTextField("Smooth radius ( Set < 1 for no smoothing)", "0", null);
            this.m_fixedDepthWidget.addStretch(10);
            this.m_fixedElevText = this.m_fixedElevWidget.createSubTextField("Fixed Elevation (ft/m)", "0", null);
            this.m_fixedElevWidget.addStretch(10);
            this.createGapLabel(14);
            this.m_combo = this.createSubComboBox("Datum specification:", this);
            for (DelayTimeModel_StaticsInfo.FinalDatumEnum ide : DelayTimeModel_StaticsInfo.FinalDatumEnum.values()) {
                this.m_combo.addItem(ide.Description);
            }
            this.m_combo.setSelectedIndex(0);
            this.m_mainPanel.add((Component)this.m_fixedElevWidget, DelayTimeModel_StaticsInfo.FinalDatumEnum.FixedElevation.Description);
            this.m_mainPanel.add((Component)this.m_fixedDepthWidget, DelayTimeModel_StaticsInfo.FinalDatumEnum.FixedDepth.Description);
            this.m_mainPanel.add((Component)this.m_databaseGrid, DelayTimeModel_StaticsInfo.FinalDatumEnum.DatabaseColumn.Description);
            this.addComponent(this.m_mainPanel, 10);
            this.m_repVelText = this.createSubTextField("Replacement velocity", "1000", null);
            this.createGapLabel(14);
            this.m_cardLayout.show(this.m_mainPanel, (String)this.m_combo.getSelectedItem());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void dialogJustOpened() {
        try {
            this.m_tableElev.setModel(new Table_SimpleModel(this.m_staticsInfo.ElevationTable));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_databaseReloadButton) {
                this.m_databaseCombo.removeAllItems();
                RefractionStaticsProject p = RefractionStaticsProject.singleton();
                ArrayList<String> cols = p.getVersionColumnNames(p.versionName(), true);
                for (String c : cols) {
                    this.m_databaseCombo.addItem(c);
                }
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void computeVel() {
        try {
            this.leavingPage();
            double d = Tools_RefractionStaticsProject.computeAverage(this.m_staticsInfo.ColumnName, -888.0, 888.0);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.m_cardLayout.show(this.m_mainPanel, (String)this.m_combo.getSelectedItem());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public GenericObjectListener listener() {
        return null;
    }

    @Override
    public boolean okayToGoToNextPage() {
        return true;
    }

    @Override
    public void leavingPage() {
        try {
            int index = this.m_combo.getSelectedIndex();
            this.m_staticsInfo.FinalDatum = DelayTimeModel_StaticsInfo.FinalDatumEnum.values()[index];
            this.m_staticsInfo.Final_DatabaseColumn = this.m_databaseCombo.getSelectedItem().toString();
            this.m_staticsInfo.Final_ReplacementVelocity = Tools_Widget.extractDouble(this.m_repVelText, 200.0, 10.0, 999999.0);
            this.m_staticsInfo.Final_FixedDepth = Tools_Widget.extractDouble(this.m_fixedDepthText, 200.0, -999999.0, 999999.0);
            this.m_staticsInfo.Final_FixedDepthSmoothRadius = Tools_Widget.extractDouble(this.m_fixedDepthSmoothRadiusText, 0.0, 0.0, 999999.0);
            this.m_staticsInfo.Final_FixedElevation = Tools_Widget.extractDouble(this.m_fixedElevText, 0.0, -999999.0, 999999.0);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void activatePage() {
        try {
            this.m_tableElev.setModel(new Table_SimpleModel(this.m_staticsInfo.ElevationTable));
            this.m_tableVel.setModel(new Table_SimpleModel(this.m_staticsInfo.VelocityTable));
            ArrayList<String> intersection = Tools_RefractionStaticsProject.getColumnList_Intersection("STATICS_");
            Collections.sort(intersection);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

