/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleFirstBreakPickPlotData;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Parameter.SliderWidget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeMath;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeModel;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeModel_ModInfo;
import com.PecosLibrary.Refraction.DelayTime.WeatherVelocityProfiler;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_StrangeEnsembles;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleAxisEnum;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleDisplayOptionsWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_VertStackedEnsembleDisplayWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_AxisLocker;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_EnsembleOverlay;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.TablePlot.Java2D_TablePlotWidget_Stacked;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_KeyPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_Line;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JTextField;

public class WeatherVelocity_DefineUsingSliceWidget
extends JSplitPane
implements GenericObjectListener.Listener,
ActionListener,
IParameterWidgetListener,
ItemListener,
Java2D_VertStackedEnsembleDisplayWidget.Listener,
ISaveableFrame {
    protected Java2D_SimpleComposite m_widgetBasemap;
    protected Java2D_TablePlotWidget_Stacked m_stackWidget = new Java2D_TablePlotWidget_Stacked();
    protected int m_elevationRow = -999;
    protected WeatherVelocityProfiler m_weatherVelocityProfiler;
    protected SliderWidget m_slider;
    protected JComboBox<String> m_plotCountCombo = new JComboBox();
    protected JCheckBox m_useEnsembleCheck = new JCheckBox("Use ensemble");
    protected JTextField m_traceCountText = new JTextField("20");
    protected JTextField m_searchRadiusText = new JTextField("500");
    protected Java2D_AxisLocker m_axisLockerTime;
    protected Java2D_VertStackedEnsembleDisplayWidget m_ensembleWidget;
    protected Java2D_EnsembleDisplayOptionsWidget m_wiggleOptionsWidget;
    protected Ensemble m_ensemble = new Ensemble();
    protected Java2D_Paintable_EnsembleOverlay m_overlay = new Java2D_Paintable_EnsembleOverlay();
    protected SliderWidget m_sliderGravityFudge;
    protected boolean m_gravityOkay = false;
    protected int m_gravityRow = -999;
    protected ComboStringListWrapper m_gravityCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_gravityVel0Combo = new ComboStringListWrapper();
    protected JCheckBox m_computeGravityCheck = new JCheckBox("Compute gravity with this field");
    protected String m_measuredGravityColumn;
    protected boolean m_measuredGravityOkay = false;
    protected String m_computedGravityColumn = "COMPUTED_GRAVITY";
    protected boolean m_computedGravityOkay = false;
    protected String m_diffGravityColumn = "GRAVITY_DIFFERENCE";
    protected JRadioButton m_blackRadio = new JRadioButton("No colors");
    protected JRadioButton m_v0Radio = new JRadioButton("Interpolated weathering velocity");
    protected JRadioButton m_tableRadio = new JRadioButton("Use database value");
    protected ButtonGroup m_plotGroup = new ButtonGroup();
    protected ComboStringListWrapper m_columnCombo = new ComboStringListWrapper();
    protected JButton m_reloadComboButton;
    protected JButton m_reloadPlotButton;
    protected JButton m_exportButton = new JButton("Export velocity field");
    protected Java2D_UserEventConsumer_Line m_lineUEC;
    protected Java2D_UserEventConsumer_KeyPressed m_mapKeyUEC;
    protected int[] m_indexVelocity = new int[20];
    protected int[] m_indexDelayTime = new int[20];
    protected int[] m_indexThickness = new int[20];
    protected int[] m_indexElevation = new int[20];
    protected int[] m_indexInterpThickness = new int[20];
    protected int[] m_indexInterpElevation = new int[20];
    protected DelayTimeMath m_math = new DelayTimeMath();

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.Refraction.DelayTime.WeatherVelocity_DefineUsingSliceWidget";
    }

    @Override
    public String TAB_LABEL() {
        return "V0";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "Define weathering velocity";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return true;
    }

    public WeatherVelocity_DefineUsingSliceWidget() {
        super(1);
        try {
            this.m_gravityOkay = false;
            this.m_weatherVelocityProfiler = RefractionStaticsProject.singleton().getWeatherVelocityProfiler();
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.createRight());
            int row = 0;
            this.m_stackWidget.setBackgroundColor(row, new Color(255, 255, 240));
            this.m_stackWidget.setColumnsUserSelectable(row, false);
            this.m_elevationRow = row++;
            if (this.m_gravityOkay) {
                this.m_stackWidget.setBackgroundColor(row, new Color(255, 255, 240));
                this.m_stackWidget.setColumnsUserSelectable(row, false);
                this.m_stackWidget.clearColumnNames(row);
                this.m_stackWidget.addColumnName(row, "GravityResidual");
                this.m_gravityRow = row++;
            }
            this.m_stackWidget.addColumnName(row++, Pecos.getColNameDT(1));
            this.m_stackWidget.addColumnName(row++, WeatherVelocityProfiler.getComputedThickness(0));
            this.m_stackWidget.setNumVisible(row);
            this.reloadCombo();
            this.reloadMap();
            this.m_mapKeyUEC = new Java2D_UserEventConsumer_KeyPressed();
            this.m_mapKeyUEC.addListener(this);
            this.m_lineUEC = new Java2D_UserEventConsumer_Line();
            this.m_lineUEC.SymmetricLine = true;
            this.m_lineUEC.addListener(this);
            this.m_widgetBasemap.mainWidget().addEventConsumer(this.m_lineUEC);
            this.m_widgetBasemap.mainWidget().addEventConsumer(this.m_mapKeyUEC);
            this.m_widgetBasemap.mainWidget().addZoomer();
            this.prepTable();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createLeft() {
        try {
            LinearLayoutWidget w = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            double minVel = 1200.0;
            double maxVel = 10000.0;
            if (!RefractionStaticsProject.singleton().units_feet()) {
                minVel = 360.0;
                maxVel = 3000.0;
            }
            this.m_slider = new SliderWidget(this, null, "Weathering velocity", 3, 2000.0, minVel, maxVel);
            w.addComponent(this.m_slider, 0);
            if (this.m_gravityOkay) {
                this.m_sliderGravityFudge = new SliderWidget(this, null, "Regional gravity correction factor", 0, 0.5, -2.0, 2.0);
                w.addComponent(this.m_sliderGravityFudge, 0);
            }
            LinearLayoutWidget sub = w.createVertical(0, "Plot options", 0);
            sub.addComponent(this.m_blackRadio, 0);
            sub.addComponent(this.m_v0Radio, 0);
            sub.addComponent(this.m_tableRadio, 0);
            sub.addComponent(this.m_columnCombo, 0);
            this.m_reloadComboButton = sub.createButton("Reload database column list", this, 0);
            this.m_reloadPlotButton = sub.createButton("Reload the plot", this, 0);
            this.m_columnCombo.setPreferredSelected("Elevation");
            this.m_columnCombo.setEnabled(false);
            this.m_columnCombo.listener().addListener(this);
            this.m_plotGroup.add(this.m_blackRadio);
            this.m_plotGroup.add(this.m_v0Radio);
            this.m_plotGroup.add(this.m_tableRadio);
            this.m_blackRadio.setSelected(true);
            this.m_blackRadio.addActionListener(this);
            this.m_v0Radio.addActionListener(this);
            this.m_tableRadio.addActionListener(this);
            this.m_exportButton = w.createButton("Export velocity field ", this, 0);
            String s = "<HTML>Left-click and drag to select profile. Press \"s\" to select existing location, \"r\" to delete</HTML>";
            w.addComponent(new JLabel(s), 0);
            Tools_FontChanger.changeSizeOfFont(w, -2, null, true);
            this.m_widgetBasemap = new Java2D_SimpleComposite(true);
            this.m_widgetBasemap.setAxesVisible(false, false);
            w.addComponent(this.m_widgetBasemap, 10);
            return w;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRight() {
        try {
            int split = 0;
            JSplitPane splitter = new JSplitPane(split);
            if (split == 1) {
                splitter.setLeftComponent(this.createRightPlot());
                splitter.setRightComponent(this.createRightEnsembleForHorzSplit());
                splitter.setDividerLocation(200);
            } else {
                splitter.setTopComponent(this.createRightPlot());
                splitter.setBottomComponent(this.createRightEnsembleForVertSplit());
                splitter.setDividerLocation(200);
            }
            this.m_wiggleOptionsWidget = new Java2D_EnsembleDisplayOptionsWidget("Trace display options");
            this.m_wiggleOptionsWidget.listener().addListener(this);
            this.m_ensembleWidget.setEnsembleDisplayOptionsWidget(this.m_wiggleOptionsWidget);
            this.m_ensembleWidget.addListener(this);
            this.m_ensembleWidget.addZoomer();
            this.m_overlay.DrawLine = true;
            this.m_axisLockerTime.listener().addListener(this);
            this.m_useEnsembleCheck.addActionListener(this);
            this.m_traceCountText.addActionListener(this);
            this.m_searchRadiusText.addActionListener(this);
            return splitter;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRightEnsembleForVertSplit() {
        try {
            LinearLayoutWidget w = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null);
            LinearLayoutWidget left = w.createVertical(0, null, 0);
            left.addComponent(this.m_useEnsembleCheck, 0);
            left.addComponent(new JLabel("Number of traces:"), 0);
            left.addComponent(this.m_traceCountText, 0);
            left.addComponent(new JLabel("Search radius (ft/m)"), 0);
            left.addComponent(this.m_searchRadiusText, 0);
            this.m_axisLockerTime = new Java2D_AxisLocker("Lock time axis", "Time range");
            left.addComponent(this.m_axisLockerTime, 0);
            left.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(left, -2, null, true);
            this.m_ensembleWidget = new Java2D_VertStackedEnsembleDisplayWidget(1);
            w.addComponent(this.m_ensembleWidget, 10);
            return w;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRightEnsembleForHorzSplit() {
        try {
            LinearLayoutWidget w = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            LinearLayoutWidget top = w.createHorizontal(3, null, 0);
            LinearLayoutWidget sub = top.createVertical(2, "", 0);
            sub.addComponent(this.m_useEnsembleCheck, 0);
            sub.addComponent(new JLabel("Number of traces:"), 0);
            sub.addComponent(this.m_traceCountText, 0);
            sub.addComponent(new JLabel("Search radius (ft/m)"), 0);
            sub.addComponent(this.m_searchRadiusText, 0);
            sub.addStretch(10);
            this.m_axisLockerTime = new Java2D_AxisLocker("Lock time axis", "Time range");
            top.addComponent(this.m_axisLockerTime, 0);
            top.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(top, -2, null, true);
            this.m_ensembleWidget = new Java2D_VertStackedEnsembleDisplayWidget(1);
            w.addComponent(this.m_ensembleWidget, 10);
            return w;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRightPlot() {
        try {
            LinearLayoutWidget w = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            LinearLayoutWidget top = w.createHorizontal(3, null, 0);
            for (int n = 1; n <= 10; ++n) {
                this.m_plotCountCombo.addItem(String.format("%d plots visible", n));
            }
            this.m_plotCountCombo.setSelectedIndex(3);
            top.addComponent(this.m_plotCountCombo, 0);
            this.m_plotCountCombo.addItemListener(this);
            top.addStretch(10);
            if (this.m_gravityOkay) {
                top.createLabel("Measured gravity", 2, 0);
                top.addComponent(this.m_gravityCombo, 1);
                this.m_gravityCombo.setPreferredSelected("GravityResidual");
                this.m_gravityCombo.listener().addListener(this);
            }
            Tools_FontChanger.changeSizeOfFont(top, -2, null, true);
            w.addComponent(this.m_stackWidget, 10);
            return w;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void loadEnsemble() {
        try {
            this.m_ensemble.clearTraces(false);
            if (!this.m_useEnsembleCheck.isSelected() || this.m_weatherVelocityProfiler.currentLocation() == null) {
                this.m_ensembleWidget.setEnsemble(0, this.m_ensemble);
                this.m_ensembleWidget.unzoom();
                return;
            }
            double radius = Tools_Widget.extractDouble(this.m_searchRadiusText, 200.0, 100.0, 5000.0);
            int count = Tools_Widget.extractInteger(this.m_traceCountText, 20, 5, 200);
            double x = this.m_weatherVelocityProfiler.currentLocation().CenterX;
            double y = this.m_weatherVelocityProfiler.currentLocation().CenterY;
            Tools_StrangeEnsembles.innerOffsetsWithinRadius(this.m_ensemble, x, y, radius, count);
            this.m_ensemble.sortDouble(0, "Trace", "Offset");
            this.m_ensembleWidget.setAxisType(Java2D_EnsembleAxisEnum.UniformSpacing);
            this.m_ensembleWidget.setEnsemble(0, this.m_ensemble);
            this.loadEnsemblePicks(false);
            this.m_ensembleWidget.clearAndLoadWigglePaintables();
            this.m_ensembleWidget.unzoom();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleEnsembleWidgetPaintEvent(Java2D_VertStackedEnsembleDisplayWidget widget, int widgetIndex, boolean imagePainted) {
        try {
            if (imagePainted && widgetIndex == 0) {
                this.m_overlay.m_ensemble = this.m_ensemble;
                this.m_widgetBasemap.mainWidget().repaint();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadEnsemblePicks(boolean repaintAll) {
        try {
            if (this.m_weatherVelocityProfiler.currentLocation() == null) {
                return;
            }
            if (this.m_ensemble.traceCount() < 1) {
                return;
            }
            double v = this.m_weatherVelocityProfiler.currentLocation().V0;
            int indexOff = this.m_ensemble.dictionary().addEntry("Trace", "Offset", DataType.Double);
            int indexPick = this.m_ensemble.dictionary().addEntry("Trace", "PickLMO", DataType.Double);
            for (int n = 0; n < this.m_ensemble.traceCount(); ++n) {
                double off = this.m_ensemble.trace(n).header().getDouble(indexOff);
                double pick = 1000.0 * off / v;
                this.m_ensemble.trace(n).header().putDouble(indexPick, pick);
            }
            EnsembleFirstBreakPickPlotData ppd = this.m_ensemble.pickPlotData();
            ppd.clear();
            ppd.add("PickLMO", Color.red, 13, Java2D_PointSymbol.HollowOval);
            if (repaintAll) {
                this.m_ensembleWidget.repaintAll();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (e.getSource() == this.m_gravityVel0Combo) {
                this.prepTable();
                return;
            }
            if (e.getSource() == this.m_plotCountCombo) {
                this.prepTable();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            if (this.m_weatherVelocityProfiler.currentLocation() != null) {
                this.m_weatherVelocityProfiler.currentLocation().V0 = this.m_slider.getDoubleValue();
                this.m_weatherVelocityProfiler.save();
                this.prepTable();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadCombo() {
        try {
            ArrayList<String> cols = Tools_RefractionStaticsProject.getColumnList_Intersection();
            this.m_columnCombo.setStringArray(cols);
            if (this.m_gravityCombo != null) {
                this.m_gravityCombo.setStringArray(cols);
            }
            if (this.m_gravityVel0Combo != null) {
                this.m_gravityVel0Combo.setStringArray(cols);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_computeGravityCheck) {
                this.prepTable();
                return;
            }
            if (e.getSource() == this.m_useEnsembleCheck || e.getSource() == this.m_traceCountText || e.getSource() == this.m_searchRadiusText) {
                this.loadEnsemble();
                return;
            }
            if (e.getSource() == this.m_exportButton) {
                int res = JOptionPane.showConfirmDialog(this, "Okay to overwrite contents of DTA_Velocity_0?", "Confirm export", 2, 2, null);
                if (res != 0) {
                    return;
                }
                this.m_weatherVelocityProfiler.export();
                res = JOptionPane.showConfirmDialog(this, "Update the refractor elevations now?", "Confirm export", 2, 2, null);
                if (res != 0) {
                    return;
                }
                RefractionStaticsProject p = RefractionStaticsProject.singleton();
                DelayTimeModel_ModInfo modInfo = new DelayTimeModel_ModInfo();
                modInfo.ModificationMethod = modInfo.Mod_None;
                modInfo.ModifyVelocity = true;
                modInfo.Refractor = 0;
                modInfo.Follow = DelayTimeModel_ModInfo.FollowupOptions.ModifyElevations;
                DelayTimeModel.singleton().performRequestedMods(modInfo);
                return;
            }
            if (e.getSource() == this.m_reloadComboButton) {
                this.reloadCombo();
                return;
            }
            if (this.m_blackRadio == e.getSource() || this.m_v0Radio == e.getSource() || this.m_tableRadio == e.getSource() || this.m_reloadPlotButton == e.getSource()) {
                this.m_columnCombo.setEnabled(this.m_tableRadio.isSelected());
                this.reloadMap();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void computeElevations() {
        try {
            Table_Abstract table = this.m_weatherVelocityProfiler.currentTable();
            if (table == null) {
                return;
            }
            int maxBranch = 0;
            for (int n = 1; n < 10; ++n) {
                if (!table.column_exists(Pecos.getColNameDT(n)) || !table.column_exists(Pecos.getColNameVel(n))) continue;
                this.m_indexVelocity[n] = table.column_indexOfColumn(Pecos.getColNameVel(n));
                this.m_indexDelayTime[n] = table.column_indexOfColumn(Pecos.getColNameDT(n));
                String s = WeatherVelocityProfiler.getComputedThickness(n - 1);
                this.m_indexThickness[n - 1] = table.column_append(s, DataType.Double);
                s = WeatherVelocityProfiler.getComputedElevation(n);
                this.m_indexElevation[n] = table.column_append(s, DataType.Double);
                s = String.format("Interpolated_Thickness_%d", n - 1);
                this.m_indexInterpThickness[n - 1] = table.column_append(s, DataType.Double);
                s = String.format("Interpolated_Elevation_%d", n);
                this.m_indexInterpElevation[n] = table.column_append(s, DataType.Double);
                maxBranch = n;
            }
            if (maxBranch < 1) {
                return;
            }
            this.m_math.MaxBranch = maxBranch;
            int indexElev = table.column_indexOfColumn("Elevation");
            int indexVelField = -9999;
            if (this.m_computeGravityCheck.isSelected()) {
                String velField = this.m_gravityVel0Combo.getSelectedString();
                indexVelField = table.column_indexOfColumn(velField);
            }
            for (int row = 0; row < table.row_count(); ++row) {
                int b;
                this.m_math.Elevation[0] = table.getDouble(row, indexElev);
                this.m_math.Velocity[0] = this.m_weatherVelocityProfiler.currentLocation().V0;
                for (b = 1; b <= maxBranch; ++b) {
                    this.m_math.DelayTime[b] = table.getDouble(row, this.m_indexDelayTime[b]);
                    this.m_math.Velocity[b] = table.getDouble(row, this.m_indexVelocity[b]);
                    this.m_math.Velocity[0] = Math.min(this.m_math.Velocity[0], 0.98 * this.m_math.Velocity[b]);
                }
                this.m_math.computeElevations();
                for (b = 1; b <= maxBranch; ++b) {
                    table.putDouble(row, this.m_indexThickness[b - 1], this.m_math.Thickness[b - 1]);
                    table.putDouble(row, this.m_indexElevation[b], this.m_math.Elevation[b]);
                }
                if (indexVelField < 0) continue;
                this.m_math.Velocity[0] = table.getDouble(row, indexVelField);
                this.m_math.Velocity[0] = Math.max(this.m_math.Velocity[0], 100.0);
                for (b = 1; b <= maxBranch; ++b) {
                    this.m_math.Velocity[0] = Math.min(this.m_math.Velocity[0], 0.98 * this.m_math.Velocity[b]);
                }
                this.m_math.computeElevations();
                for (b = 1; b <= maxBranch; ++b) {
                    table.putDouble(row, this.m_indexInterpThickness[b - 1], this.m_math.Thickness[b - 1]);
                    table.putDouble(row, this.m_indexInterpElevation[b], this.m_math.Elevation[b]);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void computeGravity() {
        try {
            this.m_computedGravityOkay = false;
            this.m_measuredGravityOkay = false;
            this.m_stackWidget.clearColumnNames(this.m_gravityRow);
            Table_Abstract table = this.m_weatherVelocityProfiler.currentTable();
            if (table == null) {
                return;
            }
            this.m_measuredGravityColumn = this.m_gravityCombo.getSelectedString();
            double v0 = this.m_weatherVelocityProfiler.currentLocation().V0;
            double averageMeasured = 0.0;
            if (table.column_exists(this.m_measuredGravityColumn)) {
                this.m_stackWidget.addColumnName(this.m_gravityRow, this.m_measuredGravityColumn);
                double sum1 = 0.0;
                int indexMeasured = table.column_indexOfColumn(this.m_measuredGravityColumn);
                for (int row = 0; row < table.row_count(); ++row) {
                    sum1 += table.getDouble(row, indexMeasured);
                }
                averageMeasured = sum1 / (1.0E-6 + (double)table.row_count());
                this.m_measuredGravityOkay = true;
            }
            double hack = this.m_sliderGravityFudge.getDoubleValue();
            int indexComputed = table.column_append(this.m_computedGravityColumn, DataType.Double);
            this.m_stackWidget.addColumnName(this.m_gravityRow, this.m_computedGravityColumn);
            double sum1 = 0.0;
            for (int row = 0; row < table.row_count(); ++row) {
                double computed = 0.0;
                double refractorVelocity = table.getDouble(row, this.m_indexVelocity[this.m_math.MaxBranch]);
                for (int branch = 1; branch <= this.m_math.MaxBranch; ++branch) {
                    double velAboveRefractor = v0;
                    if (branch >= 2) {
                        velAboveRefractor = table.getDouble(row, this.m_indexVelocity[branch - 1]);
                    }
                    double thicknessAboveRefractor = table.getDouble(row, this.m_indexThickness[branch - 1]);
                    double densityDeepest = 0.23 * Math.sqrt(Math.sqrt(refractorVelocity));
                    double densityLayer = 0.23 * Math.sqrt(Math.sqrt(velAboveRefractor));
                    double layerGravity = hack * (0.0 - 0.01277 * thicknessAboveRefractor * (densityDeepest - densityLayer));
                    computed += layerGravity;
                }
                table.putDouble(row, indexComputed, computed);
                sum1 += computed;
            }
            double averageComputed = sum1 / (double)table.row_count();
            double shift = averageMeasured - averageComputed;
            for (int row = 0; row < table.row_count(); ++row) {
                double computed = table.getDouble(row, indexComputed);
                table.putDouble(row, indexComputed, computed + shift);
            }
            if (this.m_computeGravityCheck.isSelected()) {
                double computed;
                int row;
                String colName = this.m_gravityVel0Combo.getSelectedString();
                int indexField = table.column_indexOfColumn(colName);
                String colNameInterp = "Comp_Using_Field";
                indexComputed = table.column_append(colNameInterp, DataType.Double);
                this.m_stackWidget.addColumnName(this.m_gravityRow, colNameInterp);
                sum1 = 0.0;
                for (row = 0; row < table.row_count(); ++row) {
                    computed = 0.0;
                    double refractorVelocity = table.getDouble(row, this.m_indexVelocity[this.m_math.MaxBranch]);
                    for (int branch = 1; branch <= this.m_math.MaxBranch; ++branch) {
                        double velAboveRefractor = table.getDouble(row, indexField);
                        if (branch >= 2) {
                            velAboveRefractor = table.getDouble(row, this.m_indexVelocity[branch - 1]);
                        }
                        double thicknessAboveRefractor = table.getDouble(row, this.m_indexInterpThickness[branch - 1]);
                        double densityDeepest = 0.23 * Math.sqrt(Math.sqrt(refractorVelocity));
                        double densityLayer = 0.23 * Math.sqrt(Math.sqrt(velAboveRefractor));
                        double layerGravity = hack * (0.0 - 0.01277 * thicknessAboveRefractor * (densityDeepest - densityLayer));
                        computed += layerGravity;
                    }
                    table.putDouble(row, indexComputed, computed);
                    sum1 += computed;
                }
                averageComputed = sum1 / (double)table.row_count();
                shift = averageMeasured - averageComputed;
                for (row = 0; row < table.row_count(); ++row) {
                    computed = table.getDouble(row, indexComputed);
                    table.putDouble(row, indexComputed, computed + shift);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void prepTable() {
        try {
            this.m_stackWidget.setNumVisible(1 + this.m_plotCountCombo.getSelectedIndex());
            this.computeElevations();
            this.m_stackWidget.clearColumnNames(this.m_elevationRow);
            this.m_stackWidget.addColumnName(this.m_elevationRow, "Elevation");
            for (int b = 1; b <= this.m_math.MaxBranch; ++b) {
                this.m_stackWidget.addColumnName(this.m_elevationRow, WeatherVelocityProfiler.getComputedElevation(b));
            }
            if (this.m_gravityOkay && this.m_weatherVelocityProfiler.currentTable() != null) {
                this.m_gravityCombo.setStringArray(this.m_weatherVelocityProfiler.currentTable().column_listOfNames());
            }
            if (this.m_gravityOkay) {
                this.computeGravity();
            }
            this.m_stackWidget.setTable(this.m_weatherVelocityProfiler.currentTable());
            this.m_stackWidget.repaint();
            this.loadEnsemblePicks(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_gravityCombo) {
                this.prepTable();
                return;
            }
            if (sender == this.m_columnCombo) {
                this.reloadMap();
                return;
            }
            if (sender == this.m_axisLockerTime) {
                this.m_ensembleWidget.setAxisLocked_Time(this.m_axisLockerTime.locked(), this.m_axisLockerTime.min(), this.m_axisLockerTime.max());
                return;
            }
            if (sender == this.m_lineUEC) {
                if (this.m_lineUEC.Dragging) {
                    return;
                }
                double dx = this.m_lineUEC.EndWorldX - this.m_lineUEC.StartWorldX;
                double dy = this.m_lineUEC.EndWorldY - this.m_lineUEC.StartWorldY;
                this.m_weatherVelocityProfiler.addLocation(this.m_lineUEC.StartWorldX, this.m_lineUEC.StartWorldY, dx, dy);
                if (this.m_weatherVelocityProfiler.currentLocation() != null) {
                    double v0 = this.m_weatherVelocityProfiler.currentLocation().V0;
                    this.m_slider.setDoubleValue(v0);
                }
                this.prepTable();
                this.loadEnsemble();
                this.m_widgetBasemap.mainWidget().repaint();
            }
            if (sender == this.m_mapKeyUEC) {
                double v0;
                if (this.m_mapKeyUEC.KeyCode == 83) {
                    this.m_weatherVelocityProfiler.selectLocation(this.m_mapKeyUEC.PixelX, this.m_mapKeyUEC.PixelY);
                    if (this.m_weatherVelocityProfiler.currentLocation() != null) {
                        v0 = this.m_weatherVelocityProfiler.currentLocation().V0;
                        this.m_slider.setDoubleValue(v0);
                    }
                    this.loadEnsemble();
                    this.m_widgetBasemap.mainWidget().repaint();
                    this.prepTable();
                }
                if (this.m_mapKeyUEC.KeyCode == 82 || this.m_mapKeyUEC.KeyCode == 68) {
                    this.m_weatherVelocityProfiler.deleteLocation(this.m_mapKeyUEC.PixelX, this.m_mapKeyUEC.PixelY);
                    if (this.m_weatherVelocityProfiler.currentLocation() != null) {
                        v0 = this.m_weatherVelocityProfiler.currentLocation().V0;
                        this.m_slider.setDoubleValue(v0);
                    }
                    this.loadEnsemble();
                    this.m_widgetBasemap.mainWidget().repaint();
                    this.prepTable();
                }
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadMap() {
        try {
            Java2D_Paintable_Table po;
            System.out.println("reloadMap()");
            Java2D_Widget w = this.m_widgetBasemap.mainWidget();
            this.m_widgetBasemap.setColorTitle("");
            w.clearPaintableList();
            if (this.m_blackRadio.isSelected()) {
                po = Tools_RefractionStaticsProject.loadGeomPO("Shot");
                po.Symbol = Java2D_PointSymbol.FilledSquare;
                w.addPaintable(po, -9999);
                po = Tools_RefractionStaticsProject.loadGeomPO("Receiver");
                po.Symbol = Java2D_PointSymbol.FilledSquare;
                w.addPaintable(po, -9999);
            }
            if (this.m_tableRadio.isSelected()) {
                String col = this.m_columnCombo.getSelectedString();
                this.m_widgetBasemap.setColorTitle(col);
                po = Tools_RefractionStaticsProject.loadGeomPO("Shot", col);
                w.addPaintable(po, -9999);
                po = Tools_RefractionStaticsProject.loadGeomPO("Receiver", col);
                w.addPaintable(po, -9999);
            }
            if (this.m_v0Radio.isSelected()) {
                this.m_widgetBasemap.setColorTitle("Interpolated weather velocity");
                po = Tools_RefractionStaticsProject.loadGeomPO("Shot");
                this.interpolate(po);
                w.addPaintable(po, -9999);
                po = Tools_RefractionStaticsProject.loadGeomPO("Receiver");
                this.interpolate(po);
                w.addPaintable(po, -9999);
            }
            w.addPaintable(this.m_weatherVelocityProfiler, -9999);
            this.m_overlay.ColumnX = "Easting";
            this.m_overlay.ColumnY = "Northing";
            w.addPaintable(this.m_overlay, -9999);
            w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            w.mooz();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void interpolate(Java2D_Paintable_Table po) {
        try {
            if (this.m_weatherVelocityProfiler.size() < 1) {
                return;
            }
            Table_Abstract table = po.getTable();
            int index = table.column_append("V0", DataType.Double);
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            for (int row = 0; row < table.row_count(); ++row) {
                double x = table.getDouble(row, indexX);
                double y = table.getDouble(row, indexY);
                double v = this.m_weatherVelocityProfiler.getInterpolatedVelocity(x, y);
                table.putDouble(row, index, v);
            }
            po.setAxisC("V0");
            po.UseColorScale = true;
            po.Symbol = Java2D_PointSymbol.FilledSquare;
            po.Size_UsePixel = false;
            po.Size_World = RefractionStaticsProject.singleton().units_feet() ? 80.0 : 25.0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

