/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.DelayTime.WaterBottomCorrection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Shared.RadioPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class WaterBottomCorrectionDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener {
    protected RefractionStaticsProject m_project;
    protected RadioPanel m_radioWBC;
    protected JTextField m_txtWaterVel = new JTextField("22");
    protected JButton m_btnOK = new JButton("Okay");
    protected JButton m_btnCancel = new JButton("Cancel");
    public boolean OK = false;

    public WaterBottomCorrectionDialog() {
        try {
            this.m_project = RefractionStaticsProject.singleton();
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            this.m_radioWBC = new RadioPanel(LinearLayoutWidget.Direction.Vertical, "Water bottom correction method", WaterBottomCorrection.Method.values()[0].Description, WaterBottomCorrection.Method.values()[1].Description, WaterBottomCorrection.Method.values()[2].Description);
            main.addComponent(this.m_radioWBC, 0);
            main.addHorzPair(new JLabel("Water velocity"), 0, this.m_txtWaterVel, 11);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            bottom.addStretch(10);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.getContentPane().add((Component)main, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.pack();
            this.setTitle("Advanced delay time analysis options");
            this.setLocationRelativeTo(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void showDialog() {
        try {
            this.OK = false;
            try {
                double v = this.m_project.getWaterVelocity();
                this.m_txtWaterVel.setText(Double.toString(v));
            }
            catch (Exception v) {
                // empty catch block
            }
            try {
                WaterBottomCorrection.Method method = this.m_project.getWaterDepthCorrectionMethod();
                int upholeIndex = WaterBottomCorrection.getIndexFromMethod(method);
                this.m_radioWBC.setSelectedIndex(upholeIndex);
            }
            catch (Exception method) {
                // empty catch block
            }
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnOK) {
                int index = this.m_radioWBC.getSelectedIndex();
                WaterBottomCorrection.Method method = WaterBottomCorrection.getMethodFromIndex(index);
                this.m_project.setWaterDepthCorrectionMethod(method);
                double v = Tools_Widget.extractDouble(this.m_txtWaterVel, 5000.0, 100.0, 12000.0);
                this.m_project.setWaterVelocity(v);
                this.OK = true;
                this.dispose();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

