/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleFirstBreakPickPlotData;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Refraction.Picking.PickPlaneEnum;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Ensemble.Worker.Amplitude.EnsembleWorker_RMS;
import com.PecosLibrary.Ensemble.Worker.DelayTime.EnsembleWorker_DelayTimeShifts;
import com.PecosLibrary.Ensemble.Worker.ModelTimeShifts.EnsembleWorker_Eikonal3D;
import com.PecosLibrary.Ensemble.Worker.ModelTimeShifts.EnsembleWorker_TomoVNS;
import com.PecosLibrary.Ensemble.Worker.Tools_EnsembleWorker;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.JDBC.Tools_JDBC;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.PickerGizmo;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3D;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Windows.Ensemble.Sequence.Sequence_MainWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleAxisEnum;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleDisplayOptionsWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_VertStackedEnsembleDisplayWidget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_KeyPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MouseMove;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MultiLineSegments;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_PenMode;
import com.PecosLibrary.Windows.Refraction.Picking.PickerBasemapWidget;
import com.PecosLibrary.Windows.Refraction.Picking.PickerGizmoWidget;
import com.PecosLibrary.Windows.Shared.BitmapCardWidget;
import com.PecosLibrary.Windows.Shared.RadioPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class SolutionStacksWidget
extends JSplitPane
implements ActionListener,
GenericObjectListener.Listener,
ItemListener,
Java2D_VertStackedEnsembleDisplayWidget.Listener,
Messenger.Listener,
ListSelectionListener,
PickerBasemapWidget.Listener {
    protected int m_magic = 2770071;
    protected double m_stackMinTime;
    protected double m_stackMaxTime;
    protected double m_stackDigi;
    protected int m_stackLength;
    protected int m_stackBranch;
    protected HashMap_Integers<StackData> m_shotHash = new HashMap_Integers();
    protected HashMap_Integers<StackData> m_recHash = new HashMap_Integers();
    protected float[] m_tempArray = new float[10];
    protected ArrayList<GroupData> m_groupList = new ArrayList();
    protected Ensemble m_groupEnsemble = new Ensemble();
    protected GroupData m_currentGroupData = null;
    protected boolean inlinesCrosslinesInitialized = false;
    protected JComboBox<String> m_branchCombo = new JComboBox();
    protected JTextField m_minTimeText = new JTextField("-300");
    protected JTextField m_maxTimeText = new JTextField("300");
    protected JTextField m_minOffsetText = new JTextField("1000");
    protected JTextField m_maxOffsetText = new JTextField("4000");
    protected JCheckBox m_chkStackInsidePolygon = new JCheckBox("Only stack shots/recs inside polygon");
    protected JCheckBox m_chkForceZeroMean = new JCheckBox("Force traces to have zero mean value");
    protected JButton m_beginStackButton = new JButton("Create stacks");
    protected JProgressBar m_progress = new JProgressBar();
    protected JButton m_btnConvertResidualsToZeroMean;
    protected JButton m_btnRestoreComputedResiduals;
    protected JCheckBox m_chkAutoRestackShots = new JCheckBox("Automatically restack shots when geometry modified");
    protected JCheckBox m_chkAutoRestackRecs = new JCheckBox("Automatically restack receivers when geometry modified");
    protected JLabel m_labelStack = new JLabel(" ", 0);
    protected JComboBox<String> m_planeCombo = new JComboBox();
    protected JComboBox<String> m_sortCombo = new JComboBox();
    protected JTextField m_countText = new JTextField("100");
    protected JButton m_applyGroupButton;
    protected ComboStringListWrapper m_comboPriSort = new ComboStringListWrapper();
    protected ComboStringListWrapper m_comboSecSort = new ComboStringListWrapper();
    protected JButton m_reloadColumnsButton;
    protected LinearLayoutWidget m_groupWidget;
    protected JTextField m_textPercentMod = new JTextField("50");
    protected JButton m_btnClearGeneralPicks;
    protected JComboBox<String> m_headerCountCombo = new JComboBox();
    protected JList<String> m_list = new JList();
    protected DefaultListModel<String> m_listModel = new DefaultListModel();
    protected boolean m_ignoreList = true;
    protected PickerGizmoWidget m_pickerGizmoWidget;
    protected BitmapCardWidget m_bitmapCardWidget = new BitmapCardWidget();
    protected Sequence_MainWidget m_workerWidget;
    protected EnsembleWorker_Sequence m_sequence;
    protected EnsembleWorker_Sequence m_sequenceLastStack = null;
    protected String m_sequenceLastStackFileName = "";
    protected Java2D_VertStackedEnsembleDisplayWidget m_widget;
    protected Java2D_EnsembleDisplayOptionsWidget m_wiggleOptionsWidget;
    protected RadioPanel m_radioPlotType;
    protected PickerBasemapWidget m_basemapWidget;
    protected JButton m_colorButton;
    protected JColorChooser m_colorChooser;
    protected Color m_pickColor;
    protected JTextField m_txtMouseSelID = new JTextField("");
    protected JTextField m_txtMouseSelLine = new JTextField("");
    protected JTextField m_txtMouseSelPoint = new JTextField("");
    protected JTextField m_txtMouseSelIndex = new JTextField("");
    protected String m_path;
    protected String m_shotFileName;
    protected String m_recFileName;
    protected JList<String> m_list_ShotKills = new JList();
    protected DefaultListModel<String> m_listModel_ShotKills = new DefaultListModel();
    protected JButton m_btnUnkillSelectedShots;
    protected JList<String> m_list_RecKills = new JList();
    protected DefaultListModel<String> m_listModel_RecKills = new DefaultListModel();
    protected JButton m_btnUnkillSelectedRecs;
    protected String m_databasePath;
    protected String m_fileNameDB;
    protected IDatabaseConnection m_geometryConn;
    protected Table_Abstract m_receiverTable;
    protected HashMap_Integer m_receiverMap;
    protected int m_receiverMap_ColID;
    protected int m_receiverMap_ColPick;
    protected int m_receiverMap_ColMod;
    protected Table_Abstract m_shotTable;
    protected HashMap_Integer m_shotMap;
    protected int m_shotMap_ColID;
    protected int m_shotMap_ColPick;
    protected int m_shotMap_ColMod;
    protected String m_externalMod = "ExternalMod";
    protected Java2D_UserEventConsumer_MultiLineSegments m_lineSegmentUEC = new Java2D_UserEventConsumer_MultiLineSegments();
    protected Java2D_UserEventConsumer_MultiLineSegments m_rubberBandUEC = new Java2D_UserEventConsumer_MultiLineSegments(true);
    protected Java2D_UserEventConsumer_KeyPressed m_keyUEC = new Java2D_UserEventConsumer_KeyPressed();
    protected Java2D_UserEventConsumer_MouseMove m_mouseMoveUEC = new Java2D_UserEventConsumer_MouseMove();
    protected Java2D_UserEventConsumer_ButtonPressed m_leftClickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
    protected Java2D_UserEventConsumer_ButtonPressed m_middleClickUEC = new Java2D_UserEventConsumer_ButtonPressed(2);
    protected Java2D_UserEventConsumer_PenMode m_penModeUEC = new Java2D_UserEventConsumer_PenMode();
    public static final int SolutionType_DelayTime = 1000;
    public static final int SolutionType_Tomo3D = 2000;
    public static final int SolutionType_Generic = 3000;
    public static final int SolutionType_TomoVNS = 4000;
    protected int m_solutionType = 1000;
    protected GridLayoutWidget m_gridGroup;
    protected Ensemble m_tempEnsembleA = new Ensemble();
    protected Ensemble m_tempEnsembleB = new Ensemble();

    public SolutionStacksWidget(int solutionType) {
        super(1);
        try {
            String tomoPath;
            this.m_solutionType = solutionType;
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (this.m_solutionType == 1000) {
                this.m_path = Tools_FileSystem.confirmSubDirectoryExists(project.projectPath(), "DelayTimeStacks");
            }
            if (this.m_solutionType == 3000) {
                this.m_path = Tools_FileSystem.confirmSubDirectoryExists(project.projectPath(), "GeneralShotrecStacks");
            }
            if (this.m_solutionType == 2000) {
                tomoPath = RefractionStaticsProject.singleton().eikonal3DProjectsPath();
                this.m_path = Tools_FileSystem.confirmSubDirectoryExists(tomoPath, "ShotRecStacks");
            }
            if (this.m_solutionType == 4000) {
                tomoPath = RefractionStaticsProject.singleton().tomoVNSProjectsPath();
                this.m_path = Tools_FileSystem.confirmSubDirectoryExists(tomoPath, "ShotRecStacks");
            }
            this.m_databasePath = Tools_FileSystem.confirmSubDirectoryExists(this.m_path, "Database");
            this.m_fileNameDB = this.m_databasePath + "/geometry.db";
            this.m_geometryConn = Tools_JDBC.getConnection(false, this.m_fileNameDB);
            this.prepReceiverTable();
            this.prepShotTable();
            this.m_sequenceLastStackFileName = this.m_path + "/LastStackSequenceSequenceXML";
            this.m_sequenceLastStack = null;
            if (Tools_FileSystem.exists_file(this.m_sequenceLastStackFileName)) {
                this.m_sequenceLastStack = new EnsembleWorker_Sequence(EnsembleWorker_Sequence.SequenceType.Interactive);
                Tools_EnsembleWorker.read(this.m_sequenceLastStack, this.m_sequenceLastStackFileName);
            }
            this.m_shotFileName = this.m_path + "/Stack.shot";
            this.m_recFileName = this.m_path + "/Stack.rec";
            this.m_shotHash = this.read(this.m_shotFileName);
            this.m_recHash = this.read(this.m_recFileName);
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.createRight());
            this.prepGrouping();
            this.m_rubberBandUEC.LineColor = Color.GREEN;
            this.m_rubberBandUEC.LineStroke = new BasicStroke(3.0f);
            this.m_rubberBandUEC.addListener(this);
            this.m_lineSegmentUEC.addListener(this);
            this.m_leftClickUEC.addListener(this);
            this.m_middleClickUEC.addListener(this);
            this.m_mouseMoveUEC.addListener(this);
            this.m_keyUEC.addListener(this);
            this.m_penModeUEC.addListener(this);
            this.loadUEC();
            Messenger.singleton().addListener(this);
            PickerGizmo.singleton().listener().addListener(this);
            this.setOneTouchExpandable(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void prepShotTable() {
        try {
            Tools_RefractionStaticsProject.confirmShotTableInExternalDatabase(this.m_geometryConn);
            this.m_geometryConn.confirmColumn_Double("Shot", "Pick", -9999.0);
            this.m_geometryConn.confirmColumn_Bool("Shot", this.m_externalMod, false);
            this.m_shotTable = this.m_geometryConn.extractTableDataUsingQuery("Shot", "SELECT * FROM SHOT", 0);
            this.m_shotMap = this.m_shotTable.createMapID();
            this.m_shotMap_ColID = this.m_shotTable.column_indexOfColumn("ShotID");
            this.m_shotMap_ColPick = this.m_shotTable.column_indexOfColumn("Pick");
            this.m_shotMap_ColMod = this.m_shotTable.column_indexOfColumn(this.m_externalMod);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void prepReceiverTable() {
        try {
            Tools_RefractionStaticsProject.confirmReceiverTableInExternalDatabase(this.m_geometryConn);
            this.m_geometryConn.confirmColumn_Double("Receiver", "Pick", -9999.0);
            this.m_geometryConn.confirmColumn_Bool("Receiver", this.m_externalMod, false);
            this.m_receiverTable = this.m_geometryConn.extractTableDataUsingQuery("Receiver", "SELECT * FROM Receiver", 0);
            this.m_receiverMap = this.m_receiverTable.createMapID();
            this.m_receiverMap_ColID = this.m_receiverTable.column_indexOfColumn("ReceiverID");
            this.m_receiverMap_ColPick = this.m_receiverTable.column_indexOfColumn("Pick");
            this.m_receiverMap_ColMod = this.m_receiverTable.column_indexOfColumn(this.m_externalMod);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected JComponent createRight() {
        try {
            JSplitPane splitter = new JSplitPane(1);
            this.m_widget = new Java2D_VertStackedEnsembleDisplayWidget(1);
            this.m_widget.HeaderTextRowCount = 0;
            this.m_widget.setHeaderPlotVisibleCount(0, 2);
            this.m_widget.addListener(this);
            this.m_widget.setStackSelectedMode(true);
            this.m_widget.setEnsembleDisplayOptionsWidget(this.m_wiggleOptionsWidget);
            LinearLayoutWidget right = LinearLayoutWidget.vert(0, null);
            JTabbedPane tabs = new JTabbedPane();
            LinearLayoutWidget kill = LinearLayoutWidget.horz(0, null);
            LinearLayoutWidget shotKills = kill.createVertical(0, "Killed shots", 1);
            shotKills.addComponent(new JScrollPane(this.m_list_ShotKills), 1);
            this.m_btnUnkillSelectedShots = shotKills.createButton("Unkill selected", this, 0);
            LinearLayoutWidget recKills = kill.createVertical(0, "Killed receivers", 1);
            recKills.addComponent(new JScrollPane(this.m_list_RecKills), 1);
            this.m_btnUnkillSelectedRecs = recKills.createButton("Unkill selected", this, 0);
            this.m_list_ShotKills.setSelectionMode(0);
            this.m_list_RecKills.setSelectionMode(0);
            tabs.addTab("Recent kill lists", kill);
            GridLayoutWidget grid = new GridLayoutWidget(0, null);
            int row = 0;
            grid.addSimple(row++, new JLabel("ID"), this.m_txtMouseSelID);
            grid.addSimple(row++, new JLabel("Line"), this.m_txtMouseSelLine);
            grid.addSimple(row++, new JLabel("Point"), this.m_txtMouseSelPoint);
            grid.addSimple(row++, new JLabel("Index"), this.m_txtMouseSelIndex);
            tabs.addTab("Selected shot/receiver", grid);
            Tools_FontChanger.changeSizeOfFont(tabs, -2, null, true);
            right.addComponent(tabs, 2);
            this.m_basemapWidget = new PickerBasemapWidget(this);
            this.m_basemapWidget.drawBFD(false);
            this.m_basemapWidget.setPickPlane(PickPlaneEnum.Shot);
            right.addComponent(this.m_basemapWidget, 10);
            splitter.setLeftComponent(this.m_widget);
            splitter.setRightComponent(right);
            splitter.setOneTouchExpandable(true);
            splitter.setResizeWeight(1.0);
            return splitter;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected JComponent createLeft() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            String sequenceFileName = p.guiOptionsPath() + "/Stack_ShotRec.SequenceXML";
            if (this.m_solutionType == 2000) {
                sequenceFileName = p.guiOptionsPath() + "/Tomo3DStack_ShotRec.SequenceXML";
            }
            if (this.m_solutionType == 3000) {
                sequenceFileName = p.guiOptionsPath() + "/General_ShotRec.SequenceXML";
            }
            if (this.m_solutionType == 4000) {
                sequenceFileName = p.guiOptionsPath() + "/TomoVNSStack_ShotRec.SequenceXML";
            }
            this.m_pickerGizmoWidget = new PickerGizmoWidget();
            this.m_workerWidget = new Sequence_MainWidget("SolutionStack", EnsembleWorker_Sequence.SequenceType.Interactive);
            this.m_workerWidget.setFileName(sequenceFileName);
            this.m_sequence = this.m_workerWidget.sequence();
            if (this.m_sequence.size() < 1) {
                EnsembleWorker_Base worker;
                if (this.m_solutionType == 1000) {
                    this.m_sequence.add(new EnsembleWorker_DelayTimeShifts());
                }
                if (this.m_solutionType == 2000) {
                    worker = new EnsembleWorker_Eikonal3D();
                    ((EnsembleWorker_Eikonal3D)worker).setResidual(false);
                    this.m_sequence.add(worker);
                }
                if (this.m_solutionType == 4000) {
                    worker = new EnsembleWorker_TomoVNS();
                    ((EnsembleWorker_TomoVNS)worker).setResidual(this.m_ignoreList);
                    this.m_sequence.add(worker);
                }
                this.m_sequence.add(new EnsembleWorker_RMS());
            }
            this.m_radioPlotType = new RadioPanel(LinearLayoutWidget.Direction.Horizontal, "Display type", "Wiggles", "Gray scale");
            this.m_radioPlotType.listener().addListener(this);
            this.m_wiggleOptionsWidget = new Java2D_EnsembleDisplayOptionsWidget("Trace display options");
            this.m_wiggleOptionsWidget.listener().addListener(this);
            LinearLayoutWidget options = LinearLayoutWidget.vert(0, null);
            options.addComponent(this.m_radioPlotType, 0);
            options.addComponent(this.m_wiggleOptionsWidget, 0);
            LinearLayoutWidget colors = options.createHorizontal(0, "Select pick color", 0);
            this.m_colorButton = new JButton();
            this.m_colorButton.setPreferredSize(new Dimension(60, 25));
            this.loadPickColor();
            if (this.m_pickColor == null) {
                this.m_pickColor = Color.GREEN;
            }
            this.m_colorButton.setBackground(this.m_pickColor);
            this.m_colorChooser = new JColorChooser();
            colors.addComponent(this.m_colorButton, 0);
            this.m_colorButton.addActionListener(this);
            options.addStretch(10);
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Stack, this.createNewStackWidget(), "Create new stacks");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Basemap, this.createNavWidget(), "Basemap");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Wiggle, options, "Display options");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.PickControl, this.m_pickerGizmoWidget, "Pick controls");
            this.m_bitmapCardWidget.setPreferredSize(new Dimension(300, 500));
            return this.m_bitmapCardWidget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createNewStackWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Stack creation options", 0);
            int row = 0;
            if (this.m_solutionType == 1000) {
                grid.addSimple(row++, new JLabel("Select branch"), this.m_branchCombo);
            }
            if (this.m_solutionType == 2000 || this.m_solutionType == 3000 || this.m_solutionType == 4000) {
                grid.addSimple(row++, new JLabel("Minimum offset"), this.m_minOffsetText);
                grid.addSimple(row++, new JLabel("Maximum offset"), this.m_maxOffsetText);
            }
            grid.addSimple(row++, new JLabel("Minimum time"), this.m_minTimeText);
            grid.addSimple(row++, new JLabel("Maximum time"), this.m_maxTimeText);
            grid.addSimple(row++, new JLabel(" "), this.m_chkStackInsidePolygon);
            grid.addSimple(row++, new JLabel(" "), this.m_chkForceZeroMean);
            grid.addSimple(row++, this.m_beginStackButton, this.m_progress);
            this.m_beginStackButton.addActionListener(this);
            this.m_beginStackButton.setMultiClickThreshhold(0L);
            JLabel lbl = new JLabel("-- NOTE --", 0);
            lbl.setForeground(Color.red);
            grid.addSimple(row++, lbl, new JLabel("Only unkilled shot/recs are stacked"));
            if (this.m_solutionType == 1000) {
                LinearLayoutWidget autoStack = main.createVertical(0, "Automatic restack options", 0);
                autoStack.addComponent(this.m_chkAutoRestackShots, 0);
                autoStack.addComponent(this.m_chkAutoRestackRecs, 0);
                this.m_chkAutoRestackShots.addActionListener(this);
                this.m_chkAutoRestackRecs.addActionListener(this);
            }
            if (this.m_solutionType == 1000) {
                for (int b = 1; b <= 10; ++b) {
                    this.m_branchCombo.addItem("Refractor " + Integer.toString(b));
                }
                this.m_branchCombo.setSelectedIndex(0);
            }
            if (this.m_solutionType == 2000 || this.m_solutionType == 4000) {
                LinearLayoutWidget sub1 = main.createVertical(0, "For tomographic analysis only...", 0);
                lbl = new JLabel("Convert to zero mean after picking new residuals!");
                lbl.setForeground(Color.blue);
                sub1.addComponent(lbl, 0);
                this.m_btnConvertResidualsToZeroMean = sub1.createButton("Convert residuals to zero mean", this, 0);
                this.m_btnRestoreComputedResiduals = sub1.createButton("Start over - restore computed residuals", this, 0);
            }
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            String s = "<HTML>The processing sequence is only used when creating new stacks";
            lbl = new JLabel(s);
            lbl.setBorder(BorderFactory.createRaisedBevelBorder());
            main.createGapLabel(12);
            main.addComponent(lbl, 0);
            main.addComponent(this.m_workerWidget, 10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createNavWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            main.addComponent(this.m_labelStack, 0);
            LinearLayoutWidget sub = main.createVertical(0, "Viewing options", 0);
            GridLayoutWidget gridTop = sub.createGridLayoutWidget(0, "Select plane, grouping method", 0);
            gridTop.addSimple(0, new JLabel("Select plane"), this.m_planeCombo);
            gridTop.addSimple(1, new JLabel("Grouping method"), this.m_sortCombo);
            this.m_applyGroupButton = new JButton("Apply group options");
            this.m_applyGroupButton.addActionListener(this);
            this.m_reloadColumnsButton = new JButton("Reload column list");
            this.m_reloadColumnsButton.addActionListener(this);
            this.m_gridGroup = sub.createGridLayoutWidget(0, "Options used if grouping by count", 0);
            this.m_gridGroup.addSimple(0, new JLabel("Traces per group"), this.m_countText);
            this.m_gridGroup.addSimple(1, new JLabel("Primary sort column"), this.m_comboPriSort);
            this.m_gridGroup.addSimple(2, new JLabel("Secondary sort column"), this.m_comboSecSort);
            this.m_gridGroup.addSimple(3, this.m_applyGroupButton, this.m_reloadColumnsButton);
            this.m_comboPriSort.setPreferredSelected("LineNumber");
            this.m_comboSecSort.setPreferredSelected("PointNumber");
            this.m_planeCombo.addItemListener(this);
            this.m_sortCombo.addItemListener(this);
            sub.addStretch(10);
            this.m_planeCombo.addItem("Shot");
            this.m_planeCombo.addItem("Receiver");
            this.m_sortCombo.addItem("LineNumber");
            this.m_sortCombo.addItem("By count");
            this.m_sortCombo.addItem("Inline");
            this.m_sortCombo.addItem("Crossline");
            this.m_sortCombo.setSelectedIndex(1);
            if (this.m_solutionType == 1000) {
                sub = main.createVertical(0, "Percent delay time change", 0);
                sub.addComponent(this.m_textPercentMod, 0);
            }
            if (this.m_solutionType == 2000 || this.m_solutionType == 4000) {
                sub = main.createVertical(0, "Residual modification percent", 0);
                sub.addComponent(this.m_textPercentMod, 0);
                this.m_textPercentMod.setText("-100");
            }
            if (this.m_solutionType == 3000) {
                sub = main.createVertical(0, "Stack time modification percent", 0);
                sub.addComponent(this.m_textPercentMod, 0);
                this.m_textPercentMod.setText("50");
            }
            if (this.m_solutionType == 3000) {
                this.m_btnClearGeneralPicks = main.createButton("Clear current general shot/receiver pick field", this, 0);
            }
            this.m_headerCountCombo.addItem("No header plots visible");
            for (int n = 1; n <= 4; ++n) {
                this.m_headerCountCombo.addItem(String.format("%d header plot(s) visible", n));
            }
            sub = main.createVertical(0, "Header plot count", 0);
            sub.addComponent(this.m_headerCountCombo, 0);
            this.m_headerCountCombo.setSelectedIndex(2);
            this.m_headerCountCombo.addItemListener(this);
            sub = main.createVertical(3, "Group navigation", 10);
            sub.addComponent(new JLabel("Click to select group"), 0);
            JScrollPane scroll = new JScrollPane(this.m_list);
            sub.addComponent(scroll, 10);
            this.m_list.addListSelectionListener(this);
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            Tools_FontChanger.changeSizeOfFont(this.m_labelStack, 3);
            this.m_labelStack.setForeground(Color.BLUE);
            this.m_labelStack.setBorder(BorderFactory.createRaisedBevelBorder());
            return main;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected void loadUEC() {
        try {
            boolean needControlPoint;
            this.m_widget.clearUserEventConsumerList();
            PickerGizmo pg = PickerGizmo.singleton();
            pg.PickName = "FBP_User";
            boolean bl = needControlPoint = pg.LeftClickAction == PickerGizmo.LeftClickActionEnum.ControlPointAdd || pg.LeftClickAction == PickerGizmo.LeftClickActionEnum.ControlPointKill || pg.LeftClickAction == PickerGizmo.LeftClickActionEnum.ControlPointSelect;
            if (needControlPoint) {
                this.m_widget.addEventConsumer(0, this.m_lineSegmentUEC);
            } else {
                this.m_widget.addEventConsumer(0, this.m_leftClickUEC);
            }
            this.m_widget.addEventConsumer(0, this.m_rubberBandUEC);
            this.m_widget.addEventConsumer(0, this.m_middleClickUEC);
            this.m_widget.addEventConsumer(0, this.m_keyUEC);
            this.m_widget.addEventConsumer(0, this.m_mouseMoveUEC);
            this.m_widget.addEventConsumer(0, this.m_penModeUEC);
            this.m_widget.addZoomer();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleBasemap_SparseCMPSelected(Ensemble ensemble) {
    }

    @Override
    public void handleBasemap_Bin2DSelected(int bin) {
    }

    @Override
    public void handleBasemap_Bin3DSelected(int inline, int crossline) {
    }

    @Override
    public void handleBasemap_ReceiverDrag(double x, double y) {
    }

    @Override
    public void handleBasemap_ReceiverDragFinish(double x, double y) {
    }

    @Override
    public void handleBasemap_ShotDrag(double x, double y) {
    }

    @Override
    public void handleBasemap_ShotSelected(int id, int plotIndex) {
    }

    @Override
    public void handleBasemap_ShotDragFinish(double x, double y) {
    }

    @Override
    public void handleBasemap_ShotSelected(int id) {
        try {
            if (this.m_planeCombo.getSelectedIndex() != 0) {
                return;
            }
            for (int n = 0; n < this.m_groupList.size(); ++n) {
                GroupData gd = this.m_groupList.get(n);
                for (StackData sd : gd.StackArray) {
                    if (sd.ID != id) continue;
                    this.m_list.setSelectedIndex(n);
                    return;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleBasemap_ReceiverSelected(int id) {
        try {
            if (this.m_planeCombo.getSelectedIndex() != 1) {
                return;
            }
            for (int n = 0; n < this.m_groupList.size(); ++n) {
                GroupData gd = this.m_groupList.get(n);
                for (StackData sd : gd.StackArray) {
                    if (sd.ID != id) continue;
                    this.m_list.setSelectedIndex(n);
                    return;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            if (this.m_ignoreList) {
                return;
            }
            this.prepEnsemble();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadCombo() {
        try {
            if (this.m_planeCombo.getSelectedIndex() == 0) {
                ArrayList<String> cols = this.database().listOfColumnNames("Shot");
                this.m_comboPriSort.setStringArray(cols);
                this.m_comboSecSort.setStringArray(cols);
            } else {
                ArrayList<String> cols = this.database().listOfColumnNames("Receiver");
                this.m_comboPriSort.setStringArray(cols);
                this.m_comboSecSort.setStringArray(cols);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected IDatabaseConnection database() {
        return RefractionStaticsProject.singleton().geometryDatabase();
    }

    public void prepEnsemble() {
        try {
            this.prepareEnsemble();
            if (this.restackCurrentGather(false)) {
                this.prepareEnsemble();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void prepareEnsemble() {
        try {
            int colPick;
            if (this.m_widget == null) {
                return;
            }
            if (this.m_groupList.size() < 1) {
                this.m_widget.setEnsemble(0, null);
                this.m_widget.unzoom();
                return;
            }
            int index = this.m_list.getSelectedIndex();
            if (index < 0) {
                this.m_ignoreList = true;
                this.m_list.setSelectedIndex(0);
                this.m_ignoreList = false;
                index = 0;
            }
            if (index >= this.m_groupList.size()) {
                this.m_ignoreList = true;
                this.m_list.setSelectedIndex(this.m_groupList.size() - 1);
                this.m_ignoreList = false;
                index = this.m_groupList.size() - 1;
            }
            this.m_currentGroupData = this.m_groupList.get(index);
            String table = "";
            String colNameID = "";
            Table_Abstract pickTable = null;
            HashMap_Integer hash = null;
            int colPickID = 0;
            if (this.m_planeCombo.getSelectedIndex() == 0) {
                table = "Shot";
                colNameID = "ShotID";
                pickTable = this.m_shotTable;
                hash = this.m_shotMap;
                colPickID = pickTable.column_indexOfColumn(colNameID);
                colPick = pickTable.column_indexOfColumn("Pick");
            } else {
                table = "Receiver";
                colNameID = "ReceiverID";
                pickTable = this.m_receiverTable;
                hash = this.m_receiverMap;
                colPickID = pickTable.column_indexOfColumn(colNameID);
                colPick = pickTable.column_indexOfColumn("Pick");
            }
            this.m_groupEnsemble.clearTraces(false);
            EnsembleFirstBreakPickPlotData ppd = this.m_groupEnsemble.pickPlotData();
            ppd.clear();
            this.m_groupEnsemble.dictionary().clear();
            int indexID = this.m_groupEnsemble.dictionary().addEntry(table, "ID", DataType.Int);
            int indexElemID = this.m_groupEnsemble.dictionary().addEntry("Trace", colNameID, DataType.Int);
            int indexCount = this.m_groupEnsemble.dictionary().addEntry("Trace", "Count", DataType.Int);
            int indexPick = this.m_groupEnsemble.dictionary().addEntry("Trace", "FBP_User", DataType.Float);
            int indexDT = this.m_groupEnsemble.dictionary().addEntry(table, "DelayTime", DataType.Float);
            int indexSharedPickTime = this.m_groupEnsemble.dictionary().addEntry(table, "SharedPickTime", DataType.Float);
            int indexOriginalPolarity = this.m_groupEnsemble.dictionary().addEntry(table, "Original polarity", DataType.Float);
            ppd.add("FBP_User", this.m_pickColor, 7, Java2D_PointSymbol.FilledOval);
            for (StackData sd : this.m_currentGroupData.StackArray) {
                EnsembleTrace trace = this.m_groupEnsemble.addTrace();
                trace.StackTraceID = sd.ID;
                trace.header().putInt(indexID, sd.ID);
                trace.header().putInt(indexElemID, sd.ID);
                trace.header().putInt(indexCount, sd.Count);
                trace.header().putFloat(indexPick, sd.PickTime);
                trace.header().putFloat(indexDT, (float)sd.DelayTime);
                trace.header().putFloat(indexSharedPickTime, (float)sd.SharedPickTime);
                trace.header().putFloat(indexOriginalPolarity, (float)sd.OriginalPolarity);
                int row = hash.get(sd.ID);
                double pick = pickTable.getDouble(row, colPick);
                trace.header().putDouble(indexPick, pick);
                FloatArrayWrapper wrapper = trace.data();
                wrapper.setFirstSampleCoord((float)this.m_stackMinTime);
                wrapper.setSampleInterval((float)this.m_stackDigi);
                wrapper.insertArray(sd.Data, sd.Data.length);
            }
            if (this.m_planeCombo.getSelectedIndex() == 0) {
                this.shotCoords();
            } else {
                this.recCoords();
            }
            this.m_widget.DrawWiggles = true;
            this.m_widget.DrawColor = false;
            if (this.m_radioPlotType.getSelectedIndex() == 1) {
                this.m_widget.DrawColor = true;
                this.m_widget.DrawWiggles = false;
                this.m_widget.setUseGrayScale(true);
            }
            this.m_widget.setAxisType(Java2D_EnsembleAxisEnum.UniformSpacing);
            this.m_widget.setTimeLineColorAndSpacing(Color.LIGHT_GRAY, 25.0);
            this.m_widget.setVisibleCount(10000);
            this.m_widget.setEnsemble(0, this.m_groupEnsemble);
            this.m_widget.clearAndLoadWigglePaintables();
            this.m_widget.unzoom();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void recCoords() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            p.populateReceiverHeader(this.m_groupEnsemble);
            int indexOriginalPolarity = this.m_groupEnsemble.dictionary().addEntry("Receiver", "Original polarity", DataType.Float);
            int indexPolarity = this.m_groupEnsemble.dictionary().getEntryIndex("Receiver", "Polarity");
            for (int n = 0; n < this.m_groupEnsemble.traceCount(); ++n) {
                EnsembleTrace trace = this.m_groupEnsemble.trace(n);
                float op = trace.header().getFloat(indexOriginalPolarity);
                float polarity = trace.header().getFloat(indexPolarity);
                if (polarity == op) {
                    trace.data().setPolarity(1);
                    continue;
                }
                trace.data().setPolarity(-1);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void shotCoords() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            p.populateShotHeader(this.m_groupEnsemble);
            int indexOriginalPolarity = this.m_groupEnsemble.dictionary().addEntry("Shot", "Original polarity", DataType.Float);
            int indexPolarity = this.m_groupEnsemble.dictionary().getEntryIndex("Shot", "Polarity");
            for (int n = 0; n < this.m_groupEnsemble.traceCount(); ++n) {
                float polarity;
                EnsembleTrace trace = this.m_groupEnsemble.trace(n);
                float op = trace.header().getFloat(indexOriginalPolarity);
                if (op * (polarity = trace.header().getFloat(indexPolarity)) > 0.0f) {
                    trace.data().setPolarity(1);
                    continue;
                }
                trace.data().setPolarity(-1);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadGroupList() {
        try {
            this.m_ignoreList = true;
            this.m_listModel.clear();
            for (GroupData gd : this.m_groupList) {
                this.m_listModel.addElement(gd.Label);
            }
            this.m_list.setModel(this.m_listModel);
            this.m_list.setSelectedIndex(0);
            this.m_ignoreList = false;
            this.prepEnsemble();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void prepShotLineGroups() {
        try {
            String sql = "SELECT * FROM Shot WHERE KILLED = FALSE ORDER BY LineNumber, PointNumber";
            Table_Abstract table = this.database().extractTableDataUsingQuery("Shot", sql, Pecos.MaxQueryRowCount);
            int indexID = table.column_indexOfColumn("ShotID");
            int indexLine = table.column_indexOfColumn("LineNumber");
            int indexPoint = table.column_indexOfColumn("PointNumber");
            int currLineNumber = -999990001;
            GroupData groupData = null;
            for (int n = 0; n < table.row_count(); ++n) {
                int id = table.getInt(n, indexID);
                int line = table.getInt(n, indexLine);
                int point = table.getInt(n, indexPoint);
                if (!this.m_shotHash.containsKey(id)) continue;
                if (line != currLineNumber) {
                    currLineNumber = line;
                    groupData = new GroupData();
                    groupData.Label = "Line " + Integer.toString(line);
                    this.m_groupList.add(groupData);
                }
                StackData stackData = this.m_shotHash.get(id);
                if (id != stackData.ID) {
                    System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! (id != stackData.ID)");
                }
                groupData.StackArray.add(stackData);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void prepReceiverLineGroups() {
        try {
            String sql = "SELECT * FROM Receiver WHERE KILLED = FALSE ORDER BY LineNumber, PointNumber";
            Table_Abstract table = this.database().extractTableDataUsingQuery("Receiver", sql, Pecos.MaxQueryRowCount);
            int indexID = table.column_indexOfColumn("ReceiverID");
            int indexLine = table.column_indexOfColumn("LineNumber");
            int indexPoint = table.column_indexOfColumn("PointNumber");
            int currLineNumber = -999990001;
            GroupData groupData = null;
            for (int n = 0; n < table.row_count(); ++n) {
                int id = table.getInt(n, indexID);
                int line = table.getInt(n, indexLine);
                int point = table.getInt(n, indexPoint);
                if (!this.m_recHash.containsKey(id)) continue;
                if (line != currLineNumber) {
                    currLineNumber = line;
                    groupData = new GroupData();
                    groupData.Label = "Line " + Integer.toString(line);
                    this.m_groupList.add(groupData);
                }
                StackData stackData = this.m_recHash.get(id);
                if (id != stackData.ID) {
                    System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! (id != stackData.ID)");
                }
                groupData.StackArray.add(stackData);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected String getSecSort() {
        try {
            String sortSec = this.m_comboSecSort.getSelectedString();
            if (sortSec.isEmpty()) {
                return "PointNumber";
            }
            return sortSec;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "PointNumber";
        }
    }

    protected String getPriSort() {
        try {
            String sortPri = this.m_comboPriSort.getSelectedString();
            if (sortPri.isEmpty()) {
                return "LineNumber";
            }
            return sortPri;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "LineNumber";
        }
    }

    protected void prepShotCountGroups() {
        try {
            String sortPri = this.m_comboPriSort.getSelectedString();
            String sql = String.format("SELECT * FROM Shot WHERE KILLED = FALSE ORDER BY %s, %s", this.getPriSort(), this.getSecSort());
            Table_Abstract table = this.database().extractTableDataUsingQuery("Shot", sql, Pecos.MaxQueryRowCount);
            int indexID = table.column_indexOfColumn("ShotID");
            int count = Tools_Widget.extractInteger(this.m_countText, 100, 20, 10000);
            int numInGroup = 10000000;
            GroupData groupData = null;
            int counter = 1;
            for (int n = 0; n < table.row_count(); ++n) {
                int id = table.getInt(n, indexID);
                if (!this.m_shotHash.containsKey(id)) continue;
                if (numInGroup >= count) {
                    groupData = new GroupData();
                    groupData.Label = String.format("%d - %d", counter, counter + count - 1);
                    this.m_groupList.add(groupData);
                    numInGroup = 0;
                }
                StackData stackData = this.m_shotHash.get(id);
                if (id != stackData.ID) {
                    System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! (id != stackData.ID)");
                }
                groupData.StackArray.add(stackData);
                ++counter;
                ++numInGroup;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void prepReceiverCountGroups() {
        try {
            String sql = String.format("SELECT * FROM Receiver WHERE KILLED = FALSE ORDER BY %s, %s", this.getPriSort(), this.getSecSort());
            Table_Abstract table = this.database().extractTableDataUsingQuery("Receiver", sql, Pecos.MaxQueryRowCount);
            int indexID = table.column_indexOfColumn("ReceiverID");
            int count = Tools_Widget.extractInteger(this.m_countText, 100, 20, 10000);
            int numInGroup = 10000000;
            GroupData groupData = null;
            int counter = 1;
            for (int n = 0; n < table.row_count(); ++n) {
                int id = table.getInt(n, indexID);
                if (!this.m_recHash.containsKey(id)) continue;
                if (numInGroup >= count) {
                    groupData = new GroupData();
                    groupData.Label = String.format("%d - %d", counter, counter + count - 1);
                    this.m_groupList.add(groupData);
                    numInGroup = 0;
                }
                StackData stackData = this.m_recHash.get(id);
                if (id != stackData.ID) {
                    System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! (id != stackData.ID)");
                }
                groupData.StackArray.add(stackData);
                ++counter;
                ++numInGroup;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void computeInlinesAndCrosslines() {
        try {
            double y;
            double x;
            int n;
            String sql = "SELECT * FROM Shot WHERE KILLED = FALSE ORDER BY Easting, Northing";
            Table_Abstract table = this.database().extractTableDataUsingQuery("Shot", sql, Pecos.MaxQueryRowCount);
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexI = table.column_append("Inline", DataType.Int);
            int indexC = table.column_append("Crossline", DataType.Int);
            Grid3D grid = RefractionStaticsProject.singleton().getEmptyGrid3D();
            for (n = 0; n < table.row_count(); ++n) {
                x = table.getDouble(n, indexX);
                y = table.getDouble(n, indexY);
                grid.setWorldLocation(x, y);
                table.putInt(n, indexI, grid.Inline);
                table.putInt(n, indexC, grid.Crossline);
            }
            this.database().writeColumnContentsToDatabase(table, "Inline");
            this.database().writeColumnContentsToDatabase(table, "Crossline");
            sql = "SELECT * FROM Receiver WHERE KILLED = FALSE ORDER BY Easting, Northing";
            table = this.database().extractTableDataUsingQuery("Receiver", sql, Pecos.MaxQueryRowCount);
            indexX = table.column_indexOfColumn("Easting");
            indexY = table.column_indexOfColumn("Northing");
            indexI = table.column_append("Inline", DataType.Int);
            indexC = table.column_append("Crossline", DataType.Int);
            for (n = 0; n < table.row_count(); ++n) {
                x = table.getDouble(n, indexX);
                y = table.getDouble(n, indexY);
                grid.setWorldLocation(x, y);
                table.putInt(n, indexI, grid.Inline);
                table.putInt(n, indexC, grid.Crossline);
            }
            this.database().writeColumnContentsToDatabase(table, "Inline");
            this.database().writeColumnContentsToDatabase(table, "Crossline");
            this.inlinesCrosslinesInitialized = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void prepShotInlineGroups() {
        try {
            String sql = "SELECT * FROM Shot WHERE KILLED = FALSE ORDER BY Inline, Crossline";
            Table_Abstract table = this.database().extractTableDataUsingQuery("Shot", sql, Pecos.MaxQueryRowCount);
            int indexID = table.column_indexOfColumn("ShotID");
            int indexI = table.column_indexOfColumn("Inline");
            int currentInline = -9999;
            GroupData groupData = null;
            for (int n = 0; n < table.row_count(); ++n) {
                int id = table.getInt(n, indexID);
                int i = table.getInt(n, indexI);
                if (!this.m_shotHash.containsKey(id)) continue;
                if (i != currentInline) {
                    currentInline = i;
                    groupData = new GroupData();
                    groupData.Label = "Inline " + Integer.toString(i);
                    this.m_groupList.add(groupData);
                }
                StackData stackData = this.m_shotHash.get(id);
                if (id != stackData.ID) {
                    System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! (id != stackData.ID)");
                }
                groupData.StackArray.add(stackData);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void prepShotCrosslineGroups() {
        try {
            String sql = "SELECT * FROM Shot WHERE KILLED = FALSE ORDER BY Crossline, Inline";
            Table_Abstract table = this.database().extractTableDataUsingQuery("Shot", sql, Pecos.MaxQueryRowCount);
            int indexID = table.column_indexOfColumn("ShotID");
            int indexC = table.column_indexOfColumn("Crossline");
            int currentCrossline = -9999;
            GroupData groupData = null;
            for (int n = 0; n < table.row_count(); ++n) {
                int id = table.getInt(n, indexID);
                int c = table.getInt(n, indexC);
                if (!this.m_shotHash.containsKey(id)) continue;
                if (c != currentCrossline) {
                    currentCrossline = c;
                    groupData = new GroupData();
                    groupData.Label = "Crossline " + Integer.toString(c);
                    this.m_groupList.add(groupData);
                }
                StackData stackData = this.m_shotHash.get(id);
                if (id != stackData.ID) {
                    System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! (id != stackData.ID)");
                }
                groupData.StackArray.add(stackData);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void prepReceiverInlineGroups() {
        try {
            String sql = "SELECT * FROM Receiver WHERE KILLED = FALSE ORDER BY Inline, Crossline";
            Table_Abstract table = this.database().extractTableDataUsingQuery("Receiver", sql, Pecos.MaxQueryRowCount);
            int indexID = table.column_indexOfColumn("ReceiverID");
            int indexI = table.column_indexOfColumn("Inline");
            int currentInline = -9999;
            GroupData groupData = null;
            for (int n = 0; n < table.row_count(); ++n) {
                int id = table.getInt(n, indexID);
                int i = table.getInt(n, indexI);
                if (!this.m_recHash.containsKey(id)) continue;
                if (i != currentInline) {
                    currentInline = i;
                    groupData = new GroupData();
                    groupData.Label = "Inline " + Integer.toString(i);
                    this.m_groupList.add(groupData);
                }
                StackData stackData = this.m_recHash.get(id);
                if (id != stackData.ID) {
                    System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! (id != stackData.ID)");
                }
                groupData.StackArray.add(stackData);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void prepReceiverCrosslineGroups() {
        try {
            String sql = "SELECT * FROM Receiver WHERE KILLED = FALSE ORDER BY Crossline, Inline";
            Table_Abstract table = this.database().extractTableDataUsingQuery("Receiver", sql, Pecos.MaxQueryRowCount);
            int indexID = table.column_indexOfColumn("ReceiverID");
            int indexC = table.column_indexOfColumn("Crossline");
            int currentCrossline = -9999;
            GroupData groupData = null;
            for (int n = 0; n < table.row_count(); ++n) {
                int id = table.getInt(n, indexID);
                int c = table.getInt(n, indexC);
                if (!this.m_recHash.containsKey(id)) continue;
                if (c != currentCrossline) {
                    currentCrossline = c;
                    groupData = new GroupData();
                    groupData.Label = "Crossline " + Integer.toString(c);
                    this.m_groupList.add(groupData);
                }
                StackData stackData = this.m_recHash.get(id);
                if (id != stackData.ID) {
                    System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! (id != stackData.ID)");
                }
                groupData.StackArray.add(stackData);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void prepGrouping() {
        try {
            this.reloadCombo();
            this.m_groupList.clear();
            if (!this.inlinesCrosslinesInitialized) {
                this.computeInlinesAndCrosslines();
            }
            if (this.m_planeCombo.getSelectedIndex() == 0) {
                if (this.m_widget != null) {
                    if (this.m_solutionType == 1000) {
                        this.m_widget.setHeaderPlotHeader(0, 0, "Shot", "DelayTime");
                    }
                    if (this.m_solutionType == 3000) {
                        this.m_widget.setHeaderPlotHeader(0, 0, "Shot", "SharedPickTime");
                    }
                }
                if (this.m_sortCombo.getSelectedIndex() == 0) {
                    this.prepShotLineGroups();
                } else if (this.m_sortCombo.getSelectedIndex() == 1) {
                    this.prepShotCountGroups();
                } else if (this.m_sortCombo.getSelectedIndex() == 2) {
                    this.prepShotInlineGroups();
                } else {
                    this.prepShotCrosslineGroups();
                }
                if (this.m_widget != null) {
                    this.m_widget.setHeaderTableColumn(0, 0, "Shot", "ID");
                    this.m_widget.setHeaderTableColumn(0, 1, "Trace", "Count");
                }
                if (this.m_basemapWidget != null) {
                    this.m_basemapWidget.setPickPlane(PickPlaneEnum.Shot);
                }
            } else {
                if (this.m_widget != null) {
                    if (this.m_solutionType == 1000) {
                        this.m_widget.setHeaderPlotHeader(0, 0, "Receiver", "DelayTime");
                    }
                    if (this.m_solutionType == 3000) {
                        this.m_widget.setHeaderPlotHeader(0, 0, "Receiver", "SharedPickTime");
                    }
                }
                if (this.m_sortCombo.getSelectedIndex() == 0) {
                    this.prepReceiverLineGroups();
                } else if (this.m_sortCombo.getSelectedIndex() == 1) {
                    this.prepReceiverCountGroups();
                } else if (this.m_sortCombo.getSelectedIndex() == 2) {
                    this.prepReceiverInlineGroups();
                } else {
                    this.prepReceiverCrosslineGroups();
                }
                if (this.m_widget != null) {
                    this.m_widget.setHeaderTableColumn(0, 0, "Receiver", "ID");
                    this.m_widget.setHeaderTableColumn(0, 1, "Trace", "Count");
                }
                if (this.m_basemapWidget != null) {
                    this.m_basemapWidget.setPickPlane(PickPlaneEnum.Receiver);
                }
            }
            this.loadGroupList();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addTrace(HashMap_Integers<StackData> hash, EnsembleTrace trace, int id, double delayTime, double polarity) {
        try {
            this.addTrace(hash, trace, id, delayTime, polarity, 0.0);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addTrace(HashMap_Integers<StackData> hash, EnsembleTrace trace, int id, double delayTime, double polarity, double generalPick) {
        try {
            if (this.m_tempArray.length != trace.data().length()) {
                this.m_tempArray = new float[trace.data().length()];
            }
            if (!hash.containsKey(id)) {
                return;
            }
            trace.data().copyToArray(this.m_tempArray);
            double t0 = trace.data().getFirstSampleCoord_WithShifts();
            double digi = trace.data().getSampleInterval();
            double invDigi = 1.0 / digi;
            StackData stackData = hash.get(id);
            if (stackData.Count < 1) {
                stackData.SharedPickTime = generalPick;
                stackData.OriginalPolarity = polarity;
                stackData.DelayTime = delayTime;
            }
            double outputTime = this.m_stackMinTime;
            boolean shitty = false;
            for (int n = 0; n < stackData.Data.length; ++n) {
                if (outputTime > t0) {
                    double inputSample = (outputTime - t0) * invDigi;
                    int lowerSampleIndex = (int)inputSample;
                    int upperSampleIndex = lowerSampleIndex + 1;
                    double s = inputSample - (double)lowerSampleIndex;
                    if (lowerSampleIndex >= 0 && lowerSampleIndex < this.m_tempArray.length) {
                        stackData.Data[n] = stackData.Data[n] + (float)(1.0 - s) * this.m_tempArray[lowerSampleIndex];
                    }
                    if (upperSampleIndex >= 0 && upperSampleIndex < this.m_tempArray.length) {
                        stackData.Data[n] = stackData.Data[n] + (float)s * this.m_tempArray[upperSampleIndex];
                    }
                    if (Float.isNaN(stackData.Data[n])) {
                        shitty = true;
                    }
                    if (Float.isInfinite(stackData.Data[n])) {
                        shitty = true;
                    }
                }
                outputTime += this.m_stackDigi;
            }
            ++stackData.Count;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addEnsembleToStacks_Branch(Ensemble ensemble, int branch, boolean addShot, boolean addRec) {
        try {
            String colNameDT = Pecos.getColNameDT(this.m_stackBranch);
            int indexBranch = ensemble.dictionary().getEntryIndex("Trace", "Branch_DelayTime");
            int indexShotID = ensemble.dictionary().getEntryIndex("Trace", "ShotID");
            int indexRecID = ensemble.dictionary().getEntryIndex("Trace", "ReceiverID");
            int indexShotDT = ensemble.dictionary().getEntryIndex("Shot", colNameDT);
            int indexRecDT = ensemble.dictionary().getEntryIndex("Receiver", colNameDT);
            int indexShotPolarity = ensemble.dictionary().getEntryIndex("Shot", "Polarity");
            int indexRecPolarity = ensemble.dictionary().getEntryIndex("Receiver", "Polarity");
            int indexShotKilled = ensemble.dictionary().getEntryIndex("Shot", "Killed");
            int indexRecKilled = ensemble.dictionary().getEntryIndex("Receiver", "Killed");
            int indexTraceKilled = -9999;
            if (ensemble.dictionary().containsEntry("Trace", "Killed")) {
                indexTraceKilled = ensemble.dictionary().getEntryIndex("Trace", "Killed");
            }
            int num = 0;
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                int b = trace.header().getInt(indexBranch);
                if (b != branch || !trace.traceOkay()) continue;
                int shotID = trace.header().getInt(indexShotID);
                int recID = trace.header().getInt(indexRecID);
                double shotDT = trace.header().getDouble(indexShotDT);
                double recDT = trace.header().getDouble(indexRecDT);
                double shotPolarity = trace.header().getDouble(indexShotPolarity);
                double recPolarity = trace.header().getDouble(indexRecPolarity);
                int killed = 0;
                if (indexTraceKilled >= 0) {
                    killed = trace.header().getInt(indexTraceKilled);
                }
                boolean killedShot = trace.header().getBool(indexShotKilled);
                boolean killedRec = trace.header().getBool(indexRecKilled);
                if (shotID == 1552) {
                    ++num;
                }
                if (killed != 0 || killedShot || killedRec) continue;
                if (addRec) {
                    this.addTrace(this.m_recHash, trace, recID, recDT, recPolarity);
                }
                if (!addShot) continue;
                this.addTrace(this.m_shotHash, trace, shotID, shotDT, shotPolarity);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addEnsembleToStacks_OffsetLimited(Ensemble ensemble, boolean includeGeneralPick) {
        try {
            int indexShotID = ensemble.dictionary().getEntryIndex("Trace", "ShotID");
            int indexRecID = ensemble.dictionary().getEntryIndex("Trace", "ReceiverID");
            int indexShotPolarity = ensemble.dictionary().getEntryIndex("Shot", "Polarity");
            int indexRecPolarity = ensemble.dictionary().getEntryIndex("Receiver", "Polarity");
            int indexShotGP = -9999;
            int indexRecGP = -9999;
            if (includeGeneralPick && ensemble.dictionary().containsEntry("Shot", "SharedPickTime")) {
                indexShotGP = ensemble.dictionary().getEntryIndex("Shot", "SharedPickTime");
                indexRecGP = ensemble.dictionary().getEntryIndex("Receiver", "SharedPickTime");
            }
            int indexShotKilled = ensemble.dictionary().getEntryIndex("Shot", "Killed");
            int indexRecKilled = ensemble.dictionary().getEntryIndex("Receiver", "Killed");
            int indexTraceKilled = -9999;
            if (ensemble.dictionary().containsEntry("Trace", "Killed")) {
                indexTraceKilled = ensemble.dictionary().getEntryIndex("Trace", "Killed");
            }
            boolean num = false;
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                if (!trace.traceOkay()) continue;
                int shotID = trace.header().getInt(indexShotID);
                int recID = trace.header().getInt(indexRecID);
                double shotPolarity = trace.header().getDouble(indexShotPolarity);
                double recPolarity = trace.header().getDouble(indexRecPolarity);
                int killed = 0;
                if (indexTraceKilled >= 0) {
                    killed = trace.header().getInt(indexTraceKilled);
                }
                boolean killedShot = trace.header().getBool(indexShotKilled);
                boolean killedRec = trace.header().getBool(indexRecKilled);
                double shotGP = 0.0;
                double recGP = 0.0;
                if (indexShotGP >= 0) {
                    shotGP = trace.header().getDouble(indexShotGP);
                    recGP = trace.header().getDouble(indexRecGP);
                }
                if (killed != 0 || killedShot || killedRec) continue;
                this.addTrace(this.m_recHash, trace, recID, 0.0, recPolarity, recGP);
                this.addTrace(this.m_shotHash, trace, shotID, 0.0, shotPolarity, shotGP);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void createHashStructure(HashMap_Integers<StackData> hash, Table_Abstract table, String colNameID, boolean usePoly) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            Java2D_Polygon poly = null;
            if (usePoly) {
                poly = project.polygon();
            }
            int indexID = table.column_indexOfColumn(colNameID);
            int indexKilled = table.column_indexOfColumn("Killed");
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            for (int n = 0; n < table.row_count(); ++n) {
                if (table.getBool(n, indexKilled)) continue;
                int id = table.getInt(n, indexID);
                double x = table.getDouble(n, indexX);
                double y = table.getDouble(n, indexY);
                boolean ok = true;
                if (poly != null) {
                    ok = poly.contains(x, y);
                }
                if (!ok) continue;
                StackData sd = new StackData();
                sd.Count = 0;
                sd.ID = id;
                sd.Data = new float[this.m_stackLength];
                for (int s = 0; s < sd.Data.length; ++s) {
                    sd.Data[s] = 0.0f;
                }
                hash.put(sd, id);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void createStack() {
        try {
            Object tomo;
            this.m_beginStackButton.setEnabled(false);
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (this.m_solutionType == 1000) {
                this.m_stackBranch = this.m_branchCombo.getSelectedIndex() + 1;
                if (this.m_stackBranch > project.delayTimeData().branchAssignment().maxBranch()) {
                    JOptionPane.showMessageDialog(null, "Selected branch not valid", "Cannot create stack", 0);
                    return;
                }
            }
            if (this.m_solutionType == 2000 && (tomo = project.getEikonal3D()) == null) {
                JOptionPane.showMessageDialog(null, "Open a tomography model first", "Cannot create stack", 0);
                return;
            }
            if (this.m_solutionType == 4000 && (tomo = project.getTomo_VNS()) == null) {
                JOptionPane.showMessageDialog(null, "Open a VNS modle first", "Cannot create stack", 0);
                return;
            }
            if (this.m_solutionType == 3000) {
                // empty if block
            }
            long startTime = System.currentTimeMillis();
            this.m_stackMinTime = Tools_Widget.extractDouble(this.m_minTimeText, -300.0, -2000.0, -100.0);
            this.m_stackMaxTime = Tools_Widget.extractDouble(this.m_maxTimeText, 300.0, 100.0, 8000.0);
            this.m_stackDigi = 4.0;
            this.m_stackLength = 1 + (int)((this.m_stackMaxTime - this.m_stackMinTime) / this.m_stackDigi);
            this.m_stackMaxTime = this.m_stackMinTime + this.m_stackDigi * (double)(this.m_stackLength - 1);
            boolean usePoly = this.m_chkStackInsidePolygon.isSelected();
            boolean zeroMean = this.m_chkForceZeroMean.isSelected();
            usePoly = usePoly && project.polygon() != null;
            this.m_shotHash.clear();
            this.m_recHash.clear();
            this.createHashStructure(this.m_shotHash, project.shotTable(), "ShotID", usePoly);
            this.createHashStructure(this.m_recHash, project.receiverTable(), "ReceiverID", usePoly);
            double minOffset = Tools_Widget.extractDouble(this.m_minOffsetText, 1000.0, 0.0, 20000.0);
            double maxOffset = Tools_Widget.extractDouble(this.m_maxOffsetText, 1000.0, minOffset + 100.0, minOffset + 20000.0);
            long traceCount = project.traceTableWrapper().traceTable().rowCount();
            this.m_progress.setMaximum((int)(traceCount / 100L));
            int chunkCount = 10000;
            Ensemble ensemble = new Ensemble();
            this.m_sequence.getParametersFromWidgets();
            this.m_listModel_RecKills = new DefaultListModel();
            this.m_list_RecKills.setModel(this.m_listModel_RecKills);
            this.m_listModel_ShotKills = new DefaultListModel();
            this.m_list_ShotKills.setModel(this.m_listModel_ShotKills);
            this.m_sequenceLastStack = this.m_sequence.newClone(true);
            Tools_EnsembleWorker.save(this.m_sequenceLastStack, this.m_sequenceLastStackFileName);
            RefractionStaticsProject.singleton().prepSeismicFilesForScanning();
            for (long startIndex = 0L; startIndex < traceCount; startIndex += (long)chunkCount) {
                this.m_progress.setValue((int)(startIndex / 100L));
                this.m_progress.paintImmediately(0, 0, 400, 44);
                double percent = 100.0 * (double)startIndex / (double)traceCount;
                System.out.println("Percent traces scanned = " + percent);
                project.ensemble_Sequence(ensemble, startIndex, chunkCount, true);
                if (zeroMean) {
                    Tools_Ensemble.removeAverageValue(ensemble);
                }
                if (this.m_solutionType == 2000 || this.m_solutionType == 3000) {
                    Tools_Ensemble.deleteTracesOutsideRange(ensemble, minOffset, maxOffset, "Trace", "Offset");
                }
                Ensemble e = this.m_sequence.work(ensemble);
                if (this.m_solutionType == 1000) {
                    this.addEnsembleToStacks_Branch(e, this.m_stackBranch, true, true);
                }
                if (this.m_solutionType == 2000 || this.m_solutionType == 4000) {
                    this.addEnsembleToStacks_OffsetLimited(e, false);
                }
                if (this.m_solutionType != 3000) continue;
                this.addEnsembleToStacks_OffsetLimited(e, true);
            }
            RefractionStaticsProject.singleton().finishedSeismicFileScanning();
            this.m_progress.setValue(0);
            for (StackData stackData : this.m_recHash.getValues()) {
                float w = 1.0f / (1.0E-6f + (float)stackData.Count);
                int n = 0;
                while (n < stackData.Data.length) {
                    int n2 = n++;
                    stackData.Data[n2] = stackData.Data[n2] * w;
                }
            }
            boolean z = false;
            for (StackData stackData : this.m_shotHash.getValues()) {
                if (stackData.ID == 1552) {
                    z = true;
                }
                float w = 1.0f / (1.0E-6f + (float)stackData.Count);
                int n = 0;
                while (n < stackData.Data.length) {
                    int n3 = n++;
                    stackData.Data[n3] = stackData.Data[n3] * w;
                }
            }
            this.save(this.m_shotFileName, this.m_shotHash);
            this.save(this.m_recFileName, this.m_recHash);
            this.m_labelStack.setText("Branch " + Integer.toString(this.m_stackBranch));
            try {
                this.m_geometryConn.executeUpdateStatement("UPDATE RECEIVER SET PICK = -9999");
                this.m_geometryConn.executeUpdateStatement("UPDATE SHOT SET PICK = -9999");
                this.m_receiverTable.column_setToValue(this.m_receiverMap_ColPick, -9999.0);
                this.m_shotTable.column_setToValue(this.m_shotMap_ColPick, -9999.0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                this.m_geometryConn.executeUpdateStatement("UPDATE RECEIVER SET EXTERNALMOD = FALSE");
                this.m_geometryConn.executeUpdateStatement("UPDATE SHOT SET EXTERNALMOD = FALSE");
                this.m_receiverTable.column_setToValue(this.m_receiverMap_ColMod, 0.0);
                this.m_shotTable.column_setToValue(this.m_shotMap_ColMod, 0.0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.prepGrouping();
            long l = System.currentTimeMillis();
            String runTimeString = Tools_Strings.runTimeMessage((int)(l - startTime) / 1000);
            System.out.println("Stack creation time: " + runTimeString);
            this.m_beginStackButton.setEnabled(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        try {
            RefractionStaticsProject.singleton().finishedSeismicFileScanning();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected HashMap_Integers<StackData> read(String fileName) {
        try {
            HashMap_Integers<StackData> hash = new HashMap_Integers<StackData>();
            if (!Tools_FileSystem.exists_file(fileName)) {
                return hash;
            }
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            int magic = file.readInt();
            if (magic != this.m_magic) {
                return hash;
            }
            int version = file.readInt();
            if (version == 1000) {
                this.m_stackMinTime = file.readDouble();
                this.m_stackMaxTime = file.readDouble();
                this.m_stackDigi = file.readDouble();
                this.m_stackLength = file.readInt();
                this.m_stackBranch = file.readInt();
                int num = file.readInt();
                for (int n = 0; n < num; ++n) {
                    StackData data = new StackData();
                    data.FileOffset = file.getFilePointer();
                    data.read(file);
                    hash.put(data, data.ID);
                }
            }
            file.close();
            this.m_labelStack.setText("Branch " + Integer.toString(this.m_stackBranch));
            return hash;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return new HashMap_Integers<StackData>();
        }
    }

    protected void save(String fileName, HashMap_Integers<StackData> hash) {
        try {
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            file.writeInt(this.m_magic);
            int version = 1000;
            file.writeInt(version);
            if (version == 1000) {
                file.writeDouble(this.m_stackMinTime);
                file.writeDouble(this.m_stackMaxTime);
                file.writeDouble(this.m_stackDigi);
                file.writeInt(this.m_stackLength);
                file.writeInt(this.m_stackBranch);
                file.writeInt(hash.size());
                for (StackData stackData : hash.getValues()) {
                    stackData.FileOffset = file.getFilePointer();
                    stackData.save(file);
                }
            }
            file.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void saveStackData(String fileName, StackData stackData) {
        try {
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            file.seek(stackData.FileOffset);
            stackData.save(file);
            file.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void clearGeneralPicks() {
        try {
            int index;
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            String sql = "";
            if (project.receiverTable().column_exists("SharedPickTime")) {
                index = project.receiverTable().column_indexOfColumn("SharedPickTime");
                project.receiverTable().column_setToValue(index, 0.0);
                sql = String.format("UPDATE %s SET %s = 0", "Receiver", "SharedPickTime");
                project.geometryDatabase().executeUpdateStatement(sql);
            }
            if (project.shotTable().column_exists("SharedPickTime")) {
                index = project.shotTable().column_indexOfColumn("SharedPickTime");
                project.shotTable().column_setToValue(index, 0.0);
                sql = String.format("UPDATE %s SET %s = 0", "Shot", "SharedPickTime");
                project.geometryDatabase().executeUpdateStatement(sql);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnUnkillSelectedShots) {
                this.unkillShots();
                return;
            }
            if (e.getSource() == this.m_btnUnkillSelectedRecs) {
                this.unkillRecs();
                return;
            }
            if ((e.getSource() == this.m_chkAutoRestackRecs || e.getSource() == this.m_chkAutoRestackShots) && this.restackCurrentGather(false)) {
                this.prepEnsemble();
            }
            if (e.getSource() == this.m_btnClearGeneralPicks) {
                this.clearGeneralPicks();
                return;
            }
            if (e.getSource() == this.m_beginStackButton) {
                this.createStack();
                return;
            }
            if (e.getSource() == this.m_btnRestoreComputedResiduals) {
                TomoEikonal3D tomo = RefractionStaticsProject.singleton().getEikonal3D();
                if (tomo != null) {
                    tomo.restoreComputedResiduals();
                }
                return;
            }
            if (e.getSource() == this.m_btnConvertResidualsToZeroMean) {
                TomoEikonal3D tomo = RefractionStaticsProject.singleton().getEikonal3D();
                if (tomo != null) {
                    tomo.convertResidualsToZeroMean();
                }
                return;
            }
            if (e.getSource() == this.m_applyGroupButton) {
                this.prepGrouping();
                return;
            }
            if (e.getSource() == this.m_colorButton) {
                JDialog dialog = new JDialog();
                this.m_pickColor = JColorChooser.showDialog(dialog, "Pick a color", Color.BLUE);
                this.m_colorButton.setBackground(this.m_pickColor);
                this.savePickColor();
                this.prepareEnsemble();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (e.getSource() == this.m_headerCountCombo) {
                int count = this.m_headerCountCombo.getSelectedIndex();
                this.m_widget.setHeaderPlotVisibleCount(0, count);
            }
            if (e.getSource() == this.m_sortCombo || e.getSource() == this.m_planeCombo) {
                this.m_gridGroup.setEnabled(this.m_sortCombo.getSelectedIndex() == 1);
                this.prepGrouping();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void setShotMod(int id) {
        try {
            int row = this.m_shotMap.get(id);
            assert (id == this.m_shotTable.getInt(row, this.m_shotMap_ColID));
            this.m_shotTable.putBool(row, this.m_shotMap_ColMod, true);
            String sql = String.format("UPDATE SHOT SET EXTERNALMOD = TRUE WHERE SHOTID = %d", id);
            this.m_geometryConn.executeUpdateStatement(sql);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void setRecMod(int id) {
        try {
            int row = this.m_receiverMap.get(id);
            assert (id == this.m_receiverTable.getInt(row, this.m_receiverMap_ColID));
            this.m_receiverTable.putBool(row, this.m_receiverMap_ColMod, true);
            String sql = String.format("UPDATE RECEIVER SET EXTERNALMOD = TRUE WHERE RECEIVERID = %d", id);
            this.m_geometryConn.executeUpdateStatement(sql);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void forceRestack(int id) {
        try {
            if (this.m_planeCombo.getSelectedIndex() == 0) {
                this.setShotMod(id);
            } else {
                this.setRecMod(id);
            }
            if (this.restackCurrentGather(true)) {
                this.prepEnsemble();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void geomCorrection(int id) {
        try {
            if (this.m_planeCombo.getSelectedIndex() == 0) {
                // empty if block
            }
            this.restackCurrentGather(true);
            this.prepEnsemble();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean restackRec(int id) {
        try {
            int row = this.m_receiverMap.get(id);
            this.m_receiverTable.putBool(row, this.m_receiverMap_ColMod, false);
            String sql = String.format("UPDATE receiver SET EXTERNALMOD = FALSE WHERE receiverID = %d", id);
            this.m_geometryConn.executeUpdateStatement(sql);
            this.m_recHash.get(id).clear();
            this.m_tempEnsembleA.clearTraces(false);
            RefractionStaticsProject.singleton().ensemble_Receiver(this.m_tempEnsembleA, id, true);
            this.m_tempEnsembleB = this.m_sequenceLastStack.work(this.m_tempEnsembleA);
            this.addEnsembleToStacks_Branch(this.m_tempEnsembleB, this.m_stackBranch, false, true);
            this.saveStackData(this.m_recFileName, this.m_recHash.get(id));
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected boolean restackShot(int id) {
        try {
            int row = this.m_shotMap.get(id);
            this.m_shotTable.putBool(row, this.m_shotMap_ColMod, false);
            String sql = String.format("UPDATE SHOT SET EXTERNALMOD = FALSE WHERE SHOTID = %d", id);
            this.m_geometryConn.executeUpdateStatement(sql);
            this.m_shotHash.get(id).clear();
            this.m_tempEnsembleA.clearTraces(false);
            RefractionStaticsProject.singleton().ensemble_Shot(this.m_tempEnsembleA, id, true);
            this.m_tempEnsembleB = this.m_sequenceLastStack.work(this.m_tempEnsembleA);
            this.addEnsembleToStacks_Branch(this.m_tempEnsembleB, this.m_stackBranch, true, false);
            this.saveStackData(this.m_shotFileName, this.m_shotHash.get(id));
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected boolean restackCurrentShotGather(boolean ignoreCheckBoxes) {
        try {
            boolean ok;
            boolean checkOK = this.m_chkAutoRestackShots.isSelected() || ignoreCheckBoxes;
            boolean bl = ok = this.m_planeCombo.getSelectedIndex() == 0 && checkOK;
            if (!ok) {
                return false;
            }
            boolean restacked = false;
            if (this.m_currentGroupData == null) {
                return false;
            }
            if (this.m_currentGroupData.StackArray == null) {
                return false;
            }
            for (StackData sd : this.m_currentGroupData.StackArray) {
                int row = this.m_shotMap.get(sd.ID);
                if (!this.m_shotTable.getBool(row, this.m_shotMap_ColMod)) continue;
                restacked = restacked || this.restackShot(sd.ID);
            }
            return restacked;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected boolean restackCurrentRecGather(boolean ignoreCheckBoxes) {
        try {
            boolean ok;
            boolean checkOK = this.m_chkAutoRestackRecs.isSelected() || ignoreCheckBoxes;
            boolean bl = ok = this.m_planeCombo.getSelectedIndex() == 1 && checkOK;
            if (!ok) {
                return false;
            }
            boolean restacked = false;
            if (this.m_currentGroupData == null) {
                return false;
            }
            if (this.m_currentGroupData.StackArray == null) {
                return false;
            }
            for (StackData sd : this.m_currentGroupData.StackArray) {
                int row = this.m_receiverMap.get(sd.ID);
                if (!this.m_receiverTable.getBool(row, this.m_receiverMap_ColMod)) continue;
                restacked = restacked || this.restackRec(sd.ID);
            }
            return restacked;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected boolean restackCurrentGather(boolean ignoreCheckBoxes) {
        try {
            return this.restackCurrentShotGather(ignoreCheckBoxes) || this.restackCurrentRecGather(ignoreCheckBoxes);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            if (message == Messenger.Message.ReceiverKilled || message == Messenger.Message.ShotKilled) {
                this.prepEnsemble();
                return;
            }
            if (message == Messenger.Message.ReceiverGeometryChanged || message == Messenger.Message.ReceiverDelayTimeChanged) {
                int id = Messenger.receiverID();
                this.setRecMod(id);
                if (this.restackCurrentGather(false)) {
                    this.prepEnsemble();
                }
                return;
            }
            if (message == Messenger.Message.ShotGeometryChanged || message == Messenger.Message.ShotDelayTimeChanged) {
                int id = Messenger.shotID();
                this.setShotMod(id);
                if (this.restackCurrentGather(false)) {
                    this.prepEnsemble();
                }
                return;
            }
            if (message == Messenger.Message.ShotPolarityFlipped) {
                this.shotCoords();
                this.m_widget.forcePaintAll();
                return;
            }
            if (message == Messenger.Message.ReceiverPolarityFlipped) {
                this.recCoords();
                this.m_widget.forcePaintAll();
                return;
            }
            if (message == Messenger.Message.TraceSelected || message == Messenger.Message.ReceiverSelected || message == Messenger.Message.ShotSelected) {
                this.m_widget.forcePaintAll();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void handleMouseMoveUEC() {
        try {
            this.m_txtMouseSelID.setText("");
            this.m_txtMouseSelLine.setText("");
            this.m_txtMouseSelPoint.setText("");
            this.m_txtMouseSelIndex.setText("");
            PickerGizmo pg = PickerGizmo.singleton();
            pg.PickName = "FBP_User";
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            int nearestID = -1;
            int minDist = 1000;
            try {
                for (int n = 0; n < this.m_groupEnsemble.traceCount(); ++n) {
                    EnsembleTrace t = this.m_groupEnsemble.trace(n);
                    int dist = Math.abs(this.m_mouseMoveUEC.PixelX - t.PlotData.PixelX);
                    if (dist >= minDist || !t.PlotData.Visible) continue;
                    nearestID = t.StackTraceID;
                    minDist = dist;
                }
            }
            catch (Exception err) {
                err.printStackTrace();
            }
            if (nearestID < 0) {
                return;
            }
            if (this.m_planeCombo.getSelectedIndex() == 0) {
                this.updateMouse(p.shotTable(), p.shotMap(), nearestID);
            } else {
                this.updateMouse(p.receiverTable(), p.receiverMap(), nearestID);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void updateMouse(Table_Abstract table, HashMap_Integer map, int id) {
        try {
            int row = map.get(id);
            int indexID = table.column_indexOfColumn(table.name() + "ID");
            int indexLine = table.column_indexOfColumn("LineNumber");
            int indexPoint = table.column_indexOfColumn("PointNumber");
            int indexIndex = table.column_indexOfColumn("PointIndex");
            this.m_txtMouseSelID.setText(table.getString(row, indexID));
            this.m_txtMouseSelLine.setText(table.getString(row, indexLine));
            this.m_txtMouseSelPoint.setText(table.getString(row, indexPoint));
            this.m_txtMouseSelIndex.setText(table.getString(row, indexIndex));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void handleKeyUEC() {
        try {
            boolean isFlag;
            int index;
            PickerGizmo pg = PickerGizmo.singleton();
            pg.PickName = "FBP_User";
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            int nearestID = -1;
            int minDist = 1000;
            EnsembleTrace nearestTrace = null;
            try {
                for (int n = 0; n < this.m_groupEnsemble.traceCount(); ++n) {
                    EnsembleTrace t = this.m_groupEnsemble.trace(n);
                    int dist = Math.abs(this.m_keyUEC.PixelX - t.PlotData.PixelX);
                    if (dist >= minDist || !t.PlotData.Visible) continue;
                    nearestID = t.StackTraceID;
                    minDist = dist;
                    nearestTrace = t;
                }
            }
            catch (Exception err) {
                err.printStackTrace();
            }
            if (this.m_keyUEC.EscapePressed) {
                if (nearestID >= 0) {
                    if (this.m_planeCombo.getSelectedIndex() == 0) {
                        Messenger.broadcastShotSelected(this, nearestID);
                    } else {
                        Messenger.broadcastReceiverSelected(this, nearestID);
                    }
                }
                return;
            }
            if (pg.keyOff(this.m_keyUEC)) {
                return;
            }
            if (pg.keyPriorEnsemble(this.m_keyUEC) || pg.keyPriorGroup(this.m_keyUEC)) {
                index = this.m_list.getSelectedIndex();
                if (index <= 0) {
                    return;
                }
                this.m_ignoreList = true;
                this.m_list.setSelectedIndex(index - 1);
                this.m_ignoreList = false;
                this.prepEnsemble();
                return;
            }
            if (pg.keyNextEnsemble(this.m_keyUEC) || pg.keyNextGroup(this.m_keyUEC)) {
                index = this.m_list.getSelectedIndex();
                if (index >= this.m_groupList.size() - 1) {
                    return;
                }
                this.m_ignoreList = true;
                this.m_list.setSelectedIndex(index + 1);
                this.m_ignoreList = false;
                this.prepEnsemble();
                return;
            }
            if (pg.isKeyAction(this.m_keyUEC, PickerGizmo.KeyActionEnum.RestackShotRec)) {
                this.forceRestack(nearestID);
                return;
            }
            if (pg.isKeyAction(this.m_keyUEC, PickerGizmo.KeyActionEnum.GeomCorrection)) {
                this.geomCorrection(nearestID);
                return;
            }
            if (pg.isKeyAction(this.m_keyUEC, PickerGizmo.KeyActionEnum.FlipPolarity)) {
                if (nearestID >= 0) {
                    if (this.m_planeCombo.getSelectedIndex() == 0) {
                        p.flipShotPolarity(nearestID);
                    } else {
                        p.flipReceiverPolarity(nearestID);
                    }
                }
                return;
            }
            boolean bl = isFlag = pg.isKeyAction(this.m_keyUEC, PickerGizmo.KeyActionEnum.SetFlag0) || pg.isKeyAction(this.m_keyUEC, PickerGizmo.KeyActionEnum.SetFlag1) || pg.isKeyAction(this.m_keyUEC, PickerGizmo.KeyActionEnum.SetFlag2) || pg.isKeyAction(this.m_keyUEC, PickerGizmo.KeyActionEnum.SetFlag3) || pg.isKeyAction(this.m_keyUEC, PickerGizmo.KeyActionEnum.SetFlag4);
            if (isFlag && nearestID >= 0) {
                PickerGizmo.KeyActionEnum actionUEC = PickerGizmo.singleton().getKeyActionEnum(this.m_keyUEC);
                int flag = actionUEC.ordinal() - PickerGizmo.KeyActionEnum.SetFlag0.ordinal();
                if (nearestID >= 0) {
                    if (this.m_planeCombo.getSelectedIndex() == 0) {
                        p.setShotFlag(nearestID, flag);
                        int headerIndex = this.m_groupEnsemble.dictionary().getEntryIndex("Shot", "Flag");
                        nearestTrace.header().putInt(headerIndex, flag);
                    } else {
                        p.setReceiverFlag(nearestID, flag);
                        int headerIndex = this.m_groupEnsemble.dictionary().getEntryIndex("Receiver", "Flag");
                        nearestTrace.header().putInt(headerIndex, flag);
                    }
                    this.m_widget.repaintAll();
                }
                return;
            }
            if (pg.isKeyAction(this.m_keyUEC, PickerGizmo.KeyActionEnum.KillTrace)) {
                if (nearestID >= 0) {
                    if (this.m_planeCombo.getSelectedIndex() == 0) {
                        this.handleKillShot(nearestID);
                    } else {
                        this.handleKillRec(nearestID);
                    }
                }
                return;
            }
            if (pg.handleKey(this.m_keyUEC, this.m_groupEnsemble, this.m_groupEnsemble, this.m_widget.transform(0), true)) {
                this.handlePicksModified();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void unkillRecs() {
        try {
            int index = this.m_list_RecKills.getSelectedIndex();
            if (index < 0 || index >= this.m_listModel_RecKills.size()) {
                return;
            }
            String sid = this.m_listModel_RecKills.elementAt(index);
            int id = Integer.parseInt(sid);
            this.m_listModel_RecKills.remove(index);
            this.m_list_RecKills.setModel(this.m_listModel_RecKills);
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            p.setReceiverKilled(id, false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void unkillShots() {
        try {
            int index = this.m_list_ShotKills.getSelectedIndex();
            if (index < 0 || index >= this.m_listModel_ShotKills.size()) {
                return;
            }
            String sid = this.m_listModel_ShotKills.elementAt(index);
            int id = Integer.parseInt(sid);
            this.m_listModel_ShotKills.remove(index);
            this.m_list_ShotKills.setModel(this.m_listModel_ShotKills);
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            p.setShotKilled(id, false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void handleKillRec(int id) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            this.m_listModel_RecKills.add(0, Integer.toString(id));
            this.m_list_RecKills.setModel(this.m_listModel_RecKills);
            p.setReceiverKilled(id, true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void handleKillShot(int id) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            this.m_listModel_ShotKills.add(0, Integer.toString(id));
            this.m_list_ShotKills.setModel(this.m_listModel_ShotKills);
            p.setShotKilled(id, true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public abstract void handleReceiverPicksModified();

    public abstract void handleShotPicksModified();

    public void updateShotPickTable() {
        try {
            if (this.m_groupEnsemble.traceCount() < 1) {
                return;
            }
            int indexID = this.m_groupEnsemble.dictionary().getEntryIndex("Shot", "ID");
            int indexPick = this.m_groupEnsemble.dictionary().getEntryIndex("Trace", "FBP_User");
            int colPick = this.m_shotTable.column_indexOfColumn("Pick");
            int colID = this.m_shotTable.column_indexOfColumn("ShotID");
            for (int n = 0; n < this.m_groupEnsemble.traceCount(); ++n) {
                int row;
                int tid;
                EnsembleTrace trace = this.m_groupEnsemble.trace(n);
                int id = trace.header().getInt(indexID);
                if (id != (tid = this.m_shotTable.getInt(row = this.m_shotMap.get(id), colID))) {
                    System.out.println("if (id != tid)");
                    continue;
                }
                double pick = trace.header().getDouble(indexPick);
                this.m_shotTable.putDouble(row, colPick, pick);
                this.m_geometryConn.updateSingleRow_Double("Shot", "Pick", id, pick);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void updateReceiverPickTable() {
        try {
            if (this.m_groupEnsemble.traceCount() < 1) {
                return;
            }
            int indexID = this.m_groupEnsemble.dictionary().getEntryIndex("Receiver", "ID");
            int indexPick = this.m_groupEnsemble.dictionary().getEntryIndex("Trace", "FBP_User");
            int colPick = this.m_receiverTable.column_indexOfColumn("Pick");
            int colID = this.m_receiverTable.column_indexOfColumn("ReceiverID");
            for (int n = 0; n < this.m_groupEnsemble.traceCount(); ++n) {
                int row;
                int tid;
                EnsembleTrace trace = this.m_groupEnsemble.trace(n);
                int id = trace.header().getInt(indexID);
                if (id != (tid = this.m_receiverTable.getInt(row = this.m_receiverMap.get(id), colID))) {
                    System.out.println("if (id != tid)");
                    continue;
                }
                double pick = trace.header().getDouble(indexPick);
                this.m_receiverTable.putDouble(row, colPick, pick);
                this.m_geometryConn.updateSingleRow_Double("Receiver", "Pick", id, pick);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void handlePicksModified() {
        try {
            if (this.m_groupEnsemble.traceCount() < 1) {
                return;
            }
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (this.m_planeCombo.getSelectedIndex() == 0) {
                this.updateShotPickTable();
                this.handleShotPicksModified();
            } else {
                this.updateReceiverPickTable();
                this.handleReceiverPicksModified();
            }
            this.m_widget.repaintAll();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            PickerGizmo pg = PickerGizmo.singleton();
            pg.PickName = "FBP_User";
            if (sender == this.m_radioPlotType) {
                this.prepEnsemble();
                return;
            }
            if (sender == PickerGizmo.singleton()) {
                this.loadUEC();
                return;
            }
            if (sender == this.m_mouseMoveUEC) {
                this.handleMouseMoveUEC();
                return;
            }
            if (sender == this.m_keyUEC) {
                this.handleKeyUEC();
                return;
            }
            if (sender == this.m_lineSegmentUEC) {
                if (this.m_lineSegmentUEC.Dragging) {
                    return;
                }
                if (!this.m_lineSegmentUEC.Finished) {
                    return;
                }
                if (pg.handleControlPoint(this.m_lineSegmentUEC, this.m_groupEnsemble, this.m_groupEnsemble)) {
                    this.handlePicksModified();
                }
                return;
            }
            if (sender == this.m_rubberBandUEC) {
                if (this.m_rubberBandUEC.Dragging) {
                    return;
                }
                if (!this.m_rubberBandUEC.Finished) {
                    return;
                }
                if (pg.handleRubberBand(this.m_rubberBandUEC, this.m_groupEnsemble, this.m_groupEnsemble)) {
                    this.handlePicksModified();
                }
                return;
            }
            if (sender == this.m_middleClickUEC) {
                return;
            }
            if (sender == this.m_leftClickUEC) {
                if (pg.handleButtonPressed(this.m_leftClickUEC, this.m_groupEnsemble, this.m_groupEnsemble, true)) {
                    this.handlePicksModified();
                }
                return;
            }
            if (sender == this.m_penModeUEC) {
                if (!this.m_penModeUEC.Dragging) {
                    return;
                }
                if (pg.handlePenMode(this.m_penModeUEC, this.m_groupEnsemble, this.m_groupEnsemble)) {
                    this.handlePicksModified();
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleEnsembleWidgetPaintEvent(Java2D_VertStackedEnsembleDisplayWidget widget, int widgetIndex, boolean imagePainted) {
        try {
            if (imagePainted && widgetIndex == 0) {
                this.m_basemapWidget.associatedEnsembleWidgetJustPainted(this.m_groupEnsemble);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void savePickColor() {
        try {
            ParameterTree tree = SharedApplicationData.singleton().getParameterTree();
            tree.color_put("srpick", this.m_pickColor);
            SharedApplicationData.singleton().saveParameterTree();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void loadPickColor() {
        try {
            ParameterTree tree = SharedApplicationData.singleton().getParameterTree();
            this.m_pickColor = tree.color_get("srpick", Color.BLUE);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected class GroupData {
        public String Label = "";
        public ArrayList<StackData> StackArray = new ArrayList();

        protected GroupData() {
        }
    }

    protected class StackData {
        public int ID;
        public int Count;
        public float[] Data;
        public float PickTime = -9999.0f;
        public double DelayTime;
        public double SharedPickTime = 0.0;
        public double OriginalPolarity = 1.0;
        public long FileOffset = -9999L;

        public void clear() {
            try {
                this.Count = 0;
                for (int n = 0; n < SolutionStacksWidget.this.m_stackLength; ++n) {
                    this.Data[n] = 0.0f;
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public void read(RandomAccessFile file) throws Exception {
            block10: {
                try {
                    int magic = file.readInt();
                    if (magic != SolutionStacksWidget.this.m_magic) {
                        throw new Exception("magic != m_magic");
                    }
                    int version = file.readInt();
                    if (version == 1000) {
                        this.ID = file.readInt();
                        this.Count = file.readInt();
                        this.DelayTime = file.readDouble();
                        this.Data = new float[SolutionStacksWidget.this.m_stackLength];
                        for (int n = 0; n < SolutionStacksWidget.this.m_stackLength; ++n) {
                            this.Data[n] = file.readFloat();
                        }
                        break block10;
                    }
                    if (version == 1001) {
                        this.ID = file.readInt();
                        this.Count = file.readInt();
                        this.DelayTime = file.readDouble();
                        this.OriginalPolarity = file.readDouble();
                        this.Data = new float[SolutionStacksWidget.this.m_stackLength];
                        for (int n = 0; n < SolutionStacksWidget.this.m_stackLength; ++n) {
                            this.Data[n] = file.readFloat();
                        }
                        break block10;
                    }
                    if (version == 1002) {
                        this.ID = file.readInt();
                        this.Count = file.readInt();
                        this.DelayTime = file.readDouble();
                        this.OriginalPolarity = file.readDouble();
                        this.SharedPickTime = file.readDouble();
                        this.Data = new float[SolutionStacksWidget.this.m_stackLength];
                        for (int n = 0; n < SolutionStacksWidget.this.m_stackLength; ++n) {
                            this.Data[n] = file.readFloat();
                        }
                        break block10;
                    }
                    if (version == 1003) {
                        this.ID = file.readInt();
                        this.Count = file.readInt();
                        this.DelayTime = file.readDouble();
                        this.OriginalPolarity = file.readDouble();
                        this.SharedPickTime = file.readDouble();
                        this.Data = Tools_FileSystem.readArray_Float(file);
                        break block10;
                    }
                    throw new Exception("Unrecognized version");
                }
                catch (Exception error) {
                    ExceptionMonitor.add(error);
                    throw error;
                }
            }
        }

        public void save(RandomAccessFile file) {
            try {
                int n;
                file.writeInt(SolutionStacksWidget.this.m_magic);
                int version = 1003;
                file.writeInt(version);
                if (version == 1000) {
                    file.writeInt(this.ID);
                    file.writeInt(this.Count);
                    file.writeDouble(this.DelayTime);
                    for (n = 0; n < this.Data.length; ++n) {
                        file.writeFloat(this.Data[n]);
                    }
                }
                if (version == 1001) {
                    file.writeInt(this.ID);
                    file.writeInt(this.Count);
                    file.writeDouble(this.DelayTime);
                    file.writeDouble(this.OriginalPolarity);
                    for (n = 0; n < this.Data.length; ++n) {
                        file.writeFloat(this.Data[n]);
                    }
                }
                if (version == 1002) {
                    file.writeInt(this.ID);
                    file.writeInt(this.Count);
                    file.writeDouble(this.DelayTime);
                    file.writeDouble(this.OriginalPolarity);
                    file.writeDouble(this.SharedPickTime);
                    for (n = 0; n < this.Data.length; ++n) {
                        file.writeFloat(this.Data[n]);
                    }
                }
                if (version == 1003) {
                    file.writeInt(this.ID);
                    file.writeInt(this.Count);
                    file.writeDouble(this.DelayTime);
                    file.writeDouble(this.OriginalPolarity);
                    file.writeDouble(this.SharedPickTime);
                    Tools_FileSystem.saveArray_Float(file, this.Data, this.Data.length);
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }
}

