/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Refraction.Picking.PickPlaneEnum;
import com.PecosLibrary.Tools.Tools_FontLibrary;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Tools.Tools_Plot;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;

public class SimpleErrorWidget
extends JPanel {
    protected Ensemble m_ensemble;
    protected PickPlaneEnum m_pickPlane;
    protected double m_maxShift = 1.0;
    protected double m_scale = 1.0;
    public boolean SetPickPlaneUsingEnsemble = false;
    protected Color m_color = new Color(255, 255, 222);

    public SimpleErrorWidget() {
        this.m_pickPlane = PickPlaneEnum.Shot;
    }

    public void setPickPlane(PickPlaneEnum pp) {
        this.m_pickPlane = pp;
        this.repaint();
    }

    public void setEnsemble(Ensemble ensemble) {
        try {
            this.m_ensemble = ensemble;
            if (this.SetPickPlaneUsingEnsemble) {
                if (Tools_Ensemble.isShotEnsemble(this.m_ensemble) >= 1) {
                    this.m_pickPlane = PickPlaneEnum.Shot;
                }
                if (Tools_Ensemble.isReceiverEnsemble(this.m_ensemble) >= 1) {
                    this.m_pickPlane = PickPlaneEnum.Receiver;
                }
            }
            this.repaint();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void drawScale(Graphics2D g2d) {
        try {
            double tick = Tools_Plot.tickMarkInterval(this.m_maxShift, 2);
            g2d.setColor(Color.LIGHT_GRAY);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_1);
            int w = this.getSize().width;
            int h = this.getSize().height;
            double shiftX = w / 2;
            double shiftY = h / 2;
            for (double r = tick; r <= this.m_maxShift; r += tick) {
                int s = (int)(0.5 + this.m_scale * r);
                g2d.drawOval(w / 2 - s, h / 2 - s, 2 * s + 1, 2 * s + 1);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void draw(Graphics2D g2d) {
        try {
            Ensemble.PredictedCoordinates pred = this.m_ensemble.predictedCoordinates();
            this.m_maxShift = Math.max(Math.abs(pred.ShiftX), Math.abs(pred.ShiftY));
            this.m_maxShift = Math.max(this.m_maxShift, 20.0);
            this.m_maxShift *= 1.1;
            int w = this.getSize().width;
            int h = this.getSize().height;
            this.m_scale = 1.0;
            double shiftX = w / 2;
            double shiftY = h / 2;
            this.m_scale = h < w ? (double)h / (2.0 * this.m_maxShift) : (double)w / (2.0 * this.m_maxShift);
            this.drawScale(g2d);
            g2d.setColor(Color.red);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
            int ix = (int)(this.m_scale * pred.ShiftX + shiftX);
            int iy = (int)(-this.m_scale * pred.ShiftY + shiftY);
            g2d.drawLine(w / 2, h / 2, ix, iy);
            g2d.setFont(Tools_FontLibrary.AxisFont);
            int stringHeight = g2d.getFontMetrics().getHeight();
            g2d.setColor(Color.black);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_1);
            double dist = Math.sqrt(1.0E-6 + pred.ShiftX * pred.ShiftX + pred.ShiftY * pred.ShiftY);
            String s = Integer.toString((int)(0.5 + dist));
            int stringWidth = g2d.getFontMetrics().stringWidth(s);
            if (iy > h / 2) {
                g2d.drawString(s, w / 2 - stringWidth / 2, h / 2 - 3);
            } else {
                g2d.drawString(s, w / 2 - stringWidth / 2, h / 2 + stringHeight + 3);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        try {
            Dimension size = this.getSize();
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(this.m_color);
            g2d.fillRect(0, 0, size.width, size.height);
            if (this.m_ensemble == null) {
                return;
            }
            if (this.m_ensemble.traceCount() < 1) {
                return;
            }
            if (Tools_Ensemble.isReceiverEnsemble(this.m_ensemble) >= 1 && this.m_pickPlane == PickPlaneEnum.Receiver) {
                this.draw(g2d);
            }
            if (Tools_Ensemble.isShotEnsemble(this.m_ensemble) >= 1 && this.m_pickPlane == PickPlaneEnum.Shot) {
                this.draw(g2d);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

