/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.Refraction.DelayTime.Action_DelayTime_PickHistogram;
import com.PecosLibrary.Refraction.PickHistogram;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Refraction.Picking.PickPolygonDialog;
import com.PecosLibrary.Windows.Shared.PopupMenuButton;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class PickHistogramWidget
extends LinearLayoutWidget
implements ActionListener,
Messenger.Listener,
PopupMenuButton.Listener,
GenericObjectListener.Listener,
ItemListener,
ISaveableFrame {
    protected JButton m_btnComputeHistogram;
    protected JButton m_btnReload;
    protected ArrayList<Wrapper> m_list = new ArrayList();
    protected PickPolygonDialog m_PickPolygonDialog;

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.Refraction.DelayTime.PickHistogramWidget";
    }

    @Override
    public String TAB_LABEL() {
        return "Pick histogram";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "Pick error histogram";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return true;
    }

    public PickHistogramWidget() {
        super(LinearLayoutWidget.Direction.Vertical, 0, null);
        try {
            LinearLayoutWidget top = this.createHorizontal(3, null, 0);
            this.m_btnComputeHistogram = top.createButton("Recompute error histograms", this, 0);
            this.m_btnReload = top.createButton("Reload histogram data", this, 0);
            top.addStretch(10);
            LinearLayoutWidget bottom = this.createVertical(3, null, 10);
            for (int n = 0; n < 2; ++n) {
                Color color = new Color(255, 255, 245);
                if (n % 2 == 0) {
                    color = new Color(245, 255, 255);
                }
                Wrapper w = new Wrapper(color, this);
                bottom.addComponent(w, 10);
                w.VersionCombo.setPreferredSelected("FBP_User");
                for (int b = 1; b < 10; ++b) {
                    w.BranchCombo.addItem("Branch " + Integer.toString(b));
                }
                w.BranchCombo.setSelectedIndex(0);
                this.m_list.add(w);
                w.BranchCombo.addItemListener(this);
                w.VersionCombo.listener().addListener(this);
                w.Widget.Listener.addListener(this);
            }
            Tools_FontChanger.changeSizeOfFont(this, -2, null, true);
            Messenger.singleton().addListener(this);
            this.reloadHistData();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadHistData() {
        try {
            PickHistogram ph = RefractionStaticsProject.singleton().pickHistogram();
            ArrayList<String> list = ph.pickNames();
            for (Wrapper w : this.m_list) {
                w.VersionCombo.setStringArray(list);
            }
            this.reloadAllPlots();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadAllPlots() {
        try {
            PickHistogram ph = RefractionStaticsProject.singleton().pickHistogram();
            for (Wrapper w : this.m_list) {
                String name = w.VersionCombo.getSelectedString();
                int branch = w.BranchCombo.getSelectedIndex() + 1;
                boolean anis = w.RadioWithAnis.isSelected();
                w.Widget.PHE = ph.getEntry(name, branch, anis);
                w.Widget.repaint();
                w.clearLabels();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            int mouseIndex = -9999;
            for (Wrapper w : this.m_list) {
                if (sender != w.Widget) continue;
                mouseIndex = w.Widget.NearestStickIndex;
            }
            if (mouseIndex >= 0) {
                for (Wrapper w : this.m_list) {
                    w.updateMouse(mouseIndex);
                }
                return;
            }
            this.reloadAllPlots();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handlePopupMenuButton(PopupMenuButton button, String text) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            PickHistogram ph = RefractionStaticsProject.singleton().pickHistogram();
            if (e.getSource() == this.m_btnComputeHistogram) {
                Action_DelayTime_PickHistogram action = new Action_DelayTime_PickHistogram();
                RefractionStaticsProject.singleton().executeSingleAction(action);
                return;
            }
            if (e.getSource() == this.m_btnReload) {
                this.reloadHistData();
                return;
            }
            for (Wrapper w : this.m_list) {
                boolean anis;
                int branch;
                if (e.getSource() != w.KillButton) continue;
                String name = w.VersionCombo.getSelectedString();
                PickHistogram.Entry entry = ph.getEntry(name, branch = w.BranchCombo.getSelectedIndex() + 1, anis = w.RadioWithAnis.isSelected());
                if (entry == null) {
                    return;
                }
                float maxError = (float)Tools_Widget.extractDouble(w.KillText, 20.0, 5.0, 1000.0);
                Action_DelayTime_PickHistogram action = new Action_DelayTime_PickHistogram();
                action.KillAnisotropy = anis;
                action.KillBranch = branch;
                action.KillVersionName = name;
                action.KillError = maxError;
                if (RefractionStaticsProject.singleton().polygon() != null) {
                    action.Polygon = RefractionStaticsProject.singleton().polygon();
                    try {
                        if (this.m_PickPolygonDialog == null) {
                            this.m_PickPolygonDialog = new PickPolygonDialog(true);
                        }
                        this.m_PickPolygonDialog.showDialog();
                        action.KillInsidePolygon = this.m_PickPolygonDialog.RadioKillInside.isSelected();
                        action.RequireShotInsidePolygon = this.m_PickPolygonDialog.CheckRequireSource.isSelected();
                        action.RequireReceiverInsidePolygon = this.m_PickPolygonDialog.CheckRequireRec.isSelected();
                        action.RequireCdpInsidePolygon = this.m_PickPolygonDialog.CheckRequireCdp.isSelected();
                    }
                    catch (Exception exp) {
                        ExceptionMonitor.add(exp);
                    }
                }
                RefractionStaticsProject.singleton().executeSingleAction(action);
                this.reloadAllPlots();
                return;
            }
            this.reloadAllPlots();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.reloadAllPlots();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
    }

    protected class Wrapper
    extends LinearLayoutWidget {
        public HistogramWidget Widget;
        public ComboStringListWrapper VersionCombo;
        public JComboBox<String> BranchCombo;
        public ButtonGroup Group;
        public JRadioButton RadioWithAnis;
        public JRadioButton RadioWithoutAnis;
        public JButton KillButton;
        public JTextField KillText;
        public JLabel Label1;
        public JLabel Label2;
        public JLabel Label3;
        public JLabel Label4;

        public Wrapper(Color color, ActionListener listener) {
            super(LinearLayoutWidget.Direction.Horizontal, 0, null);
            this.Widget = new HistogramWidget();
            this.VersionCombo = new ComboStringListWrapper();
            this.BranchCombo = new JComboBox();
            this.Group = new ButtonGroup();
            this.RadioWithAnis = new JRadioButton("With anisotropy term");
            this.RadioWithoutAnis = new JRadioButton("Without anisotropy term");
            this.KillText = new JTextField("20");
            this.Label1 = new JLabel(" ");
            this.Label2 = new JLabel(" ");
            this.Label3 = new JLabel(" ");
            this.Label4 = new JLabel(" ");
            try {
                LinearLayoutWidget left = this.createVertical(0, null, 0);
                LinearLayoutWidget sub = left.createVertical(0, "Select version/branch", 0);
                sub.addComponent(this.VersionCombo, 0);
                sub.addComponent(this.BranchCombo, 0);
                sub = left.createVertical(0, "Pick errors computed", 0);
                sub.addComponent(this.RadioWithAnis, 0);
                sub.addComponent(this.RadioWithoutAnis, 0);
                this.Group.add(this.RadioWithAnis);
                this.Group.add(this.RadioWithoutAnis);
                this.RadioWithoutAnis.setSelected(true);
                this.RadioWithAnis.addActionListener(listener);
                this.RadioWithoutAnis.addActionListener(listener);
                sub = left.createVertical(0, "Info from cursor location", 0);
                sub.addComponent(this.Label1, 0);
                sub.addComponent(this.Label2, 0);
                sub.addComponent(this.Label3, 0);
                sub.addComponent(this.Label4, 0);
                sub = left.createVertical(0, "Kill bad picks", 0);
                this.KillButton = sub.createButton("Kill bad picks", listener, 0);
                sub.addComponent(new JLabel("Max error (ms):"), 0);
                sub.addComponent(this.KillText, 0);
                left.addStretch(10);
                this.addComponent(this.Widget, 10);
                this.Widget.BackColor = color;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void updateMouse(int mouseIndex) {
            try {
                int n;
                this.clearLabels();
                if (this.Widget.PHE == null) {
                    return;
                }
                int index = mouseIndex;
                index = Math.max(index, 0);
                index = Math.min(index, this.Widget.PHE.Count.length - 1);
                int numLess = 0;
                int numMore = 0;
                for (n = 0; n <= index; ++n) {
                    numLess += this.Widget.PHE.Count[n];
                }
                for (n = index + 1; n < this.Widget.PHE.Count.length; ++n) {
                    numMore += this.Widget.PHE.Count[n];
                }
                int total = numMore + numLess;
                double percentLess = 100.0 * (double)numLess / (0.001 + (double)total);
                double percentMore = 100.0 * (double)numMore / (0.001 + (double)total);
                String s = Tools_Strings.getString(percentLess, 3);
                this.Label1.setText("Cutoff error (ms): " + Integer.toString(index + 1));
                this.Label2.setText("# less:  " + Integer.toString(numLess));
                this.Label3.setText("# greater:  " + Integer.toString(numMore));
                this.Label4.setText("Percent less:  " + s);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void clearLabels() {
            this.Label1.setText("  ");
            this.Label2.setText("  ");
            this.Label3.setText("  ");
            this.Label4.setText("  ");
        }
    }

    protected class HistogramWidget
    extends JPanel
    implements MouseMotionListener {
        public PickHistogram.Entry PHE = null;
        public boolean PlotValid = false;
        public int[] Pixel = new int[100];
        public Color BackColor;
        public GenericObjectListener Listener = new GenericObjectListener();
        public int NearestStickIndex = 0;

        public HistogramWidget() {
            this.addMouseMotionListener(this);
        }

        @Override
        public void mouseDragged(MouseEvent event) {
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            try {
                if (!this.PlotValid) {
                    return;
                }
                this.NearestStickIndex = 0;
                int minDist = 100000;
                for (int n = 0; n < this.Pixel.length; ++n) {
                    if (Math.abs(event.getX() - this.Pixel[n]) >= minDist) continue;
                    minDist = Math.abs(event.getX() - this.Pixel[n]);
                    this.NearestStickIndex = n;
                }
                this.Listener.broadcast(this, null);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            try {
                int stringWidth;
                String s;
                int maxPlot;
                this.PlotValid = false;
                Dimension size = this.getSize();
                Graphics2D g2d = (Graphics2D)g;
                g2d.setColor(this.BackColor);
                g2d.fillRect(0, 0, size.width, size.height);
                if (this.PHE == null) {
                    return;
                }
                int axisWidth = 90;
                int axisHeight = 40;
                int mainWidth = size.width - axisWidth;
                int pixPerCount = mainWidth / this.PHE.Count.length;
                int stickWidth = (pixPerCount = Math.max(pixPerCount, 5)) - 3;
                if (stickWidth % 2 == 0) {
                    ++stickWidth;
                }
                int halfWidth = stickWidth / 2;
                int stickGap = pixPerCount - stickWidth;
                int max = this.PHE.maxCount();
                for (maxPlot = 10; max > maxPlot; maxPlot *= 10) {
                }
                int baseline = size.height - axisHeight;
                int stickBottom = baseline - 7;
                int stickTop = 7;
                double alpha = (double)(stickTop - stickBottom) / Math.log10(maxPlot);
                double beta = stickBottom;
                int stringHeight = g2d.getFontMetrics().getHeight();
                for (int c = 1; c <= maxPlot; c *= 10) {
                    double y = Math.log10(c);
                    int iy = (int)(y * alpha + beta);
                    g2d.setColor(Color.LIGHT_GRAY);
                    g2d.drawLine(axisWidth, iy, size.width, iy);
                    s = Integer.toString(c);
                    stringWidth = g2d.getFontMetrics().stringWidth(s);
                    g2d.setColor(Color.black);
                    g2d.drawString(s, axisWidth - stringWidth - 3, iy + 4);
                }
                g2d.setColor(Color.LIGHT_GRAY);
                g2d.drawLine(axisWidth, 0, axisWidth, baseline);
                g2d.drawLine(axisWidth, baseline, size.width, baseline);
                if (this.Pixel.length != this.PHE.Count.length) {
                    this.Pixel = new int[this.PHE.Count.length];
                }
                int stickPixelX = axisWidth + 1 + pixPerCount / 2;
                int rightText = -9999;
                for (int n = 0; n < this.PHE.Count.length; ++n) {
                    this.Pixel[n] = stickPixelX;
                    if (this.PHE.Count[n] >= 1) {
                        double y = Math.log10(this.PHE.Count[n]);
                        int iy = (int)(y * alpha + beta);
                        g2d.setColor(Color.BLUE);
                        for (int h = -halfWidth; h <= halfWidth; ++h) {
                            g2d.drawLine(stickPixelX + h, baseline, stickPixelX + h, iy);
                        }
                    }
                    s = Integer.toString(n + 1);
                    stringWidth = g2d.getFontMetrics().stringWidth(s);
                    int left = stickPixelX - stringWidth / 2;
                    if (left > rightText) {
                        g2d.setColor(Color.black);
                        g2d.drawString(s, left, baseline + 2 + stringHeight);
                        rightText = left + stringWidth + 12;
                    }
                    stickPixelX += pixPerCount;
                }
                g2d.setColor(Color.black);
                g2d.drawString("Pick error (milliseconds)", size.width / 2, size.height - 3);
                this.PlotValid = true;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }
}

