/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_AxisLines;
import com.PecosLibrary.Windows.Refraction.DelayTime.DelayTimeModelProfileWidget;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelProfileLine;
import java.awt.Color;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import javax.swing.JPanel;

public class StackedComposites
extends JPanel
implements ComponentListener {
    public int m_numVisible = 1;
    public ArrayList<ModelProfileLine> ProfileList = new ArrayList();
    public ArrayList<Java2D_SimpleComposite> PlotList = new ArrayList();
    public ArrayList<Java2D_Paintable_AxisLines> LineList = new ArrayList();

    public StackedComposites(int max) {
        try {
            this.setLayout(null);
            for (int n = 0; n < max; ++n) {
                ModelProfileLine pl = new ModelProfileLine(null);
                pl.LineIndex = n;
                Java2D_SimpleComposite w = new Java2D_SimpleComposite(false);
                this.LineList.add(new Java2D_Paintable_AxisLines());
                w.mainWidget().addPaintable(pl, DelayTimeModelProfileWidget.ProfileLine.PlotProfile);
                w.mainWidget().addPaintable(this.LineList.get(n), -9999);
                Color c = Color.BLACK;
                if (n == 0) {
                    c = Color.RED;
                }
                if (n == 1) {
                    c = Color.BLUE;
                }
                if (n == 2) {
                    c = Color.MAGENTA;
                }
                if (n == 3) {
                    c = Color.YELLOW;
                }
                if (n == 4) {
                    c = Color.CYAN;
                }
                pl.ProfileLineColor = c;
                Color axisColor = Tools_GraphicalObjectLibrary.lighten(c);
                w.setVerticalAxisColor(axisColor);
                this.PlotList.add(w);
                this.ProfileList.add(pl);
                this.add(w);
            }
            this.addComponentListener(this);
            this.placeWidgets();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setLinesVisible(boolean vis) {
        try {
            for (int n = 0; n < this.LineList.size(); ++n) {
                this.LineList.get((int)n).DrawHorizontalLines = vis;
                this.PlotList.get(n).mainWidget().mooz();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        try {
            this.placeWidgets();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    public void placeWidgets() {
        try {
            int width = this.getSize().width;
            int height = this.getSize().height;
            this.m_numVisible = Math.max(1, this.m_numVisible);
            this.m_numVisible = Math.min(this.m_numVisible, this.PlotList.size());
            int pixPer = height / this.m_numVisible;
            for (int n = 0; n < this.PlotList.size(); ++n) {
                this.PlotList.get(n).setVisible(n < this.m_numVisible);
            }
            int top = 0;
            for (int n = 0; n < this.m_numVisible; ++n) {
                this.PlotList.get(n).setBounds(0, top, width, pixPer);
                top += pixPer;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setNumVisible(int num) {
        try {
            this.m_numVisible = num;
            this.placeWidgets();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

