/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.InteractiveModel;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.LayerDataType;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelData;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.SelectedGeometryItem;

public class ModelDataViewModel {
    ModelData _md;
    LayerDataType _dt;
    InteractiveModel _model;

    public ModelDataViewModel(ModelData md, InteractiveModel model) {
        this._model = model;
        this._md = md;
        this._dt = md.getLayerDataType();
    }

    public ModelData getModelData() {
        return this._md;
    }

    public String toString() {
        try {
            SelectedGeometryItem item = this._model.getSelectedItem();
            if (item.IsSrc.booleanValue()) {
                int nSrc = this._model.getSourceCount();
                if (item.Index >= 0 && item.Index < nSrc) {
                    double dVal = this._md.getShotValue(item.Index);
                    int iShotID = this._md.getShotID(item.Index);
                    return this._dt.toString() + ": " + String.format("%.2f", dVal) + " S: " + Integer.toString(iShotID);
                }
            } else {
                int nRec = this._model.getReceiverCount();
                if (item.Index >= 0 && item.Index < nRec) {
                    double dVal = this._md.getRecValue(item.Index);
                    int iRecID = this._md.getRecID(item.Index);
                    return this._dt.toString() + ": " + String.format("%.2f", dVal) + " R: " + Integer.toString(iRecID);
                }
            }
            return this._dt.toString();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "error";
        }
    }
}

