/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Windows.Refraction.Picking.PickPlaneEnum;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Tools.Tools_FontLibrary;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Tools.Tools_Plot;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public class GeometryErrorDisplayWidget
extends JPanel
implements MouseListener,
MouseMotionListener,
KeyListener {
    protected Ensemble m_ensemble;
    protected PickPlaneEnum m_pickPlane;
    protected double m_maxShift = 1.0;
    protected double m_scale = 1.0;
    public boolean SetPickPlaneUsingEnsemble = false;
    protected GenericObjectListener m_listener = new GenericObjectListener();
    protected int m_mouseX;
    protected int m_mouseY;

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public GeometryErrorDisplayWidget() {
        this.m_pickPlane = PickPlaneEnum.Shot;
        try {
            this.addMouseListener(this);
            this.addKeyListener(this);
            this.addMouseMotionListener(this);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setPickPlane(PickPlaneEnum pp) {
        this.m_pickPlane = pp;
        this.repaint();
    }

    public void setEnsemble(Ensemble ensemble) {
        try {
            this.m_ensemble = ensemble;
            if (this.SetPickPlaneUsingEnsemble) {
                if (Tools_Ensemble.isShotEnsemble(this.m_ensemble) >= 1) {
                    this.m_pickPlane = PickPlaneEnum.Shot;
                }
                if (Tools_Ensemble.isReceiverEnsemble(this.m_ensemble) >= 1) {
                    this.m_pickPlane = PickPlaneEnum.Receiver;
                }
            }
            this.repaint();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        try {
            Dimension size = this.getSize();
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(Color.white);
            g2d.fillRect(0, 0, size.width, size.height);
            if (this.m_ensemble == null) {
                return;
            }
            if (this.m_ensemble.traceCount() < 1) {
                return;
            }
            if (Tools_Ensemble.isReceiverEnsemble(this.m_ensemble) >= 1 && this.m_pickPlane == PickPlaneEnum.Receiver) {
                this.drawRec(g2d);
            }
            if (Tools_Ensemble.isShotEnsemble(this.m_ensemble) >= 1 && this.m_pickPlane == PickPlaneEnum.Shot) {
                this.drawShot(g2d);
            }
            this.drawScale(g2d);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void drawScale(Graphics2D g2d) {
        try {
            double tick = 2.0 * Tools_Plot.tickMarkInterval(this.m_maxShift, 2);
            g2d.setFont(Tools_FontLibrary.AxisFont);
            int stringHeight = g2d.getFontMetrics().getHeight();
            int w = this.getSize().width;
            int h = this.getSize().height;
            g2d.setColor(Color.lightGray);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_1);
            int lastRight = -9999;
            double x = 0.0;
            while (Math.abs(x) < this.m_maxShift) {
                x -= tick;
            }
            int ix = (int)(this.m_scale * x + (double)(w / 2));
            while (x < this.m_maxShift) {
                g2d.drawLine(ix, 0, ix, h);
                String s = Integer.toString((int)Math.round(x));
                int stringWidth = g2d.getFontMetrics().stringWidth(s);
                int left = ix - stringWidth / 2;
                if (left > lastRight) {
                    g2d.drawString(s, left, h - 10);
                    lastRight = left + stringWidth + 7;
                }
                ix = (int)(this.m_scale * (x += tick) + (double)(w / 2));
            }
            double y = 0.0;
            while (Math.abs(y) < this.m_maxShift) {
                y -= tick;
            }
            int iy = (int)(-this.m_scale * y + (double)(h / 2));
            while (y < this.m_maxShift) {
                g2d.drawLine(0, iy, w, iy);
                String s = Integer.toString((int)Math.round(y));
                int stringWidth = g2d.getFontMetrics().stringWidth(s);
                g2d.drawString(s, w - stringWidth - 2, iy + 4);
                iy = (int)(-this.m_scale * (y += tick) + (double)(h / 2));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void drawShot(Graphics2D g2d) {
        try {
            Ensemble.PredictedCoordinates pred = this.m_ensemble.predictedCoordinates();
            this.m_maxShift = Math.max(Math.abs(pred.ShiftX), Math.abs(pred.ShiftY));
            for (int n = 0; n < this.m_ensemble.traceCount(); ++n) {
                EnsembleTrace.GeometryError errorData = this.m_ensemble.trace(n).geometryErrorData();
                this.m_maxShift = Math.max(this.m_maxShift, Math.abs(errorData.InitialShotDeltaX));
                this.m_maxShift = Math.max(this.m_maxShift, Math.abs(errorData.InitialShotDeltaY));
            }
            this.m_maxShift = Math.max(this.m_maxShift, 20.0);
            this.m_maxShift *= 1.1;
            int w = this.getSize().width;
            int h = this.getSize().height;
            this.m_scale = 1.0;
            double shiftX = w / 2;
            double shiftY = h / 2;
            this.m_scale = h < w ? (double)h / (2.0 * this.m_maxShift) : (double)w / (2.0 * this.m_maxShift);
            g2d.setColor(Color.black);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
            int h2 = 5;
            int s2 = h2 / 2;
            for (int n = 0; n < this.m_ensemble.traceCount(); ++n) {
                EnsembleTrace.GeometryError errorData = this.m_ensemble.trace(n).geometryErrorData();
                errorData.ErrorStickPixelX = -9999;
                errorData.ErrorStickPixelY = -9999;
                if (errorData.Branch < 1) continue;
                int ix = (int)(this.m_scale * errorData.InitialShotDeltaX + shiftX);
                int iy = (int)(-this.m_scale * errorData.InitialShotDeltaY + shiftY);
                errorData.ErrorStickPixelX = ix;
                errorData.ErrorStickPixelY = iy;
                g2d.drawLine(w / 2, h / 2, ix, iy);
            }
            g2d.setColor(Color.red);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_3);
            int ix = (int)(this.m_scale * pred.ShiftX + shiftX);
            int iy = (int)(-this.m_scale * pred.ShiftY + shiftY);
            g2d.drawLine(w / 2, h / 2, ix, iy);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void drawRec(Graphics2D g2d) {
        try {
            Ensemble.PredictedCoordinates pred = this.m_ensemble.predictedCoordinates();
            this.m_maxShift = Math.max(Math.abs(pred.ShiftX), Math.abs(pred.ShiftY));
            for (int n = 0; n < this.m_ensemble.traceCount(); ++n) {
                EnsembleTrace.GeometryError errorData = this.m_ensemble.trace(n).geometryErrorData();
                this.m_maxShift = Math.max(this.m_maxShift, Math.abs(errorData.InitialReceiverDeltaX));
                this.m_maxShift = Math.max(this.m_maxShift, Math.abs(errorData.InitialReceiverDeltaY));
            }
            this.m_maxShift = Math.max(this.m_maxShift, 20.0);
            this.m_maxShift *= 1.1;
            int w = this.getSize().width;
            int h = this.getSize().height;
            this.m_scale = 1.0;
            double shiftX = w / 2;
            double shiftY = h / 2;
            this.m_scale = h < w ? (double)h / (2.0 * this.m_maxShift) : (double)w / (2.0 * this.m_maxShift);
            g2d.setColor(Color.black);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
            for (int n = 0; n < this.m_ensemble.traceCount(); ++n) {
                EnsembleTrace.GeometryError errorData = this.m_ensemble.trace(n).geometryErrorData();
                errorData.ErrorStickPixelX = -9999;
                errorData.ErrorStickPixelY = -9999;
                if (errorData.Branch < 1) continue;
                int ix = (int)(this.m_scale * errorData.InitialReceiverDeltaX + shiftX);
                int iy = (int)(-this.m_scale * errorData.InitialReceiverDeltaY + shiftY);
                errorData.ErrorStickPixelX = ix;
                errorData.ErrorStickPixelY = iy;
                g2d.drawLine(w / 2, h / 2, ix, iy);
            }
            g2d.setColor(Color.red);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_3);
            int ix = (int)(this.m_scale * pred.ShiftX + shiftX);
            int iy = (int)(-this.m_scale * pred.ShiftY + shiftY);
            g2d.drawLine(w / 2, h / 2, ix, iy);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void handleESC(int x, int y) {
        try {
            if (this.m_ensemble == null) {
                return;
            }
            int nearest = -1;
            int minDist = 500;
            for (int n = 0; n < this.m_ensemble.traceCount(); ++n) {
                EnsembleTrace.GeometryError errorData = this.m_ensemble.trace(n).geometryErrorData();
                int dist = Math.abs(x - errorData.ErrorStickPixelX) + Math.abs(y - errorData.ErrorStickPixelY);
                if (dist >= minDist) continue;
                minDist = dist;
                nearest = n;
            }
            if (nearest < 0) {
                return;
            }
            int indexShotID = this.m_ensemble.dictionary().getEntryIndex("Trace", "ShotID");
            int indexRecID = this.m_ensemble.dictionary().getEntryIndex("Trace", "ReceiverID");
            int shotID = this.m_ensemble.trace(nearest).header().getInt(indexShotID);
            int recID = this.m_ensemble.trace(nearest).header().getInt(indexRecID);
            Messenger.broadcastTraceSelected(null, shotID, recID, -9999, -9999);
            this.m_listener.broadcast(this, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void handleKill(int x, int y) {
        try {
            if (this.m_ensemble == null) {
                return;
            }
            int nearest = -1;
            int minDist = 500;
            for (int n = 0; n < this.m_ensemble.traceCount(); ++n) {
                EnsembleTrace.GeometryError errorData = this.m_ensemble.trace(n).geometryErrorData();
                int dist = Math.abs(x - errorData.ErrorStickPixelX) + Math.abs(y - errorData.ErrorStickPixelY);
                if (dist >= minDist) continue;
                minDist = dist;
                nearest = n;
            }
            if (nearest < 0) {
                return;
            }
            int index = this.m_ensemble.dictionary().getEntryIndex("Trace", "FBP_User");
            this.m_ensemble.trace(nearest).header().putFloat(index, -9999.0f);
            int traceIndex = this.m_ensemble.dictionary().getEntryIndex("Trace", "TraceIndex");
            long traceRow = this.m_ensemble.trace(nearest).header().getLong(traceIndex);
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            int colPick = p.traceTableWrapper().traceTable().column_indexOfColumn("FBP_User");
            p.traceTableWrapper().traceTable().putFloat(traceRow, colPick, -9999.0f);
            p.traceTableWrapper().traceTable().saveCurrentSection();
            this.m_listener.broadcast(this, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        try {
            this.handleKill(event.getX(), event.getY());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        try {
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
        try {
            if (event.getKeyCode() == 27) {
                this.handleESC(this.m_mouseX, this.m_mouseY);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void mouseDragged(MouseEvent event) {
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        try {
            this.m_mouseX = event.getX();
            this.m_mouseY = event.getY();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

