/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;

public class CartoonWidget
extends JSplitPane
implements ActionListener {
    public CartoonDrawWidget m_widget = new CartoonDrawWidget();
    protected JTextField m_txt_width = new JTextField("4000");
    protected JTextField m_txt_h0 = new JTextField("100");
    protected JTextField m_txt_h1 = new JTextField("100");
    protected JTextField m_txt_h2 = new JTextField("100");
    protected JTextField m_txt_h3 = new JTextField("100");
    protected JTextField m_txt_v0 = new JTextField("1000");
    protected JTextField m_txt_v1 = new JTextField("1500");
    protected JTextField m_txt_v2 = new JTextField("2000");
    protected JTextField m_txt_v3 = new JTextField("2500");
    protected JTextField m_txt_v4 = new JTextField("3000");

    public CartoonWidget() {
        super(1);
        try {
            this.setRightComponent(this.m_widget);
            this.setLeftComponent(this.createLeft());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void prep() {
        try {
            this.m_widget.Width = Tools_Widget.extractDouble(this.m_txt_width, 4000.0, 100.0, 20000.0);
            this.m_widget.H[0] = Tools_Widget.extractDouble(this.m_txt_h0, 100.0, 5.0, 5000.0);
            this.m_widget.H[1] = Tools_Widget.extractDouble(this.m_txt_h1, 100.0, 5.0, 5000.0);
            this.m_widget.H[2] = Tools_Widget.extractDouble(this.m_txt_h2, 100.0, 5.0, 5000.0);
            this.m_widget.H[3] = Tools_Widget.extractDouble(this.m_txt_h3, 100.0, 5.0, 5000.0);
            this.m_widget.V[0] = Tools_Widget.extractDouble(this.m_txt_v0, 1000.0, 100.0, 20000.0);
            this.m_widget.V[1] = Tools_Widget.extractDouble(this.m_txt_v1, 1000.0, this.m_widget.V[0] + 10.0, 20000.0);
            this.m_widget.V[2] = Tools_Widget.extractDouble(this.m_txt_v2, 1000.0, this.m_widget.V[1] + 10.0, 20000.0);
            this.m_widget.V[3] = Tools_Widget.extractDouble(this.m_txt_v3, 1000.0, this.m_widget.V[2] + 10.0, 20000.0);
            this.m_widget.V[4] = Tools_Widget.extractDouble(this.m_txt_v4, 1000.0, this.m_widget.V[3] + 10.0, 20000.0);
            this.m_widget.Valid = true;
            this.m_widget.do_stuff();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createLeft() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Axis columns", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Total line length (m)"), this.m_txt_width);
            grid.addComponent(new JLabel(" "), row++, 1);
            grid.addSimple(row++, new JLabel("Layer 0 thickness (m)"), this.m_txt_h0);
            grid.addSimple(row++, new JLabel("Layer 0 velocity (m/s)"), this.m_txt_v0);
            grid.addComponent(new JLabel(" "), row++, 1);
            grid.addSimple(row++, new JLabel("Layer 1 thickness (m)"), this.m_txt_h1);
            grid.addSimple(row++, new JLabel("Layer 1 velocity (m/s)"), this.m_txt_v1);
            grid.addComponent(new JLabel(" "), row++, 1);
            grid.addSimple(row++, new JLabel("Layer 2 thickness (m)"), this.m_txt_h2);
            grid.addSimple(row++, new JLabel("Layer 2 velocity (m/s)"), this.m_txt_v2);
            grid.addComponent(new JLabel(" "), row++, 1);
            grid.addSimple(row++, new JLabel("Layer 3 thickness (m)"), this.m_txt_h3);
            grid.addSimple(row++, new JLabel("Layer 3 velocity (m/s)"), this.m_txt_v3);
            grid.addComponent(new JLabel(" "), row++, 1);
            grid.addSimple(row++, new JLabel("Layer 4 velocity (m/s)"), this.m_txt_v4);
            main.addStretch(10);
            this.m_txt_width.addActionListener(this);
            this.m_txt_h0.addActionListener(this);
            this.m_txt_v0.addActionListener(this);
            this.m_txt_h1.addActionListener(this);
            this.m_txt_v1.addActionListener(this);
            this.m_txt_h2.addActionListener(this);
            this.m_txt_v2.addActionListener(this);
            this.m_txt_h3.addActionListener(this);
            this.m_txt_v3.addActionListener(this);
            this.m_txt_v4.addActionListener(this);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            System.out.println("CrtoonWidget actionPerformed");
            this.prep();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public class CartoonDrawWidget
    extends JPanel
    implements ComponentListener,
    KeyListener,
    MouseWheelListener,
    MouseMotionListener,
    MouseListener {
        public double Width = 10.0;
        public double Height = 10.0;
        public boolean Valid = false;
        public double[] V = new double[10];
        public double[] H = new double[10];
        public double[] Z = new double[10];
        public double[] X = new double[10];
        protected double ScaleX;
        protected double ShiftX;
        protected double ScaleY;
        protected double ShiftY;
        protected int Buffer = 100;

        public void do_stuff() {
            try {
                int n;
                this.Height = 0.0;
                this.Z[0] = 0.0;
                for (n = 0; n <= 3; ++n) {
                    this.Height += this.H[n];
                }
                for (n = 1; n <= 3; ++n) {
                    this.Z[n] = this.Z[n - 1] - this.H[n - 1];
                }
                this.Z[4] = -this.Height;
                this.repaint();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            try {
                double scale;
                long start = System.currentTimeMillis();
                Graphics2D g2d = (Graphics2D)g;
                int w = this.getSize().width;
                int h = this.getSize().height;
                if (!this.Valid) {
                    g2d.setColor(Color.LIGHT_GRAY);
                    g2d.fillRect(0, 0, w, h);
                    return;
                }
                g2d.setColor(Color.WHITE);
                g2d.fillRect(0, 0, w, h);
                this.ScaleY = -((double)(h - 2 * this.Buffer)) / this.Height;
                this.ScaleX = (double)(w - 2 * this.Buffer) / this.Width;
                this.ScaleX = scale = Math.min(Math.abs(this.ScaleX), Math.abs(this.ScaleY));
                this.ScaleY = -scale;
                this.ShiftY = (double)(h / 2) + this.ScaleY * this.Height / 2.0;
                this.ShiftX = (double)(w / 2) - this.ScaleX * this.Width / 2.0;
                g2d.setColor(Color.BLACK);
                g2d.setStroke(new BasicStroke(3.0f));
                g2d.setColor(Color.GRAY);
                for (int n = 0; n <= 4; ++n) {
                    this.line(g2d, 0.0, this.Z[n], this.Width, this.Z[n]);
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        protected void line(Graphics2D g2d, double x1, double y1, double x2, double y2) {
            try {
                g2d.drawLine((int)(this.ScaleX * x1 + this.ShiftX), (int)(this.ScaleY * y1 + this.ShiftY), (int)(this.ScaleX * x2 + this.ShiftX), (int)(this.ScaleY * y2 + this.ShiftY));
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void mouseDragged(MouseEvent event) {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent event) {
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }

        @Override
        public void keyPressed(KeyEvent event) {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
        }

        @Override
        public void mouseExited(MouseEvent event) {
        }

        @Override
        public void mousePressed(MouseEvent event) {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
        }

        @Override
        public void mouseMoved(MouseEvent event) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            try {
                this.repaint();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }
}

