/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Database;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ZeroMeanDialog
extends JDialog
implements GenericObjectListener.Listener,
ActionListener {
    protected RefractionStaticsProject m_project;
    protected JButton m_btnCancel = new JButton("Close");
    protected JButton m_btnInterpolate = new JButton("Convert to zero mean");
    protected ComboStringListWrapper m_combo = new ComboStringListWrapper();
    protected JTextField m_minText = new JTextField("-10000000");
    protected JTextField m_maxText = new JTextField("10000000");
    protected JLabel m_label = new JLabel("ll");
    protected double m_sum = 0.0;
    protected double m_avg = 0.0;
    protected double m_count = 1.0E-40;

    public ZeroMeanDialog() {
        try {
            this.m_project = RefractionStaticsProject.singleton();
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            LinearLayoutWidget sub = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, "Modify which column", 0);
            sub.addComponent(this.m_combo, 0);
            sub.addComponent(this.m_label, 0);
            this.m_combo.listener().addListener(this);
            this.m_combo.setPreferredSelected("Elevation");
            sub = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, "Valid values", 0);
            String s = "<HTML>Values OUTSIDE of the following minimum and maximum will be ignored</HTML>";
            sub.addComponent(new JLabel(s), 0);
            GridLayoutWidget grid = sub.createGridLayoutWidget(3, 0);
            grid.addSimple(0, new JLabel("Minimum"), this.m_minText);
            grid.addSimple(1, new JLabel("Maximum"), this.m_maxText);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addStretch(10);
            bottom.addComponent(this.m_btnInterpolate, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            bottom.addStretch(10);
            this.m_btnInterpolate.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.getContentPane().add((Component)main, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.reloadColumns();
            this.setTitle("Convert to zero mean");
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadColumns() {
        try {
            boolean rec = true;
            boolean shot = true;
            ArrayList<String> colList = null;
            if (shot && !rec) {
                colList = this.database().listOfColumnNames("Shot");
            }
            if (!shot && rec) {
                colList = this.database().listOfColumnNames("Receiver");
            }
            if (shot && rec) {
                colList = this.database().listOfColumnNames("Receiver", "Shot");
            }
            this.m_combo.setEnabled(colList != null);
            if (colList != null) {
                this.m_combo.setStringArray(colList);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void addTable(Table_Abstract table) {
        try {
            String col = this.m_combo.getSelectedString();
            if (!table.column_exists(col)) {
                return;
            }
            int indexCol = table.column_indexOfColumn(col);
            int indexKilled = table.column_indexOfColumn("Killed");
            for (int n = 0; n < table.row_count(); ++n) {
                if (table.getBool(n, indexKilled)) continue;
                this.m_sum += table.getDouble(n, indexCol);
                this.m_count += 1.0;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void subTable(Table_Abstract table) {
        try {
            String col = this.m_combo.getSelectedString();
            if (!table.column_exists(col)) {
                return;
            }
            int indexCol = table.column_indexOfColumn(col);
            int indexKilled = table.column_indexOfColumn("Killed");
            for (int n = 0; n < table.row_count(); ++n) {
                if (table.getBool(n, indexKilled)) continue;
                double v = table.getDouble(n, indexCol) - this.m_avg;
                table.putDouble(n, indexCol, v);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void modify() {
        try {
            this.addTable(this.m_project.receiverTable());
            this.addTable(this.m_project.shotTable());
            this.m_avg = this.m_sum / this.m_count;
            this.subTable(this.m_project.receiverTable());
            this.subTable(this.m_project.shotTable());
            String col = this.m_combo.getSelectedString();
            this.database().writeColumnContentsToDatabase(this.m_project.receiverTable(), col);
            this.database().writeColumnContentsToDatabase(this.m_project.shotTable(), col);
            this.m_project.reloadAllData();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnInterpolate) {
                this.modify();
                this.dispose();
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

