/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Database;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SetValueUsingPolygon
extends JDialog
implements GenericObjectListener.Listener,
ActionListener {
    protected RefractionStaticsProject m_project;
    protected JButton m_btnCancel = new JButton("Close");
    protected JButton m_btnInterpolate = new JButton("Set value inside polygon");
    protected JCheckBox m_shotCheck = new JCheckBox("Modify the shot table");
    protected JCheckBox m_recCheck = new JCheckBox("Modify the receiver table");
    protected ComboStringListWrapper m_combo = new ComboStringListWrapper();
    protected JTextField m_valueText = new JTextField("-9999");
    protected JLabel m_label = new JLabel("ll");

    public SetValueUsingPolygon() {
        try {
            this.m_project = RefractionStaticsProject.singleton();
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            LinearLayoutWidget sub = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, "Modify which column", 0);
            sub.addComponent(this.m_combo, 0);
            sub.addComponent(this.m_label, 0);
            this.m_combo.listener().addListener(this);
            this.m_combo.setPreferredSelected("Elevation");
            LinearLayoutWidget linearLayoutWidget = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, "Valid values", 0);
            GridLayoutWidget grid = linearLayoutWidget.createGridLayoutWidget(3, 0);
            grid.addSimple(0, new JLabel("Value"), this.m_valueText);
            sub = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, "Modify which tables", 0);
            sub.addComponent(this.m_shotCheck, 0);
            sub.addComponent(this.m_recCheck, 0);
            this.m_shotCheck.addActionListener(this);
            this.m_shotCheck.setSelected(true);
            this.m_recCheck.addActionListener(this);
            this.m_recCheck.setSelected(true);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addStretch(10);
            bottom.addComponent(this.m_btnInterpolate, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            bottom.addStretch(10);
            this.m_btnInterpolate.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.getContentPane().add((Component)main, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.reloadColumns();
            this.setTitle("Set value inside polygon");
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadColumns() {
        try {
            boolean rec = this.m_recCheck.isSelected();
            boolean shot = this.m_shotCheck.isSelected();
            ArrayList<String> colList = null;
            if (shot && !rec) {
                colList = this.database().listOfColumnNames("Shot");
            }
            if (!shot && rec) {
                colList = this.database().listOfColumnNames("Receiver");
            }
            if (shot && rec) {
                colList = this.database().listOfColumnNames("Receiver", "Shot");
            }
            this.m_combo.setEnabled(colList != null);
            if (colList != null) {
                this.m_combo.setStringArray(colList);
            }
            this.checkSelected();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void modifyInsidePolygon() {
        try {
            if (!this.checkSelected()) {
                return;
            }
            String col = this.m_combo.getSelectedString();
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.m_recCheck.isSelected()) {
                this.getFromPolygon(this.m_project.receiverTable());
                this.database().writeColumnContentsToDatabase(this.m_project.receiverTable(), col);
            }
            if (this.m_shotCheck.isSelected()) {
                this.getFromPolygon(this.m_project.shotTable());
                this.database().writeColumnContentsToDatabase(this.m_project.shotTable(), col);
            }
            this.m_project.reloadAllData();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void getFromPolygon(Table_Abstract table) {
        try {
            Java2D_Polygon poly = this.m_project.polygon();
            String col = this.m_combo.getSelectedString();
            String tableName = table.name();
            double value = Tools_Widget.extractDouble(this.m_valueText, 0.0, -1.0E30, 1.0E30);
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int index = table.column_indexOfColumn(col);
            for (int row = 0; row < table.row_count(); ++row) {
                double y;
                double v = table.getDouble(row, index);
                double x = table.getDouble(row, indexX);
                if (!poly.contains(x, y = table.getDouble(row, indexY))) continue;
                table.putDouble(row, index, value);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean checkSelected() {
        try {
            boolean required;
            boolean modOkay = this.m_recCheck.isSelected() || this.m_shotCheck.isSelected();
            this.m_btnInterpolate.setEnabled(false);
            if (!modOkay) {
                this.m_label.setText("Must modify at least one table");
                this.m_label.setForeground(Color.red);
                return false;
            }
            if (!this.m_combo.isEnabled()) {
                this.m_label.setText("Cannot modify column - no table selected?");
                this.m_label.setForeground(Color.red);
                return false;
            }
            String col = this.m_combo.getSelectedString();
            boolean bl = required = col.equalsIgnoreCase("Easting") || col.equalsIgnoreCase("Northing") || col.equalsIgnoreCase("LineNumber") || col.equalsIgnoreCase("PointNumber") || col.equalsIgnoreCase("PointIndex") || col.equalsIgnoreCase("ShotID") || col.equalsIgnoreCase("ReceiverID");
            if (required) {
                this.m_label.setText("Cannot modify required column");
                this.m_label.setForeground(Color.red);
                return false;
            }
            this.m_label.setText("Okay to modify this columns");
            this.m_label.setForeground(Color.blue);
            this.m_btnInterpolate.setEnabled(true);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.checkSelected();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_recCheck || e.getSource() == this.m_shotCheck) {
                this.reloadColumns();
                return;
            }
            if (e.getSource() == this.m_btnInterpolate) {
                this.modifyInsidePolygon();
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

