/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Menus;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Math.ComplexMatrix_Tools;
import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Seismic.Segy.Segy_FileHeader;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_ByteArray;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Stack.DigiStack2D;
import com.PecosLibrary.Stack.StackGizmo;
import com.PecosLibrary.Windows.Refraction.Import.ImportGliDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class Menu_Test
implements ActionListener {
    protected JMenu m_menu = new JMenu("Test");
    protected JMenuItem m_menuItem_SynthGathers;
    protected JMenuItem m_menuItem_Exception;
    protected JMenuItem m_menuItem_Seq;
    protected JMenuItem m_menuItem_IBM;
    protected JMenuItem m_menuItem_GLI;
    protected JMenuItem m_menuItem_Upsample;
    protected JMenuItem m_menuItem_WellSplit;
    protected JMenuItem m_menuItem_DipScan;
    protected JMenuItem m_menuItem_CatapultExport;
    protected JMenuItem m_menuItem_ConjugateGradient;
    protected JMenuItem m_menuItem_CreateJavaSeis = null;
    protected JMenuItem m_menuItem_GridTest;
    protected JMenuItem m_menuItem_Print;
    protected JMenu m_menuMath = new JMenu("Math");

    public Menu_Test(JMenuBar menuBar) {
        try {
            menuBar.add(this.m_menu);
            this.m_menuItem_GridTest = this.addMenuItem(this.m_menu, "Test grid code");
            this.m_menuItem_Print = this.addMenuItem(this.m_menu, "Print to console");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JMenuItem addMenuItem(JMenu menu, String text) {
        try {
            JMenuItem mi = new JMenuItem(text);
            menu.add(mi);
            mi.addActionListener(this);
            return mi;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void testThrowException() throws Exception {
        try {
            throw new Exception("Sample exception");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return;
        }
    }

    public void testUpsample() {
        try {
            StackGizmo stackGizmo = new StackGizmo();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void wellSplitFile(File file) {
        try {
            Segy segy = new Segy();
            segy.setFileName(file.getAbsolutePath());
            if (!segy.isFileOK()) {
                return;
            }
            System.out.println(file.getAbsolutePath());
            Segy_FileHeader header = segy.binaryHeader();
            int bytesPerTrace = header.BytesPerTrace;
            int numTraces = (int)segy.traceCount();
            int compOffset = 206;
            String split518Path = "/Users/matt/Data/Wellington/CAS_SPLIT_518";
            String split519Path = "/Users/matt/Data/Wellington/CAS_SPLIT_519";
            String split520Path = "/Users/matt/Data/Wellington/CAS_SPLIT_520";
            String split518 = split518Path + "/" + file.getName();
            String split519 = split519Path + "/" + file.getName();
            String split520 = split520Path + "/" + file.getName();
            ByteBuffer buffer = ByteBuffer_Shared.buffer(0, 3600);
            RandomAccessFile input = new RandomAccessFile(file.getAbsolutePath(), "r");
            long numInputBytes = input.length() - 3600L;
            long checkNumTraces = numInputBytes / (long)bytesPerTrace;
            int tracesPerChunk = 5000;
            RandomAccessFile out518 = new RandomAccessFile(split518, "rw");
            RandomAccessFile out519 = new RandomAccessFile(split519, "rw");
            RandomAccessFile out520 = new RandomAccessFile(split520, "rw");
            input.read(buffer.array(), 0, 3600);
            out518.write(buffer.array(), 0, 3600);
            out519.write(buffer.array(), 0, 3600);
            out520.write(buffer.array(), 0, 3600);
            int numBytesPerChunk = tracesPerChunk * bytesPerTrace;
            buffer = ByteBuffer_Shared.buffer(0, numBytesPerChunk);
            buffer.order(header.FileByteOrder);
            int nextTrace = 0;
            while (nextTrace < numTraces) {
                short code;
                int byteOffset;
                int n;
                int lastTraceIndex = nextTrace + tracesPerChunk - 1;
                if (lastTraceIndex >= numTraces) {
                    lastTraceIndex = numTraces - 1;
                }
                int numberInThisChunk = lastTraceIndex - nextTrace + 1;
                int bytesInThisChunk = numberInThisChunk * bytesPerTrace;
                long offset = 3600L + (long)nextTrace * (long)bytesPerTrace;
                input.seek(offset);
                input.read(buffer.array(), 0, bytesInThisChunk);
                for (n = 0; n < numberInThisChunk; ++n) {
                    byteOffset = n * bytesPerTrace;
                    code = buffer.getShort(byteOffset + compOffset);
                    if (code != 518) continue;
                    out518.write(buffer.array(), byteOffset, bytesPerTrace);
                }
                for (n = 0; n < numberInThisChunk; ++n) {
                    byteOffset = n * bytesPerTrace;
                    code = buffer.getShort(byteOffset + compOffset);
                    if (code != 520) continue;
                    out520.write(buffer.array(), byteOffset, bytesPerTrace);
                }
                for (n = 0; n < numberInThisChunk; ++n) {
                    byteOffset = n * bytesPerTrace;
                    code = buffer.getShort(byteOffset + compOffset);
                    if (code != 519) continue;
                    out519.write(buffer.array(), byteOffset, bytesPerTrace);
                }
                nextTrace = lastTraceIndex + 1;
            }
            input.close();
            out518.close();
            out519.close();
            out520.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void wellSplitPath(String path) {
        try {
            File[] files;
            File file = new File(path);
            if (!file.isDirectory()) {
                return;
            }
            for (File f : files = file.listFiles()) {
                if (!f.getAbsolutePath().endsWith(".sgy")) continue;
                this.wellSplitFile(f);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void wellSplit() {
        try {
            this.wellSplitPath("/Users/matt/Data/Wellington/CAS2/CAS");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void ibm(float v, byte[] array) {
        try {
            boolean negative = false;
            if (v < 0.0f) {
                negative = true;
                v = -v;
            }
            int exp = (int)(Math.log(v) / Math.log(2.0) / 4.0 + 1.0 + 64.0);
            double frac = (double)v / Math.pow(16.0, exp - 64);
            double Exp24 = 1.6777216E7;
            int tf = (int)(Exp24 * frac);
            int byte3 = tf & 0xFF;
            int byte2 = (tf /= 256) & 0xFF;
            int byte1 = (tf /= 256) & 0xFF;
            int byte0 = exp;
            if (negative) {
                byte0 += 128;
            }
            array[3] = (byte)this.convertInt(byte3);
            array[2] = (byte)this.convertInt(byte2);
            array[1] = (byte)this.convertInt(byte1);
            array[0] = (byte)this.convertInt(byte0);
            float[] outputArray = new float[array.length / 4];
            Tools_ByteArray.populateFloatUsingIBM(array, outputArray);
            float out = outputArray[0];
            double test = frac * Math.pow(16.0, exp - 64);
            System.out.println(String.format("%f  %f", Float.valueOf(v), Float.valueOf(out)));
            double d = 0.0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected int convertInt(int v) {
        try {
            if (v < 128) {
                return (byte)v;
            }
            return -((byte)(256 - v));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }

    protected void testIBM() {
        try {
            int count = 1;
            float[] input = new float[count];
            float[] output = new float[count];
            byte[] bytes = new byte[4 * count];
            this.ibm(1.0E-5f, bytes);
            this.ibm(1.0E-4f, bytes);
            this.ibm(0.001f, bytes);
            this.ibm(0.01f, bytes);
            this.ibm(0.1f, bytes);
            this.ibm(1.0f, bytes);
            this.ibm(10.0f, bytes);
            this.ibm(100.0f, bytes);
            this.ibm(1000.0f, bytes);
            this.ibm(10000.0f, bytes);
            this.ibm(100000.0f, bytes);
            this.ibm(1.0E7f, bytes);
            this.ibm(-1.0E-5f, bytes);
            this.ibm(-1.0E-4f, bytes);
            this.ibm(-0.001f, bytes);
            this.ibm(-0.01f, bytes);
            this.ibm(-0.1f, bytes);
            this.ibm(-1.0f, bytes);
            this.ibm(-10.0f, bytes);
            this.ibm(-100.0f, bytes);
            this.ibm(-1000.0f, bytes);
            this.ibm(-10000.0f, bytes);
            this.ibm(-100000.0f, bytes);
            this.ibm(-1.0E7f, bytes);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void catExp(String sql, String tableName) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (!project.valid()) {
                return;
            }
            String path = project.projectPath();
            IDatabaseConnection db = project.geometryDatabase();
            for (int id = 10; id < 990; ++id) {
                String query = "SELECT " + sql + " FROM " + tableName + " WHERE SURVEYID = " + Integer.toString(id) + " ORDER BY POINTNUMBER";
                Table_Abstract table = db.extractTableDataUsingQuery(tableName, query, Pecos.MaxQueryRowCount);
                if (table.row_count() <= 0) continue;
                String fileName = path + "/statics_" + tableName + "_" + Integer.toString(id) + ".txt";
                table.exportColumn(fileName);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void createJavaseis() {
    }

    public void print() {
        try {
            String st = RefractionStaticsProject.singleton().projectPath() + "/Data/" + RefractionStaticsProject.singleton().projectName() + "_data.sgy_wcf";
            System.out.println(st);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void gridTest() {
        try {
            Grid3D grid = RefractionStaticsProject.singleton().getEmptyGrid3D();
            Range_Double rangeX = new Range_Double();
            Range_Double rangeY = new Range_Double();
            grid.Java2D_RangeWorld(rangeX, rangeY, 0);
            System.out.println(String.format("X:  min = %f    max = %f", rangeX.rangeMin(), rangeX.rangeMax()));
            System.out.println(String.format("Y:  min = %f    max = %f", rangeY.rangeMin(), rangeY.rangeMax()));
            double gridAngle = grid.inlineAngle();
            double originX = grid.originX();
            double originY = grid.originY();
            double lengthX = grid.inlineBinSize() * (double)grid.numInline();
            double x1 = grid.getWorldX(grid.inlineMax(), grid.crosslineMin());
            double y1 = grid.getWorldY(grid.inlineMax(), grid.crosslineMin());
            double lengthY = grid.crosslineBinSize() * (double)grid.numCrossline();
            double x2 = grid.getWorldX(grid.inlineMin(), grid.crosslineMax());
            double y2 = grid.getWorldY(grid.inlineMin(), grid.crosslineMax());
            double x3 = grid.getWorldX(grid.inlineMax(), grid.crosslineMax());
            double y3 = grid.getWorldY(grid.inlineMax(), grid.crosslineMax());
            System.out.println(String.format("Bottom left:    x = %f    y = %f", originX, originY));
            System.out.println(String.format("Bottom right:   x = %f    y = %f", x1, y1));
            System.out.println(String.format("Top left:       x = %f    y = %f", x2, y2));
            System.out.println(String.format("Top right:      x = %f    y = %f", x3, y3));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (e.getSource() == this.m_menuItem_ConjugateGradient) {
                ComplexMatrix_Tools.testConjugateGradientSolution();
                return;
            }
            if (e.getSource() == this.m_menuItem_CreateJavaSeis) {
                this.createJavaseis();
                return;
            }
            if (e.getSource() == this.m_menuItem_CatapultExport) {
                if (!project.valid()) {
                    return;
                }
                String sql = JOptionPane.showInputDialog(null, "Query statement", "SQL", -1);
                if (sql == null) {
                    return;
                }
                if (sql.length() < 1) {
                    return;
                }
                this.catExp(sql, "Shot");
                this.catExp(sql, "Receiver");
                return;
            }
            if (e.getSource() == this.m_menuItem_SynthGathers) {
                boolean bl = project.SubstituteSyntheticGather = !project.SubstituteSyntheticGather;
                if (project.SubstituteSyntheticGather) {
                    this.m_menuItem_SynthGathers.setText("Turn synthetics gathers off");
                } else {
                    this.m_menuItem_SynthGathers.setText("Turn synthetics gathers on");
                }
            }
            if (e.getSource() == this.m_menuItem_DipScan) {
                DigiStack2D.testWithSine();
                return;
            }
            if (e.getSource() == this.m_menuItem_IBM) {
                this.testIBM();
                return;
            }
            if (e.getSource() == this.m_menuItem_Upsample) {
                this.testUpsample();
                return;
            }
            if (e.getSource() == this.m_menuItem_WellSplit) {
                this.wellSplit();
                return;
            }
            if (e.getSource() == this.m_menuItem_Exception) {
                this.testThrowException();
                return;
            }
            if (e.getSource() == this.m_menuItem_GLI) {
                ImportGliDialog dlg = new ImportGliDialog();
                return;
            }
            if (e.getSource() == this.m_menuItem_GridTest) {
                this.gridTest();
                return;
            }
            if (e.getSource() == this.m_menuItem_Print) {
                this.print();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

