/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.MDI;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Windows.MDI.MDIDesktopPane;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

class MDIDesktopManager
extends DefaultDesktopManager {
    private MDIDesktopPane m_desktop;

    public MDIDesktopManager(MDIDesktopPane desktop) {
        this.m_desktop = desktop;
    }

    @Override
    public void endResizingFrame(JComponent f) {
        try {
            super.endResizingFrame(f);
            this.resizeDesktop();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void endDraggingFrame(JComponent f) {
        try {
            super.endDraggingFrame(f);
            this.resizeDesktop();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setNormalSize() {
        try {
            JScrollPane scrollPane = this.getScrollPane();
            int x = 0;
            int y = 0;
            Insets scrollInsets = this.getScrollPaneInsets();
            if (scrollPane != null) {
                Dimension d = scrollPane.getVisibleRect().getSize();
                if (scrollPane.getBorder() != null) {
                    d.setSize(d.getWidth() - (double)scrollInsets.left - (double)scrollInsets.right, d.getHeight() - (double)scrollInsets.top - (double)scrollInsets.bottom);
                }
                d.setSize(d.getWidth() - 20.0, d.getHeight() - 20.0);
                this.m_desktop.setAllSize(x, y);
                scrollPane.invalidate();
                scrollPane.validate();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    private Insets getScrollPaneInsets() {
        try {
            JScrollPane scrollPane = this.getScrollPane();
            if (scrollPane == null) {
                return new Insets(0, 0, 0, 0);
            }
            return this.getScrollPane().getBorder().getBorderInsets(scrollPane);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return new Insets(0, 0, 0, 0);
        }
    }

    private JScrollPane getScrollPane() {
        try {
            JViewport viewPort;
            if (this.m_desktop.getParent() instanceof JViewport && (viewPort = (JViewport)this.m_desktop.getParent()).getParent() instanceof JScrollPane) {
                return (JScrollPane)viewPort.getParent();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        return null;
    }

    protected void resizeDesktop() {
        try {
            int x = 0;
            int y = 0;
            JScrollPane scrollPane = this.getScrollPane();
            Insets scrollInsets = this.getScrollPaneInsets();
            if (scrollPane != null) {
                JInternalFrame[] allFrames = this.m_desktop.getAllFrames();
                for (int i = 0; i < allFrames.length; ++i) {
                    if (allFrames[i].getX() + allFrames[i].getWidth() > x) {
                        x = allFrames[i].getX() + allFrames[i].getWidth();
                    }
                    if (allFrames[i].getY() + allFrames[i].getHeight() <= y) continue;
                    y = allFrames[i].getY() + allFrames[i].getHeight();
                }
                Dimension d = scrollPane.getVisibleRect().getSize();
                if (scrollPane.getBorder() != null) {
                    d.setSize(d.getWidth() - (double)scrollInsets.left - (double)scrollInsets.right, d.getHeight() - (double)scrollInsets.top - (double)scrollInsets.bottom);
                }
                if ((double)x <= d.getWidth()) {
                    x = (int)d.getWidth() - 20;
                }
                if ((double)y <= d.getHeight()) {
                    y = (int)d.getHeight() - 20;
                }
                this.m_desktop.setAllSize(x, y);
                scrollPane.invalidate();
                scrollPane.validate();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

