/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.UserEventHandler;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3DProfile;
import com.PecosLibrary.Refraction.Tomography.VNS.TomoProfileV2_VNS;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumerBase;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventDataWrapper;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventOrigin;
import java.awt.Color;
import java.awt.Graphics2D;

public class Java2D_UserEventConsumer_MouseoverInfo
extends Java2D_UserEventConsumerBase {
    public int PixelX;
    public int PixelY;
    public double WorldX;
    public double WorldY;
    protected ModelType m_modelType;
    protected DisplayType m_displayType;
    protected Java2D_PaintableInterface m_paintable;

    public Java2D_UserEventConsumer_MouseoverInfo(Java2D_PaintableInterface paintable, ModelType modelType, DisplayType displayType) {
        this.m_paintable = paintable;
        this.m_modelType = modelType;
        this.m_displayType = displayType;
    }

    @Override
    public void handleUserEvent(Java2D_UserEventDataWrapper eventData) {
        try {
            if (eventData.UserEventOrigin != Java2D_UserEventOrigin.MouseMoved) {
                return;
            }
            this.PixelX = eventData.PixelX;
            this.PixelY = eventData.PixelY;
            this.WorldX = eventData.Transform.getWorldFromPixel_X(this.PixelX);
            this.WorldY = eventData.Transform.getWorldFromPixel_Y(this.PixelY);
            this.NeedsToBePainted = true;
            this.broadcast(this, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void paint(Java2D_PaintParameter paintParameter) {
        try {
            double vel;
            Graphics2D g2d;
            String label;
            Java2D_PaintableInterface profile;
            if (this.m_paintable == null) {
                return;
            }
            if (this.m_modelType == ModelType.TomoVNS) {
                if (!(this.m_paintable instanceof TomoProfileV2_VNS)) {
                    return;
                }
                profile = (TomoProfileV2_VNS)this.m_paintable;
                label = " ";
                g2d = paintParameter.G2D;
                g2d.setColor(Color.black);
                if (this.m_displayType == DisplayType.Velocity) {
                    vel = ((TomoProfileV2_VNS)profile).getNearestVelocity(this.WorldX, this.WorldY);
                    label = String.format("Vel: %f", vel);
                    if (vel < 0.0) {
                        g2d.drawString(" ", this.PixelX, this.PixelY);
                    } else {
                        g2d.drawString(label, this.PixelX, this.PixelY);
                    }
                } else {
                    int count = ((TomoProfileV2_VNS)profile).getNearestCount(this.WorldX, this.WorldY);
                    label = String.format("Count: %d", count);
                    if (count < 0) {
                        g2d.drawString(" ", this.PixelX, this.PixelY);
                    } else {
                        g2d.drawString(label, this.PixelX, this.PixelY);
                    }
                }
            }
            if (this.m_modelType == ModelType.Tomo3D) {
                if (!(this.m_paintable instanceof TomoEikonal3DProfile)) {
                    return;
                }
                profile = (TomoEikonal3DProfile)this.m_paintable;
                label = " ";
                g2d = paintParameter.G2D;
                g2d.setColor(Color.black);
                if (this.m_displayType == DisplayType.Velocity) {
                    vel = ((TomoEikonal3DProfile)profile).getNearestVelocity(this.WorldX, this.WorldY);
                    label = String.format("Vel: %f", vel);
                    if (vel < 0.0) {
                        g2d.drawString(" ", this.PixelX, this.PixelY);
                    } else {
                        g2d.drawString(label, this.PixelX, this.PixelY);
                    }
                } else {
                    int count = ((TomoEikonal3DProfile)profile).getNearestCount(this.WorldX, this.WorldY);
                    label = String.format("Count: %d", count);
                    if (count < 0) {
                        g2d.drawString(" ", this.PixelX, this.PixelY);
                    } else {
                        g2d.drawString(label, this.PixelX, this.PixelY);
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleImageJustPainted() {
    }

    public static enum ModelType {
        TomoVNS,
        Tomo3D,
        DelayTime,
        Uphole;

    }

    public static enum DisplayType {
        Velocity,
        Count;

    }
}

