/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.TablePlot;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.TablePlot.Java2D_TablePlotImage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class Java2D_TablePlotWidget
extends JPanel
implements ComponentListener,
KeyListener,
MouseWheelListener,
MouseMotionListener,
MouseListener {
    protected Java2D_TablePlotImage m_image = new Java2D_TablePlotImage();
    public int m_vertLineCoord = -9;

    public Java2D_TablePlotWidget() {
        try {
            this.addComponentListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
            this.addMouseListener(this);
            this.addKeyListener(this);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Java2D_TablePlotImage image() {
        return this.m_image;
    }

    @Override
    public void paintComponent(Graphics g) {
        try {
            Dimension size = this.getSize();
            Graphics2D g2d = (Graphics2D)g;
            BufferedImage image = this.m_image.image(size.width, size.height);
            g2d.drawImage((Image)image, 0, 0, null);
            g2d.setColor(Color.lightGray);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_1);
            g2d.drawLine(this.m_vertLineCoord, 0, this.m_vertLineCoord, size.height);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void drawVerticalLine(int x) {
        try {
            this.m_vertLineCoord = x;
            this.repaint();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        try {
            this.repaint();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        try {
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        try {
            if (this.m_image.checkIfLockClick(event.getX(), event.getY())) {
                this.repaint();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void mouseDragged(MouseEvent event) {
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        try {
            this.drawVerticalLine(event.getX());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
    }
}

