/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.TablePlot;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Tools.Tools_Bitmap;
import com.PecosLibrary.Tools.Tools_ColorLibrary;
import com.PecosLibrary.Tools.Tools_FontLibrary;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Tools.Tools_Plot;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.ImageIcon;

public class Java2D_TablePlotImage {
    protected BufferedImage m_image = null;
    protected boolean m_dirty = true;
    protected Table_Abstract m_table;
    protected ArrayList<Entry> m_list = new ArrayList();
    protected int m_numVisible = 4;
    protected double m_scaleX = 1.0;
    protected double m_shiftX = 0.0;
    protected int m_horizontalAxisHeight = 0;
    protected int m_verticalAxisWidth = 80;
    protected int m_plotWidth = 100;
    protected Color m_evenColor = new Color(255, 255, 233);
    protected Color m_oddColor = new Color(233, 255, 255);
    protected Color[] m_colorList = new Color[4];
    protected ImageIcon m_iconLock;
    protected ImageIcon m_iconUnlock;
    protected Image m_imageLock;
    protected Image m_imageUnlock;

    public Java2D_TablePlotImage() {
        try {
            this.m_colorList[0] = Color.BLUE;
            this.m_colorList[1] = Color.RED;
            this.m_colorList[2] = Color.GREEN;
            this.m_colorList[3] = Color.CYAN;
            for (int n = 0; n < 20; ++n) {
                this.m_list.add(new Entry());
            }
            this.m_iconLock = Tools_Bitmap.makeIcon(BitmapEnum.Lock.Bitmap);
            this.m_iconUnlock = Tools_Bitmap.makeIcon(BitmapEnum.Unlock.Bitmap);
            this.m_imageLock = this.m_iconLock.getImage();
            this.m_imageUnlock = this.m_iconUnlock.getImage();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setTable(Table_Abstract table) {
        this.m_table = table;
        this.m_dirty = true;
    }

    public void setNumVisible(int numVis) {
        this.m_numVisible = Math.max(1, numVis);
        this.m_numVisible = Math.min(this.m_list.size(), this.m_numVisible);
        this.m_dirty = true;
    }

    public void clearColumnNames(int index) {
        try {
            this.m_dirty = true;
            this.m_list.get((int)index).ColumnList.clear();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addColumnName(int index, String colName) {
        try {
            this.m_dirty = true;
            NameIndexPair nip = new NameIndexPair();
            nip.Valid = false;
            nip.ColumnName = colName;
            this.m_list.get((int)index).ColumnList.add(nip);
            this.m_list.get((int)index).Valid = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean checkIfLockClick(int x, int y) {
        try {
            int w = this.m_imageLock.getWidth(null);
            int h = this.m_imageLock.getHeight(null);
            for (Entry entry : this.m_list) {
                if (!entry.Valid) continue;
                int top = entry.TopPixel;
                int bottom = top + h;
                if (x >= w || y <= top || y >= bottom) continue;
                entry.Locked = !entry.Locked;
                this.m_dirty = true;
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public BufferedImage image(int width, int height) {
        try {
            Entry entry;
            int n;
            boolean resized = this.resizeImage(width, height);
            if (!this.m_dirty && !resized) {
                return this.m_image;
            }
            int w = this.m_image.getWidth();
            int h = this.m_image.getHeight();
            for (Entry entry2 : this.m_list) {
                entry2.Valid = false;
            }
            Graphics2D g2d = this.m_image.createGraphics();
            g2d.setColor(Tools_ColorLibrary.AxisImage_Background);
            g2d.fillRect(0, 0, w, h);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_3);
            if (this.m_table == null) {
                return this.m_image;
            }
            if (this.m_table.row_count() < 1) {
                return this.m_image;
            }
            this.m_verticalAxisWidth = 80;
            this.m_horizontalAxisHeight = 0;
            this.m_plotWidth = w - this.m_verticalAxisWidth;
            if (this.m_plotWidth < 10) {
                return this.m_image;
            }
            double minRow = -1.0;
            double maxRow = this.m_table.row_count();
            this.m_scaleX = (double)(w - 1 - this.m_verticalAxisWidth) / (maxRow - minRow);
            this.m_shiftX = (double)this.m_verticalAxisWidth - this.m_scaleX * minRow;
            boolean buffer = false;
            int pixPerPlot = (h - this.m_horizontalAxisHeight) / this.m_numVisible;
            if (pixPerPlot < 10) {
                return this.m_image;
            }
            int top = this.m_horizontalAxisHeight;
            for (n = 0; n < this.m_numVisible; ++n) {
                if (n % 2 == 0) {
                    g2d.setColor(this.m_evenColor);
                } else {
                    g2d.setColor(this.m_oddColor);
                }
                entry = this.m_list.get(n);
                entry.TopPixel = top;
                top = entry.BottomPixel = top + pixPerPlot;
                g2d.fillRect(0, entry.TopPixel, w, pixPerPlot);
            }
            for (n = 0; n < this.m_numVisible; ++n) {
                entry = this.m_list.get(n);
                this.plotEntry(g2d, entry);
            }
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_1);
            for (n = 0; n < this.m_numVisible; ++n) {
                entry = this.m_list.get(n);
                this.plotAxis(g2d, entry);
            }
            g2d.setClip(0, 0, w, h);
            g2d.setColor(Color.black);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
            g2d.drawLine(this.m_verticalAxisWidth, 0, this.m_verticalAxisWidth, h);
            for (n = 0; n < this.m_numVisible; ++n) {
                entry = this.m_list.get(n);
                if (this.m_horizontalAxisHeight <= 0 && n < 1) continue;
                g2d.drawLine(0, entry.TopPixel, w, entry.TopPixel);
            }
            this.m_dirty = false;
            return this.m_image;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected void plotAxis(Graphics2D g2d, Entry entry) {
        try {
            if (!entry.Valid) {
                return;
            }
            int w = this.m_image.getWidth();
            double range = entry.Max - entry.Min;
            double tick = Tools_Plot.tickMarkInterval(range, 10);
            int temp = (int)(entry.Min / tick);
            g2d.setFont(Tools_FontLibrary.AxisFont);
            int stringHeight = g2d.getFontMetrics().getHeight();
            int stickLeft = this.m_verticalAxisWidth - 0;
            g2d.setColor(Color.BLACK);
            int priorY = -99999;
            int minPixel = entry.TopPixel + stringHeight / 2;
            int maxPixel = entry.BottomPixel - stringHeight / 2;
            for (double v = (double)temp * tick; v < entry.Max; v += tick) {
                String s = Tools_Strings.doubleToString(v, range, true);
                int iy = (int)(v * entry.Scale + entry.Shift);
                if (iy <= minPixel || iy >= maxPixel) continue;
                g2d.setColor(Color.LIGHT_GRAY);
                g2d.drawLine(stickLeft, iy, 2000, iy);
                int stringWidth = g2d.getFontMetrics().stringWidth(s);
                int strLeft = stickLeft - stringWidth;
                strLeft = Math.max(strLeft, 0);
                if (Math.abs(iy - priorY) <= 20) continue;
                priorY = iy;
                g2d.setColor(Color.BLACK);
                g2d.drawString(s, strLeft, iy + 4);
            }
            if (entry.Locked) {
                g2d.drawImage(this.m_imageLock, 0, entry.TopPixel, null);
            } else {
                g2d.drawImage(this.m_imageUnlock, 0, entry.TopPixel, null);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void plotEntry(Graphics2D g2d, Entry entry) {
        try {
            entry.Valid = false;
            int num = 0;
            for (NameIndexPair nameIndexPair : entry.ColumnList) {
                nameIndexPair.Index = -9999;
                nameIndexPair.Valid = this.m_table.column_exists(nameIndexPair.ColumnName);
                boolean bl = entry.Valid = entry.Valid || nameIndexPair.Valid;
                if (!nameIndexPair.Valid) continue;
                nameIndexPair.PlotColor = this.m_colorList[num % 4];
                ++num;
                nameIndexPair.Index = this.m_table.column_indexOfColumn(nameIndexPair.ColumnName);
            }
            if (!entry.Valid) {
                return;
            }
            if (!entry.Locked) {
                entry.Min = Double.MAX_VALUE;
                entry.Max = Double.MIN_VALUE;
                for (int row = 0; row < this.m_table.row_count(); ++row) {
                    for (NameIndexPair nip : entry.ColumnList) {
                        if (nip.Index < 0) continue;
                        double v = this.m_table.getDouble(row, nip.Index);
                        entry.Min = Math.min(entry.Min, v);
                        entry.Max = Math.max(entry.Max, v);
                    }
                }
                double range = Math.max(0.1, entry.Max - entry.Min);
                double buff = range * 0.05;
                entry.Max += buff;
                entry.Min -= buff;
            }
            entry.Scale = (double)(entry.TopPixel - entry.BottomPixel) / (entry.Max - entry.Min);
            entry.Shift = (double)entry.TopPixel - entry.Scale * entry.Max;
            g2d.setColor(Color.blue);
            for (NameIndexPair nameIndexPair : entry.ColumnList) {
                if (nameIndexPair.Index < 0) continue;
                g2d.setColor(nameIndexPair.PlotColor);
                for (int n = 1; n < this.m_table.row_count(); ++n) {
                    int x1 = (int)(this.m_scaleX * (double)(n - 1) + this.m_shiftX);
                    int x2 = (int)(this.m_scaleX * (double)n + this.m_shiftX);
                    double v1 = this.m_table.getDouble(n - 1, nameIndexPair.Index);
                    double v2 = this.m_table.getDouble(n, nameIndexPair.Index);
                    if (!(v1 >= entry.Min) || !(v1 <= entry.Max) || !(v2 >= entry.Min) || !(v2 <= entry.Max)) continue;
                    int y1 = (int)(entry.Scale * v1 + entry.Shift);
                    int y2 = (int)(entry.Scale * v2 + entry.Shift);
                    g2d.drawLine(x1, y1, x2, y2);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean resizeImage(int width, int height) {
        try {
            if (this.m_image == null) {
                this.m_image = new BufferedImage(width, height, 2);
                return true;
            }
            if (this.m_image.getWidth() != width || this.m_image.getHeight() != height) {
                this.m_image = new BufferedImage(width, height, 2);
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return true;
        }
    }

    protected class Entry {
        public ArrayList<NameIndexPair> ColumnList = new ArrayList();
        public boolean Locked = false;
        public boolean Valid = false;
        public double Min;
        public double Max;
        public double Scale;
        public double Shift;
        public int TopPixel;
        public int BottomPixel;

        protected Entry() {
        }
    }

    protected class NameIndexPair {
        public Color PlotColor = Color.BLACK;
        public String ColumnName;
        public boolean Valid;
        public int Index;

        protected NameIndexPair() {
        }
    }
}

