/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.Paintables;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosLibrary.Data.Table_SimpleModel;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;

public class Java2D_Paintable_TextTable
implements Java2D_PaintableInterface {
    protected Table_Abstract m_table = null;
    protected String m_columnX = "";
    protected String m_columnY = "";
    protected String m_columnC = "";
    protected int m_indexX = -999999;
    protected int m_indexY = -999999;
    protected int m_indexC = -999999;
    protected DataType m_typeX = DataType.Text;
    protected DataType m_typeY = DataType.Text;
    protected DataType m_typeC = DataType.Text;
    protected boolean m_valid = false;
    protected boolean m_validColor = false;
    protected boolean m_bContentsChangedSinceLastPaint = true;
    public Java2D_PointSymbol Symbol = Java2D_PointSymbol.HollowOval;
    public int Size_Pixel = 15;
    public double Size_World = 25.0;
    public boolean Size_UsePixel = true;
    public boolean UseColorScale = true;
    public Color FixedColor = Color.black;
    protected Table_Abstract m_selectedRowTable;
    protected int m_indexColName;
    protected int m_indexColValue;
    protected Table_SimpleModel m_selTableModel;
    protected ArrayList<PointData> m_points = new ArrayList();

    public Java2D_Paintable_TextTable() {
        try {
            this.m_selectedRowTable = new Table_Memory();
            this.m_indexColName = this.m_selectedRowTable.column_append("Name", DataType.Text);
            this.m_indexColValue = this.m_selectedRowTable.column_append("Value", DataType.Text);
            this.m_selTableModel = new Table_SimpleModel(this.m_selectedRowTable);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void selectRow(int row) {
        try {
            this.m_selectedRowTable.row_clear(false);
            if (row < 0 || row >= this.m_table.row_count()) {
                return;
            }
            for (int col = 0; col < this.m_table.column_count(); ++col) {
                int newRow = this.m_selectedRowTable.row_increment();
                this.m_selectedRowTable.putString(newRow, this.m_indexColName, this.m_table.column_name(col));
                this.m_selectedRowTable.putString(newRow, this.m_indexColValue, this.m_table.getString(row, col));
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Table_Abstract getSelectedRowTable() {
        return this.m_selectedRowTable;
    }

    protected int getColumnIndex(String s) {
        try {
            if (this.m_table == null) {
                return -999999;
            }
            if (s == null) {
                return -999999;
            }
            if (!this.m_table.column_exists(s)) {
                return -999999;
            }
            int index = this.m_table.column_indexOfColumn(s);
            return index;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return -999999;
        }
    }

    protected DataType getColumnType(int index) {
        try {
            if (this.m_table == null) {
                return DataType.Text;
            }
            if (index < 0) {
                return DataType.Text;
            }
            return this.m_table.column_type(index);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return DataType.Text;
        }
    }

    protected void checkStatus() {
        try {
            this.m_valid = false;
            this.m_validColor = false;
            this.m_indexX = this.getColumnIndex(this.m_columnX);
            this.m_indexY = this.getColumnIndex(this.m_columnY);
            this.m_indexC = this.getColumnIndex(this.m_columnC);
            this.m_typeX = this.getColumnType(this.m_indexX);
            this.m_typeY = this.getColumnType(this.m_indexY);
            this.m_typeC = this.getColumnType(this.m_indexC);
            this.m_valid = this.m_indexX >= 0 && this.m_indexY >= 0;
            this.m_validColor = this.m_indexC >= 0;
            this.createPointData();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    /*
     * Loose catch block
     */
    protected boolean valueOkay(int row, int column) {
        String s;
        block7: {
            if (column < 0) {
                return false;
            }
            if (this.m_table.column_type(column) != DataType.Text) {
                return true;
            }
            s = this.m_table.getString(row, column);
            if (s.length() >= 1) break block7;
            return false;
            {
                catch (Exception ex) {
                    ExceptionMonitor.add(ex);
                    return false;
                }
            }
        }
        try {
            double v = Double.parseDouble(s);
            return true;
        }
        catch (Exception error) {
            return false;
        }
    }

    protected void createPointData() {
        try {
            if (!this.m_valid) {
                return;
            }
            while (this.m_points.size() < this.m_table.row_count()) {
                this.m_points.add(new PointData());
            }
            for (int n = 0; n < this.m_table.row_count(); ++n) {
                PointData pd = this.m_points.get(n);
                pd.PixelX = -999999999;
                pd.PixelY = -999999999;
                pd.ColorValid = this.valueOkay(n, this.m_indexC);
                boolean bl = pd.CoordinatesValid = this.valueOkay(n, this.m_indexY) && this.valueOkay(n, this.m_indexX);
                if (pd.ColorValid) {
                    pd.ColorValue = this.m_table.getDouble(n, this.m_indexC);
                }
                if (!pd.CoordinatesValid) continue;
                pd.CoordinateX = this.m_table.getDouble(n, this.m_indexX);
                pd.CoordinateY = this.m_table.getDouble(n, this.m_indexY);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setTable(Table_Abstract table) {
        try {
            this.m_table = table;
            this.checkStatus();
            this.m_bContentsChangedSinceLastPaint = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Table_Abstract getTable() {
        return this.m_table;
    }

    public void setAxisX(String columnX) {
        try {
            this.m_columnX = columnX;
            this.checkStatus();
            this.m_bContentsChangedSinceLastPaint = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setAxisY(String columnY) {
        try {
            this.m_columnY = columnY;
            this.checkStatus();
            this.m_bContentsChangedSinceLastPaint = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setAxisC(String columnC) {
        try {
            this.m_columnC = columnC;
            this.checkStatus();
            this.m_bContentsChangedSinceLastPaint = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setDefaultWorldSize() {
        try {
            this.Size_Pixel = 3;
            this.Size_UsePixel = false;
            this.Size_World = 25.0;
            if (!RefractionStaticsProject.singleton().valid()) {
                return;
            }
            if (RefractionStaticsProject.singleton().units_feet()) {
                this.Size_World = 75.0;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int getNearestIndex(int px, int py) {
        try {
            if (this.m_points.size() < this.m_table.row_count()) {
                return -9999;
            }
            int min = 10000000;
            int index = -9999;
            for (int n = 0; n < this.m_table.row_count(); ++n) {
                PointData pd = this.m_points.get(n);
                int d = Math.abs(px - pd.PixelX) + Math.abs(py - pd.PixelY);
                if (d >= min) continue;
                min = d;
                index = n;
            }
            return index;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return -9999;
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return this.m_bContentsChangedSinceLastPaint;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 0;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            this.m_bContentsChangedSinceLastPaint = false;
            if (!this.m_valid) {
                return;
            }
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            g2d.setColor(this.FixedColor);
            int pixelSize = this.Size_Pixel;
            pixelSize = Math.max(pixelSize, 3);
            pixelSize = Math.min(pixelSize, 21);
            int h = pixelSize / 2;
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_0);
            for (int n = 0; n < this.m_table.row_count(); ++n) {
                PointData pd = this.m_points.get(n);
                pd.PixelX = -999999999;
                pd.PixelY = -999999999;
                if (!pd.CoordinatesValid) continue;
                int ix = (int)(scaleX * pd.CoordinateX + shiftX);
                int iy = (int)(scaleY * pd.CoordinateY + shiftY);
                pd.PixelX = ix;
                pd.PixelY = iy;
                boolean ok = true;
                if (!pd.ColorValid) {
                    g2d.setColor(this.FixedColor);
                }
                if (this.m_validColor && this.UseColorScale && pd.ColorValid) {
                    ok = false;
                    if (colorWrapper.valueOK(pd.ColorValue)) {
                        ok = true;
                        g2d.setColor(colorWrapper.colorUsingValue(pd.ColorValue));
                    }
                }
                if (!ok) continue;
                if (this.Symbol == Java2D_PointSymbol.FilledSquare) {
                    g2d.fillRect(ix - h, iy - h, pixelSize, pixelSize);
                    continue;
                }
                if (this.Symbol == Java2D_PointSymbol.HollowSquare) {
                    g2d.drawRect(ix - h, iy - h, pixelSize, pixelSize);
                    continue;
                }
                if (this.Symbol == Java2D_PointSymbol.HollowOval) {
                    g2d.drawOval(ix - h, iy - h, pixelSize, pixelSize);
                    continue;
                }
                if (this.Symbol == Java2D_PointSymbol.FilledOval) {
                    g2d.fillOval(ix - h, iy - h, pixelSize, pixelSize);
                    continue;
                }
                if (this.Symbol == Java2D_PointSymbol.Plus) {
                    g2d.drawLine(ix - h, iy, ix + h, iy);
                    g2d.drawLine(ix, iy - h, ix, iy + h);
                    continue;
                }
                if (this.Symbol != Java2D_PointSymbol.X) continue;
                g2d.drawLine(ix - h, iy - h, ix + h, iy + h);
                g2d.drawLine(ix + h, iy - h, ix - h, iy + h);
            }
            this.m_bContentsChangedSinceLastPaint = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            if (!this.m_valid) {
                return;
            }
            for (int n = 0; n < this.m_table.row_count(); ++n) {
                PointData pd = this.m_points.get(n);
                if (!pd.CoordinatesValid) continue;
                rangeX.expandRange(pd.CoordinateX);
                rangeY.expandRange(pd.CoordinateY);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
        try {
            if (!this.m_valid) {
                return;
            }
            if (!this.m_validColor) {
                return;
            }
            for (int n = 0; n < this.m_table.row_count(); ++n) {
                PointData pd = this.m_points.get(n);
                if (!pd.ColorValid) continue;
                rangeC.expandRange(pd.ColorValue);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }

    protected class PointData {
        public double CoordinateX;
        public double CoordinateY;
        public boolean CoordinatesValid = false;
        public double ColorValue;
        public boolean ColorValid = false;
        public int PixelX;
        public int PixelY;

        protected PointData() {
        }
    }
}

