/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.Paintables;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Tools.Tools_FontLibrary;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_TextRects;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;

public class Java2D_Paintable_Table
implements Java2D_PaintableInterface {
    protected Table_Abstract m_table = null;
    protected String m_columnX = "";
    protected String m_columnY = "";
    protected String m_columnC = "";
    protected String m_columnID = "";
    protected int m_indexX = -999999;
    protected int m_indexY = -999999;
    protected int m_indexC = -999999;
    protected int m_indexID = -999999;
    protected int m_indexKilled = -999999;
    protected int m_indexInitialX = -999999;
    protected int m_indexInitialY = -999999;
    protected int[] m_pixelX = null;
    protected int[] m_pixelY = null;
    protected int[] m_id = null;
    protected boolean[] m_visible = null;
    protected boolean m_valid = false;
    protected boolean m_validColor = false;
    protected boolean m_bContentsChangedSinceLastPaint = true;
    public Java2D_PointSymbol Symbol = Java2D_PointSymbol.Plus;
    public int Size_Pixel = 5;
    public double Size_World = 25.0;
    public boolean Size_UsePixel = true;
    public boolean UseColorScale = true;
    public Color FixedColor = Color.black;
    public boolean AttemptToPlotText = false;
    public boolean DrawMoveVectors = false;
    public boolean DrawTextLabels = false;
    public String TextLabelColumn = "None";
    public boolean DrawErrorVectors = false;
    public int NearestID = -9999;
    public ArrayList<NearestEntry> NearestList = new ArrayList();
    public boolean NearestColorValid = false;
    public boolean ForceSymmetricalRange = false;

    public String columnC() {
        return this.m_columnC;
    }

    protected int getColumnIndex(String s) {
        try {
            if (this.m_table == null) {
                return -999999;
            }
            if (s == null) {
                return -999999;
            }
            if (!this.m_table.column_exists(s)) {
                return -999999;
            }
            int index = this.m_table.column_indexOfColumn(s);
            if (!this.AttemptToPlotText && this.m_table.column_type(index) == DataType.Text) {
                return -999999;
            }
            return index;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return -999999;
        }
    }

    protected void checkStatus() {
        try {
            this.m_valid = false;
            this.m_validColor = false;
            this.m_indexInitialX = this.getColumnIndex("InitialEasting");
            this.m_indexInitialY = this.getColumnIndex("InitialNorthing");
            this.m_indexX = this.getColumnIndex(this.m_columnX);
            this.m_indexY = this.getColumnIndex(this.m_columnY);
            this.m_indexC = this.getColumnIndex(this.m_columnC);
            this.m_indexID = this.getColumnIndex(this.m_columnID);
            this.m_indexKilled = this.getColumnIndex("Killed");
            this.m_valid = this.m_indexX >= 0 && this.m_indexY >= 0;
            this.m_validColor = this.m_indexC >= 0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setTable(Table_Abstract table) {
        try {
            this.m_table = table;
            this.m_columnID = table.name() + "ID";
            this.checkStatus();
            this.m_bContentsChangedSinceLastPaint = true;
            this.m_id = new int[10 + table.row_count()];
            this.m_pixelX = new int[10 + table.row_count()];
            this.m_pixelY = new int[10 + table.row_count()];
            this.m_visible = new boolean[10 + table.row_count()];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Table_Abstract getTable() {
        return this.m_table;
    }

    public void setAxisX(String columnX) {
        try {
            this.m_columnX = columnX;
            this.checkStatus();
            this.m_bContentsChangedSinceLastPaint = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setAxisY(String columnY) {
        try {
            this.m_columnY = columnY;
            this.checkStatus();
            this.m_bContentsChangedSinceLastPaint = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setAxisC(String columnC) {
        try {
            this.m_columnC = columnC;
            this.checkStatus();
            this.m_bContentsChangedSinceLastPaint = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setDefaultWorldSize() {
        try {
            this.Size_Pixel = 3;
            this.Size_UsePixel = false;
            this.Size_World = 25.0;
            if (!RefractionStaticsProject.singleton().valid()) {
                return;
            }
            if (RefractionStaticsProject.singleton().units_feet()) {
                this.Size_World = 75.0;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public boolean prepMouseLocation(int px, int py) {
        try {
            int n;
            this.NearestID = -9999;
            this.NearestList.clear();
            boolean bl = this.NearestColorValid = this.m_indexC >= 0;
            if (this.m_indexID < 0) {
                return false;
            }
            int min = 100000000;
            int minX = 0;
            int minY = 0;
            boolean minRow = false;
            for (n = 0; n < this.m_table.row_count(); ++n) {
                int d;
                if (!this.m_visible[n] || (d = Math.abs(px - this.m_pixelX[n]) + Math.abs(py - this.m_pixelY[n])) >= min) continue;
                min = d;
                minX = this.m_pixelX[n];
                minY = this.m_pixelY[n];
                this.NearestID = this.m_table.getInt(n, this.m_indexID);
            }
            if (this.NearestID < 0) {
                return false;
            }
            for (n = 0; n < this.m_table.row_count(); ++n) {
                if (!this.m_visible[n]) continue;
                int dx = Math.abs(minX - this.m_pixelX[n]);
                int dy = Math.abs(minY - this.m_pixelY[n]);
                if (dx > 5 || dy > 5) continue;
                NearestEntry entry = new NearestEntry();
                entry.ID = this.m_table.getInt(n, this.m_indexID);
                if (this.NearestColorValid) {
                    entry.ColorValue = this.m_table.getDouble(n, this.m_indexC);
                }
                this.NearestList.add(entry);
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public int getNearestID(int px, int py) {
        try {
            if (this.m_indexID < 0) {
                return -9999;
            }
            int min = 100000000;
            int id = -9999;
            for (int n = 0; n < this.m_table.row_count(); ++n) {
                int d;
                if (!this.m_visible[n] || (d = Math.abs(px - this.m_pixelX[n]) + Math.abs(py - this.m_pixelY[n])) >= min) continue;
                min = d;
                id = this.m_id[n];
            }
            return id;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return -9999;
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return this.m_bContentsChangedSinceLastPaint;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 0;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            int iy;
            double y;
            int n;
            this.m_bContentsChangedSinceLastPaint = false;
            if (!this.m_valid) {
                return;
            }
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            int textIndex = -9999;
            if (this.DrawTextLabels && this.TextLabelColumn != null && this.m_table.column_exists(this.TextLabelColumn)) {
                textIndex = this.m_table.column_indexOfColumn(this.TextLabelColumn);
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            double viewMinX = transform.actualLeft();
            double viewMaxX = transform.actualRight();
            double viewMinY = transform.actualMinY();
            double viewMaxY = transform.actualMaxY();
            g2d.setColor(this.FixedColor);
            boolean world = this.m_columnX.equalsIgnoreCase("Easting") && this.m_columnY.equalsIgnoreCase("Northing");
            boolean drawMoveVectors = this.DrawMoveVectors && world && this.m_indexInitialX >= 0 && this.m_indexInitialY >= 0;
            boolean drawErrorVectors = this.DrawErrorVectors && world && this.m_table.column_exists("GeomErr_Az") && this.m_table.column_exists("GeomErr_Dist");
            g2d.setFont(Tools_FontLibrary.AxisFont);
            int stringHeight = g2d.getFontMetrics().getHeight();
            Java2D_TextRects textRects = paintParameter.TextRects;
            int pixelSize = this.Size_Pixel;
            if (world && !this.Size_UsePixel) {
                pixelSize = (int)(scaleX * this.Size_World);
            }
            pixelSize = Math.max(pixelSize, 3);
            pixelSize = Math.min(pixelSize, 31);
            int h = pixelSize / 2;
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_0);
            if (drawErrorVectors) {
                int indexAz = this.m_table.column_indexOfColumn("GeomErr_Az");
                int indexDist = this.m_table.column_indexOfColumn("GeomErr_Dist");
                g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
                g2d.setColor(Color.RED);
                for (int n2 = 0; n2 < this.m_table.row_count(); ++n2) {
                    double x1 = this.m_table.getDouble(n2, this.m_indexX);
                    double y1 = this.m_table.getDouble(n2, this.m_indexY);
                    double dist = this.m_table.getDouble(n2, indexDist);
                    double az = this.m_table.getDouble(n2, indexAz);
                    double x2 = x1 + dist * Math.cos(az);
                    double y2 = y1 + dist * Math.sin(az);
                    if (!(x1 >= viewMinX) || !(x1 <= viewMaxX) || !(y1 >= viewMinY) || !(y1 <= viewMaxY)) continue;
                    int ix1 = (int)(scaleX * x1 + shiftX);
                    int iy1 = (int)(scaleY * y1 + shiftY);
                    int ix2 = (int)(scaleX * x2 + shiftX);
                    int iy2 = (int)(scaleY * y2 + shiftY);
                    if (ix1 == ix2 && iy1 == iy2) continue;
                    g2d.drawLine(ix1, iy1, ix2, iy2);
                }
            }
            if (drawMoveVectors) {
                g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
                g2d.setColor(Color.BLACK);
                for (n = 0; n < this.m_table.row_count(); ++n) {
                    double x1 = this.m_table.getDouble(n, this.m_indexX);
                    double y1 = this.m_table.getDouble(n, this.m_indexY);
                    double x2 = this.m_table.getDouble(n, this.m_indexInitialX);
                    double y2 = this.m_table.getDouble(n, this.m_indexInitialY);
                    if (!(x1 >= viewMinX) || !(x1 <= viewMaxX) || !(y1 >= viewMinY) || !(y1 <= viewMaxY)) continue;
                    int ix1 = (int)(scaleX * x1 + shiftX);
                    int iy1 = (int)(scaleY * y1 + shiftY);
                    int ix2 = (int)(scaleX * x2 + shiftX);
                    int iy2 = (int)(scaleY * y2 + shiftY);
                    if (ix1 == ix2 && iy1 == iy2) continue;
                    g2d.drawLine(ix1, iy1, ix2, iy2);
                }
            }
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_0);
            for (n = 0; n < this.m_table.row_count(); ++n) {
                this.m_pixelX[n] = -99999;
                this.m_pixelY[n] = -99999;
                this.m_visible[n] = false;
                this.m_id[n] = -9999;
                if (this.m_indexID >= 0) {
                    this.m_id[n] = this.m_table.getInt(n, this.m_indexID);
                }
                double x = this.m_table.getDouble(n, this.m_indexX);
                y = this.m_table.getDouble(n, this.m_indexY);
                if (!(x >= viewMinX) || !(x <= viewMaxX) || !(y >= viewMinY) || !(y <= viewMaxY)) continue;
                int ix = (int)(scaleX * x + shiftX);
                iy = (int)(scaleY * y + shiftY);
                this.m_pixelX[n] = ix;
                this.m_pixelY[n] = iy;
                this.m_visible[n] = false;
                boolean ok = true;
                if (this.m_indexKilled >= 0) {
                    boolean bl = ok = !this.m_table.getBool(n, this.m_indexKilled);
                }
                if (ok && this.m_validColor && this.UseColorScale) {
                    ok = false;
                    double c = this.m_table.getDouble(n, this.m_indexC);
                    if (colorWrapper.valueOK(c)) {
                        ok = true;
                        g2d.setColor(colorWrapper.colorUsingValue(c));
                    }
                }
                if (!ok) continue;
                this.m_visible[n] = true;
                if (this.Symbol == Java2D_PointSymbol.FilledSquare) {
                    g2d.fillRect(ix - h, iy - h, pixelSize, pixelSize);
                    continue;
                }
                if (this.Symbol == Java2D_PointSymbol.HollowSquare) {
                    g2d.drawRect(ix - h, iy - h, pixelSize, pixelSize);
                    continue;
                }
                if (this.Symbol == Java2D_PointSymbol.HollowOval) {
                    g2d.drawOval(ix - h, iy - h, pixelSize, pixelSize);
                    continue;
                }
                if (this.Symbol == Java2D_PointSymbol.FilledOval) {
                    g2d.fillOval(ix - h, iy - h, pixelSize, pixelSize);
                    continue;
                }
                if (this.Symbol == Java2D_PointSymbol.Plus) {
                    g2d.drawLine(ix - h, iy, ix + h, iy);
                    g2d.drawLine(ix, iy - h, ix, iy + h);
                    continue;
                }
                if (this.Symbol != Java2D_PointSymbol.X) continue;
                g2d.drawLine(ix - h, iy - h, ix + h, iy + h);
                g2d.drawLine(ix + h, iy - h, ix - h, iy + h);
            }
            if (textIndex >= 0) {
                g2d.setColor(Color.BLACK);
                for (n = 0; n < this.m_table.row_count(); ++n) {
                    if (!this.m_visible[n]) continue;
                    double x = this.m_table.getDouble(n, this.m_indexX);
                    y = this.m_table.getDouble(n, this.m_indexY);
                    int ix = this.m_pixelX[n];
                    iy = this.m_pixelY[n];
                    if (!(x >= viewMinX) || !(x <= viewMaxX) || !(y >= viewMinY) || !(y <= viewMaxY)) continue;
                    String label = this.m_table.getString(n, textIndex, 2);
                    int stringWidth = g2d.getFontMetrics().stringWidth(label);
                    if (!textRects.tryToAdd(ix = ix + h + 0, iy = iy - h + 0, stringWidth, stringHeight)) continue;
                    g2d.drawString(label, ix, iy);
                }
            }
            this.m_bContentsChangedSinceLastPaint = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            if (!this.m_valid) {
                return;
            }
            for (int n = 0; n < this.m_table.row_count(); ++n) {
                rangeX.expandRange(this.m_table.getDouble(n, this.m_indexX));
                rangeY.expandRange(this.m_table.getDouble(n, this.m_indexY));
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
        try {
            if (!this.m_validColor) {
                return;
            }
            for (int n = 0; n < this.m_table.row_count(); ++n) {
                boolean ok = true;
                if (this.m_indexKilled >= 0) {
                    boolean bl = ok = !this.m_table.getBool(n, this.m_indexKilled);
                }
                if (!ok) continue;
                double v = this.m_table.getDouble(n, this.m_indexC);
                if (this.ForceSymmetricalRange) {
                    rangeC.expandRange(v);
                    rangeC.expandRange(-v);
                    continue;
                }
                rangeC.expandRange(v);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }

    public static class NearestEntry {
        public int ID;
        public double ColorValue = -9999.0;
    }
}

